/*
 * Decompiled with CFR 0.152.
 */
package squants.time;

import scala.Option;
import scala.Tuple2;
import scala.collection.immutable.Set;
import scala.concurrent.duration.Duration;
import scala.math.Numeric;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyVals$;
import scala.util.Try;
import squants.Dimension;
import squants.PrimaryUnit;
import squants.Quantity;
import squants.SiBaseUnit;
import squants.UnitOfMeasure;
import squants.radio.AreaTime;
import squants.radio.SquareMeterSeconds$;
import squants.space.Area;
import squants.time.Days$;
import squants.time.Hours$;
import squants.time.Microseconds$;
import squants.time.Milliseconds$;
import squants.time.Minutes$;
import squants.time.Nanoseconds$;
import squants.time.Seconds$;
import squants.time.Time$;
import squants.time.TimeDerivative;
import squants.time.TimeSquared;
import squants.time.TimeSquared$;
import squants.time.TimeUnit;

public final class Time
extends Quantity<Time> {
    private final double value;
    private final TimeUnit unit;
    public static final long OFFSET$_m_0 = LazyVals$.MODULE$.getOffset(Time$.class, "0bitmap$1");

    public static double HoursPerDay() {
        return Time$.MODULE$.HoursPerDay();
    }

    public static double MicrosecondsPerSecond() {
        return Time$.MODULE$.MicrosecondsPerSecond();
    }

    public static double MillisecondsPerDay() {
        return Time$.MODULE$.MillisecondsPerDay();
    }

    public static double MillisecondsPerHour() {
        return Time$.MODULE$.MillisecondsPerHour();
    }

    public static double MillisecondsPerMicrosecond() {
        return Time$.MODULE$.MillisecondsPerMicrosecond();
    }

    public static double MillisecondsPerMinute() {
        return Time$.MODULE$.MillisecondsPerMinute();
    }

    public static double MillisecondsPerNanosecond() {
        return Time$.MODULE$.MillisecondsPerNanosecond();
    }

    public static double MillisecondsPerSecond() {
        return Time$.MODULE$.MillisecondsPerSecond();
    }

    public static double MinutesPerHour() {
        return Time$.MODULE$.MinutesPerHour();
    }

    public static double NanosecondsPerSecond() {
        return Time$.MODULE$.NanosecondsPerSecond();
    }

    public static double SecondsPerDay() {
        return Time$.MODULE$.SecondsPerDay();
    }

    public static double SecondsPerHour() {
        return Time$.MODULE$.SecondsPerHour();
    }

    public static double SecondsPerMinute() {
        return Time$.MODULE$.SecondsPerMinute();
    }

    public static Time apply(Duration duration) {
        return Time$.MODULE$.apply(duration);
    }

    public static Try<Time> apply(Object object) {
        return Time$.MODULE$.apply(object);
    }

    public static <A> Time apply(A a, TimeUnit timeUnit, Numeric<A> numeric) {
        return Time$.MODULE$.apply(a, timeUnit, numeric);
    }

    public static Dimension dimensionImplicit() {
        return Time$.MODULE$.dimensionImplicit();
    }

    public static String dimensionSymbol() {
        return Time$.MODULE$.dimensionSymbol();
    }

    public static String name() {
        return Time$.MODULE$.name();
    }

    public static Try<Time> parseString(String string) {
        return Time$.MODULE$.parseString(string);
    }

    public static <N> Try<Time> parseTuple(Tuple2<N, String> tuple2, Numeric<N> numeric) {
        return Time$.MODULE$.parseTuple((Tuple2)tuple2, (Numeric)numeric);
    }

    public static PrimaryUnit primaryUnit() {
        return Time$.MODULE$.primaryUnit();
    }

    public static SiBaseUnit siUnit() {
        return Time$.MODULE$.siUnit();
    }

    public static Option<UnitOfMeasure<Time>> symbolToUnit(String string) {
        return Time$.MODULE$.symbolToUnit(string);
    }

    public static Set units() {
        return Time$.MODULE$.units();
    }

    public static void squants$Dimension$_setter_$dimensionImplicit_$eq(Dimension dimension) {
        Time$.MODULE$.squants$Dimension$_setter_$dimensionImplicit_$eq(dimension);
    }

    public Time(double value, TimeUnit unit) {
        this.value = value;
        this.unit = unit;
    }

    @Override
    public double value() {
        return this.value;
    }

    public TimeUnit unit() {
        return this.unit;
    }

    @Override
    public Dimension<Time> dimension() {
        return Time$.MODULE$;
    }

    public long millis() {
        return (long)this.toMilliseconds();
    }

    public <A extends Quantity<A>> A $times(TimeDerivative<A> that) {
        return that.$times(this);
    }

    public TimeSquared $times(Time that) {
        return TimeSquared$.MODULE$.apply(this, that);
    }

    public TimeSquared squared() {
        return TimeSquared$.MODULE$.apply(this);
    }

    public AreaTime $times(Area that) {
        return SquareMeterSeconds$.MODULE$.apply(BoxesRunTime.boxToDouble((double)(this.toSeconds() * that.toSquareMeters())), (Numeric)Numeric.DoubleIsFractional$.MODULE$);
    }

    public double toNanoseconds() {
        return this.to(Nanoseconds$.MODULE$);
    }

    public double toMicroseconds() {
        return this.to(Microseconds$.MODULE$);
    }

    public double toMilliseconds() {
        return this.to(Milliseconds$.MODULE$);
    }

    public double toSeconds() {
        return this.to(Seconds$.MODULE$);
    }

    public double toMinutes() {
        return this.to(Minutes$.MODULE$);
    }

    public double toHours() {
        return this.to(Hours$.MODULE$);
    }

    public double toDays() {
        return this.to(Days$.MODULE$);
    }
}

