/*
 * Decompiled with CFR 0.152.
 */
package org.openmole.spatialsampling;

import java.io.Serializable;
import org.openmole.spatialsampling.Math$;
import org.openmole.spatialsampling.Morphology;
import org.openmole.spatialsampling.Network;
import org.openmole.spatialsampling.Network$;
import scala.Function1;
import scala.Function3;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple14;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Vector;
import scala.math.Numeric;
import scala.math.package$;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction1;
import scala.util.Random;

public final class Morphology$
implements Serializable {
    public static final Morphology$ MODULE$ = new Morphology$();

    public Morphology apply(double[][] grid, Random rng) {
        Network cachedNetwork = Network$.MODULE$.gridToNetwork(grid);
        return new Morphology(grid.length, grid[0].length, BoxesRunTime.unboxToDouble((Object)Predef$.MODULE$.wrapDoubleArray((double[])ArrayOps$.MODULE$.flatten$extension(Predef$.MODULE$.refArrayOps((Object[])grid), (Function1 & Serializable)xs -> Predef$.MODULE$.wrapDoubleArray(xs), (ClassTag)ClassTag$.MODULE$.Double())).sum((Numeric)Numeric.DoubleIsFractional$.MODULE$)), this.moranDirect(grid), this.distanceMeanDirect(grid), Math$.MODULE$.entropy((double[])ArrayOps$.MODULE$.flatten$extension(Predef$.MODULE$.refArrayOps((Object[])grid), (Function1 & Serializable)xs -> Predef$.MODULE$.wrapDoubleArray(xs), (ClassTag)ClassTag$.MODULE$.Double())), Math$.MODULE$.slope((double[])ArrayOps$.MODULE$.flatten$extension(Predef$.MODULE$.refArrayOps((Object[])grid), (Function1 & Serializable)xs -> Predef$.MODULE$.wrapDoubleArray(xs), (ClassTag)ClassTag$.MODULE$.Double())), this.density(grid), this.components(grid, (Option<Network>)new Some((Object)cachedNetwork)), this.avgDetour(grid, (Option<Network>)new Some((Object)cachedNetwork), this.avgDetour$default$3(), rng), this.avgBlockArea(grid, (Option<Network>)new Some((Object)cachedNetwork)), this.avgComponentArea(grid), this.fullDilationSteps(grid, this.fullDilationSteps$default$2()), this.fullErosionSteps(grid, this.fullErosionSteps$default$2()));
    }

    public double density(double[][] world) {
        return BoxesRunTime.unboxToDouble((Object)Predef$.MODULE$.wrapDoubleArray((double[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.doubleArrayOps((double[])ArrayOps$.MODULE$.filter$extension(Predef$.MODULE$.doubleArrayOps((double[])ArrayOps$.MODULE$.flatten$extension(Predef$.MODULE$.refArrayOps((Object[])world), (Function1 & Serializable)xs -> Predef$.MODULE$.wrapDoubleArray(xs), (ClassTag)ClassTag$.MODULE$.Double())), (Function1)(JFunction1.mcZD.sp & Serializable)x$1 -> x$1 > 0.0)), (Function1)(JFunction1.mcDD.sp & Serializable)x$2 -> 1.0, (ClassTag)ClassTag$.MODULE$.Double())).sum((Numeric)Numeric.DoubleIsFractional$.MODULE$)) / (double)((double[])ArrayOps$.MODULE$.flatten$extension(Predef$.MODULE$.refArrayOps((Object[])world), (Function1 & Serializable)xs -> Predef$.MODULE$.wrapDoubleArray(xs), (ClassTag)ClassTag$.MODULE$.Double())).length;
    }

    public double avgBlockArea(double[][] world, Option<Network> cachedNetwork) {
        Option<Network> option = cachedNetwork;
        Network network = None$.MODULE$.equals(option) ? Network$.MODULE$.gridToNetwork(world) : (Network)option.get();
        Network nw = network;
        Seq<Network> components = Network$.MODULE$.connectedComponentsTraverse(nw);
        int n = components.size();
        switch (n) {
            default: 
        }
        double avgblockarea = n == 0 ? 0.0 : (double)BoxesRunTime.unboxToInt((Object)((IterableOnceOps)components.map((Function1 & Serializable)x$3 -> BoxesRunTime.boxToInteger((int)Morphology$.$anonfun$avgBlockArea$1(x$3)))).sum((Numeric)Numeric.IntIsIntegral$.MODULE$)) / (double)components.size();
        return avgblockarea;
    }

    public Option<Network> avgBlockArea$default$2() {
        return None$.MODULE$;
    }

    public double avgComponentArea(double[][] world) {
        Network inversedNetwork = Network$.MODULE$.gridToNetwork((double[][])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])world), (Function1 & Serializable)x$4 -> (double[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.doubleArrayOps(x$4), (Function1)(JFunction1.mcDD.sp & Serializable)x -> 1.0 - x, (ClassTag)ClassTag$.MODULE$.Double()), ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Double.TYPE))));
        Seq<Network> components = Network$.MODULE$.connectedComponentsTraverse(inversedNetwork);
        return components.nonEmpty() ? (double)(BoxesRunTime.unboxToInt((Object)((IterableOnceOps)components.map((Function1 & Serializable)x$5 -> BoxesRunTime.boxToInteger((int)Morphology$.$anonfun$avgComponentArea$3(x$5)))).sum((Numeric)Numeric.IntIsIntegral$.MODULE$)) / components.size()) : 0.0;
    }

    public double distanceMeanDirect(double[][] matrix) {
        if (Morphology$.totalQuantity$1(matrix) == 0.0 || Morphology$.normalisation$1(matrix) == 0.0) {
            return 0.0;
        }
        return this.numerator$1(matrix) / (Morphology$.totalQuantity$1(matrix) * Morphology$.totalQuantity$1(matrix)) / Morphology$.normalisation$1(matrix);
    }

    public double distance(Tuple2<Object, Object> p1, Tuple2<Object, Object> p2) {
        Tuple2<Object, Object> tuple2 = p1;
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        int i1 = tuple2._1$mcI$sp();
        int j1 = tuple2._2$mcI$sp();
        Tuple2.mcII.sp sp2 = new Tuple2.mcII.sp(i1, j1);
        Tuple2.mcII.sp sp3 = sp2;
        int i12 = sp3._1$mcI$sp();
        int j12 = sp3._2$mcI$sp();
        Tuple2<Object, Object> tuple22 = p2;
        if (tuple22 == null) {
            throw new MatchError(tuple22);
        }
        int i2 = tuple22._1$mcI$sp();
        int j2 = tuple22._2$mcI$sp();
        Tuple2.mcII.sp sp4 = new Tuple2.mcII.sp(i2, j2);
        Tuple2.mcII.sp sp5 = sp4;
        int i22 = sp5._1$mcI$sp();
        int j22 = sp5._2$mcI$sp();
        int a = i22 - i12;
        int b = j22 - j12;
        return package$.MODULE$.sqrt((double)(a * a + b * b));
    }

    public Seq<Tuple2<Object, Tuple2<Object, Object>>> zipWithPosition(double[][] m) {
        return ArrayOps$.MODULE$.toSeq$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.flatMap$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.zipWithIndex$extension(Predef$.MODULE$.refArrayOps((Object[])m))), (Function1 & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            double[] row = (double[])tuple2._1();
            int i = tuple2._2$mcI$sp();
            Tuple2[] tuple2Array = (Tuple2[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.zipWithIndex$extension(Predef$.MODULE$.doubleArrayOps(row))), (Function1 & Serializable)x0$2 -> {
                Tuple2 tuple2 = x0$2;
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                double content = tuple2._1$mcD$sp();
                int j = tuple2._2$mcI$sp();
                Tuple2 tuple22 = new Tuple2((Object)BoxesRunTime.boxToDouble((double)content), (Object)new Tuple2.mcII.sp(i, j));
                return tuple22;
            }, ClassTag$.MODULE$.apply(Tuple2.class));
            return tuple2Array;
        }, (Function1 & Serializable)xs -> Predef$.MODULE$.wrapRefArray((Object[])xs), ClassTag$.MODULE$.apply(Tuple2.class))));
    }

    public double moranDirect(double[][] matrix) {
        double totalPop = BoxesRunTime.unboxToDouble((Object)Predef$.MODULE$.wrapDoubleArray(Morphology$.flatCells$1(matrix)).sum((Numeric)Numeric.DoubleIsFractional$.MODULE$));
        double averagePop = totalPop / (double)((double[])ArrayOps$.MODULE$.flatten$extension(Predef$.MODULE$.refArrayOps((Object[])matrix), (Function1 & Serializable)xs -> Predef$.MODULE$.wrapDoubleArray(xs), (ClassTag)ClassTag$.MODULE$.Double())).length;
        return Morphology$.denominator$1(averagePop, matrix) == 0.0 ? 0.0 : (double)((double[])ArrayOps$.MODULE$.flatten$extension(Predef$.MODULE$.refArrayOps((Object[])matrix), (Function1 & Serializable)xs -> Predef$.MODULE$.wrapDoubleArray(xs), (ClassTag)ClassTag$.MODULE$.Double())).length / this.totalWeight$1(matrix, averagePop) * (this.numerator$2(matrix, averagePop) / Morphology$.denominator$1(averagePop, matrix));
    }

    public double components(double[][] world, Option<Network> cachedNetwork) {
        Option<Network> option = cachedNetwork;
        Network network = None$.MODULE$.equals(option) ? Network$.MODULE$.gridToNetwork(world) : (Network)option.get();
        Network nw = network;
        Seq<Network> components = Network$.MODULE$.connectedComponentsTraverse(nw);
        return components.size();
    }

    public Option<Network> components$default$2() {
        return None$.MODULE$;
    }

    public double[][] dilation(double[][] matrix, Function3<double[][], double[][], Function1<Object, Object>, double[][]> convol) {
        return (double[][])convol.apply((Object)matrix, (Object)((Object[])new double[][]{{0.0, 1.0, 0.0}, {1.0, 1.0, 1.0}, {0.0, 1.0, 0.0}}), (JFunction1.mcDD.sp & Serializable)d -> d > 0.0 ? 1.0 : 0.0);
    }

    public Function3<double[][], double[][], Function1<Object, Object>, double[][]> dilation$default$2() {
        return (Function3 & Serializable)(matrix, mask, filter) -> Math$.MODULE$.convolution2dDirect((double[][])matrix, (double[][])mask, (Function1<Object, Object>)filter);
    }

    public double[][] erosion(double[][] matrix, Function3<double[][], double[][], Function1<Object, Object>, double[][]> convol) {
        double[][] mask = (double[][])((Object[])new double[][]{{0.0, 1.0, 0.0}, {1.0, 1.0, 1.0}, {0.0, 1.0, 0.0}});
        return (double[][])convol.apply((Object)matrix, (Object)mask, (JFunction1.mcDD.sp & Serializable)d -> d == BoxesRunTime.unboxToDouble((Object)Predef$.MODULE$.wrapDoubleArray((double[])ArrayOps$.MODULE$.flatten$extension(Predef$.MODULE$.refArrayOps((Object[])mask), (Function1 & Serializable)xs -> Predef$.MODULE$.wrapDoubleArray(xs), (ClassTag)ClassTag$.MODULE$.Double())).sum((Numeric)Numeric.DoubleIsFractional$.MODULE$)) ? 1.0 : 0.0);
    }

    public Function3<double[][], double[][], Function1<Object, Object>, double[][]> erosion$default$2() {
        return (Function3 & Serializable)(matrix, mask, filter) -> Math$.MODULE$.convolution2dDirect((double[][])matrix, (double[][])mask, (Function1<Object, Object>)filter);
    }

    public double fullDilationSteps(double[][] matrix, Function3<double[][], double[][], Function1<Object, Object>, double[][]> convol) {
        int steps = 0;
        boolean complete = false;
        double[][] currentworld = matrix;
        if (BoxesRunTime.unboxToDouble((Object)Predef$.MODULE$.wrapDoubleArray((double[])ArrayOps$.MODULE$.flatten$extension(Predef$.MODULE$.refArrayOps((Object[])matrix), (Function1 & Serializable)xs -> Predef$.MODULE$.wrapDoubleArray(xs), (ClassTag)ClassTag$.MODULE$.Double())).sum((Numeric)Numeric.DoubleIsFractional$.MODULE$)) == 0.0) {
            return 0.0;
        }
        while (!complete) {
            complete = BoxesRunTime.unboxToDouble((Object)Predef$.MODULE$.wrapDoubleArray((double[])ArrayOps$.MODULE$.flatten$extension(Predef$.MODULE$.refArrayOps((Object[])(currentworld = this.dilation(currentworld, convol))), (Function1 & Serializable)xs -> Predef$.MODULE$.wrapDoubleArray(xs), (ClassTag)ClassTag$.MODULE$.Double())).sum((Numeric)Numeric.DoubleIsFractional$.MODULE$)) == (double)((double[])ArrayOps$.MODULE$.flatten$extension(Predef$.MODULE$.refArrayOps((Object[])currentworld), (Function1 & Serializable)xs -> Predef$.MODULE$.wrapDoubleArray(xs), (ClassTag)ClassTag$.MODULE$.Double())).length;
            ++steps;
        }
        return steps;
    }

    public Function3<double[][], double[][], Function1<Object, Object>, double[][]> fullDilationSteps$default$2() {
        return (Function3 & Serializable)(matrix, mask, filter) -> Math$.MODULE$.convolution2dDirect((double[][])matrix, (double[][])mask, (Function1<Object, Object>)filter);
    }

    public double fullErosionSteps(double[][] matrix, Function3<double[][], double[][], Function1<Object, Object>, double[][]> convol) {
        int steps = 0;
        boolean complete = false;
        double[][] currentworld = matrix;
        if (BoxesRunTime.unboxToDouble((Object)Predef$.MODULE$.wrapDoubleArray((double[])ArrayOps$.MODULE$.flatten$extension(Predef$.MODULE$.refArrayOps((Object[])matrix), (Function1 & Serializable)xs -> Predef$.MODULE$.wrapDoubleArray(xs), (ClassTag)ClassTag$.MODULE$.Double())).sum((Numeric)Numeric.DoubleIsFractional$.MODULE$)) == (double)((double[])ArrayOps$.MODULE$.flatten$extension(Predef$.MODULE$.refArrayOps((Object[])matrix), (Function1 & Serializable)xs -> Predef$.MODULE$.wrapDoubleArray(xs), (ClassTag)ClassTag$.MODULE$.Double())).length) {
            return 0.0;
        }
        while (!complete) {
            complete = BoxesRunTime.unboxToDouble((Object)Predef$.MODULE$.wrapDoubleArray((double[])ArrayOps$.MODULE$.flatten$extension(Predef$.MODULE$.refArrayOps((Object[])(currentworld = this.erosion(currentworld, convol))), (Function1 & Serializable)xs -> Predef$.MODULE$.wrapDoubleArray(xs), (ClassTag)ClassTag$.MODULE$.Double())).sum((Numeric)Numeric.DoubleIsFractional$.MODULE$)) == 0.0;
            ++steps;
        }
        return steps;
    }

    public Function3<double[][], double[][], Function1<Object, Object>, double[][]> fullErosionSteps$default$2() {
        return (Function3 & Serializable)(matrix, mask, filter) -> Math$.MODULE$.convolution2dDirect((double[][])matrix, (double[][])mask, (Function1<Object, Object>)filter);
    }

    public double avgDetour(double[][] world, Option<Network> cachedNetwork, int sampledPoints, Random rng) {
        if (BoxesRunTime.unboxToDouble((Object)Predef$.MODULE$.wrapDoubleArray((double[])ArrayOps$.MODULE$.flatten$extension(Predef$.MODULE$.refArrayOps((Object[])world), (Function1 & Serializable)xs -> Predef$.MODULE$.wrapDoubleArray(xs), (ClassTag)ClassTag$.MODULE$.Double())).sum((Numeric)Numeric.DoubleIsFractional$.MODULE$)) == (double)BoxesRunTime.unboxToInt((Object)Predef$.MODULE$.wrapIntArray((int[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])world), (Function1 & Serializable)x$12 -> BoxesRunTime.boxToInteger((int)Morphology$.$anonfun$avgDetour$2(x$12)), (ClassTag)ClassTag$.MODULE$.Int())).sum((Numeric)Numeric.IntIsIntegral$.MODULE$))) {
            return 0.0;
        }
        Option<Network> option = cachedNetwork;
        Network network = None$.MODULE$.equals(option) ? Network$.MODULE$.gridToNetwork(world) : (Network)option.get();
        Network nw = network;
        Vector sampled = Math$.MODULE$.sampleWithoutReplacement(nw.nodes().toSeq(), sampledPoints, rng);
        Map<Tuple2<Network.Node, Network.Node>, Tuple3<Seq<Network.Node>, Seq<Network.Link>, Object>> paths = Network$.MODULE$.shortestPaths(nw, (Seq<Network.Node>)sampled, (Seq<Network.Node>)sampled);
        double avgdetour = BoxesRunTime.unboxToDouble((Object)((IterableOnceOps)((IterableOps)((IterableOps)((IterableOps)paths.toSeq().filter((Function1 & Serializable)x$13 -> BoxesRunTime.boxToBoolean((boolean)Morphology$.$anonfun$avgDetour$3(x$13)))).map((Function1 & Serializable)x0$1 -> BoxesRunTime.boxToDouble((double)Morphology$.$anonfun$avgDetour$4(x0$1)))).filter((Function1)(JFunction1.mcZD.sp & Serializable)x$15 -> !Predef$.MODULE$.double2Double(x$15).isNaN())).filter((Function1)(JFunction1.mcZD.sp & Serializable)x$16 -> !Predef$.MODULE$.double2Double(x$16).isInfinite())).sum((Numeric)Numeric.DoubleIsFractional$.MODULE$)) / (double)paths.size();
        return avgdetour;
    }

    public Option<Network> avgDetour$default$2() {
        return None$.MODULE$;
    }

    public int avgDetour$default$3() {
        return 50;
    }

    public Morphology apply(double height, double width, double area, double moran, double avgDistance, double entropy, Tuple2<Object, Object> slope, double density, double components, double avgDetour, double avgBlockArea, double avgComponentArea, double fullDilationSteps, double fullErosionSteps) {
        return new Morphology(height, width, area, moran, avgDistance, entropy, slope, density, components, avgDetour, avgBlockArea, avgComponentArea, fullDilationSteps, fullErosionSteps);
    }

    public Option<Tuple14<Object, Object, Object, Object, Object, Object, Tuple2<Object, Object>, Object, Object, Object, Object, Object, Object, Object>> unapply(Morphology x$0) {
        return x$0 == null ? None$.MODULE$ : new Some((Object)new Tuple14((Object)BoxesRunTime.boxToDouble((double)x$0.height()), (Object)BoxesRunTime.boxToDouble((double)x$0.width()), (Object)BoxesRunTime.boxToDouble((double)x$0.area()), (Object)BoxesRunTime.boxToDouble((double)x$0.moran()), (Object)BoxesRunTime.boxToDouble((double)x$0.avgDistance()), (Object)BoxesRunTime.boxToDouble((double)x$0.entropy()), x$0.slope(), (Object)BoxesRunTime.boxToDouble((double)x$0.density()), (Object)BoxesRunTime.boxToDouble((double)x$0.components()), (Object)BoxesRunTime.boxToDouble((double)x$0.avgDetour()), (Object)BoxesRunTime.boxToDouble((double)x$0.avgBlockArea()), (Object)BoxesRunTime.boxToDouble((double)x$0.avgComponentArea()), (Object)BoxesRunTime.boxToDouble((double)x$0.fullDilationSteps()), (Object)BoxesRunTime.boxToDouble((double)x$0.fullErosionSteps())));
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(Morphology$.class);
    }

    public static final /* synthetic */ int $anonfun$avgBlockArea$1(Network x$3) {
        return x$3.nodes().size();
    }

    public static final /* synthetic */ int $anonfun$avgComponentArea$3(Network x$5) {
        return x$5.nodes().size();
    }

    private static final double totalQuantity$1(double[][] matrix$1) {
        return BoxesRunTime.unboxToDouble((Object)Predef$.MODULE$.wrapDoubleArray((double[])ArrayOps$.MODULE$.flatten$extension(Predef$.MODULE$.refArrayOps((Object[])matrix$1), (Function1 & Serializable)xs -> Predef$.MODULE$.wrapDoubleArray(xs), (ClassTag)ClassTag$.MODULE$.Double())).sum((Numeric)Numeric.DoubleIsFractional$.MODULE$));
    }

    public static final /* synthetic */ boolean $anonfun$distanceMeanDirect$2(Tuple2 check$ifrefutable$1) {
        Tuple2 tuple2 = check$ifrefutable$1;
        boolean bl = tuple2 != null;
        return bl;
    }

    public static final /* synthetic */ boolean $anonfun$distanceMeanDirect$4(Tuple2 check$ifrefutable$2) {
        Tuple2 tuple2 = check$ifrefutable$2;
        boolean bl = tuple2 != null;
        return bl;
    }

    public static final /* synthetic */ double $anonfun$distanceMeanDirect$5(Tuple2 p1$1, double c1$1, Tuple2 x$6) {
        Tuple2 tuple2 = x$6;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        double c2 = tuple2._1$mcD$sp();
        Tuple2 p2 = (Tuple2)tuple2._2();
        double d = MODULE$.distance((Tuple2<Object, Object>)p1$1, (Tuple2<Object, Object>)p2) * c1$1 * c2;
        return d;
    }

    private final double numerator$1(double[][] matrix$1) {
        return BoxesRunTime.unboxToDouble((Object)((IterableOnceOps)this.zipWithPosition(matrix$1).withFilter((Function1 & Serializable)check$ifrefutable$1 -> BoxesRunTime.boxToBoolean((boolean)Morphology$.$anonfun$distanceMeanDirect$2(check$ifrefutable$1))).flatMap((Function1 & Serializable)x$7 -> {
            Tuple2 tuple2 = x$7;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            double c1 = tuple2._1$mcD$sp();
            Tuple2 p1 = (Tuple2)tuple2._2();
            Seq seq = (Seq)MODULE$.zipWithPosition(matrix$1).withFilter((Function1 & Serializable)check$ifrefutable$2 -> BoxesRunTime.boxToBoolean((boolean)Morphology$.$anonfun$distanceMeanDirect$4(check$ifrefutable$2))).map((Function1 & Serializable)x$6 -> BoxesRunTime.boxToDouble((double)Morphology$.$anonfun$distanceMeanDirect$5(p1, c1, x$6)));
            return seq;
        })).sum((Numeric)Numeric.DoubleIsFractional$.MODULE$));
    }

    private static final double normalisation$1(double[][] matrix$1) {
        return package$.MODULE$.sqrt((double)((double[])ArrayOps$.MODULE$.flatten$extension(Predef$.MODULE$.refArrayOps((Object[])matrix$1), (Function1 & Serializable)xs -> Predef$.MODULE$.wrapDoubleArray(xs), (ClassTag)ClassTag$.MODULE$.Double())).length / Math.PI);
    }

    private final double decay$1(Tuple2 p1, Tuple2 p2) {
        Tuple2 tuple2 = p1;
        Tuple2 tuple22 = p2;
        return !(tuple2 != null ? !tuple2.equals(tuple22) : tuple22 != null) ? 0.0 : 1.0 / this.distance((Tuple2<Object, Object>)p1, (Tuple2<Object, Object>)p2);
    }

    private static final double[] flatCells$1(double[][] matrix$2) {
        return (double[])ArrayOps$.MODULE$.flatten$extension(Predef$.MODULE$.refArrayOps((Object[])matrix$2), (Function1 & Serializable)xs -> Predef$.MODULE$.wrapDoubleArray(xs), (ClassTag)ClassTag$.MODULE$.Double());
    }

    public static final /* synthetic */ boolean $anonfun$moranDirect$3(Tuple2 check$ifrefutable$3) {
        Tuple2 tuple2 = check$ifrefutable$3;
        boolean bl = tuple2 != null;
        return bl;
    }

    public static final /* synthetic */ boolean $anonfun$moranDirect$5(Tuple2 check$ifrefutable$4) {
        Tuple2 tuple2 = check$ifrefutable$4;
        boolean bl = tuple2 != null;
        return bl;
    }

    private final Seq vals$1(double[][] matrix$2, double averagePop$1) {
        return (Seq)this.zipWithPosition(matrix$2).withFilter((Function1 & Serializable)check$ifrefutable$3 -> BoxesRunTime.boxToBoolean((boolean)Morphology$.$anonfun$moranDirect$3(check$ifrefutable$3))).flatMap((Function1 & Serializable)x$11 -> {
            Tuple2 tuple2 = x$11;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            double c1 = tuple2._1$mcD$sp();
            Tuple2 p1 = (Tuple2)tuple2._2();
            Seq seq = (Seq)MODULE$.zipWithPosition(matrix$2).withFilter((Function1 & Serializable)check$ifrefutable$4 -> BoxesRunTime.boxToBoolean((boolean)Morphology$.$anonfun$moranDirect$5(check$ifrefutable$4))).map((Function1 & Serializable)x$10 -> {
                Tuple2 tuple2 = x$10;
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                double c2 = tuple2._1$mcD$sp();
                Tuple2 p2 = (Tuple2)tuple2._2();
                Tuple2.mcDD.sp sp2 = new Tuple2.mcDD.sp(this.decay$1(p1, p2) * (c1 - averagePop$1) * (c2 - averagePop$1), this.decay$1(p1, p2));
                return sp2;
            });
            return seq;
        });
    }

    public static final /* synthetic */ double $anonfun$moranDirect$7(Tuple2 x0$1) {
        double n;
        Tuple2 tuple2 = x0$1;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        double d = n = tuple2._1$mcD$sp();
        return d;
    }

    private final double numerator$2(double[][] matrix$2, double averagePop$1) {
        return BoxesRunTime.unboxToDouble((Object)((IterableOnceOps)this.vals$1(matrix$2, averagePop$1).map((Function1 & Serializable)x0$1 -> BoxesRunTime.boxToDouble((double)Morphology$.$anonfun$moranDirect$7(x0$1)))).sum((Numeric)Numeric.DoubleIsFractional$.MODULE$));
    }

    public static final /* synthetic */ double $anonfun$moranDirect$8(Tuple2 x0$1) {
        double w;
        Tuple2 tuple2 = x0$1;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        double d = w = tuple2._2$mcD$sp();
        return d;
    }

    private final double totalWeight$1(double[][] matrix$2, double averagePop$1) {
        return BoxesRunTime.unboxToDouble((Object)((IterableOnceOps)this.vals$1(matrix$2, averagePop$1).map((Function1 & Serializable)x0$1 -> BoxesRunTime.boxToDouble((double)Morphology$.$anonfun$moranDirect$8(x0$1)))).sum((Numeric)Numeric.DoubleIsFractional$.MODULE$));
    }

    private static final double denominator$1(double averagePop$1, double[][] matrix$2) {
        return BoxesRunTime.unboxToDouble((Object)Predef$.MODULE$.wrapDoubleArray((double[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.doubleArrayOps(Morphology$.flatCells$1(matrix$2)), (Function1)(JFunction1.mcDD.sp & Serializable)p -> p == 0.0 ? 0.0 : package$.MODULE$.pow(p - averagePop$1, 2.0), (ClassTag)ClassTag$.MODULE$.Double())).sum((Numeric)Numeric.DoubleIsFractional$.MODULE$));
    }

    public static final /* synthetic */ int $anonfun$avgDetour$2(double[] x$12) {
        return x$12.length;
    }

    public static final /* synthetic */ boolean $anonfun$avgDetour$3(Tuple2 x$13) {
        return !Predef$.MODULE$.double2Double(BoxesRunTime.unboxToDouble((Object)((Tuple3)x$13._2())._3())).isInfinite();
    }

    public static final /* synthetic */ double $anonfun$avgDetour$4(Tuple2 x0$1) {
        Tuple2 tuple2;
        double d;
        Tuple3 tuple3;
        Tuple2 tuple22 = x0$1;
        if (tuple22 != null && (tuple3 = (Tuple3)tuple22._2()) != null) {
            Seq nodes = (Seq)tuple3._1();
            d = BoxesRunTime.unboxToDouble((Object)tuple3._3());
            Tuple2 tuple23 = new Tuple2(nodes.head(), nodes.last());
            if (tuple23 == null) {
                throw new MatchError((Object)tuple23);
            }
            Network.Node n1 = (Network.Node)tuple23._1();
            Network.Node n2 = (Network.Node)tuple23._2();
            tuple2 = new Tuple2((Object)n1, (Object)n2);
        } else {
            throw new MatchError((Object)tuple22);
        }
        Tuple2 tuple24 = tuple2;
        Network.Node n1 = (Network.Node)tuple24._1();
        Network.Node n2 = (Network.Node)tuple24._2();
        double de = package$.MODULE$.sqrt((n1.x() - n2.x()) * (n1.x() - n2.x()) + (n1.y() - n2.y()) * (n1.y() - n2.y()));
        double d2 = d / de;
        return d2;
    }

    private Morphology$() {
    }
}

