/*
 * Decompiled with CFR 0.152.
 */
package org.openmole.core.fileservice;

import java.io.File;
import java.io.Serializable;
import java.util.concurrent.LinkedBlockingQueue;
import org.openmole.core.fileservice.FileService;
import org.openmole.core.threadprovider.ThreadProvider;
import org.openmole.tool.file.package$;
import scala.Function0;
import scala.ref.WeakReference;
import scala.runtime.java8.JFunction0;

public class AsynchronousDeleter {
    private final WeakReference<FileService> fileService;
    private final LinkedBlockingQueue<File> cleanFiles;

    public AsynchronousDeleter(WeakReference<FileService> fileService) {
        this.fileService = fileService;
        this.cleanFiles = new LinkedBlockingQueue();
    }

    public boolean stop() {
        return !this.fileService.get().isDefined();
    }

    public boolean asynchronousRemove(File file) {
        return this.cleanFiles.add(file);
    }

    private void run() {
        while (!this.cleanFiles.isEmpty() || !this.stop()) {
            package$.MODULE$.FileDecorator(this.cleanFiles.take()).recursiveDelete();
        }
    }

    public void start(ThreadProvider threadProvider) {
        threadProvider.virtual((Function0)(JFunction0.mcV.sp & Serializable)() -> this.run());
    }
}

