/*
 * Decompiled with CFR 0.152.
 */
package org.openmole.gui.client.core.files;

import com.raquo.airstream.core.Observer;
import com.raquo.airstream.core.Sink;
import com.raquo.airstream.core.Source;
import com.raquo.airstream.state.Var;
import com.raquo.laminar.Implicits;
import com.raquo.laminar.api.package$;
import com.raquo.laminar.modifiers.Modifier;
import com.raquo.laminar.nodes.ReactiveHtmlElement;
import com.raquo.laminar.tags.HtmlTag;
import java.io.Serializable;
import org.openmole.gui.client.core.Panels;
import org.openmole.gui.client.core.files.EditorPanelUI$;
import org.openmole.gui.client.core.files.EditorPanelUI$HighlightedFile$;
import org.openmole.gui.client.ext.FileContentType;
import org.openmole.gui.client.ext.FileContentType$;
import org.openmole.gui.client.ext.GUIPlugins;
import org.openmole.gui.client.ext.ReadableFileType;
import org.openmole.gui.shared.data.CompilationErrorData;
import org.openmole.gui.shared.data.ErrorData;
import org.openmole.gui.shared.data.MessageErrorData;
import org.openmole.gui.shared.data.SafePath;
import org.openmole.gui.shared.data.ScriptError;
import org.scalajs.dom.Element;
import org.scalajs.dom.HTMLDivElement;
import org.scalajs.dom.MouseEvent;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Some$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.IterableOps;
import scala.collection.immutable.Seq;
import scala.math.Ordering;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.scalajs.js.Any;
import scala.scalajs.js.Any$;
import scala.scalajs.js.Dynamic;
import scala.scalajs.js.Function;
import scala.util.hashing.MurmurHash3$;
import scaladget.ace.Document;
import scaladget.ace.Editor;
import scaladget.ace.IEditSession;
import scaladget.ace.ace$;

public class EditorPanelUI {
    private final SafePath safePath;
    private final FileContentType fileContentType;
    private final Var<Object> modified;
    private final Var<Option<ErrorData>> errors;
    private final Var<Option<String>> errorMessage;
    private final Var<String> errorAreaSize;
    private final ReactiveHtmlElement<HTMLDivElement> edDiv;
    private final Editor editor;
    private String contentHash;
    private Var lineHeight$lzy1;
    private boolean lineHeightbitmap$1;
    private final Observer<Object> lineHeightObserver;
    private final ReactiveHtmlElement<HTMLDivElement> view;

    public static EditorPanelUI apply(SafePath safePath, String string, String string2, GUIPlugins gUIPlugins, Panels panels) {
        return EditorPanelUI$.MODULE$.apply(safePath, string, string2, gUIPlugins, panels);
    }

    public static Option<HighlightedFile> highlightedFile(FileContentType fileContentType, GUIPlugins gUIPlugins) {
        return EditorPanelUI$.MODULE$.highlightedFile(fileContentType, gUIPlugins);
    }

    public EditorPanelUI(SafePath safePath, GUIPlugins plugins, Panels panels) {
        Modifier modifier;
        this.safePath = safePath;
        this.fileContentType = FileContentType$.MODULE$.apply(safePath, plugins);
        this.modified = package$.MODULE$.L().Var().apply((Object)BoxesRunTime.boxToBoolean((boolean)false));
        this.errors = package$.MODULE$.L().Var().apply((Object)None$.MODULE$);
        this.errorMessage = package$.MODULE$.L().Var().apply((Object)None$.MODULE$);
        this.errorAreaSize = package$.MODULE$.L().Var().apply((Object)"100px");
        this.edDiv = package$.MODULE$.L().div().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Modifier[]{package$.MODULE$.L().idAttr().$colon$eq((Object)"editor"), package$.MODULE$.L().fontFamily().$colon$eq((Object)"monospace")}));
        Editor ed = ace$.MODULE$.edit((Element)this.edDiv().ref());
        IEditSession session = ed.getSession();
        Dynamic.global$.MODULE$.selectDynamic("ace").selectDynamic("config").applyDynamic("set", (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Any[]{Any$.MODULE$.fromString("basePath"), Any$.MODULE$.fromString("js")}));
        Dynamic.global$.MODULE$.selectDynamic("ace").selectDynamic("config").applyDynamic("set", (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Any[]{Any$.MODULE$.fromString("modePath"), Any$.MODULE$.fromString("js")}));
        Dynamic.global$.MODULE$.selectDynamic("ace").selectDynamic("config").applyDynamic("set", (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Any[]{Any$.MODULE$.fromString("themePath"), Any$.MODULE$.fromString("js")}));
        ed.setTheme("ace/theme/github");
        EditorPanelUI$.MODULE$.highlightedFile(this.fileContentType(), plugins).foreach((Function1 & Serializable)h -> session.setMode("ace/mode/" + h.highlighter()));
        ed.renderer().setShowGutter(true);
        ed.setShowPrintMargin(true);
        ed.setAutoScrollEditorIntoView(false);
        Object[] objectArray = new Tuple2[2];
        String string = (String)Predef$.MODULE$.ArrowAssoc((Object)"enableBasicAutocompletion");
        objectArray[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)Any$.MODULE$.fromBoolean(true));
        String string2 = (String)Predef$.MODULE$.ArrowAssoc((Object)"enableLiveAutocompletion");
        objectArray[1] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string2, (Object)Any$.MODULE$.fromBoolean(true));
        ed.setOptions((Dynamic)Dynamic.literal$.MODULE$.applyDynamic("apply", (Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray)));
        this.editor = ed;
        this.contentHash = "";
        this.lineHeightObserver = package$.MODULE$.L().Observer().apply((Function1 & Serializable)v1 -> {
            this.$init$$$anonfun$2(BoxesRunTime.unboxToInt((Object)v1));
            return BoxedUnit.UNIT;
        });
        HtmlTag htmlTag = package$.MODULE$.L().div();
        Object[] objectArray2 = new Modifier[1];
        ReactiveHtmlElement<HTMLDivElement> reactiveHtmlElement = this.edDiv();
        Object[] objectArray3 = new Modifier[3];
        Source source = package$.MODULE$.L().enrichSource(this.lineHeight());
        objectArray3[0] = Implicits.RichSource$.MODULE$.$minus$minus$greater$extension(source, this.lineHeightObserver());
        FileContentType fileContentType = this.fileContentType();
        ReadableFileType readableFileType = FileContentType$.MODULE$.OpenMOLEScript();
        FileContentType fileContentType2 = fileContentType;
        if (!(readableFileType != null ? !readableFileType.equals(fileContentType2) : fileContentType2 != null)) {
            Source source2 = package$.MODULE$.L().enrichSource(this.errors());
            modifier = Implicits.RichSource$.MODULE$.$minus$minus$greater$extension(source2, (Sink)package$.MODULE$.L().Observer().apply((Function1 & Serializable)x$1 -> {
                this.$init$$$anonfun$3((Option)x$1);
                return BoxedUnit.UNIT;
            }));
        } else {
            modifier = package$.MODULE$.L().emptyMod();
        }
        objectArray3[1] = modifier;
        objectArray3[2] = package$.MODULE$.L().eventPropToProcessor(package$.MODULE$.L().onClick()).$minus$minus$greater((Function1 & Serializable)_$4 -> {
            this.$init$$$anonfun$4((MouseEvent)_$4);
            return BoxedUnit.UNIT;
        });
        objectArray2[0] = reactiveHtmlElement.amend((Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray3));
        this.view = htmlTag.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray2));
    }

    public SafePath safePath() {
        return this.safePath;
    }

    public FileContentType fileContentType() {
        return this.fileContentType;
    }

    public Var<Object> modified() {
        return this.modified;
    }

    public Var<Option<ErrorData>> errors() {
        return this.errors;
    }

    public Var<Option<String>> errorMessage() {
        return this.errorMessage;
    }

    public Var<String> errorAreaSize() {
        return this.errorAreaSize;
    }

    public ReactiveHtmlElement<HTMLDivElement> edDiv() {
        return this.edDiv;
    }

    public Editor editor() {
        return this.editor;
    }

    public String contentHash() {
        return this.contentHash;
    }

    public void contentHash_$eq(String x$1) {
        this.contentHash = x$1;
    }

    public void onSaved(String hash) {
        this.contentHash_$eq(hash);
    }

    public Var<Object> lineHeight() {
        if (!this.lineHeightbitmap$1) {
            this.lineHeight$lzy1 = package$.MODULE$.L().Var().apply((Object)BoxesRunTime.boxToInteger((int)17));
            this.lineHeightbitmap$1 = true;
        }
        return this.lineHeight$lzy1;
    }

    public Observer<Object> lineHeightObserver() {
        return this.lineHeightObserver;
    }

    public Dynamic scrollToBottom() {
        return this.editor().renderer().scrollToLine(99999.0, false, true, (Function)Any$.MODULE$.fromFunction0((Function0 & Serializable)() -> {
            EditorPanelUI.scrollToBottom$$anonfun$1();
            return BoxedUnit.UNIT;
        }));
    }

    public void unsetErrors() {
        this.errors().set((Object)None$.MODULE$);
        this.errorMessage().set((Object)None$.MODULE$);
    }

    public String errorMessage(ScriptError e) {
        return e.position().map((Function1 & Serializable)p -> p.line() + ": ").getOrElse(EditorPanelUI::errorMessage$$anonfun$2) + e.message();
    }

    public void updateErrorMessage() {
        ((Option)this.errors().now()).foreach((Function1 & Serializable)x$1 -> {
            this.updateErrorMessage$$anonfun$1((ErrorData)x$1);
            return BoxedUnit.UNIT;
        });
    }

    public void updateFont(int lHeight) {
        this.lineHeight().set((Object)BoxesRunTime.boxToInteger((int)lHeight));
    }

    public ReactiveHtmlElement<HTMLDivElement> view() {
        return this.view;
    }

    public Document aceDoc() {
        return this.editor().getSession().getDocument();
    }

    public Tuple2<String, String> code() {
        Tuple2 tuple2;
        Editor editor = this.editor();
        synchronized (editor) {
            tuple2 = Tuple2$.MODULE$.apply((Object)this.editor().getSession().getValue(), (Object)this.contentHash());
        }
        return tuple2;
    }

    public Dynamic setCode(String content, String hash) {
        Dynamic dynamic;
        Editor editor = this.editor();
        synchronized (editor) {
            this.contentHash_$eq(hash);
            this.editor().getSession().setValue(content);
            this.modified().set((Object)BoxesRunTime.boxToBoolean((boolean)false));
            dynamic = this.editor().getSession().on("change", _$5 -> {
                this.modified().set((Object)BoxesRunTime.boxToBoolean((boolean)true));
                return BoxedUnit.UNIT;
            });
        }
        return dynamic;
    }

    public Dynamic setReadOnly(boolean b) {
        return this.editor().setReadOnly(b);
    }

    public boolean hasBeenModified() {
        return BoxesRunTime.unboxToBoolean((Object)this.modified().now());
    }

    private final /* synthetic */ void $init$$$anonfun$2(int i) {
        this.editor().container().style().lineHeight_$eq(i + "px");
        this.editor().container().style().fontSize_$eq(i - 3 + "px");
        this.editor().renderer().updateFontSize();
    }

    private final /* synthetic */ void $init$$$anonfun$3$$anonfun$1(ScriptError e) {
        e.position().foreach((Function1 & Serializable)p -> this.editor().getSession().setBreakpoint(p.line() - 1));
    }

    private static final int $init$$$anonfun$3$$anonfun$2$$anonfun$2() {
        return -1;
    }

    private final /* synthetic */ void $init$$$anonfun$3$$anonfun$3(ScriptError e) {
        this.errorMessage().set((Object)Some$.MODULE$.apply((Object)this.errorMessage(e)));
    }

    private final /* synthetic */ void $init$$$anonfun$3(Option x$1) {
        Option option = x$1;
        if (option instanceof Some) {
            Some some = (Some)option;
            ErrorData errorData = (ErrorData)some.value();
            if (errorData instanceof CompilationErrorData) {
                CompilationErrorData compilationErrorData;
                CompilationErrorData errors = compilationErrorData = (CompilationErrorData)errorData;
                this.editor().getSession().clearBreakpoints();
                errors.errors().foreach((Function1 & Serializable)e -> {
                    this.$init$$$anonfun$3$$anonfun$1((ScriptError)e);
                    return BoxedUnit.UNIT;
                });
                ((IterableOps)errors.errors().sortBy((Function1 & Serializable)_$2 -> BoxesRunTime.unboxToInt((Object)_$2.position().map((Function1 & Serializable)_$3 -> _$3.line()).getOrElse(EditorPanelUI::$init$$$anonfun$3$$anonfun$2$$anonfun$2)), (Ordering)Ordering.Int$.MODULE$)).headOption().foreach((Function1 & Serializable)e -> {
                    this.$init$$$anonfun$3$$anonfun$3((ScriptError)e);
                    return BoxedUnit.UNIT;
                });
                return;
            }
            if (errorData instanceof MessageErrorData) {
                MessageErrorData messageErrorData;
                MessageErrorData e2 = messageErrorData = (MessageErrorData)errorData;
                this.errorMessage().set((Object)Some$.MODULE$.apply((Object)e2.message()));
                return;
            }
        }
        if (None$.MODULE$.equals(option)) {
            this.editor().getSession().clearBreakpoints();
            return;
        }
    }

    private final /* synthetic */ void $init$$$anonfun$4(MouseEvent _$4) {
        this.updateErrorMessage();
    }

    private static final /* synthetic */ void scrollToBottom$$anonfun$1() {
    }

    private static final String errorMessage$$anonfun$2() {
        return "";
    }

    private final /* synthetic */ void updateErrorMessage$$anonfun$1(ErrorData x$1) {
        ErrorData errorData = x$1;
        if (errorData instanceof CompilationErrorData) {
            CompilationErrorData compilationErrorData = (CompilationErrorData)errorData;
            CompilationErrorData error = compilationErrorData;
            Option selected = error.errors().find((Function1 & Serializable)e -> e.position().map((Function1 & Serializable)_$1 -> _$1.line() - 1).contains((Object)BoxesRunTime.boxToInteger((int)((int)this.editor().selection().getCursor().row()))));
            Option option = selected;
            if (option instanceof Some) {
                Some some = (Some)option;
                ScriptError e2 = (ScriptError)some.value();
                this.errorMessage().set((Object)Some$.MODULE$.apply((Object)this.errorMessage(e2)));
                return;
            }
            return;
        }
    }

    public static class HighlightedFile
    implements Product,
    Serializable {
        private final String highlighter;

        public static HighlightedFile apply(String string) {
            return EditorPanelUI$HighlightedFile$.MODULE$.apply(string);
        }

        public static HighlightedFile fromProduct(Product product) {
            return EditorPanelUI$HighlightedFile$.MODULE$.fromProduct(product);
        }

        public static HighlightedFile unapply(HighlightedFile highlightedFile) {
            return EditorPanelUI$HighlightedFile$.MODULE$.unapply(highlightedFile);
        }

        public HighlightedFile(String highlighter) {
            this.highlighter = highlighter;
        }

        public int hashCode() {
            return MurmurHash3$.MODULE$.productHash((Product)this, 170069212, true);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            HighlightedFile highlightedFile;
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof HighlightedFile)) return false;
            HighlightedFile highlightedFile2 = highlightedFile = (HighlightedFile)object;
            String string = this.highlighter();
            String string2 = highlightedFile2.highlighter();
            if (string == null) {
                if (string2 != null) {
                    return false;
                }
            } else if (!string.equals(string2)) return false;
            if (!highlightedFile2.canEqual(this)) return false;
            return true;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof HighlightedFile;
        }

        public int productArity() {
            return 1;
        }

        public String productPrefix() {
            return "HighlightedFile";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "highlighter";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String highlighter() {
            return this.highlighter;
        }

        public HighlightedFile copy(String highlighter) {
            return new HighlightedFile(highlighter);
        }

        public String copy$default$1() {
            return this.highlighter();
        }

        public String _1() {
            return this.highlighter();
        }
    }
}

