/*
 * Decompiled with CFR 0.152.
 */
package org.openmole.gui.server.core;

import cats.kernel.Order;
import io.circe.Codec;
import io.circe.Decoder;
import io.circe.Decoder$;
import io.circe.Encoder;
import io.circe.Encoder$;
import io.circe.derivation.Configuration;
import io.circe.derivation.Configuration$;
import io.circe.derivation.ConfiguredDecoder$;
import io.circe.derivation.ConfiguredEncoder$;
import io.circe.derivation.DecoderNotDeriveSum;
import io.circe.derivation.Default$;
import io.circe.derivation.EncoderNotDeriveSum;
import io.circe.export.Exported$;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.PrintStream;
import java.io.Serializable;
import java.net.URI;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.concurrent.Future;
import java.util.zip.GZIPInputStream;
import org.apache.commons.compress.archivers.tar.TarArchiveInputStream;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.openmole.core.argument.ToFromContext$;
import org.openmole.core.authentication.Authentication$;
import org.openmole.core.authentication.AuthenticationStore;
import org.openmole.core.buildinfo.BuildInfo$;
import org.openmole.core.compiler.Interpreter;
import org.openmole.core.context.Variable;
import org.openmole.core.dsl.package$;
import org.openmole.core.event.EventDispatcher;
import org.openmole.core.event.package$package$;
import org.openmole.core.exception.UserBadDataError;
import org.openmole.core.exception.UserBadDataError$;
import org.openmole.core.fileservice.FileService;
import org.openmole.core.fileservice.FileServiceCache;
import org.openmole.core.fileservice.FileServiceCache$;
import org.openmole.core.format.OMRContent;
import org.openmole.core.format.OMRFormat$;
import org.openmole.core.market.MarketIndex;
import org.openmole.core.market.MarketIndexEntry;
import org.openmole.core.networkservice.NetworkService;
import org.openmole.core.networkservice.NetworkService$;
import org.openmole.core.outputmanager.OutputManager$;
import org.openmole.core.pluginmanager.PluginManager$;
import org.openmole.core.preference.ClearPreferenceLocation;
import org.openmole.core.preference.ConfigurationString;
import org.openmole.core.preference.ConfigurationString$;
import org.openmole.core.preference.Preference;
import org.openmole.core.preference.Preference$;
import org.openmole.core.preference.PreferenceLocation$;
import org.openmole.core.project.CompileResult;
import org.openmole.core.project.Compiled;
import org.openmole.core.project.ErrorInCode;
import org.openmole.core.project.ErrorInCode$;
import org.openmole.core.project.ErrorInCompiler;
import org.openmole.core.project.ErrorInCompiler$;
import org.openmole.core.project.Project$;
import org.openmole.core.project.ScriptFileDoesNotExists;
import org.openmole.core.project.ScriptFileDoesNotExists$;
import org.openmole.core.replication.ReplicaCatalog;
import org.openmole.core.serializer.SerializerService;
import org.openmole.core.services.Services;
import org.openmole.core.services.Services$;
import org.openmole.core.services.ServicesContainer;
import org.openmole.core.threadprovider.ThreadProvider;
import org.openmole.core.threadprovider.ThreadProvider$;
import org.openmole.core.timeservice.TimeService;
import org.openmole.core.workflow.composition.DSL;
import org.openmole.core.workflow.execution.Environment;
import org.openmole.core.workflow.mole.MoleExecution;
import org.openmole.core.workflow.mole.MoleExecution$;
import org.openmole.core.workflow.mole.MoleServices;
import org.openmole.core.workflow.mole.MoleServices$;
import org.openmole.core.workflow.validation.Validation$;
import org.openmole.core.workflow.validation.ValidationProblem$;
import org.openmole.core.workspace.TmpDirectory;
import org.openmole.core.workspace.TmpDirectory$;
import org.openmole.core.workspace.Workspace;
import org.openmole.gui.server.core.GUIServer;
import org.openmole.gui.server.core.GUIServer$;
import org.openmole.gui.server.core.MarkDownProcessor$;
import org.openmole.gui.server.core.RunningEnvironment;
import org.openmole.gui.server.core.ServerState;
import org.openmole.gui.server.core.ServerState$ExecutionInfo$;
import org.openmole.gui.server.core.ServerState$MoleExecutionState$;
import org.openmole.gui.server.ext.GUIPluginRegistry$;
import org.openmole.gui.server.ext.OMRouter;
import org.openmole.gui.server.ext.utils;
import org.openmole.gui.server.ext.utils$;
import org.openmole.gui.server.git.GitService$;
import org.openmole.gui.shared.data.BranchData;
import org.openmole.gui.shared.data.BranchData$;
import org.openmole.gui.shared.data.EnvironmentError;
import org.openmole.gui.shared.data.EnvironmentId;
import org.openmole.gui.shared.data.EnvironmentId$;
import org.openmole.gui.shared.data.ErrorData;
import org.openmole.gui.shared.data.ErrorData$;
import org.openmole.gui.shared.data.ErrorStateLevel;
import org.openmole.gui.shared.data.ErrorStateLevel$;
import org.openmole.gui.shared.data.ExecutionData;
import org.openmole.gui.shared.data.ExecutionId;
import org.openmole.gui.shared.data.ExecutionId$;
import org.openmole.gui.shared.data.ExecutionOutput;
import org.openmole.gui.shared.data.ExecutionState;
import org.openmole.gui.shared.data.FailedTest$;
import org.openmole.gui.shared.data.FileListData;
import org.openmole.gui.shared.data.FileSorting;
import org.openmole.gui.shared.data.FileSorting$;
import org.openmole.gui.shared.data.GUIOMRContent;
import org.openmole.gui.shared.data.GUIOMRContent$;
import org.openmole.gui.shared.data.GUIOMRDataIndex;
import org.openmole.gui.shared.data.GUIOMRDataIndex$;
import org.openmole.gui.shared.data.GUIOMRImport;
import org.openmole.gui.shared.data.GUIOMRImport$;
import org.openmole.gui.shared.data.GUIOMRScript$;
import org.openmole.gui.shared.data.GUIOMRSectionContent$;
import org.openmole.gui.shared.data.GUIVariable;
import org.openmole.gui.shared.data.GUIVariable$;
import org.openmole.gui.shared.data.GitPrivateKeyAuthenticationData;
import org.openmole.gui.shared.data.GitPrivateKeyAuthenticationData$;
import org.openmole.gui.shared.data.JVMInfos;
import org.openmole.gui.shared.data.JVMInfos$;
import org.openmole.gui.shared.data.MergeStatus;
import org.openmole.gui.shared.data.MergeStatus$;
import org.openmole.gui.shared.data.MessageErrorData;
import org.openmole.gui.shared.data.MessageErrorData$;
import org.openmole.gui.shared.data.NotificationEvent;
import org.openmole.gui.shared.data.OMSettings;
import org.openmole.gui.shared.data.OMSettings$;
import org.openmole.gui.shared.data.PassedTest$;
import org.openmole.gui.shared.data.Plugin;
import org.openmole.gui.shared.data.Plugin$;
import org.openmole.gui.shared.data.PluginExtensionData;
import org.openmole.gui.shared.data.PluginExtensionData$;
import org.openmole.gui.shared.data.PushStatus;
import org.openmole.gui.shared.data.PushStatus$;
import org.openmole.gui.shared.data.Resource$;
import org.openmole.gui.shared.data.Resources;
import org.openmole.gui.shared.data.Resources$;
import org.openmole.gui.shared.data.SafePath;
import org.openmole.gui.shared.data.SafePath$;
import org.openmole.gui.shared.data.ScriptError;
import org.openmole.gui.shared.data.ScriptError$;
import org.openmole.gui.shared.data.SequenceData;
import org.openmole.gui.shared.data.SequenceData$;
import org.openmole.gui.shared.data.ServerFileSystemContext;
import org.openmole.gui.shared.data.ServerFileSystemContext$;
import org.openmole.plugin.task.container.ContainerTask$;
import org.openmole.tool.archive.ArchiveType;
import org.openmole.tool.archive.ArchiveType$;
import org.openmole.tool.cache.KeyValueCache;
import org.openmole.tool.cache.Lazy;
import org.openmole.tool.crypto.Cypher;
import org.openmole.tool.crypto.Cypher$;
import org.openmole.tool.file.FilePackage;
import org.openmole.tool.logger.LoggerService;
import org.openmole.tool.outputredirection.OutputRedirection;
import org.openmole.tool.outputredirection.OutputRedirection$;
import org.openmole.tool.random.Seeder;
import org.openmole.tool.stream.StringPrintStream;
import org.openmole.tool.stream.StringPrintStream$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.NamedTuple$;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Some$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.Tuple3;
import scala.Tuple3$;
import scala.collection.ArrayOps$;
import scala.collection.Iterable;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.SeqOps;
import scala.collection.StringOps$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Vector;
import scala.collection.mutable.ListBuffer;
import scala.collection.mutable.ListBuffer$;
import scala.deriving.Mirror;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.ManifestFactory$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyRef;
import scala.runtime.ScalaRunTime$;
import scala.runtime.function.JProcedure1;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;
import scala.util.control.Breaks$;
import scala.util.matching.Regex;

public class ApiImpl {
    private final Services services;
    private final Option<GUIServer.ApplicationControl> applicationControl;
    private final ClearPreferenceLocation<Object> outputSize;
    private final ServerState serverState;

    public ApiImpl(Services services, Option<GUIServer.ApplicationControl> applicationControl) {
        this.services = services;
        this.applicationControl = applicationControl;
        this.outputSize = PreferenceLocation$.MODULE$.apply("gui", "outputsize", ApiImpl::$init$$$anonfun$1);
        this.serverState = new ServerState();
    }

    public Services services() {
        return this.services;
    }

    public ClearPreferenceLocation<Object> outputSize() {
        return this.outputSize;
    }

    public ServerState serverState() {
        return this.serverState;
    }

    public OMSettings settings() {
        utils.SafePathFileDecorator safePathFileDecorator = utils$.MODULE$.SafePathFileDecorator(utils$.MODULE$.projectsDirectory(this.services().workspace()));
        Workspace workspace = this.services().workspace();
        ServerFileSystemContext serverFileSystemContext = safePathFileDecorator.toSafePath$default$1();
        return OMSettings$.MODULE$.apply(safePathFileDecorator.toSafePath(serverFileSystemContext, workspace), org.openmole.core.buildinfo.package$.MODULE$.version().value(), org.openmole.core.buildinfo.package$.MODULE$.name(), BuildInfo$.MODULE$.buildTime(), org.openmole.core.buildinfo.package$.MODULE$.development());
    }

    public void shutdown() {
        this.applicationControl.foreach((Function1)(JProcedure1 & Serializable)_$1 -> _$1.stop().apply$mcV$sp());
    }

    public boolean isAlive() {
        return true;
    }

    public JVMInfos jvmInfos() {
        Runtime runtime = Runtime.getRuntime();
        long totalMemory = runtime.totalMemory();
        long allocatedMemory = totalMemory - runtime.freeMemory();
        String javaVersion = System.getProperty("java.version");
        String jvmName = System.getProperty("java.vm.name");
        return JVMInfos$.MODULE$.apply(javaVersion, jvmName, Runtime.getRuntime().availableProcessors(), allocatedMemory, totalMemory);
    }

    public boolean isPasswordCorrect(String pass) {
        return Preference$.MODULE$.passwordIsCorrect(Cypher$.MODULE$.apply(pass), this.services().preference());
    }

    public void resetPassword() {
        Services$.MODULE$.resetPassword(this.services().authenticationStore(), this.services().preference());
    }

    public boolean createFile(SafePath safePath, String name, boolean directory) {
        File target = new File(utils$.MODULE$.SafePathDecorator(safePath).toFile(this.services().workspace()), name);
        if (directory) {
            return target.mkdirs();
        }
        return target.createNewFile();
    }

    public void deleteFiles(Seq<SafePath> safePaths) {
        ((IterableOnceOps)safePaths.map((Function1 & Serializable)safePath -> {
            File file = utils$.MODULE$.safePathToFile(safePath, this.services().workspace());
            return Tuple2$.MODULE$.apply(safePath, (Object)file);
        })).foreach((Function1)(JProcedure1 & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 != null) {
                SafePath safePath = (SafePath)tuple2._1();
                File file = (File)tuple2._2();
                this.unplug(file);
                return;
            }
            throw new MatchError((Object)tuple2);
        });
        utils$.MODULE$.deleteFiles(safePaths, this.services().workspace());
    }

    private Option<ArchiveType> archiveType(File f) {
        String name = f.getName();
        String string = name;
        String n = string;
        if (n.endsWith(".tar")) {
            return Some$.MODULE$.apply((Object)ArchiveType$.Tar);
        }
        String n2 = string;
        if (n2.endsWith(".tgz") | n2.endsWith(".tar.gz")) {
            return Some$.MODULE$.apply((Object)ArchiveType$.TarGZ);
        }
        String n3 = string;
        if (n3.endsWith(".zip")) {
            return Some$.MODULE$.apply((Object)ArchiveType$.Zip);
        }
        String n4 = string;
        if (n4.endsWith(".tar.xz") | n4.endsWith("txz")) {
            return Some$.MODULE$.apply((Object)ArchiveType$.TarXZ);
        }
        return None$.MODULE$;
    }

    private Option<MessageErrorData> extractArchiveFromFiles(File from, File to) {
        Try try_ = Try$.MODULE$.apply((Function0 & Serializable)() -> {
            this.extractArchiveFromFiles$$anonfun$1(from, to);
            return BoxedUnit.UNIT;
        });
        if (try_ instanceof Success) {
            Success success = (Success)try_;
            return None$.MODULE$;
        }
        if (try_ instanceof Failure) {
            Failure failure = (Failure)try_;
            Throwable t = failure.exception();
            return Some$.MODULE$.apply((Object)ErrorData$.MODULE$.apply(t, ErrorData$.MODULE$.apply$default$2()));
        }
        throw new MatchError((Object)try_);
    }

    public Option<MessageErrorData> extractArchive(SafePath safePath, SafePath to) {
        return this.extractArchiveFromFiles(this.archiveFile$1(safePath), this.toFile$1(to));
    }

    public SafePath temporaryDirectory() {
        File dir = this.services().tmpDirectory().newDirectory("openmoleGUI", true, this.services().tmpDirectory());
        utils.SafePathFileDecorator safePathFileDecorator = utils$.MODULE$.SafePathFileDecorator(dir);
        return safePathFileDecorator.toSafePath(ServerFileSystemContext$.Absolute, this.services().workspace());
    }

    public boolean exists(SafePath safePath) {
        return utils$.MODULE$.exists(safePath, this.services().workspace());
    }

    public boolean isTextFile(SafePath safePath) {
        FilePackage.FileDecorator fileDecorator = package$.MODULE$.FileDecorator(utils$.MODULE$.safePathToFile(safePath, this.services().workspace()));
        return fileDecorator.isTextFile(fileDecorator.isTextFile$default$1());
    }

    public Seq<SafePath> copyFiles(Seq<Tuple2<SafePath, SafePath>> paths, boolean overwrite) {
        return utils$.MODULE$.copyFiles(paths, overwrite, this.services().workspace());
    }

    public FileListData listFiles(SafePath sp, FileSorting fileFilter, boolean testPlugin, boolean withHidden, boolean directorySize) {
        return utils$.MODULE$.listFiles(sp, fileFilter, this.listPlugins(), testPlugin, withHidden, directorySize, this.services().workspace());
    }

    public FileSorting listFiles$default$2() {
        return FileSorting$.MODULE$.apply(FileSorting$.MODULE$.$lessinit$greater$default$1(), FileSorting$.MODULE$.$lessinit$greater$default$2(), FileSorting$.MODULE$.$lessinit$greater$default$3());
    }

    public boolean listFiles$default$3() {
        return true;
    }

    public boolean listFiles$default$4() {
        return true;
    }

    public boolean listFiles$default$5() {
        return false;
    }

    public Seq<Tuple2<SafePath, Object>> recursiveListFiles(SafePath sp, Option<String> findString, boolean withHidden) {
        return utils$.MODULE$.recursiveListFiles(sp, findString, withHidden, this.services().workspace());
    }

    public boolean isEmpty(SafePath sp) {
        File f = utils$.MODULE$.safePathToFile(sp, this.services().workspace());
        return package$.MODULE$.FileDecorator(f).isDirectoryEmpty();
    }

    public Seq<SafePath> move(Seq<Tuple2<SafePath, SafePath>> moves, boolean overwrite) {
        ListBuffer existing = (ListBuffer)ListBuffer$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new SafePath[0]));
        moves.foreach((Function1)(JProcedure1 & Serializable)x$1 -> {
            SafePath from = (SafePath)x$1._1();
            SafePath to = (SafePath)x$1._2();
            File fromFile = utils$.MODULE$.safePathToFile(from, this.services().workspace());
            File toFile = utils$.MODULE$.safePathToFile(to, this.services().workspace());
            boolean exists = toFile.exists();
            if (exists) {
                existing.$plus$eq((Object)to);
            }
            if (!exists || overwrite) {
                toFile.getParentFile().mkdirs();
                if (OMRFormat$.MODULE$.isOMR(fromFile)) {
                    OMRFormat$.MODULE$.move(fromFile, toFile);
                    return;
                }
                this.unplug(fromFile);
                package$.MODULE$.FileDecorator(fromFile).move(toFile);
                return;
            }
        });
        return existing.toSeq();
    }

    public String mdToHtml(SafePath safePath) {
        return MarkDownProcessor$.MODULE$.apply(package$.MODULE$.FileDecorator(utils$.MODULE$.safePathToFile(safePath, this.services().workspace())).content());
    }

    public Tuple2<Object, String> saveFile(SafePath path, String fileContent, Option<String> hash, boolean overwrite) {
        File file = utils$.MODULE$.safePathToFile(path, this.services().workspace());
        if (!file.exists()) {
            package$.MODULE$.FileDecorator(file).content_$eq("");
        }
        return (Tuple2)package$.MODULE$.FileDecorator(file).withLock((Function1 & Serializable)_$2 -> {
            Some some;
            String string;
            if (overwrite) {
                return this.save$1(file, fileContent);
            }
            Option option = hash;
            if (option instanceof Some && (string = (String)(some = (Some)option).value()) != null) {
                String hashOnDisk;
                String string2;
                String expectedHash = string2 = string;
                FileService fileService = this.services().fileService();
                String string3 = hashOnDisk = fileService.hashNoCache(file, fileService.hashNoCache$default$2(), this.services().tmpDirectory()).toString();
                String string4 = expectedHash;
                if (!(string3 != null ? !string3.equals(string4) : string4 != null)) {
                    return this.save$1(file, fileContent);
                }
                return Tuple2$.MODULE$.apply((Object)BoxesRunTime.boxToBoolean((boolean)false), (Object)hashOnDisk);
            }
            return this.save$1(file, fileContent);
        });
    }

    public long size(SafePath safePath) {
        return utils$.MODULE$.safePathToFile(safePath, this.services().workspace()).length();
    }

    public SequenceData sequence(SafePath safePath, char separator) {
        Object[] content = package$.MODULE$.FileDecorator(utils$.MODULE$.SafePathDecorator(safePath).toFile(this.services().workspace())).content().split("\n");
        Regex regex = StringOps$.MODULE$.r$extension(Predef$.MODULE$.augmentString("\\[[^\\]]+\\]|[+-]?[0-9][0-9]*\\.?[0-9]*([Ee][+-]?[0-9]+)?|true|false"));
        Object object = Predef$.MODULE$.refArrayOps(content);
        return (SequenceData)ArrayOps$.MODULE$.headOption$extension(object).map(arg_0 -> ApiImpl.sequence$$anonfun$1((String[])content, regex, arg_0)).getOrElse(ApiImpl::sequence$$anonfun$2);
    }

    public char sequence$default$2() {
        return ',';
    }

    public void cancelExecution(ExecutionId id) {
        this.serverState().cancel(id);
    }

    public void removeExecution(ExecutionId id) {
        this.serverState().remove(id);
    }

    public Option<ErrorData> validateScript(SafePath script) {
        StringPrintStream outputStream = StringPrintStream$.MODULE$.apply((Option)Some$.MODULE$.apply(this.services().preference().apply(this.outputSize(), (ConfigurationString)ConfigurationString.given_ConfigurationString_Int$.MODULE$)));
        Object object = this.compileToDSL(script, outputStream);
        if (object instanceof ErrorData) {
            ErrorData errorData;
            ErrorData e2 = errorData = (ErrorData)object;
            return Some$.MODULE$.apply((Object)e2);
        }
        if (object instanceof Tuple3) {
            Tuple3 tuple3 = (Tuple3)object;
            DSL dSL = (DSL)tuple3._3();
            ServicesContainer s = (ServicesContainer)tuple3._1();
            if (dSL != null) {
                Some some;
                block9: {
                    DSL dSL2;
                    DSL dsl = dSL2 = dSL;
                    try {
                        try {
                            LazyRef lazyRef = new LazyRef();
                            List validationErrors = Validation$.MODULE$.apply(dsl, this.services().tmpDirectory(), this.services().fileService(), ApiImpl.given_KeyValueCache$1(lazyRef), this.services().outputRedirection());
                            if (validationErrors.nonEmpty()) {
                                Object object2 = Predef$.MODULE$.refArrayOps((Object[])validationErrors.map((Function1 & Serializable)e -> "- " + e).mkString("\n").split("\n"));
                                UserBadDataError error = UserBadDataError$.MODULE$.apply("Formal validation has failed, " + ValidationProblem$.MODULE$.errorsString(validationErrors.size()) + ":\n" + Predef$.MODULE$.wrapRefArray((Object[])ArrayOps$.MODULE$.map$extension(object2, (Function1 & Serializable)l -> "  " + l, ClassTag$.MODULE$.apply(String.class))).mkString("\n"), UserBadDataError$.MODULE$.apply$default$2());
                                some = Some$.MODULE$.apply((Object)ErrorData$.MODULE$.apply((Throwable)error, ErrorData$.MODULE$.apply$default$2()));
                                break block9;
                            }
                            some = None$.MODULE$;
                        }
                        catch (Throwable e3) {
                            some = Some$.MODULE$.apply((Object)ErrorData$.MODULE$.apply(e3, ErrorData$.MODULE$.apply$default$2()));
                        }
                    }
                    finally {
                        TmpDirectory$.MODULE$.dispose(s.tmpDirectory());
                    }
                }
                return some;
            }
        }
        throw new MatchError(object);
    }

    public ErrorData scriptCompilationError(Throwable t) {
        MessageErrorData messageErrorData;
        Throwable throwable = t;
        if (throwable instanceof Interpreter.CompilationError) {
            Interpreter.CompilationError compilationError;
            Interpreter.CompilationError ce = compilationError = (Interpreter.CompilationError)throwable;
            messageErrorData = ErrorData$.MODULE$.apply((Seq)ce.errorMessages().map((Function1 & Serializable)em -> ApiImpl.toErrorWithLocation$1(em)), t);
        } else {
            messageErrorData = ErrorData$.MODULE$.apply(t, ErrorData$.MODULE$.apply$default$2());
        }
        return (ErrorData)messageErrorData;
    }

    public Object compileToDSL(SafePath scriptPath, StringPrintStream outputStream) {
        ErrorData errorData;
        block9: {
            File script = utils$.MODULE$.safePathToFile(scriptPath, this.services().workspace());
            OutputRedirection executionOutputRedirection = OutputRedirection$.MODULE$.apply((PrintStream)outputStream);
            File executionTmpDirectory = TmpDirectory$.MODULE$.newDirectory("execution", TmpDirectory$.MODULE$.newDirectory$default$2(), this.services().tmpDirectory());
            TmpDirectory tmpDirectory = TmpDirectory$.MODULE$.apply(executionTmpDirectory);
            FileServiceCache fileServiceCache = FileServiceCache$.MODULE$.apply(this.services().preference());
            Workspace workspace = Services$.MODULE$.copy$default$2(this.services());
            Preference preference = Services$.MODULE$.copy$default$3(this.services());
            Cypher cypher = Services$.MODULE$.copy$default$4(this.services());
            ThreadProvider threadProvider = Services$.MODULE$.copy$default$5(this.services());
            Seeder seeder = Services$.MODULE$.copy$default$6(this.services());
            ReplicaCatalog replicaCatalog = Services$.MODULE$.copy$default$7(this.services());
            AuthenticationStore authenticationStore = Services$.MODULE$.copy$default$9(this.services());
            SerializerService serializerService = Services$.MODULE$.copy$default$10(this.services());
            FileService fileService = Services$.MODULE$.copy$default$11(this.services());
            Lazy lazy = Services$.MODULE$.copy$default$12(this.services());
            EventDispatcher eventDispatcher = Services$.MODULE$.copy$default$13(this.services());
            NetworkService networkService = Services$.MODULE$.copy$default$15(this.services());
            LoggerService loggerService = Services$.MODULE$.copy$default$17(this.services());
            TimeService timeService = Services$.MODULE$.copy$default$18(this.services());
            ServicesContainer runServices = Services$.MODULE$.copy(this.services(), workspace, preference, cypher, threadProvider, seeder, replicaCatalog, tmpDirectory, authenticationStore, serializerService, fileService, lazy, eventDispatcher, executionOutputRedirection, networkService, fileServiceCache, loggerService, timeService);
            try {
                ScriptFileDoesNotExists scriptFileDoesNotExists;
                CompileResult compileResult = Project$.MODULE$.compile(package$.MODULE$.FileDecorator(script).getParentFileSafe(), script, Project$.MODULE$.compile$default$3(), Project$.MODULE$.compile$default$4(), (Services)runServices);
                if (compileResult instanceof ScriptFileDoesNotExists && ScriptFileDoesNotExists$.MODULE$.unapply(scriptFileDoesNotExists = (ScriptFileDoesNotExists)compileResult)) {
                    errorData = ErrorData$.MODULE$.apply("Script file does not exist");
                    break block9;
                }
                if (compileResult instanceof ErrorInCode) {
                    Interpreter.CompilationError compilationError;
                    ErrorInCode errorInCode = (ErrorInCode)compileResult;
                    ErrorInCode errorInCode2 = ErrorInCode$.MODULE$.unapply(errorInCode);
                    Interpreter.CompilationError e = compilationError = errorInCode2._1();
                    errorData = this.scriptCompilationError((Throwable)e);
                    break block9;
                }
                if (compileResult instanceof ErrorInCompiler) {
                    Throwable throwable;
                    ErrorInCompiler errorInCompiler = (ErrorInCompiler)compileResult;
                    ErrorInCompiler errorInCompiler2 = ErrorInCompiler$.MODULE$.unapply(errorInCompiler);
                    Throwable e = throwable = errorInCompiler2._1();
                    errorData = this.scriptCompilationError(e);
                    break block9;
                }
                if (compileResult instanceof Compiled) {
                    Compiled compiled;
                    Compiled compiled2 = compiled = (Compiled)compileResult;
                    if (Thread.interrupted()) {
                        throw new InterruptedIOException();
                    }
                    Try try_ = utils$.MODULE$.catchAll(() -> ApiImpl.compileToDSL$$anonfun$1(outputStream, compiled2, runServices));
                    if (try_ instanceof Failure) {
                        Failure failure = (Failure)try_;
                        Throwable e = failure.exception();
                        errorData = this.scriptCompilationError(e);
                        break block9;
                    }
                    if (try_ instanceof Success) {
                        Success success = (Success)try_;
                        DSL dsl = (DSL)success.value();
                        errorData = Tuple3$.MODULE$.apply((Object)runServices, (Object)compiled2, (Object)dsl);
                        break block9;
                    }
                    throw new MatchError((Object)try_);
                }
                throw new MatchError((Object)compileResult);
            }
            catch (Throwable t) {
                errorData = this.scriptCompilationError(t);
            }
        }
        return errorData;
    }

    public Object compileToMoleExecution(SafePath scriptPath, StringPrintStream outputStream) {
        ErrorData errorData;
        block8: {
            try {
                Object object = this.compileToDSL(scriptPath, outputStream);
                if (object instanceof ErrorData) {
                    ErrorData errorData2;
                    ErrorData e;
                    errorData = e = (errorData2 = (ErrorData)object);
                    break block8;
                }
                if (object instanceof Tuple3) {
                    Tuple3 tuple3 = (Tuple3)object;
                    ServicesContainer servicesContainer = (ServicesContainer)tuple3._1();
                    DSL dSL = (DSL)tuple3._3();
                    if (servicesContainer != null) {
                        ServicesContainer servicesContainer2;
                        ServicesContainer runServices = servicesContainer2 = servicesContainer;
                        Compiled compiled = (Compiled)tuple3._2();
                        if (dSL != null) {
                            DSL dSL2 = dSL;
                            DSL dsl = dSL2;
                            MoleServices executionServices = MoleServices$.MODULE$.create(runServices.workspace().tmpDirectory(), (Option)Some$.MODULE$.apply((Object)runServices.tmpDirectory().directory()), (Option)Some$.MODULE$.apply((Object)runServices.outputRedirection()), MoleServices$.MODULE$.create$default$4(), (Option)Some$.MODULE$.apply((Object)compiled.compilationContext()), runServices.preference(), runServices.seeder(), runServices.threadProvider(), runServices.eventDispatcher(), runServices.tmpDirectory(), runServices.fileService(), runServices.workspace(), runServices.outputRedirection(), runServices.loggerService(), runServices.serializerService(), runServices.networkService(), runServices.fileServiceCache(), runServices.timeService());
                            Try try_ = Try$.MODULE$.apply(() -> ApiImpl.compileToMoleExecution$$anonfun$1(dsl, executionServices));
                            if (try_ instanceof Success) {
                                Success success = (Success)try_;
                                MoleExecution ex = (MoleExecution)success.value();
                                errorData = ex;
                                break block8;
                            }
                            if (try_ instanceof Failure) {
                                Failure failure = (Failure)try_;
                                Throwable e = failure.exception();
                                MoleServices$.MODULE$.clean(executionServices);
                                errorData = this.scriptCompilationError(e);
                                break block8;
                            }
                            throw new MatchError((Object)try_);
                        }
                    }
                }
                throw new MatchError(object);
            }
            catch (Throwable t) {
                errorData = this.scriptCompilationError(t);
            }
        }
        return errorData;
    }

    public ExecutionId launchScript(SafePath script, boolean validateScript) {
        ExecutionId execId = ExecutionId$.MODULE$.apply();
        StringPrintStream outputStream = StringPrintStream$.MODULE$.apply((Option)Some$.MODULE$.apply(this.services().preference().apply(this.outputSize(), (ConfigurationString)ConfigurationString.given_ConfigurationString_Int$.MODULE$)));
        String content = package$.MODULE$.FileDecorator(utils$.MODULE$.safePathToFile(script, this.services().workspace())).content();
        Future<Object> future = ThreadProvider$.MODULE$.newSingleThreadExecutor(this.services().threadProvider()).submit(() -> this.compileAndRun$1(script, outputStream, execId, validateScript));
        this.serverState().addExecutionInfo(execId, ServerState$ExecutionInfo$.MODULE$.apply(script, content, System.currentTimeMillis(), outputStream, (ServerState.MoleExecutionState)ServerState$MoleExecutionState$.MODULE$.given_Conversion_$bar_MoleExecutionState().apply(future), (Map<EnvironmentId, RunningEnvironment>)Predef$.MODULE$.Map().empty()));
        return execId;
    }

    public Seq<ExecutionData> executionData(Seq<ExecutionId> ids) {
        return this.serverState().executionData(ids);
    }

    public ExecutionOutput executionOutput(ExecutionId id, int lines) {
        return this.serverState().executionOutput(id, lines);
    }

    public Seq<ExecutionId> executionIds() {
        return this.serverState().executionIds().toSeq();
    }

    public void clearEnvironmentErrors(ExecutionId executionId, EnvironmentId environmentId) {
        this.serverState().clearEnvironmentErrors(executionId, environmentId);
    }

    public Seq<EnvironmentError> listEnvironmentErrors(ExecutionId executionId, EnvironmentId environmentId, int lines) {
        Seq<EnvironmentError> environmentErrors = this.serverState().environmentErrors(executionId, environmentId);
        Tuple2 tuple2 = environmentErrors.partition((Function1 & Serializable)_$7 -> {
            ErrorStateLevel errorStateLevel = _$7.level();
            ErrorStateLevel errorStateLevel2 = ErrorStateLevel$.Error;
            return !(errorStateLevel != null ? !errorStateLevel.equals(errorStateLevel2) : errorStateLevel2 != null);
        });
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        Tuple2 $6$ = tuple2;
        Tuple2 tuple22 = $6$;
        Seq errors = (Seq)tuple22._1();
        Seq warning = (Seq)tuple22._2();
        Seq res = (Seq)((IterableOps)((IterableOps)((SeqOps)errors.sortBy((Function1 & Serializable)_$8 -> _$8.date(), package$.MODULE$.catsKernelOrderingForOrder((Order)package$.MODULE$.catsKernelStdOrderForLong()))).reverse()).$plus$plus((IterableOnce)((SeqOps)warning.sortBy((Function1 & Serializable)_$9 -> _$9.date(), package$.MODULE$.catsKernelOrderingForOrder((Order)package$.MODULE$.catsKernelStdOrderForLong()))).reverse())).take(lines);
        return res;
    }

    public MarketIndex marketIndex() {
        return ApiImpl.mapToMd$1(org.openmole.core.market.package$.MODULE$.marketIndex(this.services().preference(), this.services().randomProvider(), this.services().tmpDirectory(), this.services().fileService(), this.services().networkService()));
    }

    public void getMarketEntry(MarketIndexEntry entry, SafePath path) {
        org.openmole.core.market.package$.MODULE$.downloadEntry(entry, utils$.MODULE$.safePathToFile(path, this.services().workspace()), this.services().networkService());
    }

    private Seq<Plugin> toPluginList(Seq<String> currentPlugins) {
        Seq currentPluginsSafePath = (Seq)currentPlugins.map((Function1 & Serializable)s -> SafePath$.MODULE$.apply((Iterable)Predef$.MODULE$.wrapRefArray((Object[])s.split("/")), ServerFileSystemContext$.Project));
        return (Seq)currentPluginsSafePath.flatMap((Function1 & Serializable)csp -> {
            File file = utils$.MODULE$.safePathToFile(csp, this.services().workspace());
            long date = file.lastModified();
            if (file.exists()) {
                return Some$.MODULE$.apply((Object)Plugin$.MODULE$.apply(csp, date, PluginManager$.MODULE$.bundle(file).isDefined()));
            }
            return None$.MODULE$;
        });
    }

    public Iterable<Tuple2<File, Throwable>> activatePlugins() {
        Seq plugins = (Seq)((IterableOps)((IterableOps)this.services().preference().preferenceOption(GUIServer$.MODULE$.plugins(), ConfigurationString$.MODULE$.given_ConfigurationString_Seq((ConfigurationString)ConfigurationString.given_ConfigurationString_String$.MODULE$)).getOrElse(ApiImpl::$anonfun$12)).map((Function1 & Serializable)s -> utils$.MODULE$.safePathToFile(SafePath$.MODULE$.apply((Iterable)Predef$.MODULE$.wrapRefArray((Object[])s.split("/")), ServerFileSystemContext$.Project), this.services().workspace()))).filter((Function1 & Serializable)_$11 -> _$11.exists());
        return PluginManager$.MODULE$.tryLoad((Iterable)plugins);
    }

    private void updatePluggedList(Function1<Seq<String>, Seq<String>> set) {
        this.services().preference().updatePreference(GUIServer$.MODULE$.plugins(), (Function1 & Serializable)p -> Some$.MODULE$.apply(set.apply(p.getOrElse(ApiImpl::updatePluggedList$$anonfun$1$$anonfun$1))), ConfigurationString$.MODULE$.given_ConfigurationString_Seq((ConfigurationString)ConfigurationString.given_ConfigurationString_String$.MODULE$), this.services().cypher());
    }

    public Seq<ErrorData> addPlugin(SafePath safePath) {
        Seq errors = utils$.MODULE$.addPlugin(safePath, this.services().workspace(), this.services().tmpDirectory());
        if (errors.isEmpty()) {
            this.updatePluggedList((Function1<Seq<String>, Seq<String>>)(Function1 & Serializable)pList -> (Seq)((SeqOps)pList.$colon$plus((Object)safePath.path().value().mkString("/"))).distinct());
        }
        return errors;
    }

    public Seq<Plugin> listPlugins() {
        Seq currentPlugins = (Seq)this.services().preference().preferenceOption(GUIServer$.MODULE$.plugins(), ConfigurationString$.MODULE$.given_ConfigurationString_Seq((ConfigurationString)ConfigurationString.given_ConfigurationString_String$.MODULE$)).getOrElse(ApiImpl::$anonfun$15);
        return this.toPluginList((Seq<String>)currentPlugins);
    }

    public void removePlugin(SafePath safePath) {
        this.updatePluggedList((Function1<Seq<String>, Seq<String>>)(Function1 & Serializable)_$12 -> (Seq)_$12.filterNot((Function1 & Serializable)_$13 -> {
            String string = _$13;
            String string2 = safePath.path().value().mkString("/");
            return !(string != null ? !string.equals(string2) : string2 != null);
        }));
        utils$.MODULE$.removePlugin(safePath, this.services().workspace());
    }

    public void unplug(File file) {
        Seq<Plugin> allPlugins = this.listPlugins();
        if (file.exists()) {
            if (file.isDirectory()) {
                org.openmole.tool.file.package$.MODULE$.FileDecorator(file).applyRecursive((Function1)(JProcedure1 & Serializable)f -> this.unplugFile$1((Seq)allPlugins, (File)f));
                return;
            }
            this.unplugFile$1(allPlugins, file);
            return;
        }
    }

    public Iterable<OMRouter> pluginRoutes() {
        return (Iterable)((IterableOps)GUIPluginRegistry$.MODULE$.all().flatMap((Function1 & Serializable)_$14 -> _$14.router())).map((Function1 & Serializable)p -> (OMRouter)p.apply((Object)this.services()));
    }

    public PluginExtensionData getGUIPlugins() {
        return PluginExtensionData$.MODULE$.apply(GUIPluginRegistry$.MODULE$.authentications(), GUIPluginRegistry$.MODULE$.wizards(), GUIPluginRegistry$.MODULE$.analysis());
    }

    public boolean isOSGI(SafePath safePath) {
        return PluginManager$.MODULE$.isOSGI(utils$.MODULE$.safePathToFile(safePath, this.services().workspace()));
    }

    public Option<String> omrMethodName(SafePath result) {
        File omrFile = utils$.MODULE$.safePathToFile(result, this.services().workspace());
        return OMRFormat$.MODULE$.methodName(omrFile);
    }

    public Option<SafePath> omrFiles(SafePath omr) {
        File omrFile = utils$.MODULE$.safePathToFile(omr, this.services().workspace());
        return OMRFormat$.MODULE$.resultFileDirectory(omrFile).map((Function1 & Serializable)rf -> {
            Workspace workspace = this.services().workspace();
            ServerFileSystemContext serverFileSystemContext = utils$.MODULE$.fileToSafePath$default$2(rf);
            return utils$.MODULE$.fileToSafePath(rf, serverFileSystemContext, workspace);
        });
    }

    public GUIOMRContent omrContent(SafePath result, Option<String> dataFile) {
        File omrFile = utils$.MODULE$.safePathToFile(result, this.services().workspace());
        OMRContent omrContent = OMRFormat$.MODULE$.omrContent(omrFile);
        return GUIOMRContent$.MODULE$.apply(this.content$2(omrFile, dataFile), omrContent.openmole$minusversion(), omrContent.execution$minusid(), ApiImpl.script$6(omrContent), omrContent.time$minusstart(), omrContent.time$minussave(), ApiImpl.index$1(omrContent), this.raw$1(omrFile, dataFile));
    }

    public Seq<GUIOMRDataIndex> omrDataIndex(SafePath result) {
        File omrFile = utils$.MODULE$.safePathToFile(result, this.services().workspace());
        return this.indexes$1(omrFile);
    }

    public Option<GUIVariable.ValueType> toValueTypeFromAny(Object x) {
        Failure failure;
        Throwable throwable;
        Failure failure2;
        Throwable throwable2;
        Try try_ = this.res$1(x);
        if (try_ instanceof Failure && (throwable2 = (failure2 = (Failure)try_).exception()) instanceof MatchError) {
            MatchError matchError;
            MatchError exception = matchError = (MatchError)throwable2;
            return None$.MODULE$;
        }
        if (try_ instanceof Success) {
            Success success = (Success)try_;
            GUIVariable.ValueType value = (GUIVariable.ValueType)success.value();
            return Some$.MODULE$.apply((Object)value);
        }
        if (try_ instanceof Failure && (throwable = (failure = (Failure)try_).exception()) != null) {
            Throwable throwable3;
            Throwable e = throwable3 = throwable;
            throw e;
        }
        throw new MatchError((Object)try_);
    }

    public GUIVariable toGUIVariable(Variable<?> v) {
        return GUIVariable$.MODULE$.apply(v.name(), this.toValueTypeFromAny(v.value()), v.prototype().type().toString());
    }

    public Resources expandResources(Resources resources) {
        Seq paths = (Seq)((IterableOps)((SeqOps)resources.all().map((Function1 & Serializable)_$17 -> _$17.safePath())).distinct()).map((Function1 & Serializable)sp -> Resource$.MODULE$.apply(sp, utils$.MODULE$.SafePathDecorator(sp).toFile(this.services().workspace()).length()));
        Seq implicitResource = (Seq)resources.implicits().map((Function1 & Serializable)r -> Resource$.MODULE$.apply(r.safePath(), utils$.MODULE$.SafePathDecorator(r.safePath()).toFile(this.services().workspace()).length()));
        return Resources$.MODULE$.apply(paths, implicitResource, paths.size() + implicitResource.size());
    }

    public Seq<NotificationEvent> listNotification() {
        return this.serverState().listNotification();
    }

    public Object clearNotification(Seq<Object> ids) {
        return this.serverState().clearNotification(ids);
    }

    public void removeContainerCache() {
        package$.MODULE$.FileDecorator(ContainerTask$.MODULE$.repositoryDirectory(this.services().workspace())).recursiveDelete();
    }

    public void downloadHTTP(String url, SafePath path, boolean extract, boolean overwrite) {
        String string = URI.create(url).getScheme();
        Object checkedURL = string == null ? "http://" + url : url;
        NetworkService$.MODULE$.withResponse((String)checkedURL, NetworkService$.MODULE$.withResponse$default$2(), (Function1)((JProcedure1 & Serializable)arg_0 -> this.downloadHTTP$$anonfun$1(path, extract, overwrite, (String)checkedURL, arg_0)), this.services().networkService());
    }

    public Option<SafePath> cloneRepository(String remoteURL, SafePath destination, boolean overwrite) {
        Seq authentications = utils$.MODULE$.gitAuthenticationFromData(this.gitAuthentications(), this.services().workspace());
        Object object = Predef$.MODULE$.refArrayOps((Object[])remoteURL.split("/"));
        String name = (String)ArrayOps$.MODULE$.last$extension(object);
        SafePath destPath = destination.$div(ApiImpl.nameValue$1(name));
        File destinationFile = utils$.MODULE$.SafePathDecorator(destPath).toFile(this.services().workspace());
        if (destinationFile.exists()) {
            if (overwrite) {
                package$.MODULE$.FileDecorator(destinationFile).recursiveDelete();
                GitService$.MODULE$.clone(remoteURL, utils$.MODULE$.SafePathDecorator(destPath).toFile(this.services().workspace()), authentications);
                return None$.MODULE$;
            }
            return Some$.MODULE$.apply((Object)destPath);
        }
        GitService$.MODULE$.clone(remoteURL, utils$.MODULE$.SafePathDecorator(destPath).toFile(this.services().workspace()), authentications);
        return None$.MODULE$;
    }

    public void commit(Seq<SafePath> paths, String message) {
        paths.headOption().foreach((Function1 & Serializable)hf -> GitService$.MODULE$.withGit(utils$.MODULE$.safePathToFile(hf, this.services().workspace()), utils$.MODULE$.projectsDirectory(this.services().workspace()), (Function1 & Serializable)git -> GitService$.MODULE$.commit((Seq)paths.map((Function1 & Serializable)_$20 -> utils$.MODULE$.SafePathDecorator(_$20).toFile(this.services().workspace())), message, git)));
    }

    public void revert(Seq<SafePath> paths) {
        paths.headOption().foreach((Function1 & Serializable)hf -> GitService$.MODULE$.withGit(utils$.MODULE$.safePathToFile(hf, this.services().workspace()), utils$.MODULE$.projectsDirectory(this.services().workspace()), (Function1)(JProcedure1 & Serializable)git -> GitService$.MODULE$.revert((Seq)paths.map((Function1 & Serializable)_$21 -> utils$.MODULE$.SafePathDecorator(_$21).toFile(this.services().workspace())), git)));
    }

    public void add(Seq<SafePath> paths) {
        paths.headOption().foreach((Function1 & Serializable)hf -> GitService$.MODULE$.withGit(utils$.MODULE$.safePathToFile(hf, this.services().workspace()), utils$.MODULE$.projectsDirectory(this.services().workspace()), (Function1 & Serializable)git -> GitService$.MODULE$.add((Seq)paths.map((Function1 & Serializable)_$22 -> utils$.MODULE$.SafePathDecorator(_$22).toFile(this.services().workspace())), git)));
    }

    public MergeStatus pull(SafePath from) {
        Seq authentications = utils$.MODULE$.gitAuthenticationFromData(this.gitAuthentications(), this.services().workspace());
        return (MergeStatus)GitService$.MODULE$.withGit(utils$.MODULE$.safePathToFile(from, this.services().workspace()), utils$.MODULE$.projectsDirectory(this.services().workspace()), (Function1 & Serializable)git -> GitService$.MODULE$.pull(git, authentications)).getOrElse(ApiImpl::pull$$anonfun$2);
    }

    public PushStatus push(SafePath fromPath) {
        Seq authentications = utils$.MODULE$.gitAuthenticationFromData(this.gitAuthentications(), this.services().workspace());
        return (PushStatus)GitService$.MODULE$.withGit(utils$.MODULE$.safePathToFile(fromPath, this.services().workspace()), utils$.MODULE$.projectsDirectory(this.services().workspace()), (Function1 & Serializable)git -> GitService$.MODULE$.push(git, authentications)).getOrElse(ApiImpl::push$$anonfun$2);
    }

    public Option<BranchData> branchList(SafePath from) {
        return GitService$.MODULE$.withGit(utils$.MODULE$.safePathToFile(from, this.services().workspace()), utils$.MODULE$.projectsDirectory(this.services().workspace()), (Function1 & Serializable)git -> BranchData$.MODULE$.apply((Seq)GitService$.MODULE$.branchList(git).map((Function1 & Serializable)_$23 -> {
            Object object = Predef$.MODULE$.refArrayOps((Object[])_$23.split("/"));
            return (String)ArrayOps$.MODULE$.last$extension(object);
        }), git.getRepository().getBranch()));
    }

    public void checkout(SafePath from, String branchName) {
        GitService$.MODULE$.withGit(utils$.MODULE$.safePathToFile(from, this.services().workspace()), utils$.MODULE$.projectsDirectory(this.services().workspace()), (Function1 & Serializable)git -> GitService$.MODULE$.checkout(branchName, git));
    }

    public void stash(SafePath from) {
        GitService$.MODULE$.withGit(utils$.MODULE$.safePathToFile(from, this.services().workspace()), utils$.MODULE$.projectsDirectory(this.services().workspace()), (Function1)(JProcedure1 & Serializable)git -> GitService$.MODULE$.stash(git));
    }

    public MergeStatus stashPop(SafePath from) {
        return (MergeStatus)GitService$.MODULE$.withGit(utils$.MODULE$.safePathToFile(from, this.services().workspace()), utils$.MODULE$.projectsDirectory(this.services().workspace()), (Function1 & Serializable)git -> GitService$.MODULE$.stashPop(git)).getOrElse(ApiImpl::stashPop$$anonfun$2);
    }

    public boolean gitAuthenticationEquality(GitPrivateKeyAuthenticationData d1, GitPrivateKeyAuthenticationData d2) {
        SafePath safePath = d1.directory();
        SafePath safePath2 = d2.directory();
        return !(safePath != null ? !safePath.equals(safePath2) : safePath2 != null);
    }

    public Seq<GitPrivateKeyAuthenticationData> gitAuthentications() {
        String string = "privateKey";
        String string2 = "password";
        String string3 = "directory";
        int size = 3;
        return (Seq)Authentication$.MODULE$.load(ManifestFactory$.MODULE$.classType(GitPrivateKeyAuthenticationData.class), Decoder$.MODULE$.importedDecoder((Decoder)Exported$.MODULE$.apply((Object)ConfiguredDecoder$.MODULE$.inline$ofProduct("GitPrivateKeyAuthenticationData", ApiImpl::gitAuthentications$$anonfun$1, scala.package$.MODULE$.Nil().$colon$colon((Object)string3).$colon$colon((Object)string2).$colon$colon((Object)string), ApiImpl::gitAuthentications$$anonfun$2, Configuration$.MODULE$.default(), Default$.MODULE$.inline$of(ApiImpl::gitAuthentications$$anonfun$3)))), this.services().authenticationStore()).map((Function1 & Serializable)d -> {
            String string = this.services().cypher().decrypt(d.password());
            Option option = d.copy$default$1();
            SafePath safePath = d.copy$default$3();
            return d.copy(option, string, safePath);
        });
    }

    public void addGitAuthentication(GitPrivateKeyAuthenticationData d) {
        String string = this.services().cypher().encrypt(d.password());
        Option option = d.copy$default$1();
        SafePath safePath = d.copy$default$3();
        String string2 = "privateKey";
        String string3 = "password";
        String string4 = "directory";
        String string5 = "privateKey";
        String string6 = "password";
        String string7 = "directory";
        int size = 3;
        Authentication$.MODULE$.save((Object)d.copy(option, string, safePath), (Function2 & Serializable)(d1, d2) -> this.gitAuthenticationEquality((GitPrivateKeyAuthenticationData)d1, (GitPrivateKeyAuthenticationData)d2), ManifestFactory$.MODULE$.classType(GitPrivateKeyAuthenticationData.class), Encoder$.MODULE$.importedEncoder((Encoder)Exported$.MODULE$.apply((Object)ConfiguredEncoder$.MODULE$.inline$ofProduct(ApiImpl::addGitAuthentication$$anonfun$2, scala.package$.MODULE$.Nil().$colon$colon((Object)string4).$colon$colon((Object)string3).$colon$colon((Object)string2), Configuration$.MODULE$.default()))), Decoder$.MODULE$.importedDecoder((Decoder)Exported$.MODULE$.apply((Object)ConfiguredDecoder$.MODULE$.inline$ofProduct("GitPrivateKeyAuthenticationData", ApiImpl::addGitAuthentication$$anonfun$3, scala.package$.MODULE$.Nil().$colon$colon((Object)string7).$colon$colon((Object)string6).$colon$colon((Object)string5), ApiImpl::addGitAuthentication$$anonfun$4, Configuration$.MODULE$.default(), Default$.MODULE$.inline$of(ApiImpl::addGitAuthentication$$anonfun$5)))), this.services().authenticationStore());
    }

    public void removeGitAuthentication(GitPrivateKeyAuthenticationData d, boolean removeFile) {
        String string = "privateKey";
        String string2 = "password";
        String string3 = "directory";
        String string4 = "privateKey";
        String string5 = "password";
        String string6 = "directory";
        int size = 3;
        Authentication$.MODULE$.remove((Object)d, (Function2 & Serializable)(d1, d2) -> this.gitAuthenticationEquality((GitPrivateKeyAuthenticationData)d1, (GitPrivateKeyAuthenticationData)d2), ManifestFactory$.MODULE$.classType(GitPrivateKeyAuthenticationData.class), Encoder$.MODULE$.importedEncoder((Encoder)Exported$.MODULE$.apply((Object)ConfiguredEncoder$.MODULE$.inline$ofProduct(ApiImpl::removeGitAuthentication$$anonfun$2, scala.package$.MODULE$.Nil().$colon$colon((Object)string3).$colon$colon((Object)string2).$colon$colon((Object)string), Configuration$.MODULE$.default()))), Decoder$.MODULE$.importedDecoder((Decoder)Exported$.MODULE$.apply((Object)ConfiguredDecoder$.MODULE$.inline$ofProduct("GitPrivateKeyAuthenticationData", ApiImpl::removeGitAuthentication$$anonfun$3, scala.package$.MODULE$.Nil().$colon$colon((Object)string6).$colon$colon((Object)string5).$colon$colon((Object)string4), ApiImpl::removeGitAuthentication$$anonfun$4, Configuration$.MODULE$.default(), Default$.MODULE$.inline$of(ApiImpl::removeGitAuthentication$$anonfun$5)))), this.services().authenticationStore());
        if (removeFile) {
            SafePath safePath = d.directory().parent();
            SafePath safePath2 = SafePath$.MODULE$.root(ServerFileSystemContext$.Authentication);
            if (!(safePath != null ? !safePath.equals(safePath2) : safePath2 != null)) {
                package$.MODULE$.FileDecorator(utils$.MODULE$.safePathToFile(d.directory(), this.services().workspace())).recursiveDelete();
                return;
            }
        }
    }

    public Seq<Serializable> testGitAuthentication(GitPrivateKeyAuthenticationData d) {
        return (Seq)d.privateKeyPath().map((Function1 & Serializable)file -> {
            File privateKey = utils$.MODULE$.safePathToFile(file, this.services().workspace());
            Option option = utils$.MODULE$.testSSHKeyPassword(privateKey.getAbsolutePath(), d.password());
            if (None$.MODULE$.equals(option)) {
                return (Seq)((SeqOps)new .colon.colon((Object)PassedTest$.MODULE$.apply("Password is correct"), (List)Nil$.MODULE$));
            }
            if (option instanceof Some) {
                Some some = (Some)option;
                Throwable e = (Throwable)some.value();
                return (Seq)((SeqOps)new .colon.colon((Object)FailedTest$.MODULE$.apply("Password is incorrect", (ErrorData)ErrorData$.MODULE$.apply(e, ErrorData$.MODULE$.apply$default$2())), (List)Nil$.MODULE$));
            }
            throw new MatchError((Object)option);
        }).getOrElse(ApiImpl::testGitAuthentication$$anonfun$2);
    }

    private static final Option $init$$$anonfun$1() {
        return Some$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)0xA00000));
    }

    private final void extractArchiveFromFiles$$anonfun$1(File from$1, File to$1) {
        String name = from$1.getName();
        Option<ArchiveType> option = this.archiveType(package$.MODULE$.stringToFile(name));
        if (option instanceof Some) {
            Some some = (Some)option;
            ArchiveType archiveType = (ArchiveType)some.value();
            ArchiveType archiveType2 = ArchiveType$.Tar;
            ArchiveType archiveType3 = archiveType;
            if (!(archiveType2 != null ? !archiveType2.equals(archiveType3) : archiveType3 != null)) {
                ArchiveType archiveType4 = ArchiveType$.Tar;
                boolean bl = org.openmole.tool.archive.package$package$.MODULE$.extract$default$3(from$1);
                org.openmole.tool.archive.package$package$.MODULE$.extract(from$1, to$1, bl, archiveType4);
                package$.MODULE$.FileDecorator(to$1).applyRecursive((Function1)(JProcedure1 & Serializable)f -> f.setWritable(true));
                return;
            }
            ArchiveType archiveType5 = ArchiveType$.TarGZ;
            ArchiveType archiveType6 = archiveType;
            if (!(archiveType5 != null ? !archiveType5.equals(archiveType6) : archiveType6 != null)) {
                org.openmole.tool.archive.package$package$.MODULE$.extract(from$1, to$1, true, ArchiveType$.TarGZ);
                package$.MODULE$.FileDecorator(to$1).applyRecursive((Function1)(JProcedure1 & Serializable)f -> f.setWritable(true));
                return;
            }
            ArchiveType archiveType7 = ArchiveType$.Zip;
            ArchiveType archiveType8 = archiveType;
            if (!(archiveType7 != null ? !archiveType7.equals(archiveType8) : archiveType8 != null)) {
                org.openmole.tool.archive.package$package$.MODULE$.extract(from$1, to$1, true, ArchiveType$.Zip);
                return;
            }
            ArchiveType archiveType9 = ArchiveType$.TarXZ;
            ArchiveType archiveType10 = archiveType;
            if (!(archiveType9 != null ? !archiveType9.equals(archiveType10) : archiveType10 != null)) {
                org.openmole.tool.archive.package$package$.MODULE$.extract(from$1, to$1, true, ArchiveType$.TarXZ);
                package$.MODULE$.FileDecorator(to$1).applyRecursive((Function1)(JProcedure1 & Serializable)f -> f.setWritable(true));
                return;
            }
        }
        if (None$.MODULE$.equals(option)) {
            throw new Throwable("Unknown compression format for file " + from$1);
        }
        throw new MatchError(option);
    }

    private final File archiveFile$1(SafePath safePath$1) {
        return utils$.MODULE$.safePathToFile(safePath$1, this.services().workspace());
    }

    private final File toFile$1(SafePath to$2) {
        return utils$.MODULE$.safePathToFile(to$2, this.services().workspace());
    }

    private final String newHash$1(File file$3) {
        FileService fileService = this.services().fileService();
        return fileService.hashNoCache(file$3, fileService.hashNoCache$default$2(), this.services().tmpDirectory()).toString();
    }

    private final Tuple2 save$1(File file$2, String fileContent$2) {
        File tmpFile = Files.createTempFile(package$.MODULE$.file2Path(file$2.getParentFile()), "." + file$2.getName(), ".tmp", new FileAttribute[0]).toFile();
        package$.MODULE$.FileDecorator(tmpFile).mode_$eq(file$2);
        try {
            package$.MODULE$.FileDecorator(tmpFile).content_$eq(fileContent$2);
            package$.MODULE$.FileDecorator(tmpFile).move(file$2);
        }
        finally {
            tmpFile.delete();
        }
        return Tuple2$.MODULE$.apply((Object)BoxesRunTime.boxToBoolean((boolean)true), (Object)this.newHash$1(file$2));
    }

    private static final /* synthetic */ SequenceData sequence$$anonfun$1(String[] content$1, Regex regex$1, String h) {
        Object object = Predef$.MODULE$.refArrayOps((Object[])StringOps$.MODULE$.split$extension(Predef$.MODULE$.augmentString(h), ','));
        Object object2 = Predef$.MODULE$.refArrayOps((Object[])content$1);
        Object object3 = Predef$.MODULE$.refArrayOps((Object[])((String[])ArrayOps$.MODULE$.tail$extension(object2)));
        Object object4 = Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.map$extension(object3, (Function1 & Serializable)row -> regex$1.findAllIn((CharSequence)row).toSeq(), (ClassTag)package$.MODULE$.manifestOrder1(ManifestFactory$.MODULE$.classType(String.class), ClassTag$.MODULE$.apply(Seq.class))));
        return SequenceData$.MODULE$.apply(ArrayOps$.MODULE$.toSeq$extension(object), ArrayOps$.MODULE$.toSeq$extension(object4));
    }

    private static final SequenceData sequence$$anonfun$2() {
        return SequenceData$.MODULE$.apply(SequenceData$.MODULE$.$lessinit$greater$default$1(), SequenceData$.MODULE$.$lessinit$greater$default$2());
    }

    private static final KeyValueCache given_KeyValueCache$lzyINIT1$1(LazyRef given_KeyValueCache$lzy1$1) {
        KeyValueCache keyValueCache;
        LazyRef lazyRef = given_KeyValueCache$lzy1$1;
        synchronized (lazyRef) {
            keyValueCache = (KeyValueCache)(given_KeyValueCache$lzy1$1.initialized() ? given_KeyValueCache$lzy1$1.value() : given_KeyValueCache$lzy1$1.initialize((Object)org.openmole.core.dsl.extension.package$.MODULE$.KeyValueCache().apply()));
        }
        return keyValueCache;
    }

    private static final KeyValueCache given_KeyValueCache$1(LazyRef given_KeyValueCache$lzy1$2) {
        return (KeyValueCache)(given_KeyValueCache$lzy1$2.initialized() ? given_KeyValueCache$lzy1$2.value() : ApiImpl.given_KeyValueCache$lzyINIT1$1(given_KeyValueCache$lzy1$2));
    }

    private static final ScriptError toErrorWithLocation$1(Interpreter.ErrorMessage em) {
        return ScriptError$.MODULE$.apply(em.rawMessage(), em.position().map((Function1 & Serializable)p -> ScriptError.Position$.MODULE$.apply(p.line(), p.point(), p.start(), p.end())));
    }

    private static final MessageErrorData message$3(String message) {
        return MessageErrorData$.MODULE$.apply(message, (Option)None$.MODULE$);
    }

    private static final DSL compileToDSL$$anonfun$1$$anonfun$1(Compiled compiled$2, ServicesContainer runServices$2) {
        return compiled$2.eval((Seq)scala.package$.MODULE$.Seq().empty(), (Services)runServices$2);
    }

    private static final DSL compileToDSL$$anonfun$1(StringPrintStream outputStream$1, Compiled compiled$1, ServicesContainer runServices$1) {
        return (DSL)OutputManager$.MODULE$.withStreamOutputs((PrintStream)outputStream$1, (PrintStream)outputStream$1, () -> ApiImpl.compileToDSL$$anonfun$1$$anonfun$1(compiled$1, runServices$1));
    }

    private static final MoleExecution compileToMoleExecution$$anonfun$1(DSL dsl$1, MoleServices executionServices$1) {
        return MoleExecution$.MODULE$.apply(dsl$1, executionServices$1);
    }

    private static final MoleExecution processRun$1$$anonfun$1$$anonfun$2(MoleExecution ex$2, boolean validateScript$2) {
        return ex$2.start(validateScript$2);
    }

    private final void processRun$1$$anonfun$1(MoleExecution ex$1, ExecutionId execId$1, SafePath script$1, boolean validateScript$1) {
        Vector vector;
        try {
            vector = (Vector)ex$1.allEnvironments().map((Function1 & Serializable)env -> {
                EnvironmentId environmentId = (EnvironmentId)Predef$.MODULE$.ArrowAssoc((Object)EnvironmentId$.MODULE$.apply(org.openmole.gui.shared.data.package$package$.MODULE$.randomId()));
                return Predef.ArrowAssoc$.MODULE$.$u2192$extension((Object)environmentId, env);
            });
        }
        catch (Throwable e) {
            this.serverState().modifyState(execId$1, (Function1<ServerState.MoleExecutionState, ServerState.MoleExecutionState>)(Function1 & Serializable)_$3 -> (ServerState.MoleExecutionState)ServerState$MoleExecutionState$.MODULE$.given_Conversion_$bar_MoleExecutionState().apply((Object)ExecutionState.Failed$.MODULE$.apply((Seq)scala.package$.MODULE$.Vector().empty(), (ErrorData)ErrorData$.MODULE$.apply(e, ErrorData$.MODULE$.apply$default$2()), (Seq)scala.package$.MODULE$.Seq().empty(), ExecutionState.Failed$.MODULE$.$lessinit$greater$default$4(), ExecutionState.Failed$.MODULE$.$lessinit$greater$default$5())));
            throw Breaks$.MODULE$.break();
        }
        Vector envIds = vector;
        this.serverState().setEnvironments(execId$1, (Seq<Tuple2<EnvironmentId, Environment>>)envIds);
        package$package$.MODULE$.EventDispatcherDecorator((Object)ex$1).listen(this.serverState().moleExecutionListener(execId$1, script$1), this.services().eventDispatcher());
        envIds.foreach((Function1 & Serializable)x$1 -> {
            EnvironmentId envId = (EnvironmentId)x$1._1();
            Environment env = (Environment)x$1._2();
            return package$package$.MODULE$.EventDispatcherDecorator((Object)env).listen(this.serverState().environmentListener(execId$1, envId), this.services().eventDispatcher());
        });
        Try try_ = utils$.MODULE$.catchAll(() -> ApiImpl.processRun$1$$anonfun$1$$anonfun$2(ex$1, validateScript$1));
        if (try_ instanceof Failure) {
            Failure failure = (Failure)try_;
            Throwable e = failure.exception();
            this.serverState().modifyState(execId$1, (Function1<ServerState.MoleExecutionState, ServerState.MoleExecutionState>)(Function1 & Serializable)_$4 -> (ServerState.MoleExecutionState)ServerState$MoleExecutionState$.MODULE$.given_Conversion_$bar_MoleExecutionState().apply((Object)ExecutionState.Failed$.MODULE$.apply((Seq)scala.package$.MODULE$.Vector().empty(), (ErrorData)ErrorData$.MODULE$.apply(e, ErrorData$.MODULE$.apply$default$2()), (Seq)scala.package$.MODULE$.Seq().empty(), ExecutionState.Failed$.MODULE$.$lessinit$greater$default$4(), ExecutionState.Failed$.MODULE$.$lessinit$greater$default$5())));
            return;
        }
        if (try_ instanceof Success) {
            Success success = (Success)try_;
            boolean inserted = this.serverState().modifyState(execId$1, (Function1<ServerState.MoleExecutionState, ServerState.MoleExecutionState>)(Function1 & Serializable)_$5 -> (ServerState.MoleExecutionState)ServerState$MoleExecutionState$.MODULE$.given_Conversion_$bar_MoleExecutionState().apply((Object)ex$1));
            if (!inserted || Thread.currentThread().isInterrupted()) {
                ex$1.cancel();
                return;
            }
            return;
        }
        throw new MatchError((Object)try_);
    }

    private final void processRun$1(SafePath script$2, ExecutionId execId, MoleExecution ex, boolean validateScript) {
        Breaks$.MODULE$.breakable((Function0 & Serializable)() -> {
            this.processRun$1$$anonfun$1(ex, execId, script$2, validateScript);
            return BoxedUnit.UNIT;
        });
    }

    private final Object compileAndRun$1(SafePath script$3, StringPrintStream outputStream$2, ExecutionId execId$3, boolean validateScript$3) {
        Object object = this.compileToMoleExecution(script$3, outputStream$2);
        if (object instanceof MoleExecution) {
            MoleExecution moleExecution;
            MoleExecution e = moleExecution = (MoleExecution)object;
            if (Thread.interrupted()) {
                throw new InterruptedIOException();
            }
            this.processRun$1(script$3, execId$3, e, validateScript$3);
            return BoxedUnit.UNIT;
        }
        if (object instanceof ErrorData) {
            ErrorData errorData;
            ErrorData ed = errorData = (ErrorData)object;
            return BoxesRunTime.boxToBoolean((boolean)this.serverState().modifyState(execId$3, (Function1<ServerState.MoleExecutionState, ServerState.MoleExecutionState>)(Function1 & Serializable)_$6 -> (ServerState.MoleExecutionState)ServerState$MoleExecutionState$.MODULE$.given_Conversion_$bar_MoleExecutionState().apply((Object)ExecutionState.Failed$.MODULE$.apply((Seq)scala.package$.MODULE$.Vector().empty(), ed, (Seq)scala.package$.MODULE$.Seq().empty(), ExecutionState.Failed$.MODULE$.$lessinit$greater$default$4(), ExecutionState.Failed$.MODULE$.$lessinit$greater$default$5()))));
        }
        throw new MatchError(object);
    }

    private static final MarketIndex mapToMd$1(MarketIndex marketIndex) {
        return marketIndex.copy((Seq)marketIndex.entries().map((Function1 & Serializable)e -> {
            Option option = e.readme().map((Function1 & Serializable)_$10 -> MarkDownProcessor$.MODULE$.apply((String)_$10));
            String string = e.copy$default$1();
            String string2 = e.copy$default$2();
            Seq seq = e.copy$default$4();
            return e.copy(string, string2, option, seq);
        }));
    }

    private static final Seq $anonfun$12() {
        return (Seq)((SeqOps)Nil$.MODULE$);
    }

    private static final Seq updatePluggedList$$anonfun$1$$anonfun$1() {
        return (Seq)((SeqOps)Nil$.MODULE$);
    }

    private static final Seq $anonfun$15() {
        return (Seq)((SeqOps)Nil$.MODULE$);
    }

    private final void unplugFile$1(Seq allPlugins$1, File f) {
        if (utils$.MODULE$.isPlugged(f, allPlugins$1, this.services().workspace())) {
            Workspace workspace = this.services().workspace();
            ServerFileSystemContext serverFileSystemContext = utils$.MODULE$.fileToSafePath$default$2(f);
            this.removePlugin(utils$.MODULE$.fileToSafePath(f, serverFileSystemContext, workspace));
            return;
        }
    }

    private final Seq content$2(File omrFile$1, Option dataFile$1) {
        return (Seq)OMRFormat$.MODULE$.variables(omrFile$1, OMRFormat$.MODULE$.variables$default$2(), dataFile$1, OMRFormat$.MODULE$.variables$default$4()).map((Function1 & Serializable)v2 -> {
            Tuple2 x$proxy4;
            Tuple2 x$proxy2;
            NamedTuple$ namedTuple$ = NamedTuple$.MODULE$;
            Tuple2 x$proxy1 = v2;
            NamedTuple$ namedTuple$2 = namedTuple$;
            Tuple2 Tuple_this = x$proxy2 = x$proxy1;
            NamedTuple$ namedTuple$3 = NamedTuple$.MODULE$;
            Tuple2 x$proxy3 = v2;
            NamedTuple$ namedTuple$4 = namedTuple$3;
            Tuple2 Tuple_this2 = x$proxy4 = x$proxy3;
            return GUIOMRSectionContent$.MODULE$.apply(((OMRContent.DataContent.SectionData)Tuple_this._1()).name(), (Seq)((Seq)Tuple_this2._2()).map((Function1 & Serializable)v -> this.toGUIVariable((Variable<?>)v)));
        });
    }

    private static final GUIOMRImport convertImport$1(OMRContent.Import i) {
        return GUIOMRImport$.MODULE$.apply(i.import(), i.content());
    }

    private static final Seq script$6$$anonfun$1$$anonfun$1() {
        return (Seq)((SeqOps)Nil$.MODULE$);
    }

    private static final Option script$6(OMRContent omrContent$1) {
        return omrContent$1.script().map((Function1 & Serializable)s -> GUIOMRScript$.MODULE$.apply(s.content(), (Seq)((IterableOps)s.import().getOrElse(ApiImpl::script$6$$anonfun$1$$anonfun$1)).map((Function1 & Serializable)i -> ApiImpl.convertImport$1(i))));
    }

    private static final Option index$1(OMRContent omrContent$2) {
        Seq names = (Seq)omrContent$2.data$minuscontent().section().flatMap((Function1 & Serializable)_$15 -> _$15.indexes());
        int size = omrContent$2.data$minusfile().size();
        if (((SeqOps)names.flatten((Function1 & Serializable)s -> package$.MODULE$.seqToSeqOfFromContext(s, ToFromContext$.MODULE$.given_ToFromContext_String_String()))).isEmpty() || size <= 1) {
            return None$.MODULE$;
        }
        return Some$.MODULE$.apply((Object)GUIOMRContent.Index$.MODULE$.apply(size, names));
    }

    private final String raw$1(File omrFile$2, Option dataFile$2) {
        return (String)this.services().tmpDirectory().withTmpFile("result", ".csv", (Function1 & Serializable)csvFile -> {
            OMRFormat$.MODULE$.writeCSV(omrFile$2, csvFile, dataFile$2, OMRFormat$.MODULE$.writeCSV$default$4(), OMRFormat$.MODULE$.writeCSV$default$5(), OMRFormat$.MODULE$.writeCSV$default$6());
            return package$.MODULE$.FileDecorator(csvFile).content();
        }, this.services().tmpDirectory());
    }

    private final Seq indexes$1(File omrFile$4) {
        return (Seq)OMRFormat$.MODULE$.indexes(omrFile$4).map((Function1 & Serializable)id -> {
            Object object = Predef$.MODULE$.genericArrayOps((Object)id.values());
            Object object2 = Predef$.MODULE$.refArrayOps((Object[])id.fileIndex());
            return GUIOMRDataIndex$.MODULE$.apply(id.sectionIndex(), id.variableName(), (Seq)Predef$.MODULE$.copyArrayToImmutableIndexedSeq(ArrayOps$.MODULE$.flatMap$extension(object, (Function1 & Serializable)x -> this.toValueTypeFromAny(x), ClassTag$.MODULE$.apply(GUIVariable.ValueType.class))), ArrayOps$.MODULE$.toSeq$extension(object2));
        });
    }

    private final GUIVariable.ValueType res$1$$anonfun$1(Object x$2) {
        Object object = x$2;
        if (object instanceof Integer) {
            int n;
            int x = n = BoxesRunTime.unboxToInt((Object)object);
            return GUIVariable.ValueType$.ValueInt$.MODULE$.apply(x);
        }
        if (object instanceof Long) {
            long l;
            long x = l = BoxesRunTime.unboxToLong((Object)object);
            return GUIVariable.ValueType$.ValueLong$.MODULE$.apply(x);
        }
        if (object instanceof Double) {
            double d;
            double x = d = BoxesRunTime.unboxToDouble((Object)object);
            return GUIVariable.ValueType$.ValueDouble$.MODULE$.apply(x);
        }
        if (object instanceof String) {
            String string;
            String x = string = (String)object;
            return GUIVariable.ValueType$.ValueString$.MODULE$.apply(x);
        }
        if (object instanceof Boolean) {
            boolean bl;
            boolean x = bl = BoxesRunTime.unboxToBoolean((Object)object);
            return GUIVariable.ValueType$.ValueBoolean$.MODULE$.apply(x);
        }
        if (object instanceof File) {
            File file;
            File x = file = (File)object;
            Workspace workspace = this.services().workspace();
            ServerFileSystemContext serverFileSystemContext = utils$.MODULE$.fileToSafePath$default$2(x);
            return GUIVariable.ValueType$.ValueFile$.MODULE$.apply(utils$.MODULE$.fileToSafePath(x, serverFileSystemContext, workspace));
        }
        if (object instanceof int[]) {
            int[] nArray;
            int[] x = nArray = (int[])object;
            return GUIVariable.ValueType$.ValueArrayInt$.MODULE$.apply(x);
        }
        if (object instanceof long[]) {
            long[] lArray;
            long[] x = lArray = (long[])object;
            return GUIVariable.ValueType$.ValueArrayLong$.MODULE$.apply(x);
        }
        if (object instanceof double[]) {
            double[] dArray;
            double[] x = dArray = (double[])object;
            return GUIVariable.ValueType$.ValueArrayDouble$.MODULE$.apply(x);
        }
        if (object instanceof String[]) {
            String[] stringArray;
            String[] x = stringArray = (String[])object;
            return GUIVariable.ValueType$.ValueArrayString$.MODULE$.apply(x);
        }
        if (object instanceof boolean[]) {
            boolean[] blArray;
            boolean[] x = blArray = (boolean[])object;
            return GUIVariable.ValueType$.ValueArrayBoolean$.MODULE$.apply(x);
        }
        if (object instanceof File[]) {
            Object[] objectArray;
            Object[] x = objectArray = (File[])object;
            Object object2 = Predef$.MODULE$.refArrayOps(x);
            return GUIVariable.ValueType$.ValueArrayFile$.MODULE$.apply((SafePath[])ArrayOps$.MODULE$.map$extension(object2, (Function1 & Serializable)f -> {
                Workspace workspace = this.services().workspace();
                ServerFileSystemContext serverFileSystemContext = utils$.MODULE$.fileToSafePath$default$2(f);
                return utils$.MODULE$.fileToSafePath(f, serverFileSystemContext, workspace);
            }, ClassTag$.MODULE$.apply(SafePath.class)));
        }
        if (object instanceof int[][]) {
            int[][] nArray;
            int[][] x = nArray = (int[][])object;
            return GUIVariable.ValueType$.ValueArrayArrayInt$.MODULE$.apply(x);
        }
        if (object instanceof long[][]) {
            long[][] lArray;
            long[][] x = lArray = (long[][])object;
            return GUIVariable.ValueType$.ValueArrayArrayLong$.MODULE$.apply(x);
        }
        if (object instanceof double[][]) {
            double[][] dArray;
            double[][] x = dArray = (double[][])object;
            return GUIVariable.ValueType$.ValueArrayArrayDouble$.MODULE$.apply(x);
        }
        if (object instanceof String[][]) {
            String[][] stringArray;
            String[][] x = stringArray = (String[][])object;
            return GUIVariable.ValueType$.ValueArrayArrayString$.MODULE$.apply(x);
        }
        if (object instanceof boolean[][]) {
            boolean[][] blArray;
            boolean[][] x = blArray = (boolean[][])object;
            return GUIVariable.ValueType$.ValueArrayArrayBoolean$.MODULE$.apply(x);
        }
        if (object instanceof File[][]) {
            File[][] fileArray;
            File[][] x = fileArray = (File[][])object;
            Object object3 = Predef$.MODULE$.refArrayOps((Object[])x);
            return GUIVariable.ValueType$.ValueArrayArrayFile$.MODULE$.apply((SafePath[][])ArrayOps$.MODULE$.map$extension(object3, (Function1 & Serializable)_$16 -> {
                Object object = Predef$.MODULE$.refArrayOps((Object[])_$16);
                return (SafePath[])ArrayOps$.MODULE$.map$extension(object, (Function1 & Serializable)f -> {
                    Workspace workspace = this.services().workspace();
                    ServerFileSystemContext serverFileSystemContext = utils$.MODULE$.fileToSafePath$default$2(f);
                    return utils$.MODULE$.fileToSafePath(f, serverFileSystemContext, workspace);
                }, ClassTag$.MODULE$.apply(SafePath.class));
            }, (ClassTag)package$.MODULE$.manifestOrder1(ManifestFactory$.MODULE$.classType(SafePath.class), ClassTag$.MODULE$.apply(SafePath.class).wrap())));
        }
        throw new MatchError(object);
    }

    private final Try res$1(Object x$1) {
        return Try$.MODULE$.apply(() -> this.res$1$$anonfun$1(x$1));
    }

    private final boolean isArchive$1(Option nameHeader$1, SafePath path$1) {
        File file;
        Option option = nameHeader$1;
        if (option instanceof Some) {
            Some some = (Some)option;
            String name = (String)some.value();
            file = utils$.MODULE$.safePathToFile(path$1.$div(name), this.services().workspace());
        } else if (None$.MODULE$.equals(option)) {
            file = utils$.MODULE$.safePathToFile(path$1, this.services().workspace());
        } else {
            throw new MatchError((Object)option);
        }
        File fileName = file;
        return this.archiveType(fileName).contains((Object)ArchiveType$.TarGZ);
    }

    private static final String extractName$1(String checkedURL$2) {
        Object object = Predef$.MODULE$.refArrayOps((Object[])checkedURL$2.split("/"));
        return (String)ArrayOps$.MODULE$.last$extension(object);
    }

    private static final String $anonfun$22(String checkedURL$3) {
        return ApiImpl.extractName$1(checkedURL$3);
    }

    private final /* synthetic */ void downloadHTTP$$anonfun$1(SafePath path$2, boolean extract$1, boolean overwrite$4, String checkedURL$1, CloseableHttpResponse response) {
        Object object = Predef$.MODULE$.refArrayOps((Object[])response.getAllHeaders());
        Object object2 = Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.map$extension(object, (Function1 & Serializable)h -> {
            String string = (String)Predef$.MODULE$.ArrowAssoc((Object)h.getName());
            return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)h.getValue());
        }, (ClassTag)package$.MODULE$.manifestOrder2(ManifestFactory$.MODULE$.classType(String.class), ManifestFactory$.MODULE$.classType(String.class), (ClassTag)package$.MODULE$.manifestOrder1(ManifestFactory$.MODULE$.classType(String.class), ClassTag$.MODULE$.apply(Tuple2.class)))));
        Object object3 = Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.flatMap$extension(object2, (Function1 & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 != null && "Content-Disposition".equals(tuple2._1())) {
                String value = (String)tuple2._2();
                Object object = Predef$.MODULE$.refArrayOps((Object[])value.split(";"));
                Object object2 = Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.map$extension(object, (Function1 & Serializable)_$18 -> _$18.split("="), (ClassTag)package$.MODULE$.manifestOrder1(ManifestFactory$.MODULE$.classType(String.class), ClassTag$.MODULE$.apply(String.class).wrap())));
                return ArrayOps$.MODULE$.find$extension(object2, (Function1 & Serializable)_$19 -> {
                    Object object = Predef$.MODULE$.refArrayOps((Object[])_$19);
                    String string = ((String)ArrayOps$.MODULE$.head$extension(object)).trim();
                    String string2 = "filename";
                    return !(string != null ? !string.equals(string2) : string2 != null);
                }).map((Function1 & Serializable)filename -> {
                    Object object = Predef$.MODULE$.refArrayOps((Object[])filename);
                    String name = ((String)ArrayOps$.MODULE$.last$extension(object)).trim();
                    if (name.startsWith("\"") && name.endsWith("\"")) {
                        return StringOps$.MODULE$.dropRight$extension(Predef$.MODULE$.augmentString(StringOps$.MODULE$.drop$extension(Predef$.MODULE$.augmentString(name), 1)), 1);
                    }
                    return name;
                });
            }
            return None$.MODULE$;
        }, ClassTag$.MODULE$.apply(String.class)));
        Option nameHeader = ArrayOps$.MODULE$.headOption$extension(object3);
        if (extract$1 && this.isArchive$1(nameHeader, path$2)) {
            File dest = utils$.MODULE$.safePathToFile(path$2, this.services().workspace());
            try (TarArchiveInputStream tis = org.openmole.tool.archive.package$package$.MODULE$.TarArchiveInputStream((InputStream)new GZIPInputStream(response.getEntity().getContent()));){
                org.openmole.tool.archive.package$package$.MODULE$.TarInputStreamDecorator(tis).extract(dest, overwrite$4);
            }
            return;
        }
        File dest = utils$.MODULE$.safePathToFile(path$2.$div((String)nameHeader.getOrElse(() -> ApiImpl.$anonfun$22(checkedURL$1))), this.services().workspace());
        if (!dest.exists() || overwrite$4) {
            package$.MODULE$.FileDecorator(dest).withOutputStream().apply((JProcedure1 & Serializable)os -> org.openmole.tool.stream.package$.MODULE$.copy(response.getEntity().getContent(), os));
            return;
        }
        throw new IOException("Destination file " + dest + " already exists and overwrite is not set");
    }

    private static final String nameValue$1(String name$2) {
        if (name$2.endsWith(".git")) {
            return StringOps$.MODULE$.dropRight$extension(Predef$.MODULE$.augmentString(name$2), ".git".length());
        }
        return name$2;
    }

    private static final MergeStatus pull$$anonfun$2() {
        return MergeStatus$.Empty;
    }

    private static final PushStatus push$$anonfun$2() {
        return PushStatus$.Failed;
    }

    private static final MergeStatus stashPop$$anonfun$2() {
        return MergeStatus$.Empty;
    }

    private static final List gitAuthentications$$anonfun$1() {
        Codec.AsObject decodeA;
        Decoder decodeA2;
        Decoder decodeA3;
        DecoderNotDeriveSum f$proxy1;
        DecoderNotDeriveSum DecoderNotDeriveSum_this = f$proxy1 = new DecoderNotDeriveSum(Configuration$.MODULE$.default());
        Configuration x$2$proxy1 = DecoderNotDeriveSum_this.io$circe$derivation$DecoderNotDeriveSum$$inline$x$1();
        Decoder decoder = decodeA3 = Decoder$.MODULE$.decodeOption(Decoder$.MODULE$.decodeString());
        DecoderNotDeriveSum DecoderNotDeriveSum_this2 = f$proxy1;
        Configuration x$2$proxy2 = DecoderNotDeriveSum_this2.io$circe$derivation$DecoderNotDeriveSum$$inline$x$1();
        Decoder decoder2 = decodeA2 = Decoder$.MODULE$.decodeString();
        DecoderNotDeriveSum DecoderNotDeriveSum_this3 = f$proxy1;
        Configuration x$2$proxy3 = DecoderNotDeriveSum_this3.io$circe$derivation$DecoderNotDeriveSum$$inline$x$1();
        Codec.AsObject asObject = decodeA = SafePath$.MODULE$.derived$AsObject();
        return scala.package$.MODULE$.Nil().$colon$colon((Object)asObject).$colon$colon((Object)decoder2).$colon$colon((Object)decoder);
    }

    private static final /* synthetic */ GitPrivateKeyAuthenticationData gitAuthentications$$anonfun$2$$anonfun$1(Mirror.Product $2$$1, Product p) {
        return (GitPrivateKeyAuthenticationData)$2$$1.fromProduct(p);
    }

    private static final Function1 gitAuthentications$$anonfun$2() {
        GitPrivateKeyAuthenticationData$ gitPrivateKeyAuthenticationData$ = GitPrivateKeyAuthenticationData$.MODULE$;
        return arg_0 -> ApiImpl.gitAuthentications$$anonfun$2$$anonfun$1((Mirror.Product)gitPrivateKeyAuthenticationData$, arg_0);
    }

    private static final Product gitAuthentications$$anonfun$3() {
        return Tuple3$.MODULE$.apply((Object)None$.MODULE$, (Object)None$.MODULE$, (Object)None$.MODULE$);
    }

    private static final List addGitAuthentication$$anonfun$2() {
        Codec.AsObject encodeA;
        Encoder encodeA2;
        Encoder encodeA3;
        EncoderNotDeriveSum f$proxy2;
        EncoderNotDeriveSum EncoderNotDeriveSum_this = f$proxy2 = new EncoderNotDeriveSum(Configuration$.MODULE$.default());
        Configuration x$2$proxy4 = EncoderNotDeriveSum_this.io$circe$derivation$EncoderNotDeriveSum$$inline$config();
        Encoder encoder = encodeA3 = Encoder$.MODULE$.encodeOption(Encoder$.MODULE$.encodeString());
        EncoderNotDeriveSum EncoderNotDeriveSum_this2 = f$proxy2;
        Configuration x$2$proxy5 = EncoderNotDeriveSum_this2.io$circe$derivation$EncoderNotDeriveSum$$inline$config();
        Encoder encoder2 = encodeA2 = Encoder$.MODULE$.encodeString();
        EncoderNotDeriveSum EncoderNotDeriveSum_this3 = f$proxy2;
        Configuration x$2$proxy6 = EncoderNotDeriveSum_this3.io$circe$derivation$EncoderNotDeriveSum$$inline$config();
        Codec.AsObject asObject = encodeA = SafePath$.MODULE$.derived$AsObject();
        return scala.package$.MODULE$.Nil().$colon$colon((Object)asObject).$colon$colon((Object)encoder2).$colon$colon((Object)encoder);
    }

    private static final List addGitAuthentication$$anonfun$3() {
        Codec.AsObject decodeA;
        Decoder decodeA2;
        Decoder decodeA3;
        DecoderNotDeriveSum f$proxy3;
        DecoderNotDeriveSum DecoderNotDeriveSum_this = f$proxy3 = new DecoderNotDeriveSum(Configuration$.MODULE$.default());
        Configuration x$2$proxy7 = DecoderNotDeriveSum_this.io$circe$derivation$DecoderNotDeriveSum$$inline$x$1();
        Decoder decoder = decodeA3 = Decoder$.MODULE$.decodeOption(Decoder$.MODULE$.decodeString());
        DecoderNotDeriveSum DecoderNotDeriveSum_this2 = f$proxy3;
        Configuration x$2$proxy8 = DecoderNotDeriveSum_this2.io$circe$derivation$DecoderNotDeriveSum$$inline$x$1();
        Decoder decoder2 = decodeA2 = Decoder$.MODULE$.decodeString();
        DecoderNotDeriveSum DecoderNotDeriveSum_this3 = f$proxy3;
        Configuration x$2$proxy9 = DecoderNotDeriveSum_this3.io$circe$derivation$DecoderNotDeriveSum$$inline$x$1();
        Codec.AsObject asObject = decodeA = SafePath$.MODULE$.derived$AsObject();
        return scala.package$.MODULE$.Nil().$colon$colon((Object)asObject).$colon$colon((Object)decoder2).$colon$colon((Object)decoder);
    }

    private static final /* synthetic */ GitPrivateKeyAuthenticationData addGitAuthentication$$anonfun$4$$anonfun$1(Mirror.Product $2$$2, Product p) {
        return (GitPrivateKeyAuthenticationData)$2$$2.fromProduct(p);
    }

    private static final Function1 addGitAuthentication$$anonfun$4() {
        GitPrivateKeyAuthenticationData$ gitPrivateKeyAuthenticationData$ = GitPrivateKeyAuthenticationData$.MODULE$;
        return arg_0 -> ApiImpl.addGitAuthentication$$anonfun$4$$anonfun$1((Mirror.Product)gitPrivateKeyAuthenticationData$, arg_0);
    }

    private static final Product addGitAuthentication$$anonfun$5() {
        return Tuple3$.MODULE$.apply((Object)None$.MODULE$, (Object)None$.MODULE$, (Object)None$.MODULE$);
    }

    private static final List removeGitAuthentication$$anonfun$2() {
        Codec.AsObject encodeA;
        Encoder encodeA2;
        Encoder encodeA3;
        EncoderNotDeriveSum f$proxy4;
        EncoderNotDeriveSum EncoderNotDeriveSum_this = f$proxy4 = new EncoderNotDeriveSum(Configuration$.MODULE$.default());
        Configuration x$2$proxy10 = EncoderNotDeriveSum_this.io$circe$derivation$EncoderNotDeriveSum$$inline$config();
        Encoder encoder = encodeA3 = Encoder$.MODULE$.encodeOption(Encoder$.MODULE$.encodeString());
        EncoderNotDeriveSum EncoderNotDeriveSum_this2 = f$proxy4;
        Configuration x$2$proxy11 = EncoderNotDeriveSum_this2.io$circe$derivation$EncoderNotDeriveSum$$inline$config();
        Encoder encoder2 = encodeA2 = Encoder$.MODULE$.encodeString();
        EncoderNotDeriveSum EncoderNotDeriveSum_this3 = f$proxy4;
        Configuration x$2$proxy12 = EncoderNotDeriveSum_this3.io$circe$derivation$EncoderNotDeriveSum$$inline$config();
        Codec.AsObject asObject = encodeA = SafePath$.MODULE$.derived$AsObject();
        return scala.package$.MODULE$.Nil().$colon$colon((Object)asObject).$colon$colon((Object)encoder2).$colon$colon((Object)encoder);
    }

    private static final List removeGitAuthentication$$anonfun$3() {
        Codec.AsObject decodeA;
        Decoder decodeA2;
        Decoder decodeA3;
        DecoderNotDeriveSum f$proxy5;
        DecoderNotDeriveSum DecoderNotDeriveSum_this = f$proxy5 = new DecoderNotDeriveSum(Configuration$.MODULE$.default());
        Configuration x$2$proxy13 = DecoderNotDeriveSum_this.io$circe$derivation$DecoderNotDeriveSum$$inline$x$1();
        Decoder decoder = decodeA3 = Decoder$.MODULE$.decodeOption(Decoder$.MODULE$.decodeString());
        DecoderNotDeriveSum DecoderNotDeriveSum_this2 = f$proxy5;
        Configuration x$2$proxy14 = DecoderNotDeriveSum_this2.io$circe$derivation$DecoderNotDeriveSum$$inline$x$1();
        Decoder decoder2 = decodeA2 = Decoder$.MODULE$.decodeString();
        DecoderNotDeriveSum DecoderNotDeriveSum_this3 = f$proxy5;
        Configuration x$2$proxy15 = DecoderNotDeriveSum_this3.io$circe$derivation$DecoderNotDeriveSum$$inline$x$1();
        Codec.AsObject asObject = decodeA = SafePath$.MODULE$.derived$AsObject();
        return scala.package$.MODULE$.Nil().$colon$colon((Object)asObject).$colon$colon((Object)decoder2).$colon$colon((Object)decoder);
    }

    private static final /* synthetic */ GitPrivateKeyAuthenticationData removeGitAuthentication$$anonfun$4$$anonfun$1(Mirror.Product $2$$3, Product p) {
        return (GitPrivateKeyAuthenticationData)$2$$3.fromProduct(p);
    }

    private static final Function1 removeGitAuthentication$$anonfun$4() {
        GitPrivateKeyAuthenticationData$ gitPrivateKeyAuthenticationData$ = GitPrivateKeyAuthenticationData$.MODULE$;
        return arg_0 -> ApiImpl.removeGitAuthentication$$anonfun$4$$anonfun$1((Mirror.Product)gitPrivateKeyAuthenticationData$, arg_0);
    }

    private static final Product removeGitAuthentication$$anonfun$5() {
        return Tuple3$.MODULE$.apply((Object)None$.MODULE$, (Object)None$.MODULE$, (Object)None$.MODULE$);
    }

    private static final Seq testGitAuthentication$$anonfun$2() {
        return (Seq)((SeqOps)new .colon.colon((Object)FailedTest$.MODULE$.apply("Private key not set", (ErrorData)ErrorData$.MODULE$.empty()), (List)Nil$.MODULE$));
    }
}

