/*
 * Decompiled with CFR 0.152.
 */
package org.openmole.gui.server.core;

import cats.Applicative;
import cats.effect.IO;
import cats.effect.IO$;
import java.io.File;
import java.io.OutputStream;
import java.io.Serializable;
import org.apache.commons.compress.archivers.tar.TarArchiveOutputStream;
import org.http4s.EntityEncoder$;
import org.http4s.Header;
import org.http4s.Request;
import org.http4s.Response;
import org.http4s.Status$;
import org.http4s.dsl.io$;
import org.openmole.core.exception.InternalProcessingError;
import org.openmole.core.exception.InternalProcessingError$;
import org.openmole.core.exception.UserBadDataError$;
import org.openmole.core.format.OMRFormat$;
import org.openmole.core.workspace.Workspace;
import org.openmole.gui.server.core.ApiImpl;
import org.openmole.gui.server.core.CoreAPIServer;
import org.openmole.gui.server.ext.utils;
import org.openmole.gui.server.ext.utils$;
import org.openmole.gui.shared.data.RelativePath$;
import org.openmole.gui.shared.data.SafePath;
import org.openmole.gui.shared.data.SafePath$;
import org.openmole.gui.shared.data.ServerFileSystemContext;
import org.openmole.gui.shared.data.ServerFileSystemContext$;
import org.openmole.tool.archive.package;
import org.openmole.tool.archive.package$package$;
import org.openmole.tool.stream.package$;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Some$;
import scala.collection.ArrayOps$;
import scala.collection.BuildFrom$;
import scala.collection.Iterable;
import scala.collection.IterableOnceOps;
import scala.collection.StringOps$;
import scala.collection.immutable.Seq;
import scala.runtime.BoxesRunTime;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.ScalaRunTime$;
import scala.runtime.function.JProcedure1;

public final class CoreAPIServer$
implements Serializable {
    public static final CoreAPIServer$ MODULE$ = new CoreAPIServer$();

    private CoreAPIServer$() {
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(CoreAPIServer$.class);
    }

    public IO<Response<IO>> download(Request<IO> req, Seq<SafePath> safePath, Option<String> name, boolean topDirectory, Workspace x$5) {
        File f;
        Seq notExists = (Seq)safePath.filter((Function1 & Serializable)sp -> !utils$.MODULE$.safePathToFile(sp, x$5).exists());
        if (notExists.nonEmpty()) {
            return (IO)io$.MODULE$.http4sNotFoundSyntax(Status$.MODULE$.NotFound()).apply((Object)("The file(s) " + ((IterableOnceOps)notExists.map((Function1 & Serializable)_$1 -> RelativePath$.MODULE$.mkString(_$1.path()))).mkString(" and ") + " do(es) not exist."), (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Header.ToRaw[0]), (Applicative)IO$.MODULE$.asyncForIO(), EntityEncoder$.MODULE$.stringEncoder(EntityEncoder$.MODULE$.stringEncoder$default$1()));
        }
        Seq files = (Seq)safePath.map((Function1 & Serializable)s -> utils$.MODULE$.safePathToFile(s, x$5));
        if (files.size() == 1 && !OMRFormat$.MODULE$.isOMR((File)files.head())) {
            File file = (File)files.head();
            if (file.isDirectory()) {
                return this.downloadInArchive$1(this.archiveDirectoryName$1(name, file), (Function1)(JProcedure1 & Serializable)os -> this.addFile$1(topDirectory, (TarArchiveOutputStream)os, file));
            }
            return this.fileDownload(file, req, name);
        }
        String fileName = files.size() == 1 ? ((f = (File)files.head()).isDirectory() ? this.archiveDirectoryName$1(name, f) : name.getOrElse(() -> CoreAPIServer$.$anonfun$10(f)) + ".tar.gz") : "files.tar.gz";
        return this.downloadInArchive$1(fileName, (Function1)(JProcedure1 & Serializable)os -> files.foreach((Function1)(JProcedure1 & Serializable)f -> this.addFile$1(topDirectory, (TarArchiveOutputStream)os, (File)f)));
    }

    public Option<String> download$default$3() {
        return None$.MODULE$;
    }

    public boolean download$default$4() {
        return true;
    }

    public IO<Response<IO>> fileDownload(File f, Request<IO> req, Option<String> name) {
        return utils.HTTP$.MODULE$.sendFile(req, f, name);
    }

    public Seq<SafePath> getSafePath(Request<IO> req) {
        Option fileType = req.multiParams().get((Object)org.openmole.gui.shared.api.package$package$.MODULE$.fileTypeParam());
        Seq path = (Seq)req.multiParams().getOrElse((Object)org.openmole.gui.shared.api.package$package$.MODULE$.pathParam(), CoreAPIServer$::$anonfun$11);
        if (path.isEmpty()) {
            throw UserBadDataError$.MODULE$.apply("Path param should be set to a value", UserBadDataError$.MODULE$.apply$default$2());
        }
        Option option = fileType;
        if (option instanceof Some) {
            Some some = (Some)option;
            Seq fileType2 = (Seq)some.value();
            return (Seq)path.lazyZip((Iterable)fileType2).map((Function2 & Serializable)(p, ft) -> {
                Object object = Predef$.MODULE$.refArrayOps((Object[])StringOps$.MODULE$.split$extension(Predef$.MODULE$.augmentString(p), '/'));
                return SafePath$.MODULE$.apply((Iterable)ArrayOps$.MODULE$.toSeq$extension(object), (ServerFileSystemContext)ServerFileSystemContext$.MODULE$.fromTypeName(ft).getOrElse(() -> CoreAPIServer$.getSafePath$$anonfun$1$$anonfun$1(fileType2)));
            }, BuildFrom$.MODULE$.buildFromIterableOps());
        }
        if (None$.MODULE$.equals(option)) {
            return (Seq)path.map((Function1 & Serializable)p -> {
                Object object = Predef$.MODULE$.refArrayOps((Object[])StringOps$.MODULE$.split$extension(Predef$.MODULE$.augmentString(p), '/'));
                return SafePath$.MODULE$.apply((Iterable)ArrayOps$.MODULE$.toSeq$extension(object), ServerFileSystemContext$.Project);
            });
        }
        throw new MatchError((Object)option);
    }

    public CoreAPIServer apply(ApiImpl apiImpl) {
        return new CoreAPIServer(apiImpl);
    }

    private final IO downloadInArchive$1(String name, Function1 f) {
        return utils.HTTP$.MODULE$.sendFileStream(name, (Function1)(JProcedure1 & Serializable)out -> {
            try (TarArchiveOutputStream tos = package$package$.MODULE$.TarArchiveOutputStream((OutputStream)package$.MODULE$.OutputStreamDecorator(out).toGZ(), (Option)Some$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)65536)));){
                f.apply((Object)tos);
            }
        });
    }

    private final void addOMR$1(TarArchiveOutputStream tos, File f) {
        Seq dataFiles = OMRFormat$.MODULE$.dataFiles(f);
        package$package$.MODULE$.TarOutputStreamDecorator(tos).addFile(f, f.getName());
        dataFiles.foreach((Function1)(JProcedure1 & Serializable)n -> package$package$.MODULE$.TarOutputStreamDecorator(tos).addFile(OMRFormat$.MODULE$.dataFile(f, n), n));
    }

    private final void addFile$1(boolean topDirectory$1, TarArchiveOutputStream tos, File f) {
        if (f.isDirectory()) {
            package.package.TarOutputStreamDecorator tarOutputStreamDecorator = package$package$.MODULE$.TarOutputStreamDecorator(tos);
            tarOutputStreamDecorator.archive(f, tarOutputStreamDecorator.archive$default$2(), topDirectory$1);
            return;
        }
        if (!OMRFormat$.MODULE$.isOMR(f)) {
            package$package$.MODULE$.TarOutputStreamDecorator(tos).addFile(f, f.getName());
            return;
        }
        this.addOMR$1(tos, f);
    }

    private static final String archiveDirectoryName$1$$anonfun$1(File f$3) {
        return f$3.getName();
    }

    private final String archiveDirectoryName$1(Option name$1, File f) {
        return name$1.getOrElse(() -> CoreAPIServer$.archiveDirectoryName$1$$anonfun$1(f)) + ".tar.gz";
    }

    private static final String $anonfun$10(File f$4) {
        return org.openmole.tool.file.package$.MODULE$.FileDecorator(f$4).baseName();
    }

    private static final Seq $anonfun$11() {
        throw UserBadDataError$.MODULE$.apply("Parameter " + org.openmole.gui.shared.api.package$package$.MODULE$.pathParam() + " is required", UserBadDataError$.MODULE$.apply$default$2());
    }

    private static final ServerFileSystemContext getSafePath$$anonfun$1$$anonfun$1(Seq fileType$2) {
        throw new InternalProcessingError("Unknown file type " + fileType$2, InternalProcessingError$.MODULE$.$lessinit$greater$default$2());
    }
}

