/*
 * Decompiled with CFR 0.152.
 */
package container.tool;

import container.tool.Tar;
import container.tool.Tar$DirectoryMetaData$3$;
import container.tool.Tar$LinkData$3$;
import container.tool.Tar$Mode$;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.Serializable;
import java.nio.file.CopyOption;
import java.nio.file.DirectoryStream;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.PosixFilePermission;
import java.util.Stack;
import java.util.zip.GZIPInputStream;
import org.apache.commons.compress.archivers.tar.TarArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveInputStream;
import org.apache.commons.compress.archivers.tar.TarArchiveOutputStream;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.IterableOnceOps;
import scala.collection.JavaConverters$;
import scala.collection.StringOps$;
import scala.collection.immutable.Seq;
import scala.collection.mutable.ListBuffer;
import scala.collection.mutable.ListBuffer$;
import scala.collection.mutable.Set;
import scala.collection.mutable.Set$;
import scala.jdk.CollectionConverters$;
import scala.package$;
import scala.runtime.Arrays$;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyRef;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

public final class Tar$
implements Serializable {
    private static final Tar$Mode$ Mode;
    public static final Tar$ MODULE$;

    private Tar$() {
    }

    static {
        MODULE$ = new Tar$();
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(Tar$.class);
    }

    public void archive(File directory, File archive, boolean includeDirectoryName) {
        try (TarArchiveOutputStream tos = new TarArchiveOutputStream(new BufferedOutputStream(new FileOutputStream(archive)));){
            Tuple2 tuple2;
            if (!Files.isDirectory(directory.toPath(), new LinkOption[0])) {
                throw new IOException(directory.toString() + " is not a directory.");
            }
            Stack<Tuple2> toArchive = new Stack<Tuple2>();
            if (!includeDirectoryName) {
                File file = (File)Predef$.MODULE$.ArrowAssoc((Object)directory);
                tuple2 = toArchive.push(Predef.ArrowAssoc$.MODULE$.$u2192$extension((Object)file, (Object)""));
            } else {
                File file = (File)Predef$.MODULE$.ArrowAssoc((Object)directory);
                tuple2 = toArchive.push(Predef.ArrowAssoc$.MODULE$.$u2192$extension((Object)file, (Object)directory.getName()));
            }
            while (!toArchive.isEmpty()) {
                TarArchiveEntry tarArchiveEntry;
                Tuple2 tuple22 = (Tuple2)toArchive.pop();
                if (tuple22 == null) {
                    throw new MatchError((Object)tuple22);
                }
                File source = (File)tuple22._1();
                String entryName = (String)tuple22._2();
                Tuple2 tuple23 = Tuple2$.MODULE$.apply((Object)source, (Object)entryName);
                File source2 = (File)tuple23._1();
                String entryName2 = (String)tuple23._2();
                boolean isSymbolicLink = Files.isSymbolicLink(source2.toPath());
                boolean isDirectory = Files.isDirectory(source2.toPath(), new LinkOption[0]);
                if (isDirectory && !isSymbolicLink) {
                    try (DirectoryStream<Path> stream = Files.newDirectoryStream(source2.toPath());){
                        ((IterableOnceOps)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(stream).asScala()).foreach((Function1 & Serializable)f -> {
                            Path newSource = source2.toPath().resolve(f.getFileName());
                            String newEntryName = entryName2 + '/' + f.getFileName();
                            return toArchive.push(Tuple2$.MODULE$.apply((Object)newSource.toFile(), (Object)newEntryName));
                        });
                    }
                    tarArchiveEntry = new TarArchiveEntry(entryName2 + '/');
                } else if (isSymbolicLink) {
                    TarArchiveEntry e = new TarArchiveEntry(entryName2, 50);
                    e.setLinkName(Files.readSymbolicLink(source2.toPath()).toString());
                    tarArchiveEntry = e;
                } else {
                    TarArchiveEntry e = new TarArchiveEntry(entryName2);
                    e.setSize(Files.size(source2.toPath()));
                    tarArchiveEntry = e;
                }
                TarArchiveEntry e = tarArchiveEntry;
                File file = source2;
                File file2 = directory;
                if (!(file == null ? file2 != null : !((Object)file).equals(file2))) continue;
                if (!isSymbolicLink) {
                    int mode = this.posixPermissionsToMode$1(((IterableOnceOps)JavaConverters$.MODULE$.asScalaSetConverter(Files.getPosixFilePermissions(source2.toPath(), new LinkOption[0])).asScala()).toSet());
                    e.setMode(mode);
                }
                tos.putArchiveEntry(e);
                if (!Files.isRegularFile(source2.toPath(), LinkOption.NOFOLLOW_LINKS)) continue;
                try {
                    Files.copy(source2.toPath(), tos);
                }
                finally {
                    tos.closeArchiveEntry();
                }
            }
        }
    }

    public boolean archive$default$3() {
        return false;
    }

    public void extract(File archive, File directory, boolean overwrite, boolean compressed, Option<Function1<TarArchiveEntry, Object>> filter) {
        try (TarArchiveInputStream tis = !compressed ? new TarArchiveInputStream(new BufferedInputStream(new FileInputStream(archive))) : new TarArchiveInputStream(new BufferedInputStream(new GZIPInputStream(new FileInputStream(archive))));){
            LazyRef lazyRef = new LazyRef();
            LazyRef lazyRef2 = new LazyRef();
            if (!directory.exists()) {
                directory.mkdirs();
            }
            if (!Files.isDirectory(directory.toPath(), new LinkOption[0])) {
                throw new IOException(directory.toString() + " is not a directory.");
            }
            public class Container_tool_Tar$DirectoryMetaData$1
            implements Product,
            Serializable {
                private final Path path;
                private final int mode;
                private final long time;
                private final /* synthetic */ Tar$ $outer;

                public Container_tool_Tar$DirectoryMetaData$1(Tar$ $outer, Path path, int mode, long time) {
                    this.path = path;
                    this.mode = mode;
                    this.time = time;
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                }

                public int hashCode() {
                    int n = -889275714;
                    n = Statics.mix((int)n, (int)this.productPrefix().hashCode());
                    n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.path()));
                    n = Statics.mix((int)n, (int)this.mode());
                    n = Statics.mix((int)n, (int)Statics.longHash((long)this.time()));
                    return Statics.finalizeHash((int)n, (int)3);
                }

                /*
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                public boolean equals(Object x$0) {
                    if (this == x$0) return true;
                    Object object = x$0;
                    if (!(object instanceof Container_tool_Tar$DirectoryMetaData$1)) return false;
                    Container_tool_Tar$DirectoryMetaData$1 var3_3 = (Container_tool_Tar$DirectoryMetaData$1)object;
                    if (this.mode() != var3_3.mode()) return false;
                    if (this.time() != var3_3.time()) return false;
                    Path path = this.path();
                    Path path2 = var3_3.path();
                    if (path == null) {
                        if (path2 != null) {
                            return false;
                        }
                    } else if (!((Object)path).equals(path2)) return false;
                    if (!var3_3.canEqual(this)) return false;
                    return true;
                }

                public String toString() {
                    return ScalaRunTime$.MODULE$._toString((Product)this);
                }

                public boolean canEqual(Object that) {
                    return that instanceof Container_tool_Tar$DirectoryMetaData$1;
                }

                public int productArity() {
                    return 3;
                }

                public String productPrefix() {
                    return "DirectoryMetaData";
                }

                public Object productElement(int n) {
                    int n2 = n;
                    switch (n2) {
                        case 0: {
                            return this._1();
                        }
                        case 1: {
                            return BoxesRunTime.boxToInteger((int)this._2());
                        }
                        case 2: {
                            return BoxesRunTime.boxToLong((long)this._3());
                        }
                    }
                    throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
                }

                public String productElementName(int n) {
                    int n2 = n;
                    switch (n2) {
                        case 0: {
                            return "path";
                        }
                        case 1: {
                            return "mode";
                        }
                        case 2: {
                            return "time";
                        }
                    }
                    throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
                }

                public Path path() {
                    return this.path;
                }

                public int mode() {
                    return this.mode;
                }

                public long time() {
                    return this.time;
                }

                public Container_tool_Tar$DirectoryMetaData$1 copy(Path path, int mode, long time) {
                    return new Container_tool_Tar$DirectoryMetaData$1(Tar$.MODULE$, path, mode, time);
                }

                public Path copy$default$1() {
                    return this.path();
                }

                public int copy$default$2() {
                    return this.mode();
                }

                public long copy$default$3() {
                    return this.time();
                }

                public Path _1() {
                    return this.path();
                }

                public int _2() {
                    return this.mode();
                }

                public long _3() {
                    return this.time();
                }

                public final /* synthetic */ Tar$ container$tool$Tar$_$DirectoryMetaData$$$outer() {
                    return this.$outer;
                }
            }
            ListBuffer directoryData = (ListBuffer)ListBuffer$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Container_tool_Tar$DirectoryMetaData$1[0]));
            public class Container_tool_Tar$LinkData$1
            implements Product,
            Serializable {
                private final Path dest;
                private final String linkName;
                private final boolean hard;
                private final /* synthetic */ Tar$ $outer;

                public Container_tool_Tar$LinkData$1(Tar$ $outer, Path dest, String linkName, boolean hard) {
                    this.dest = dest;
                    this.linkName = linkName;
                    this.hard = hard;
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                }

                public int hashCode() {
                    int n = -889275714;
                    n = Statics.mix((int)n, (int)this.productPrefix().hashCode());
                    n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.dest()));
                    n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.linkName()));
                    n = Statics.mix((int)n, (int)(this.hard() ? 1231 : 1237));
                    return Statics.finalizeHash((int)n, (int)3);
                }

                /*
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                public boolean equals(Object x$0) {
                    if (this == x$0) return true;
                    Object object = x$0;
                    if (!(object instanceof Container_tool_Tar$LinkData$1)) return false;
                    Container_tool_Tar$LinkData$1 var3_3 = (Container_tool_Tar$LinkData$1)object;
                    if (this.hard() != var3_3.hard()) return false;
                    Path path = this.dest();
                    Path path2 = var3_3.dest();
                    if (path == null) {
                        if (path2 != null) {
                            return false;
                        }
                    } else if (!((Object)path).equals(path2)) return false;
                    String string = this.linkName();
                    String string2 = var3_3.linkName();
                    if (string == null) {
                        if (string2 != null) {
                            return false;
                        }
                    } else if (!string.equals(string2)) return false;
                    if (!var3_3.canEqual(this)) return false;
                    return true;
                }

                public String toString() {
                    return ScalaRunTime$.MODULE$._toString((Product)this);
                }

                public boolean canEqual(Object that) {
                    return that instanceof Container_tool_Tar$LinkData$1;
                }

                public int productArity() {
                    return 3;
                }

                public String productPrefix() {
                    return "LinkData";
                }

                public Object productElement(int n) {
                    int n2 = n;
                    switch (n2) {
                        case 0: {
                            return this._1();
                        }
                        case 1: {
                            return this._2();
                        }
                        case 2: {
                            return BoxesRunTime.boxToBoolean((boolean)this._3());
                        }
                    }
                    throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
                }

                public String productElementName(int n) {
                    int n2 = n;
                    switch (n2) {
                        case 0: {
                            return "dest";
                        }
                        case 1: {
                            return "linkName";
                        }
                        case 2: {
                            return "hard";
                        }
                    }
                    throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
                }

                public Path dest() {
                    return this.dest;
                }

                public String linkName() {
                    return this.linkName;
                }

                public boolean hard() {
                    return this.hard;
                }

                public Container_tool_Tar$LinkData$1 copy(Path dest, String linkName, boolean hard) {
                    return new Container_tool_Tar$LinkData$1(Tar$.MODULE$, dest, linkName, hard);
                }

                public Path copy$default$1() {
                    return this.dest();
                }

                public String copy$default$2() {
                    return this.linkName();
                }

                public boolean copy$default$3() {
                    return this.hard();
                }

                public Path _1() {
                    return this.dest();
                }

                public String _2() {
                    return this.linkName();
                }

                public boolean _3() {
                    return this.hard();
                }

                public final /* synthetic */ Tar$ container$tool$Tar$_$LinkData$$$outer() {
                    return this.$outer;
                }
            }
            ListBuffer linkData = (ListBuffer)ListBuffer$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Container_tool_Tar$LinkData$1[0]));
            package$.MODULE$.Iterator().continually(() -> this.extract$$anonfun$1(tis)).takeWhile((Function1 & Serializable)_$2 -> _$2 != null).filter((Function1 & Serializable)e -> this.filterValue$1((Option)filter, (TarArchiveEntry)e)).foreach((Function1 & Serializable)e -> {
                Object object;
                Path dest = Paths.get(directory.toString(), e.getName());
                if (e.isDirectory()) {
                    Files.createDirectories(dest, new FileAttribute[0]);
                    object = directoryData.$plus$eq((Object)this.DirectoryMetaData$2(lazyRef).apply(dest, e.getMode(), e.getModTime().getTime()));
                } else {
                    Files.createDirectories(dest.getParent(), new FileAttribute[0]);
                    if (StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(e.getLinkName()))) {
                        object = linkData.$plus$eq((Object)this.LinkData$2(lazyRef2).apply(dest, e.getLinkName(), e.isLink()));
                    } else {
                        Files.copy(tis, dest, (CopyOption[])((StandardCopyOption[])Arrays$.MODULE$.seqToArray((Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new StandardCopyOption[]{StandardCopyOption.REPLACE_EXISTING})).filter((Function1 & Serializable)_$3 -> overwrite), StandardCopyOption.class)));
                        object = this.setMode$1(dest, e.getMode());
                    }
                }
                return dest.toFile().setLastModified(e.getModTime().getTime());
            });
            linkData.foreach((Function1 & Serializable)l -> {
                Path path;
                if (!l.hard()) {
                    Path path2;
                    Path link = Paths.get(l.linkName(), new String[0]);
                    try {
                        path2 = Files.createSymbolicLink(l.dest(), link, new FileAttribute[0]);
                    }
                    catch (Throwable throwable) {
                        Throwable throwable2 = throwable;
                        if (throwable2 instanceof FileAlreadyExistsException) {
                            FileAlreadyExistsException e = (FileAlreadyExistsException)throwable2;
                            if (overwrite) {
                                l.dest().toFile().delete();
                                path2 = Files.createSymbolicLink(l.dest(), link, new FileAttribute[0]);
                            }
                        }
                        throw throwable;
                    }
                    return path2;
                }
                Path link = Paths.get(directory.toString(), l.linkName());
                try {
                    path = Files.createLink(l.dest(), link);
                }
                catch (Throwable throwable) {
                    Throwable throwable3 = throwable;
                    if (throwable3 instanceof FileAlreadyExistsException) {
                        FileAlreadyExistsException e = (FileAlreadyExistsException)throwable3;
                        if (overwrite) {
                            l.dest().toFile().delete();
                            path = Files.createLink(l.dest(), link);
                        }
                    }
                    throw throwable;
                }
                return path;
            });
            directoryData.foreach((Function1 & Serializable)r -> {
                this.setMode$1(r.path(), r.mode());
                return r.path().toFile().setLastModified(r.time());
            });
        }
    }

    public boolean extract$default$3() {
        return true;
    }

    public boolean extract$default$4() {
        return false;
    }

    public Option<Function1<TarArchiveEntry, Object>> extract$default$5() {
        return None$.MODULE$;
    }

    private final int posixPermissionsToMode$1(scala.collection.immutable.Set permissions) {
        int mode = 0;
        if (permissions.contains((Object)PosixFilePermission.OWNER_READ)) {
            mode |= 0x100;
        }
        if (permissions.contains((Object)PosixFilePermission.OWNER_WRITE)) {
            mode |= 0x80;
        }
        if (permissions.contains((Object)PosixFilePermission.OWNER_EXECUTE)) {
            mode |= 0x40;
        }
        if (permissions.contains((Object)PosixFilePermission.GROUP_READ)) {
            mode |= 0x20;
        }
        if (permissions.contains((Object)PosixFilePermission.GROUP_WRITE)) {
            mode |= 0x10;
        }
        if (permissions.contains((Object)PosixFilePermission.GROUP_EXECUTE)) {
            mode |= 8;
        }
        if (permissions.contains((Object)PosixFilePermission.OTHERS_READ)) {
            mode |= 4;
        }
        if (permissions.contains((Object)PosixFilePermission.OTHERS_WRITE)) {
            mode |= 2;
        }
        if (permissions.contains((Object)PosixFilePermission.OTHERS_EXECUTE)) {
            mode |= 1;
        }
        return mode;
    }

    private final Path setMode$1(Path file, int mode) {
        Set permissionSet = (Set)Set$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new PosixFilePermission[0]));
        if ((mode & 0x100) != 0) {
            permissionSet.$plus$eq((Object)PosixFilePermission.OWNER_READ);
        }
        if ((mode & 0x80) != 0) {
            permissionSet.$plus$eq((Object)PosixFilePermission.OWNER_WRITE);
        }
        if ((mode & 0x40) != 0) {
            permissionSet.$plus$eq((Object)PosixFilePermission.OWNER_EXECUTE);
        }
        if ((mode & 0x20) != 0) {
            permissionSet.$plus$eq((Object)PosixFilePermission.GROUP_READ);
        }
        if ((mode & 0x10) != 0) {
            permissionSet.$plus$eq((Object)PosixFilePermission.GROUP_WRITE);
        }
        if ((mode & 8) != 0) {
            permissionSet.$plus$eq((Object)PosixFilePermission.GROUP_EXECUTE);
        }
        if ((mode & 4) != 0) {
            permissionSet.$plus$eq((Object)PosixFilePermission.OTHERS_READ);
        }
        if ((mode & 2) != 0) {
            permissionSet.$plus$eq((Object)PosixFilePermission.OTHERS_WRITE);
        }
        if ((mode & 1) != 0) {
            permissionSet.$plus$eq((Object)PosixFilePermission.OTHERS_EXECUTE);
        }
        File f = file.toRealPath(new LinkOption[0]).toFile();
        return Files.setPosixFilePermissions(f.toPath(), CollectionConverters$.MODULE$.MutableSetHasAsJava(permissionSet).asJava());
    }

    private final Tar$DirectoryMetaData$3$ DirectoryMetaData$lzyINIT1$1(LazyRef DirectoryMetaData$lzy1$1) {
        Tar$DirectoryMetaData$3$ tar$DirectoryMetaData$3$;
        LazyRef lazyRef = DirectoryMetaData$lzy1$1;
        synchronized (lazyRef) {
            tar$DirectoryMetaData$3$ = (Tar$DirectoryMetaData$3$)(DirectoryMetaData$lzy1$1.initialized() ? DirectoryMetaData$lzy1$1.value() : DirectoryMetaData$lzy1$1.initialize((Object)new Tar$DirectoryMetaData$3$()));
        }
        return tar$DirectoryMetaData$3$;
    }

    private final Tar$DirectoryMetaData$3$ DirectoryMetaData$2(LazyRef DirectoryMetaData$lzy1$2) {
        return (Tar$DirectoryMetaData$3$)(DirectoryMetaData$lzy1$2.initialized() ? DirectoryMetaData$lzy1$2.value() : this.DirectoryMetaData$lzyINIT1$1(DirectoryMetaData$lzy1$2));
    }

    private final Tar$LinkData$3$ LinkData$lzyINIT1$1(LazyRef LinkData$lzy1$1) {
        Tar$LinkData$3$ tar$LinkData$3$;
        LazyRef lazyRef = LinkData$lzy1$1;
        synchronized (lazyRef) {
            tar$LinkData$3$ = (Tar$LinkData$3$)(LinkData$lzy1$1.initialized() ? LinkData$lzy1$1.value() : LinkData$lzy1$1.initialize((Object)new Tar$LinkData$3$()));
        }
        return tar$LinkData$3$;
    }

    private final Tar$LinkData$3$ LinkData$2(LazyRef LinkData$lzy1$2) {
        return (Tar$LinkData$3$)(LinkData$lzy1$2.initialized() ? LinkData$lzy1$2.value() : this.LinkData$lzyINIT1$1(LinkData$lzy1$2));
    }

    private final boolean filterValue$1$$anonfun$2() {
        return true;
    }

    private final boolean filterValue$1(Option filter$1, TarArchiveEntry e) {
        return BoxesRunTime.unboxToBoolean((Object)filter$1.map((Function1 & Serializable)_$1 -> BoxesRunTime.unboxToBoolean((Object)_$1.apply((Object)e))).getOrElse(this::filterValue$1$$anonfun$2));
    }

    private final TarArchiveEntry extract$$anonfun$1(TarArchiveInputStream tis$1) {
        return tis$1.getNextTarEntry();
    }
}

