/*
 * Decompiled with CFR 0.152.
 */
package org.openmole.core.db;

import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.security.NoTypePermission;
import java.io.File;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.DriverManager;
import org.h2.Driver;
import org.openmole.core.db.package;
import org.openmole.core.db.package$DBServerInfo$;
import org.openmole.core.db.package$Transactor$;
import org.openmole.tool.logger.JavaLogger;
import org.openmole.tool.logger.JavaLogger$Log$;
import scala.io.BufferedSource;
import scala.io.Codec$;
import scala.io.Source$;
import scala.runtime.LazyVals;
import scala.runtime.LazyVals$;
import scala.runtime.ModuleSerializationProxy;
import squants.time.Time;

public final class package$
implements JavaLogger,
Serializable {
    public static final long OFFSET$_m_1 = LazyVals$.MODULE$.getOffsetStatic(package$.class.getDeclaredField("Log$lzy1"));
    public static final long OFFSET$_m_0 = LazyVals$.MODULE$.getOffsetStatic(package$.class.getDeclaredField("xstream$lzy1"));
    private volatile Object Log$lzy1;
    public static final package$DBServerInfo$ DBServerInfo;
    public static final package$Transactor$ Transactor;
    private volatile Object xstream$lzy1;
    public static final package$ MODULE$;

    private package$() {
    }

    static {
        MODULE$ = new package$();
    }

    public final JavaLogger$Log$ Log() {
        Object object = this.Log$lzy1;
        if (object instanceof JavaLogger$Log$) {
            return (JavaLogger$Log$)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (JavaLogger$Log$)this.Log$lzyINIT1();
    }

    private Object Log$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.Log$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$_m_1, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    JavaLogger$Log$ javaLogger$Log$ = null;
                    try {
                        javaLogger$Log$ = new JavaLogger$Log$((JavaLogger)this);
                        object2 = javaLogger$Log$ == null ? LazyVals.NullValue$.MODULE$ : javaLogger$Log$;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$_m_1, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.Log$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$_m_1, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return javaLogger$Log$;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$_m_1, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(package$.class);
    }

    public int dbVersion() {
        return 3;
    }

    public String dbName() {
        return "replica-" + this.dbVersion();
    }

    public String dbInfoName() {
        return this.dbName() + ".info";
    }

    public File dbDirectory(File baseDirectory) {
        return org.openmole.tool.file.package$.MODULE$.FileDecorator(baseDirectory).$div("database");
    }

    public File dbFile(File dbDirectory) {
        return new File(dbDirectory, this.dbName());
    }

    public File dbInfoFile(File dbDirectory) {
        return new File(dbDirectory, this.dbInfoName());
    }

    public XStream xstream() {
        Object object = this.xstream$lzy1;
        if (object instanceof XStream) {
            return (XStream)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (XStream)this.xstream$lzyINIT1();
    }

    private Object xstream$lzyINIT1() {
        Object object;
        block7: {
            while (true) {
                if ((object = this.xstream$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$_m_0, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    XStream xStream = null;
                    try {
                        XStream xstream = new XStream();
                        xstream.addPermission(NoTypePermission.NONE);
                        xstream.allowTypesByWildcard(new String[]{"java.*", "org.openmole.core.*"});
                        xstream.setClassLoader(package.DBServerInfo.class.getClassLoader());
                        xstream.alias("DBServerInfo", package.DBServerInfo.class);
                        xStream = xstream;
                        object2 = xStream == null ? LazyVals.NullValue$.MODULE$ : xStream;
                    }
                    catch (Throwable throwable) {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$_m_0, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.xstream$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$_m_0, (Object)waiting, object2);
                            waiting.countDown();
                        }
                        throw throwable;
                    }
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$_m_0, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                        LazyVals.Waiting waiting = (LazyVals.Waiting)this.xstream$lzy1;
                        LazyVals$.MODULE$.objCAS((Object)this, OFFSET$_m_0, (Object)waiting, object2);
                        waiting.countDown();
                    }
                    return xStream;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block7;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$_m_0, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    public package.DBServerInfo load(File f) {
        package.DBServerInfo dBServerInfo;
        try (BufferedSource src = Source$.MODULE$.fromFile(f, Codec$.MODULE$.fallbackSystemCodec());){
            dBServerInfo = (package.DBServerInfo)this.xstream().fromXML(src.mkString());
        }
        return dBServerInfo;
    }

    public String jdbcH2Options() {
        return "AUTO_SERVER=TRUE;AUTO_RECONNECT=TRUE";
    }

    public package.Transactor.InsertionResult insert(package.Transactor transactor, String source, String storage, String path, String hash, long lastCheckExists) {
        return transactor.insert(source, storage, path, hash, lastCheckExists);
    }

    public package.Transactor memory() {
        DriverManager.registerDriver((java.sql.Driver)new Driver());
        Connection connection = DriverManager.getConnection("jdbc:h2:mem:replica");
        connection.setAutoCommit(false);
        package.Transactor transactor = new package.Transactor(connection);
        this.createDB(transactor);
        return transactor;
    }

    public boolean createDB(package.Transactor transactor) {
        return transactor.execute("\n      CREATE TABLE IF NOT EXISTS Replicas (\n        ID bigint auto_increment not null,\n        SOURCE VARCHAR(255),\n        STORAGE VARCHAR(255),\n        PATH VARCHAR(255),\n        HASH VARCHAR(64),\n        LAST_CHECK_EXISTS bigint,\n        PRIMARY KEY  (`ID`)\n      );\n      CREATE INDEX IF NOT EXISTS idx1 ON REPLICAS (SOURCE, HASH, STORAGE);\n      CREATE INDEX IF NOT EXISTS idx2 ON REPLICAS (PATH, STORAGE);\n      CREATE INDEX IF NOT EXISTS idx3 ON REPLICAS (HASH, STORAGE);\n      ");
    }

    public package.Transactor databaseServer(File baseDirectory, Time lockTimeout) {
        DriverManager.registerDriver((java.sql.Driver)new Driver());
        Connection connection = DriverManager.getConnection(this.urlDBPath$1(baseDirectory));
        connection.setAutoCommit(false);
        package.Transactor transactor = new package.Transactor(connection);
        transactor.execute("SET DEFAULT_LOCK_TIMEOUT " + lockTimeout.millis());
        this.createDB(transactor);
        return transactor;
    }

    private final File dbFile$1(File baseDirectory$1) {
        return org.openmole.tool.file.package$.MODULE$.FileDecorator(baseDirectory$1).$div(this.dbName());
    }

    private final String urlDBPath$1(File baseDirectory$2) {
        return "jdbc:h2:" + this.dbFile$1(baseDirectory$2) + ";" + this.jdbcH2Options() + ";";
    }
}

