/*
 * Decompiled with CFR 0.152.
 */
package cats.effect;

import cats.Show$;
import cats.effect.CpuStarvationCheckPlatform;
import cats.effect.IO;
import cats.effect.IO$;
import cats.effect.kernel.Async;
import cats.effect.metrics.CpuStarvationWarningMetrics;
import cats.effect.metrics.CpuStarvationWarningMetrics$;
import cats.effect.std.Console$;
import cats.effect.unsafe.IORuntimeConfig;
import cats.effect.unsafe.metrics.CpuStarvationSampler;
import cats.syntax.ApplicativeByNameOps$;
import cats.syntax.package$all$;
import java.io.Serializable;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.collection.StringOps$;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.FiniteDuration;
import scala.runtime.BoxedUnit;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.Nothing$;

public final class CpuStarvationCheck$
extends CpuStarvationCheckPlatform
implements Serializable {
    public static final CpuStarvationCheck$ MODULE$ = new CpuStarvationCheck$();

    private CpuStarvationCheck$() {
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(CpuStarvationCheck$.class);
    }

    public IO<Nothing$> run(IORuntimeConfig runtimeConfig, CpuStarvationSampler sampler, Function1<CpuStarvationWarningMetrics, IO<BoxedUnit>> onCpuStarvationWarn) {
        Duration threshold = runtimeConfig.cpuStarvationCheckInterval().$times(1.0 + runtimeConfig.cpuStarvationCheckThreshold());
        return IO$.MODULE$.monotonic().flatMap((Function1 & Serializable)_$1 -> this.go$1(runtimeConfig, sampler, (Function1)onCpuStarvationWarn, threshold, (FiniteDuration)_$1)).delayBy(runtimeConfig.cpuStarvationCheckInitialDelay());
    }

    public IO<BoxedUnit> logWarning(CpuStarvationWarningMetrics cpuStarvationWarningMetrics) {
        return (IO)Console$.MODULE$.make((Async)IO$.MODULE$.asyncForIO()).errorln(this.mkWarning(cpuStarvationWarningMetrics.starvationInterval().$times(cpuStarvationWarningMetrics.starvationThreshold()), cpuStarvationWarningMetrics.occurrenceTime()), Show$.MODULE$.catsShowForString());
    }

    private String mkWarning(Duration threshold, FiniteDuration when) {
        return StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(447).append("|").append(this.format(when)).append(" [WARNING] Your app's responsiveness to a new asynchronous\n        | event (such as a new connection, an upstream response, or a timer) was in excess\n        | of ").append(threshold).append(". Your CPU is probably starving. Consider increasing the\n        | granularity of your delays or adding more cedes. This may also be a sign that you\n        | are unintentionally running blocking I/O operations (such as File or InetAddress)\n        | without the blocking combinator.").toString())).replaceAll("\n", "");
    }

    private static final IO go$1$$anonfun$1$$anonfun$1$$anonfun$1$$anonfun$1$$anonfun$1(Function1 onCpuStarvationWarn$6, FiniteDuration fd$1, FiniteDuration delta$3, IORuntimeConfig runtimeConfig$6, CpuStarvationSampler sampler$6) {
        return ((IO)onCpuStarvationWarn$6.apply((Object)CpuStarvationWarningMetrics$.MODULE$.apply(fd$1, delta$3.$minus(runtimeConfig$6.cpuStarvationCheckInterval()), runtimeConfig$6.cpuStarvationCheckThreshold(), runtimeConfig$6.cpuStarvationCheckInterval()))).$times$greater(sampler$6.incCpuStarvationCount());
    }

    private static final IO go$1$$anonfun$1$$anonfun$1$$anonfun$1(Function1 onCpuStarvationWarn$4, FiniteDuration delta$1, IORuntimeConfig runtimeConfig$4, CpuStarvationSampler sampler$4, Duration threshold$4) {
        return IO$.MODULE$.realTime().flatMap((Function1 & Serializable)fd -> {
            Function0 function0 = package$all$.MODULE$.catsSyntaxApplicativeByName(() -> CpuStarvationCheck$.go$1$$anonfun$1$$anonfun$1$$anonfun$1$$anonfun$1$$anonfun$1(onCpuStarvationWarn$4, fd, delta$1, runtimeConfig$4, sampler$4));
            return (IO)ApplicativeByNameOps$.MODULE$.whenA$extension(function0, delta$1.$greater$eq((Object)threshold$4), IO$.MODULE$.asyncForIO());
        });
    }

    private final IO go$1$$anonfun$1$$anonfun$1$$anonfun$2(FiniteDuration now$1, IORuntimeConfig runtimeConfig$7, CpuStarvationSampler sampler$7, Function1 onCpuStarvationWarn$7, Duration threshold$6) {
        return this.go$1(runtimeConfig$7, sampler$7, onCpuStarvationWarn$7, threshold$6, now$1);
    }

    private final IO go$1$$anonfun$1(FiniteDuration initial$1, CpuStarvationSampler sampler$2, IORuntimeConfig runtimeConfig$2, Function1 onCpuStarvationWarn$2, Duration threshold$2) {
        return IO$.MODULE$.monotonic().flatMap((Function1 & Serializable)now -> {
            FiniteDuration delta = now.$minus(initial$1);
            return sampler$2.recordClockDrift(delta.$minus(runtimeConfig$2.cpuStarvationCheckInterval())).$greater$greater(() -> CpuStarvationCheck$.go$1$$anonfun$1$$anonfun$1$$anonfun$1(onCpuStarvationWarn$2, delta, runtimeConfig$2, sampler$2, threshold$2)).$greater$greater(() -> this.go$1$$anonfun$1$$anonfun$1$$anonfun$2(now, runtimeConfig$2, sampler$2, onCpuStarvationWarn$2, threshold$2));
        });
    }

    private final IO go$1(IORuntimeConfig runtimeConfig$1, CpuStarvationSampler sampler$1, Function1 onCpuStarvationWarn$1, Duration threshold$1, FiniteDuration initial) {
        return IO$.MODULE$.sleep(runtimeConfig$1.cpuStarvationCheckInterval()).$greater$greater(() -> this.go$1$$anonfun$1(initial, sampler$1, runtimeConfig$1, onCpuStarvationWarn$1, threshold$1));
    }
}

