/*
 * Decompiled with CFR 0.152.
 */
package cats.effect.unsafe;

import cats.effect.unsafe.StripedHashtable$;
import cats.effect.unsafe.ThreadSafeHashtable;
import scala.Function1;
import scala.runtime.BoxedUnit;

public final class StripedHashtable {
    private final int log2NumTables = StripedHashtable$.MODULE$.log2NumTables();
    private final int mask = this.numTables() - 1;
    private final ThreadSafeHashtable[] tables;

    /*
     * WARNING - void declaration
     */
    public StripedHashtable() {
        void var1_1;
        ThreadSafeHashtable[] array = new ThreadSafeHashtable[this.numTables()];
        for (int i = 0; i < this.numTables(); ++i) {
            array[i] = new ThreadSafeHashtable(this.initialCapacity());
        }
        this.tables = var1_1;
    }

    public int numTables() {
        return 1 << this.log2NumTables;
    }

    private int initialCapacity() {
        return 8;
    }

    public ThreadSafeHashtable<Function1<Throwable, BoxedUnit>>[] tables() {
        return this.tables;
    }

    public void put(Function1<Throwable, BoxedUnit> cb) {
        int hash2 = System.identityHashCode(cb);
        int idx = hash2 & this.mask;
        this.tables()[idx].put(cb, hash2 >> this.log2NumTables);
    }

    public void remove(Function1<Throwable, BoxedUnit> cb) {
        int hash2 = System.identityHashCode(cb);
        int idx = hash2 & this.mask;
        this.tables()[idx].remove(cb, hash2 >> this.log2NumTables);
    }
}

