/*
 * Decompiled with CFR 0.152.
 */
package org.openmole.tool.random;

import java.util.Random;
import org.apache.commons.math3.random.RandomGenerator;
import org.openmole.tool.cache.Lazy;
import org.openmole.tool.random.package$;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Vector;
import scala.math.BigDecimal;
import scala.math.BigDecimal$;
import scala.runtime.BoxedUnit;

public final class package {
    public static <T> IterableShuffleDecorator<T> IterableShuffleDecorator(Iterable<T> iterable) {
        return package$.MODULE$.IterableShuffleDecorator(iterable);
    }

    public static RandomDecorator RandomDecorator(scala.util.Random random) {
        return package$.MODULE$.RandomDecorator(random);
    }

    public static Lazy<scala.util.Random> emptyLazyRandom() {
        return package$.MODULE$.emptyLazyRandom();
    }

    public static BigDecimal longInterval() {
        return package$.MODULE$.longInterval();
    }

    public static <T> T multinomialDraw(Vector<Tuple2<Object, T>> vector, scala.util.Random random) {
        return package$.MODULE$.multinomialDraw(vector, random);
    }

    public static <T> Object shuffle(Object object, scala.util.Random random) {
        return package$.MODULE$.shuffle(object, random);
    }

    public static <T> IndexedSeq<T> shuffled(Iterable<T> iterable, scala.util.Random random) {
        return package$.MODULE$.shuffled(iterable, random);
    }

    public static class IterableShuffleDecorator<T> {
        private final Iterable<T> a;

        public IterableShuffleDecorator(Iterable<T> a) {
            this.a = a;
        }

        public Seq<T> shuffled(scala.util.Random rng) {
            return package$.MODULE$.shuffled(this.a, rng).toSeq();
        }
    }

    public static class RandomDecorator {
        private final scala.util.Random rng;

        public RandomDecorator(scala.util.Random rng) {
            this.rng = rng;
        }

        public <T> Object shuffle(Object a) {
            return package$.MODULE$.shuffle(a, this.rng);
        }

        public long nextLong(long max) {
            BigDecimal v = scala.package$.MODULE$.BigDecimal().apply(this.rng.nextLong());
            return v.$minus(BigDecimal$.MODULE$.long2bigDecimal(Long.MIN_VALUE)).$times(scala.package$.MODULE$.BigDecimal().apply(max).$div(package$.MODULE$.longInterval())).toLong();
        }
    }

    public static class SynchronizedRandom
    extends Random {
        private final RandomGenerator generator;
        private final boolean initialized;

        public SynchronizedRandom(RandomGenerator generator) {
            this.generator = generator;
            this.initialized = true;
        }

        public boolean initialized() {
            return this.initialized;
        }

        @Override
        public boolean nextBoolean() {
            boolean bl;
            SynchronizedRandom synchronizedRandom = this;
            synchronized (synchronizedRandom) {
                bl = this.generator.nextBoolean();
            }
            return bl;
        }

        @Override
        public void nextBytes(byte[] bytes) {
            SynchronizedRandom synchronizedRandom = this;
            synchronized (synchronizedRandom) {
                this.generator.nextBytes(bytes);
            }
        }

        @Override
        public double nextDouble() {
            double d;
            SynchronizedRandom synchronizedRandom = this;
            synchronized (synchronizedRandom) {
                d = this.generator.nextDouble();
            }
            return d;
        }

        @Override
        public float nextFloat() {
            float f;
            SynchronizedRandom synchronizedRandom = this;
            synchronized (synchronizedRandom) {
                f = this.generator.nextFloat();
            }
            return f;
        }

        @Override
        public double nextGaussian() {
            double d;
            SynchronizedRandom synchronizedRandom = this;
            synchronized (synchronizedRandom) {
                d = this.generator.nextGaussian();
            }
            return d;
        }

        @Override
        public int nextInt() {
            int n;
            SynchronizedRandom synchronizedRandom = this;
            synchronized (synchronizedRandom) {
                n = this.generator.nextInt();
            }
            return n;
        }

        @Override
        public int nextInt(int n) {
            int n2;
            SynchronizedRandom synchronizedRandom = this;
            synchronized (synchronizedRandom) {
                n2 = this.generator.nextInt(n);
            }
            return n2;
        }

        @Override
        public long nextLong() {
            long l;
            SynchronizedRandom synchronizedRandom = this;
            synchronized (synchronizedRandom) {
                l = this.generator.nextLong();
            }
            return l;
        }

        @Override
        public void setSeed(long seed) {
            SynchronizedRandom synchronizedRandom = this;
            synchronized (synchronizedRandom) {
                if (this.initialized()) {
                    this.generator.setSeed(seed);
                    v0 = BoxedUnit.UNIT;
                } else {
                    v0 = BoxedUnit.UNIT;
                }
            }
        }

        public scala.util.Random toScala() {
            return new scala.util.Random((Random)this);
        }
    }
}

