/*
 * Decompiled with CFR 0.152.
 */
package com.github.rjeschke.txtmark;

import com.github.rjeschke.txtmark.BlockEmitter;
import com.github.rjeschke.txtmark.Decorator;
import com.github.rjeschke.txtmark.DefaultDecorator;
import com.github.rjeschke.txtmark.SpanEmitter;

public class Configuration {
    final boolean safeMode;
    final boolean panicMode;
    final String encoding;
    final Decorator decorator;
    final BlockEmitter codeBlockEmitter;
    final boolean forceExtendedProfile;
    final boolean allowSpacesInFencedDelimiters;
    final SpanEmitter specialLinkEmitter;
    public static final Configuration DEFAULT = Configuration.builder().build();
    public static final Configuration DEFAULT_SAFE = Configuration.builder().enableSafeMode().build();

    Configuration(boolean bl, String string, Decorator decorator, BlockEmitter blockEmitter, boolean bl2, SpanEmitter spanEmitter, boolean bl3, boolean bl4) {
        this.safeMode = bl;
        this.encoding = string;
        this.decorator = decorator;
        this.codeBlockEmitter = blockEmitter;
        this.forceExtendedProfile = bl2;
        this.specialLinkEmitter = spanEmitter;
        this.allowSpacesInFencedDelimiters = bl3;
        this.panicMode = bl4;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private boolean safeMode = false;
        private boolean panicMode = false;
        private boolean forceExtendedProfile = false;
        private boolean allowSpacesInFencedDelimiters = true;
        private String encoding = "UTF-8";
        private Decorator decorator = new DefaultDecorator();
        private BlockEmitter codeBlockEmitter = null;
        private SpanEmitter specialLinkEmitter = null;

        Builder() {
        }

        public Builder enableSafeMode() {
            this.safeMode = true;
            return this;
        }

        public Builder forceExtentedProfile() {
            this.forceExtendedProfile = true;
            return this;
        }

        public Builder setSafeMode(boolean bl) {
            this.safeMode = bl;
            return this;
        }

        public Builder setEncoding(String string) {
            this.encoding = string;
            return this;
        }

        public Builder setDecorator(Decorator decorator) {
            this.decorator = decorator;
            return this;
        }

        public Builder setCodeBlockEmitter(BlockEmitter blockEmitter) {
            this.codeBlockEmitter = blockEmitter;
            return this;
        }

        public Builder setSpecialLinkEmitter(SpanEmitter spanEmitter) {
            this.specialLinkEmitter = spanEmitter;
            return this;
        }

        public Builder setAllowSpacesInFencedCodeBlockDelimiters(boolean bl) {
            this.allowSpacesInFencedDelimiters = bl;
            return this;
        }

        public Builder setEnablePanicMode(boolean bl) {
            this.panicMode = bl;
            return this;
        }

        public Builder enablePanicMode() {
            this.panicMode = true;
            return this;
        }

        public Configuration build() {
            return new Configuration(this.safeMode, this.encoding, this.decorator, this.codeBlockEmitter, this.forceExtendedProfile, this.specialLinkEmitter, this.allowSpacesInFencedDelimiters, this.panicMode);
        }
    }
}

