/*
 * Decompiled with CFR 0.152.
 */
package com.github.rjeschke.txtmark;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;

public class TableDef {
    protected int[] aligns = new int[4];
    protected int width = 0;
    protected int border = 0;
    public LinkedList<String> header;
    public List<LinkedList<String>> rows = new ArrayList<LinkedList<String>>();

    public static final int skipSpaces(String string, int n, int n2) {
        int n3;
        for (n3 = n; n3 < n2 && Character.isWhitespace(string.charAt(n3)); ++n3) {
        }
        return n3 >= n2 ? -1 : n3;
    }

    public static int skip(char c, String string, int n, int n2) {
        int n3;
        for (n3 = n; n3 < n2 && string.charAt(n3) == c; ++n3) {
        }
        return n3 >= n2 ? -1 : n3;
    }

    public static final int skipSpacesBackward(String string, int n, int n2) {
        int n3;
        for (n3 = n2 - 1; n3 >= n && Character.isWhitespace(string.charAt(n3)); --n3) {
        }
        return n3 < n ? -1 : n3;
    }

    public static TableDef parse(String string, String string2) {
        TableDef tableDef = TableDef.parseTableDividerLine(string2);
        if (tableDef != null) {
            tableDef.header = tableDef.parseRow(string);
            if (tableDef.header == null) {
                tableDef = null;
            }
        }
        return tableDef;
    }

    private static TableDef parseTableDividerLine(String string) {
        int n = string.length();
        int n2 = TableDef.skipSpaces(string, 0, n);
        if (n2 == -1) {
            return null;
        }
        int n3 = 0;
        char c = string.charAt(n2);
        if (c == '|') {
            n3 |= 1;
            ++n2;
        } else if (c != '-' && c != ':') {
            return null;
        }
        int n4 = TableDef.skipSpacesBackward(string, 0, n);
        c = string.charAt(n4);
        if (c == '|') {
            n3 |= 2;
            --n4;
        } else if (c != '-' && c != ':') {
            return null;
        }
        TableDef tableDef = TableDef.readTableDividerCols(string, n2, n4 + 1);
        if (tableDef != null) {
            tableDef.border = n3;
        }
        return tableDef;
    }

    private static TableDef readTableDividerCols(String string, int n, int n2) {
        TableDef tableDef = null;
        int n3 = 0;
        int n4 = n;
        while (true) {
            if ((n4 = TableDef.skipSpaces(string, n4, n2)) == -1) {
                return null;
            }
            char c = string.charAt(n4);
            if (c == ':') {
                n3 = 1;
                if ((n4 = TableDef.skipSpaces(string, n4 + 1, n2)) == -1) {
                    return null;
                }
                c = string.charAt(n4);
                if (c != '-') {
                    return null;
                }
            } else if (c == '-') {
                n3 = 0;
            } else {
                return null;
            }
            if ((n4 = TableDef.skip('-', string, n4 + 1, n2)) == -1 || (n4 = TableDef.skipSpaces(string, n4, n2)) == -1) break;
            c = string.charAt(n4);
            if (c == ':') {
                n3 |= 2;
                if ((n4 = TableDef.skipSpaces(string, n4 + 1, n2)) == -1) break;
                c = string.charAt(n4);
                if (c != '|') {
                    return null;
                }
            } else if (c != '|') {
                return null;
            }
            if (tableDef == null) {
                tableDef = new TableDef();
                tableDef.defineColumn(n3);
            } else {
                tableDef.defineColumn(n3);
            }
            ++n4;
        }
        if (tableDef == null) {
            return null;
        }
        tableDef.defineColumn(n3);
        return tableDef;
    }

    private static LinkedList<String> splitColumns(String string, char c) {
        if (string == null || string.length() == 0) {
            return null;
        }
        int n = 0;
        int n2 = string.indexOf(c, n);
        if (n2 == -1) {
            return null;
        }
        LinkedList<String> linkedList = new LinkedList<String>();
        do {
            String string2 = string.substring(n, n2).trim();
            linkedList.add(string2);
        } while ((n2 = string.indexOf(c, n = n2 + 1)) != -1);
        int n3 = string.length();
        if (n < n3) {
            String string3 = string.substring(n).trim();
            linkedList.add(string3);
        } else {
            linkedList.add("");
        }
        return linkedList;
    }

    public String getAlign(int n) {
        if (n >= this.width) {
            return null;
        }
        switch (this.aligns[n]) {
            case 0: {
                return null;
            }
            case 1: {
                return "left";
            }
            case 2: {
                return "right";
            }
            case 3: {
                return "center";
            }
        }
        return null;
    }

    private void defineColumn(int n) {
        int n2 = this.width + 1;
        if (n2 > this.aligns.length) {
            int[] nArray = new int[n2];
            System.arraycopy(this.aligns, 0, nArray, 0, this.width);
            nArray[this.width] = n;
            this.aligns = nArray;
            this.width = n2;
        } else {
            this.aligns[this.width++] = n;
        }
    }

    public boolean addRow(String string) {
        LinkedList<String> linkedList = this.parseRow(string);
        if (linkedList != null) {
            this.rows.add(linkedList);
            return true;
        }
        return false;
    }

    private LinkedList<String> parseRow(String string) {
        LinkedList<String> linkedList;
        block8: {
            int n;
            block7: {
                int n2;
                boolean bl;
                linkedList = TableDef.splitColumns(string, '|');
                if (linkedList == null || linkedList.size() < 2) {
                    return null;
                }
                boolean bl2 = (this.border & 1) != 0;
                boolean bl3 = bl = (this.border & 2) != 0;
                if (bl2 && linkedList.getFirst().isEmpty()) {
                    linkedList.removeFirst();
                } else if (bl2) {
                    return null;
                }
                if (bl && linkedList.getLast().isEmpty()) {
                    linkedList.removeLast();
                }
                if ((n = (n2 = this.width) - linkedList.size()) <= 0) break block7;
                while (n > 0) {
                    linkedList.addLast("&nbsp;");
                    --n;
                }
                break block8;
            }
            if (n >= 0) break block8;
            while (n < 0) {
                linkedList.removeLast();
                ++n;
            }
        }
        return linkedList;
    }
}

