/*
 * Decompiled with CFR 0.152.
 */
package miniclust.message;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.Serializable;
import java.net.URI;
import java.time.Duration;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import miniclust.message.MiniClust$Coordination$;
import miniclust.message.MiniClust$User$;
import miniclust.message.Minio;
import miniclust.message.Minio$Bucket$;
import miniclust.message.Minio$MinioObject$;
import miniclust.message.Minio$Server$;
import scala.;
import scala.$less$colon$less$;
import scala.Function1;
import scala.Int$;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Some$;
import scala.Tuple2;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.ListBuffer;
import scala.collection.mutable.ListBuffer$;
import scala.deriving.Mirror;
import scala.io.Codec$;
import scala.io.Source$;
import scala.jdk.CollectionConverters$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.ScalaRunTime$;
import scala.runtime.function.JProcedure1;
import scala.runtime.java8.JFunction1;
import scala.util.Try$;
import software.amazon.awssdk.auth.credentials.AwsBasicCredentials;
import software.amazon.awssdk.auth.credentials.StaticCredentialsProvider;
import software.amazon.awssdk.awscore.client.builder.AwsClientBuilder;
import software.amazon.awssdk.core.ResponseInputStream;
import software.amazon.awssdk.core.client.builder.SdkSyncClientBuilder;
import software.amazon.awssdk.core.client.config.ClientOverrideConfiguration;
import software.amazon.awssdk.core.retry.RetryPolicy;
import software.amazon.awssdk.core.sync.RequestBody;
import software.amazon.awssdk.http.HttpExecuteRequest;
import software.amazon.awssdk.http.HttpExecuteResponse;
import software.amazon.awssdk.http.SdkHttpClient;
import software.amazon.awssdk.http.SdkHttpConfigurationOption;
import software.amazon.awssdk.http.SdkHttpMethod;
import software.amazon.awssdk.http.SdkHttpRequest;
import software.amazon.awssdk.http.apache.ApacheHttpClient;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.s3.S3BaseClientBuilder;
import software.amazon.awssdk.services.s3.S3Client;
import software.amazon.awssdk.services.s3.model.BucketAlreadyOwnedByYouException;
import software.amazon.awssdk.services.s3.model.CreateBucketRequest;
import software.amazon.awssdk.services.s3.model.Delete;
import software.amazon.awssdk.services.s3.model.DeleteObjectsRequest;
import software.amazon.awssdk.services.s3.model.EncodingType;
import software.amazon.awssdk.services.s3.model.GetBucketTaggingRequest;
import software.amazon.awssdk.services.s3.model.GetBucketTaggingResponse;
import software.amazon.awssdk.services.s3.model.GetObjectRequest;
import software.amazon.awssdk.services.s3.model.GetObjectResponse;
import software.amazon.awssdk.services.s3.model.HeadObjectRequest;
import software.amazon.awssdk.services.s3.model.ListObjectsV2Request;
import software.amazon.awssdk.services.s3.model.ListObjectsV2Response;
import software.amazon.awssdk.services.s3.model.NoSuchKeyException;
import software.amazon.awssdk.services.s3.model.ObjectIdentifier;
import software.amazon.awssdk.services.s3.model.PutBucketTaggingRequest;
import software.amazon.awssdk.services.s3.model.PutObjectRequest;
import software.amazon.awssdk.services.s3.model.PutObjectResponse;
import software.amazon.awssdk.services.s3.model.S3Exception;
import software.amazon.awssdk.services.s3.model.Tag;
import software.amazon.awssdk.services.s3.model.Tagging;
import software.amazon.awssdk.utils.AttributeMap;

public final class Minio$
implements Mirror.Product,
Serializable {
    public static final Minio$Server$ Server;
    public static final Minio$Bucket$ Bucket;
    public static final Minio$MinioObject$ MinioObject;
    public static final Minio$ MODULE$;

    private Minio$() {
    }

    static {
        MODULE$ = new Minio$();
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(Minio$.class);
    }

    public Minio unapply(Minio x$1) {
        return x$1;
    }

    public String jsonContentType() {
        return "application/json";
    }

    public Minio apply(Minio.Server server) {
        return new Minio(server);
    }

    public <T> T withClient(Minio minio, Option<Object> timeout, Function1<S3Client, T> f) {
        Object object;
        int n = BoxesRunTime.unboxToInt((Object)timeout.getOrElse(() -> Minio$.$anonfun$1(minio)));
        String string = minio.server().copy$default$1();
        String string2 = minio.server().copy$default$2();
        String string3 = minio.server().copy$default$3();
        int n2 = minio.server().copy$default$5();
        boolean bl = minio.server().copy$default$6();
        try (S3Client c = this.client(minio.server().copy(string, string2, string3, n, n2, bl));){
            object = f.apply((Object)c);
        }
        return (T)object;
    }

    public <T> Option<Object> withClient$default$2() {
        return None$.MODULE$;
    }

    private void closeHttpClient(SdkHttpClient httpClient) {
        httpClient.close();
    }

    private SdkHttpClient httpClient(Minio.Server server) {
        ApacheHttpClient.Builder builder = ApacheHttpClient.builder().connectionAcquisitionTimeout(Duration.ofSeconds(Int$.MODULE$.int2long(server.timeout()))).connectionTimeout(Duration.ofSeconds(Int$.MODULE$.int2long(server.timeout()))).socketTimeout(Duration.ofSeconds(Int$.MODULE$.int2long(server.timeout())));
        if (server.insecure()) {
            AttributeMap attributes = AttributeMap.builder().put(SdkHttpConfigurationOption.TRUST_ALL_CERTIFICATES, Predef$.MODULE$.boolean2Boolean(true)).build();
            return builder.buildWithDefaults(attributes);
        }
        return builder.build();
    }

    private S3Client client(Minio.Server server) {
        SdkHttpClient c = this.httpClient(server);
        return (S3Client)((S3BaseClientBuilder)((SdkSyncClientBuilder)((AwsClientBuilder)S3Client.builder().endpointOverride(URI.create(server.url()))).region(Region.US_EAST_1).credentialsProvider(StaticCredentialsProvider.create(AwsBasicCredentials.create(server.user(), server.password())))).httpClient(c)).forcePathStyle(Predef$.MODULE$.boolean2Boolean(true)).overrideConfiguration((ClientOverrideConfiguration)ClientOverrideConfiguration.builder().retryPolicy(RetryPolicy.builder().numRetries(Predef$.MODULE$.int2Integer(server.retry())).build()).build()).build();
    }

    public Minio.Bucket bucket(Minio minio, String name, boolean create) {
        block2: {
            if (!create) break block2;
            try {
                this.withClient(minio, this.withClient$default$2(), (Function1 & Serializable)client -> client.createBucket((CreateBucketRequest)CreateBucketRequest.builder().bucket(name).build()));
            }
            catch (BucketAlreadyOwnedByYouException e) {}
        }
        return Minio$Bucket$.MODULE$.apply(name);
    }

    public boolean bucket$default$3() {
        return true;
    }

    public Minio.Bucket userBucket(Minio minio, String login, boolean create) {
        return (Minio.Bucket)this.withClient(minio, this.withClient$default$2(), (Function1 & Serializable)c -> {
            if (create) {
                Object object;
                try {
                    object = c.createBucket((CreateBucketRequest)CreateBucketRequest.builder().bucket(login).build());
                }
                catch (BucketAlreadyOwnedByYouException e) {
                    object = BoxedUnit.UNIT;
                }
                Tagging tagging = (Tagging)Tagging.builder().tagSet((Tag)Tag.builder().key((String)MiniClust$User$.MODULE$.submitBucketTag()._1()).value((String)MiniClust$User$.MODULE$.submitBucketTag()._2()).build()).build();
                c.putBucketTagging((PutBucketTaggingRequest)PutBucketTaggingRequest.builder().bucket(login).tagging(tagging).build());
            }
            return MODULE$.bucket(minio, login, false);
        });
    }

    public boolean userBucket$default$3() {
        return true;
    }

    public scala.collection.immutable.Seq<Minio.Bucket> listUserBuckets(Minio minio, Function1<Minio.Bucket, Object> ignore) {
        return (scala.collection.immutable.Seq)this.withClient(minio, this.withClient$default$2(), (Function1 & Serializable)c -> ((IterableOnceOps)((IterableOps)((IterableOps)CollectionConverters$.MODULE$.ListHasAsScala(c.listBuckets().buckets()).asScala().map((Function1 & Serializable)b -> Minio$Bucket$.MODULE$.apply(b.name()))).filterNot((Function1 & Serializable)b -> this.ignoreValue$1(ignore, (Minio.Bucket)b))).flatMap((Function1 & Serializable)bucket -> Try$.MODULE$.apply(() -> Minio$.listUserBuckets$$anonfun$1$$anonfun$3$$anonfun$1(c, bucket)).toOption().flatMap((Function1 & Serializable)t2 -> {
            if (((IterableOnceOps)CollectionConverters$.MODULE$.ListHasAsScala(t2.tagSet()).asScala().map((Function1 & Serializable)t -> {
                String string = (String)Predef$.MODULE$.ArrowAssoc((Object)t.key());
                return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)t.value());
            })).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl()).get(MiniClust$User$.MODULE$.submitBucketTag()._1()).contains(MiniClust$User$.MODULE$.submitBucketTag()._2())) {
                return Some$.MODULE$.apply(bucket);
            }
            return None$.MODULE$;
        }))).toSeq());
    }

    public Function1<Minio.Bucket, Object> listUserBuckets$default$2() {
        return (Function1 & Serializable)_$1 -> false;
    }

    public void delete(Minio minio, Minio.Bucket bucket, scala.collection.immutable.Seq<String> path) {
        this.withClient(minio, this.withClient$default$2(), (Function1 & Serializable)c -> {
            Delete delete = (Delete)Delete.builder().objects(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)path.map((Function1 & Serializable)p -> (ObjectIdentifier)ObjectIdentifier.builder().key((String)p).build())).asJava()).build();
            return c.deleteObjects((DeleteObjectsRequest)DeleteObjectsRequest.builder().bucket(bucket.name()).delete(delete).build());
        });
    }

    public void deleteRecursive(Minio minio, Minio.Bucket bucket, String path) {
        this.withClient(minio, this.withClient$default$2(), (Function1)(JProcedure1 & Serializable)c -> {
            ListObjectsV2Request listRequest = (ListObjectsV2Request)ListObjectsV2Request.builder().bucket(bucket.name()).prefix(path).build();
            boolean more = true;
            while (more) {
                Buffer keys;
                ListObjectsV2Response listedObjects = c.listObjectsV2(listRequest);
                if (!Predef$.MODULE$.Boolean2boolean(listedObjects.isTruncated())) {
                    more = false;
                }
                if (!(keys = (Buffer)CollectionConverters$.MODULE$.ListHasAsScala(listedObjects.contents()).asScala().map((Function1 & Serializable)_$2 -> _$2.key())).nonEmpty()) continue;
                Buffer objectIdentifiers = (Buffer)keys.map((Function1 & Serializable)k -> (ObjectIdentifier)ObjectIdentifier.builder().key((String)k).build());
                MODULE$.delete(minio, bucket, (scala.collection.immutable.Seq<String>)keys.toSeq());
            }
        });
    }

    public long download(Minio minio, Minio.Bucket bucket, String path, File local) {
        return BoxesRunTime.unboxToLong(this.withClient(minio, this.withClient$default$2(), (Function1 & Serializable)c -> {
            long l;
            try (ResponseInputStream<GetObjectResponse> stream = c.getObject((GetObjectRequest)GetObjectRequest.builder().bucket(bucket.name()).key(path).build());){
                local.getParentFile().mkdirs();
                try (FileOutputStream fos = new FileOutputStream(local);){
                    l = stream.transferTo(fos);
                }
            }
            catch (NoSuchKeyException e) {
                throw new FileNotFoundException(new StringBuilder(26).append("File ").append(path).append(" not found in bucket ").append(bucket.name()).toString());
            }
            return l;
        }));
    }

    public String content(Minio minio, Minio.Bucket bucket, String path) {
        return (String)this.withClient(minio, this.withClient$default$2(), (Function1 & Serializable)c -> {
            String string;
            try (ResponseInputStream<GetObjectResponse> stream = c.getObject((GetObjectRequest)GetObjectRequest.builder().bucket(bucket.name()).key(path).build());){
                string = Source$.MODULE$.fromInputStream(stream, Codec$.MODULE$.fallbackSystemCodec()).mkString();
            }
            catch (NoSuchKeyException e) {
                throw new FileNotFoundException(new StringBuilder(26).append("File ").append(path).append(" not found in bucket ").append(bucket.name()).toString());
            }
            return string;
        });
    }

    public boolean upload(Minio minio, Minio.Bucket bucket, Comparable local, String path, boolean overwrite, Option<String> contentType, Option<Object> timeout) {
        return BoxesRunTime.unboxToBoolean(this.withClient(minio, timeout, (Function1 & Serializable)c -> {
            boolean bl;
            PutObjectRequest.Builder builder;
            java.util.Map map;
            if (!overwrite) {
                Object[] objectArray = new Tuple2[1];
                String string = (String)Predef$.MODULE$.ArrowAssoc((Object)"If-None-Match");
                objectArray[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)"*");
                map = CollectionConverters$.MODULE$.MapHasAsJava((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray))).asJava();
            } else {
                map = CollectionConverters$.MODULE$.MapHasAsJava((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[0]))).asJava();
            }
            java.util.Map headers = map;
            PutObjectRequest.Builder b = PutObjectRequest.builder().bucket(bucket.name()).key(path);
            Option option = contentType;
            if (option instanceof Some) {
                String c2 = (String)((Some)option).value();
                builder = b.contentType(c2);
            } else if (None$.MODULE$.equals(option)) {
                builder = b;
            } else {
                throw new MatchError((Object)option);
            }
            PutObjectRequest.Builder b2 = builder;
            PutObjectRequest.Builder arg = overwrite ? b2 : b2.ifNoneMatch("*");
            try {
                PutObjectResponse putObjectResponse;
                Comparable comparable = local;
                if (comparable instanceof File) {
                    File local = (File)comparable;
                    putObjectResponse = c.putObject((PutObjectRequest)arg.build(), local.toPath());
                } else if (comparable instanceof String) {
                    String local = (String)((Object)comparable);
                    RequestBody requestBody = RequestBody.fromString(local);
                    contentType.foreach((Function1 & Serializable)x$0 -> arg.contentType((String)x$0));
                    putObjectResponse = c.putObject((PutObjectRequest)arg.build(), requestBody);
                } else {
                    throw new MatchError((Object)comparable);
                }
                bl = true;
            }
            catch (Throwable throwable) {
                S3Exception e;
                Throwable throwable2 = throwable;
                if (throwable2 instanceof S3Exception && (e = (S3Exception)throwable2).statusCode() == 412) {
                    bl = false;
                }
                throw throwable;
            }
            return bl;
        }));
    }

    public boolean upload$default$5() {
        return true;
    }

    public Option<String> upload$default$6() {
        return None$.MODULE$;
    }

    public Option<Object> upload$default$7() {
        return None$.MODULE$;
    }

    public void listAndApply(Minio minio, Minio.Bucket bucket, String prefix, boolean recursive, boolean addSlash, boolean listCommonPrefix, Option<Object> maxKeys, Option<Object> maxList, Option<String> startAfter, Function1<Minio.MinioObject, BoxedUnit> f) {
        this.withClient(minio, this.withClient$default$2(), (Function1)(JProcedure1 & Serializable)c2 -> {
            String p = addSlash && !prefix.endsWith("/") ? new StringBuilder(1).append(prefix).append("/").toString() : prefix;
            ListObjectsV2Request.Builder listRequest = !recursive ? this.r3$1(startAfter, maxKeys, bucket, p).delimiter("/") : this.r3$1(startAfter, maxKeys, bucket, p);
            None$ continuationToken = None$.MODULE$;
            boolean more = true;
            IntRef total = IntRef.create((int)0);
            while (more) {
                ListObjectsV2Response listObjectsV2Response;
                None$ none$ = continuationToken;
                if (none$ instanceof Some) {
                    String k = (String)((Some)none$).value();
                    listObjectsV2Response = c2.listObjectsV2((ListObjectsV2Request)listRequest.continuationToken(k).build());
                } else if (None$.MODULE$.equals(none$)) {
                    listObjectsV2Response = c2.listObjectsV2((ListObjectsV2Request)listRequest.build());
                } else {
                    throw new MatchError((Object)none$);
                }
                ListObjectsV2Response listedObjects = listObjectsV2Response;
                CollectionConverters$.MODULE$.ListHasAsScala(listedObjects.contents()).asScala().foreach((Function1)(JProcedure1 & Serializable)c -> {
                    if (!this.isFull$1(maxList, total)) {
                        ++total$3.elem;
                        f.apply((Object)Minio$MinioObject$.MODULE$.apply(c.key(), c.key().endsWith("/"), (Option<Object>)Option$.MODULE$.apply((Object)c.lastModified()).map((Function1 & Serializable)_$3 -> _$3.getEpochSecond())));
                        return;
                    }
                });
                if (listCommonPrefix) {
                    CollectionConverters$.MODULE$.ListHasAsScala(listedObjects.commonPrefixes()).asScala().foreach((Function1)(JProcedure1 & Serializable)c -> f.apply((Object)Minio$MinioObject$.MODULE$.apply(c.prefix(), true, (Option<Object>)None$.MODULE$)));
                }
                continuationToken = Some$.MODULE$.apply((Object)listedObjects.nextContinuationToken());
                if (Predef$.MODULE$.Boolean2boolean(listedObjects.isTruncated()) && !this.isFull$1(maxList, total)) continue;
                more = false;
            }
        });
    }

    public boolean listAndApply$default$4() {
        return false;
    }

    public boolean listAndApply$default$5() {
        return false;
    }

    public boolean listAndApply$default$6() {
        return false;
    }

    public Option<Object> listAndApply$default$7() {
        return Some$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)100));
    }

    public Option<Object> listAndApply$default$8() {
        return None$.MODULE$;
    }

    public Option<String> listAndApply$default$9() {
        return None$.MODULE$;
    }

    public scala.collection.immutable.Seq<Minio.MinioObject> listObjects(Minio minio, Minio.Bucket bucket, String prefix, boolean recursive, boolean addSlash, boolean listCommonPrefix, Option<Object> maxList) {
        ListBuffer response = (ListBuffer)ListBuffer$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Minio.MinioObject[0]));
        this.listAndApply(minio, bucket, prefix, recursive, addSlash, listCommonPrefix, this.listAndApply$default$7(), maxList, this.listAndApply$default$9(), (Function1<Minio.MinioObject, BoxedUnit>)(JProcedure1 & Serializable)c -> response.addOne(c));
        return response.toSeq();
    }

    public boolean listObjects$default$4() {
        return false;
    }

    public boolean listObjects$default$5() {
        return false;
    }

    public boolean listObjects$default$6() {
        return false;
    }

    public Option<Object> listObjects$default$7() {
        return None$.MODULE$;
    }

    public boolean exists(Minio minio, Minio.Bucket bucket, String prefix) {
        return BoxesRunTime.unboxToBoolean(this.withClient(minio, this.withClient$default$2(), (Function1 & Serializable)c -> {
            boolean bl;
            try {
                c.headObject((HeadObjectRequest)HeadObjectRequest.builder().bucket(bucket.name()).key(prefix).build());
                bl = true;
            }
            catch (NoSuchKeyException e) {
                bl = false;
            }
            return bl;
        }));
    }

    public long date(Minio minio) {
        long l;
        SdkHttpRequest httpRequest = (SdkHttpRequest)SdkHttpRequest.builder().uri(URI.create(minio.server().url())).method(SdkHttpMethod.HEAD).build();
        SdkHttpClient client = this.httpClient(minio.server());
        try {
            HttpExecuteResponse response = client.prepareRequest(HttpExecuteRequest.builder().request(httpRequest).build()).call();
            String dateHeader = (String)CollectionConverters$.MODULE$.ListHasAsScala(response.httpResponse().headers().get("Date")).asScala().head();
            DateTimeFormatter formatter = DateTimeFormatter.RFC_1123_DATE_TIME;
            l = ZonedDateTime.parse(dateHeader, formatter).toEpochSecond();
        }
        finally {
            this.closeHttpClient(client);
        }
        return l;
    }

    public Minio fromProduct(Product x$0) {
        Minio.Server server = (Minio.Server)x$0.productElement(0);
        return new Minio(server);
    }

    private static final int $anonfun$1(Minio minio$1) {
        return minio$1.server().timeout();
    }

    private final boolean ignoreValue$1(Function1 ignore$1, Minio.Bucket b) {
        String string = b.name();
        String string2 = MiniClust$Coordination$.MODULE$.bucketName();
        return !(string == null ? string2 != null : !string.equals(string2)) || BoxesRunTime.unboxToBoolean((Object)ignore$1.apply((Object)b));
    }

    private static final GetBucketTaggingResponse listUserBuckets$$anonfun$1$$anonfun$3$$anonfun$1(S3Client c$2, Minio.Bucket bucket$1) {
        return c$2.getBucketTagging((GetBucketTaggingRequest)GetBucketTaggingRequest.builder().bucket(bucket$1.name()).build());
    }

    private final ListObjectsV2Request.Builder r$1(Minio.Bucket bucket$9, String p$1) {
        return ListObjectsV2Request.builder().bucket(bucket$9.name()).fetchOwner(Predef$.MODULE$.boolean2Boolean(false)).encodingType(EncodingType.URL).prefix(p$1);
    }

    private final ListObjectsV2Request.Builder r2$1(Option maxKeys$2, Minio.Bucket bucket$10, String p$2) {
        Option option = maxKeys$2;
        if (option instanceof Some) {
            int k = BoxesRunTime.unboxToInt((Object)((Some)option).value());
            return this.r$1(bucket$10, p$2).maxKeys(Predef$.MODULE$.int2Integer(k));
        }
        if (None$.MODULE$.equals(option)) {
            return this.r$1(bucket$10, p$2);
        }
        throw new MatchError((Object)option);
    }

    private final ListObjectsV2Request.Builder r3$1(Option startAfter$2, Option maxKeys$3, Minio.Bucket bucket$11, String p$3) {
        Option option = startAfter$2;
        if (option instanceof Some) {
            String s = (String)((Some)option).value();
            return this.r2$1(maxKeys$3, bucket$11, p$3).startAfter(s);
        }
        if (None$.MODULE$.equals(option)) {
            return this.r2$1(maxKeys$3, bucket$11, p$3);
        }
        throw new MatchError((Object)option);
    }

    private final boolean isFull$1(Option maxList$2, IntRef total$1) {
        return maxList$2.exists((Function1)(JFunction1.mcZI.sp & Serializable)l -> total$2.elem >= l);
    }
}

