/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.checksums.internal;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public final class CrcCombineChecksumUtil {
    public static final int CRC_SIZE = 32;

    private CrcCombineChecksumUtil() {
    }

    public static long[][] generateCombineMatrices(long polynomial) {
        long[][] combineMatrices = new long[32][32];
        CrcCombineChecksumUtil.initializeFirstMatrix(combineMatrices, polynomial);
        CrcCombineChecksumUtil.deriveRemainingMatrices(combineMatrices);
        return combineMatrices;
    }

    public static long combine(long crc1, long crc2, long originalLengthOfCrc2, long[][] combineMatrices) {
        Validate.isNotNegative(originalLengthOfCrc2, "The length of the original data for the second CRC value must be positive.");
        if (originalLengthOfCrc2 == 0L) {
            return crc1;
        }
        int matrixIndex = 2;
        while (originalLengthOfCrc2 != 0L) {
            ++matrixIndex;
            if ((originalLengthOfCrc2 & 1L) != 0L) {
                crc1 = CrcCombineChecksumUtil.gf2MatrixTimes(combineMatrices[matrixIndex], crc1);
            }
            originalLengthOfCrc2 >>= 1;
        }
        return crc1 ^= crc2;
    }

    private static long gf2MatrixTimes(long[] matrix, long vector) {
        long sum = 0L;
        for (long l : matrix) {
            if (vector == 0L) break;
            if ((vector & 1L) != 0L) {
                sum ^= l;
            }
            vector >>= 1;
        }
        return sum;
    }

    private static void initializeFirstMatrix(long[][] combineMatrices, long polynomial) {
        combineMatrices[0][0] = polynomial;
        long row = 1L;
        for (int i = 1; i < 32; ++i) {
            combineMatrices[0][i] = row;
            row <<= 1;
        }
    }

    private static void deriveRemainingMatrices(long[][] combineMatrices) {
        for (int i = 0; i < 31; ++i) {
            for (int j = 0; j < 32; ++j) {
                combineMatrices[i + 1][j] = CrcCombineChecksumUtil.gf2MatrixTimes(combineMatrices[i], combineMatrices[i][j]);
            }
        }
    }
}

