/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.core.client.config;

import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Supplier;
import software.amazon.awssdk.annotations.SdkProtectedApi;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.ClientOverrideConfiguration;
import software.amazon.awssdk.core.client.config.SdkAdvancedClientOption;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.core.signer.Signer;
import software.amazon.awssdk.utils.AttributeMap;
import software.amazon.awssdk.utils.SdkAutoCloseable;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

@SdkProtectedApi
public final class SdkClientConfiguration
implements ToCopyableBuilder<Builder, SdkClientConfiguration>,
SdkAutoCloseable {
    private final AttributeMap attributes;

    private SdkClientConfiguration(AttributeMap attributes) {
        this.attributes = attributes;
    }

    public static Builder builder() {
        return new Builder(AttributeMap.builder());
    }

    public static SdkClientConfiguration fromOverrideConfiguration(ClientOverrideConfiguration configuration) {
        SdkClientConfiguration result = configuration.asSdkClientConfiguration();
        Signer signerFromOverride = result.option(SdkAdvancedClientOption.SIGNER);
        if (signerFromOverride == null) {
            return result;
        }
        return result.toBuilder().option(SdkClientOption.SIGNER_OVERRIDDEN, true).build();
    }

    public <T> T option(ClientOption<T> option) {
        return this.attributes.get(option);
    }

    public ClientOverrideConfiguration asOverrideConfiguration() {
        return new ClientOverrideConfiguration.DefaultBuilder(this.toBuilder()).build();
    }

    public SdkClientConfiguration merge(SdkClientConfiguration configuration) {
        return new SdkClientConfiguration(this.attributes.merge(configuration.attributes));
    }

    public SdkClientConfiguration merge(Consumer<Builder> configuration) {
        return this.merge(SdkClientConfiguration.builder().applyMutation(configuration).build());
    }

    public String toString() {
        return ToString.builder("SdkClientConfiguration").add("attributes", this.attributes).build();
    }

    @Override
    public Builder toBuilder() {
        return new Builder(this.attributes.toBuilder());
    }

    @Override
    public void close() {
        this.attributes.close();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SdkClientConfiguration that = (SdkClientConfiguration)o;
        return this.attributes.equals(that.attributes);
    }

    public int hashCode() {
        return this.attributes.hashCode();
    }

    public static final class Builder
    implements CopyableBuilder<Builder, SdkClientConfiguration> {
        private final AttributeMap.Builder attributes;

        private Builder(AttributeMap.Builder attributes) {
            this.attributes = attributes;
        }

        public ClientOverrideConfiguration.Builder asOverrideConfigurationBuilder() {
            return new ClientOverrideConfiguration.DefaultBuilder(this);
        }

        public <T> Builder option(ClientOption<T> option, T value) {
            this.attributes.put(option, value);
            return this;
        }

        public <T> Builder lazyOption(ClientOption<T> option, AttributeMap.LazyValue<T> lazyValue) {
            this.attributes.putLazy(option, lazyValue);
            return this;
        }

        public <T> Builder lazyOptionIfAbsent(ClientOption<T> option, AttributeMap.LazyValue<T> lazyValue) {
            this.attributes.putLazyIfAbsent(option, lazyValue);
            return this;
        }

        public <T> T option(ClientOption<T> option) {
            return this.attributes.get(option);
        }

        public <T> T computeOptionIfAbsent(ClientOption<T> option, Supplier<T> valueSupplier) {
            return this.attributes.computeIfAbsent(option, valueSupplier);
        }

        public Builder putAll(Map<? extends ClientOption<?>, ?> options) {
            this.attributes.putAll(options);
            return this;
        }

        public Builder putAll(ClientOverrideConfiguration configuration) {
            this.attributes.putAll(SdkClientConfiguration.fromOverrideConfiguration(configuration).attributes);
            return this;
        }

        @Override
        public Builder copy() {
            return new Builder(this.attributes.copy());
        }

        @Override
        public SdkClientConfiguration build() {
            return new SdkClientConfiguration(this.attributes.build());
        }
    }
}

