/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.core.internal.async;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.annotations.SdkTestInternalApi;
import software.amazon.awssdk.core.async.AsyncRequestBody;
import software.amazon.awssdk.core.exception.NonRetryableException;
import software.amazon.awssdk.core.internal.util.NoopSubscription;
import software.amazon.awssdk.utils.Logger;
import software.amazon.awssdk.utils.SdkAutoCloseable;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public final class ByteBuffersAsyncRequestBody
implements AsyncRequestBody,
SdkAutoCloseable {
    private static final Logger log = Logger.loggerFor(ByteBuffersAsyncRequestBody.class);
    private final String mimetype;
    private final Long length;
    private List<ByteBuffer> buffers;
    private final Set<ReplayableByteBufferSubscription> subscriptions;
    private final Object lock = new Object();
    private boolean closed;

    private ByteBuffersAsyncRequestBody(String mimetype, Long length, List<ByteBuffer> buffers) {
        this.mimetype = mimetype;
        this.buffers = buffers;
        this.length = length;
        this.subscriptions = ConcurrentHashMap.newKeySet();
    }

    @Override
    public Optional<Long> contentLength() {
        return Optional.ofNullable(this.length);
    }

    @Override
    public String contentType() {
        return this.mimetype;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void subscribe(Subscriber<? super ByteBuffer> subscriber) {
        Validate.paramNotNull(subscriber, "subscriber");
        Object object = this.lock;
        synchronized (object) {
            if (this.closed) {
                subscriber.onSubscribe(new NoopSubscription(subscriber));
                subscriber.onError(NonRetryableException.create("AsyncRequestBody has been closed"));
                return;
            }
        }
        try {
            ReplayableByteBufferSubscription replayableByteBufferSubscription = new ReplayableByteBufferSubscription(subscriber);
            subscriber.onSubscribe(replayableByteBufferSubscription);
            this.subscriptions.add(replayableByteBufferSubscription);
        }
        catch (Throwable ex) {
            log.error(() -> subscriber + " violated the Reactive Streams rule 2.13 by throwing an exception from onSubscribe.", ex);
        }
    }

    @Override
    public String body() {
        return AsyncRequestBody.BodyType.BYTES.getName();
    }

    public static ByteBuffersAsyncRequestBody of(List<ByteBuffer> buffers, long length) {
        return new ByteBuffersAsyncRequestBody("application/octet-stream", length, buffers);
    }

    public static ByteBuffersAsyncRequestBody of(List<ByteBuffer> buffers) {
        long length = buffers.stream().mapToLong(Buffer::remaining).sum();
        return new ByteBuffersAsyncRequestBody("application/octet-stream", length, buffers);
    }

    public static ByteBuffersAsyncRequestBody of(ByteBuffer ... buffers) {
        List<ByteBuffer> byteBuffers = Arrays.asList(buffers);
        long length = byteBuffers.stream().mapToLong(Buffer::remaining).sum();
        return ByteBuffersAsyncRequestBody.of(byteBuffers, length);
    }

    public static ByteBuffersAsyncRequestBody of(Long length, ByteBuffer ... buffers) {
        return new ByteBuffersAsyncRequestBody("application/octet-stream", length, Arrays.asList(buffers));
    }

    public static ByteBuffersAsyncRequestBody of(String mimetype, ByteBuffer ... buffers) {
        long length = Arrays.stream(buffers).mapToLong(Buffer::remaining).sum();
        return new ByteBuffersAsyncRequestBody(mimetype, length, Arrays.asList(buffers));
    }

    public static ByteBuffersAsyncRequestBody of(String mimetype, Long length, ByteBuffer ... buffers) {
        return new ByteBuffersAsyncRequestBody(mimetype, length, Arrays.asList(buffers));
    }

    public static ByteBuffersAsyncRequestBody from(byte[] bytes) {
        return new ByteBuffersAsyncRequestBody("application/octet-stream", Long.valueOf(bytes.length), Collections.singletonList(ByteBuffer.wrap(bytes)));
    }

    public static ByteBuffersAsyncRequestBody from(String mimetype, byte[] bytes) {
        return new ByteBuffersAsyncRequestBody(mimetype, Long.valueOf(bytes.length), Collections.singletonList(ByteBuffer.wrap(bytes)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        Object object = this.lock;
        synchronized (object) {
            if (this.closed) {
                return;
            }
            this.closed = true;
            this.buffers = new ArrayList<ByteBuffer>();
            this.subscriptions.forEach(s -> s.notifyError(new IllegalStateException("The publisher has been closed")));
            this.subscriptions.clear();
        }
    }

    @SdkTestInternalApi
    public List<ByteBuffer> bufferedData() {
        return this.buffers;
    }

    private class ReplayableByteBufferSubscription
    implements Subscription {
        private final AtomicInteger index = new AtomicInteger(0);
        private volatile boolean done;
        private final AtomicBoolean processingRequest = new AtomicBoolean(false);
        private Subscriber<? super ByteBuffer> currentSubscriber;
        private final AtomicLong outstandingDemand = new AtomicLong();

        private ReplayableByteBufferSubscription(Subscriber<? super ByteBuffer> subscriber) {
            this.currentSubscriber = subscriber;
        }

        @Override
        public void request(long n) {
            if (n <= 0L) {
                this.currentSubscriber.onError(new IllegalArgumentException("\u00a73.9: non-positive requests are not allowed!"));
                this.currentSubscriber = null;
                return;
            }
            if (this.done) {
                return;
            }
            if (ByteBuffersAsyncRequestBody.this.buffers.size() == 0) {
                this.currentSubscriber.onComplete();
                this.done = true;
                ByteBuffersAsyncRequestBody.this.subscriptions.remove(this);
                return;
            }
            this.outstandingDemand.updateAndGet(current -> {
                if (Long.MAX_VALUE - current < n) {
                    return Long.MAX_VALUE;
                }
                return current + n;
            });
            this.processRequest();
        }

        private void processRequest() {
            do {
                if (!this.processingRequest.compareAndSet(false, true)) {
                    return;
                }
                try {
                    this.doProcessRequest();
                }
                catch (Throwable e) {
                    this.notifyError(new IllegalStateException("Encountered fatal error in publisher", e));
                    ByteBuffersAsyncRequestBody.this.subscriptions.remove(this);
                    break;
                }
                finally {
                    this.processingRequest.set(false);
                }
            } while (this.shouldProcessRequest());
        }

        private boolean shouldProcessRequest() {
            return !this.done && this.outstandingDemand.get() > 0L && this.index.get() < ByteBuffersAsyncRequestBody.this.buffers.size();
        }

        private void doProcessRequest() {
            int currentIndex;
            do {
                if (!this.shouldProcessRequest()) {
                    return;
                }
                currentIndex = this.index.getAndIncrement();
                if (currentIndex >= ByteBuffersAsyncRequestBody.this.buffers.size()) {
                    this.notifyError(new IllegalStateException("Index out of bounds"));
                    ByteBuffersAsyncRequestBody.this.subscriptions.remove(this);
                    return;
                }
                ByteBuffer buffer = (ByteBuffer)ByteBuffersAsyncRequestBody.this.buffers.get(currentIndex);
                this.currentSubscriber.onNext(buffer.asReadOnlyBuffer());
                this.outstandingDemand.decrementAndGet();
            } while (currentIndex != ByteBuffersAsyncRequestBody.this.buffers.size() - 1);
            this.done = true;
            this.currentSubscriber.onComplete();
            ByteBuffersAsyncRequestBody.this.subscriptions.remove(this);
        }

        @Override
        public void cancel() {
            this.done = true;
            ByteBuffersAsyncRequestBody.this.subscriptions.remove(this);
        }

        public void notifyError(Exception exception) {
            if (this.currentSubscriber != null) {
                this.done = true;
                this.currentSubscriber.onError(exception);
                this.currentSubscriber = null;
            }
        }
    }
}

