/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.core.internal.metrics;

import java.nio.ByteBuffer;
import java.util.concurrent.atomic.AtomicLong;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.annotations.SdkInternalApi;

@SdkInternalApi
public final class BytesReadTrackingPublisher
implements Publisher<ByteBuffer> {
    private final Publisher<ByteBuffer> upstream;
    private final AtomicLong bytesRead;

    public BytesReadTrackingPublisher(Publisher<ByteBuffer> upstream, AtomicLong bytesRead) {
        this.upstream = upstream;
        this.bytesRead = bytesRead;
    }

    @Override
    public void subscribe(Subscriber<? super ByteBuffer> subscriber) {
        this.upstream.subscribe(new BytesReadTracker(subscriber, this.bytesRead));
    }

    public long bytesRead() {
        return this.bytesRead.get();
    }

    private static final class BytesReadTracker
    implements Subscriber<ByteBuffer> {
        private final Subscriber<? super ByteBuffer> downstream;
        private final AtomicLong bytesRead;

        private BytesReadTracker(Subscriber<? super ByteBuffer> downstream, AtomicLong bytesRead) {
            this.downstream = downstream;
            this.bytesRead = bytesRead;
        }

        @Override
        public void onSubscribe(Subscription subscription) {
            this.downstream.onSubscribe(subscription);
        }

        @Override
        public void onNext(ByteBuffer byteBuffer) {
            this.bytesRead.addAndGet(byteBuffer.remaining());
            this.downstream.onNext(byteBuffer);
        }

        @Override
        public void onError(Throwable throwable) {
            this.downstream.onError(throwable);
        }

        @Override
        public void onComplete() {
            this.downstream.onComplete();
        }
    }
}

