/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.retries.internal;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.retries.api.RetryToken;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.Validate;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

@SdkInternalApi
public final class DefaultRetryToken
implements RetryToken,
ToCopyableBuilder<Builder, DefaultRetryToken> {
    private final String scope;
    private final TokenState state;
    private final int attempt;
    private final int capacityAcquired;
    private final int capacityRemaining;
    private final List<Throwable> failures;

    private DefaultRetryToken(Builder builder) {
        this.scope = Validate.paramNotNull(builder.scope, "scope");
        this.state = Validate.paramNotNull(builder.state, "status");
        this.attempt = Validate.isPositive(builder.attempt, "attempt");
        this.capacityAcquired = Validate.isNotNegative(builder.capacityAcquired, "capacityAcquired");
        this.capacityRemaining = Validate.isNotNegative(builder.capacityRemaining, "capacityRemaining");
        this.failures = Collections.unmodifiableList(Validate.paramNotNull(builder.failures, "failures"));
    }

    public int attempt() {
        return this.attempt;
    }

    public String scope() {
        return this.scope;
    }

    public int capacityAcquired() {
        return this.capacityAcquired;
    }

    public int capacityRemaining() {
        return this.capacityRemaining;
    }

    public TokenState state() {
        return this.state;
    }

    @Override
    public Builder toBuilder() {
        return new Builder(this);
    }

    public String toString() {
        return ToString.builder("StandardRetryToken").add("scope", this.scope).add("status", (Object)this.state).add("attempt", this.attempt).add("capacityAcquired", this.capacityAcquired).add("capacityRemaining", this.capacityRemaining).add("failures", this.failures).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder
    implements CopyableBuilder<Builder, DefaultRetryToken> {
        private TokenState state = TokenState.IN_PROGRESS;
        private String scope;
        private int attempt = 1;
        private int capacityAcquired = 0;
        private int capacityRemaining = 0;
        private List<Throwable> failures;

        Builder() {
            this.failures = new ArrayList<Throwable>();
        }

        Builder(DefaultRetryToken token) {
            this.scope = token.scope;
            this.attempt = token.attempt;
            this.capacityAcquired = token.capacityAcquired;
            this.capacityRemaining = token.capacityRemaining;
            this.failures = new ArrayList<Throwable>(token.failures);
        }

        public Builder scope(String scope) {
            this.scope = scope;
            return this;
        }

        public Builder state(TokenState state) {
            this.state = state;
            return this;
        }

        public Builder increaseAttempt() {
            ++this.attempt;
            return this;
        }

        public Builder capacityAcquired(int capacityAcquired) {
            this.capacityAcquired = capacityAcquired;
            return this;
        }

        public Builder capacityRemaining(int capacityRemaining) {
            this.capacityRemaining = capacityRemaining;
            return this;
        }

        public Builder addFailure(Throwable failure) {
            this.failures.add(Validate.paramNotNull(failure, "failure"));
            return this;
        }

        @Override
        public DefaultRetryToken build() {
            return new DefaultRetryToken(this);
        }
    }

    public static enum TokenState {
        IN_PROGRESS,
        SUCCEEDED,
        TOKEN_ACQUISITION_FAILED,
        MAX_RETRIES_REACHED,
        NON_RETRYABLE_EXCEPTION;

    }
}

