/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.s3.internal.multipart;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.SortedSet;
import java.util.TreeSet;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.services.s3.model.GetObjectResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class MultipartDownloadResumeContext {
    private final SortedSet<Integer> completedParts;
    private Long bytesToLastCompletedParts;
    private Integer totalParts;
    private GetObjectResponse response;

    public MultipartDownloadResumeContext() {
        this(new TreeSet<Integer>(), 0L);
    }

    public MultipartDownloadResumeContext(Collection<Integer> completedParts, Long bytesToLastCompletedParts) {
        this.completedParts = new TreeSet<Integer>(Validate.notNull(completedParts, "completedParts must not be null", new Object[0]));
        this.bytesToLastCompletedParts = Validate.notNull(bytesToLastCompletedParts, "bytesToLastCompletedParts must not be null", new Object[0]);
    }

    public List<Integer> completedParts() {
        return Arrays.asList(this.completedParts.toArray(new Integer[0]));
    }

    public Long bytesToLastCompletedParts() {
        return this.bytesToLastCompletedParts;
    }

    public void addCompletedPart(int partNumber) {
        this.completedParts.add(partNumber);
    }

    public void addToBytesToLastCompletedParts(long bytes) {
        this.bytesToLastCompletedParts = this.bytesToLastCompletedParts + bytes;
    }

    public void totalParts(int totalParts) {
        this.totalParts = totalParts;
    }

    public Integer totalParts() {
        return this.totalParts;
    }

    public GetObjectResponse response() {
        return this.response;
    }

    public void response(GetObjectResponse response) {
        this.response = response;
    }

    public int highestSequentialCompletedPart() {
        if (this.completedParts.isEmpty() || this.completedParts.first() != 1) {
            return 0;
        }
        if (this.completedParts.size() == 1) {
            return 1;
        }
        int previous = this.completedParts.first();
        for (Integer i : this.completedParts) {
            if (i - previous > 1) {
                return previous;
            }
            previous = i;
        }
        return this.completedParts.last();
    }

    public boolean isComplete() {
        if (this.totalParts == null) {
            return false;
        }
        return this.completedParts.size() == this.totalParts.intValue();
    }

    public String toString() {
        return ToString.builder("MultipartDownloadContext").add("completedParts", this.completedParts).add("bytesToLastCompletedParts", this.bytesToLastCompletedParts).build();
    }
}

