/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.s3.internal.multipart;

import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkRequest;
import software.amazon.awssdk.services.s3.model.ChecksumAlgorithm;
import software.amazon.awssdk.services.s3.model.PutObjectRequest;
import software.amazon.awssdk.utils.Logger;

@SdkInternalApi
public final class S3ChecksumUtils {
    private static final Logger log = Logger.loggerFor(S3ChecksumUtils.class);

    private S3ChecksumUtils() {
    }

    public static boolean checksumValueSpecified(SdkRequest request) {
        for (ChecksumAlgorithm algorithm : ChecksumAlgorithm.knownValues()) {
            String s = "Checksum" + (Object)((Object)algorithm);
            if (!request.getValueForField(s, String.class).isPresent()) continue;
            return true;
        }
        return false;
    }

    public static Optional<ChecksumAlgorithm> checksumAlgorithmFromPutObjectRequest(PutObjectRequest request) {
        if (request.checksumAlgorithm() != null) {
            return Optional.of(request.checksumAlgorithm());
        }
        try {
            for (SdkField<?> field : request.sdkFields()) {
                if (!field.memberName().startsWith("Checksum") || !request.getValueForField(field.memberName(), String.class).isPresent()) continue;
                String substring = field.memberName().substring(8);
                return Optional.of(ChecksumAlgorithm.fromValue(substring));
            }
        }
        catch (Exception e) {
            log.debug(() -> "Failed to retrieve checksum algorithm from PutObjectRequest, will use the SDK default checksum algorithm", e);
            return Optional.empty();
        }
        return Optional.empty();
    }
}

