/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.s3.internal.plugins;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.SdkPlugin;
import software.amazon.awssdk.core.SdkServiceClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.services.s3.S3Configuration;
import software.amazon.awssdk.services.s3.S3ServiceClientConfiguration;
import software.amazon.awssdk.services.s3.internal.plugins.S3DisableChunkEncodingAuthSchemeProvider;
import software.amazon.awssdk.utils.Logger;

@SdkInternalApi
public final class S3DisableChunkEncodingIfConfiguredPlugin
implements SdkPlugin {
    private static final Logger LOG = Logger.loggerFor(S3DisableChunkEncodingIfConfiguredPlugin.class);
    private final boolean isServiceConfigurationPresent;
    private final boolean isChunkedEncodingEnabledConfigured;
    private final boolean isChunkedEncodingEnabledDisabled;
    private final boolean configuresDisableChunkEncoding;

    public S3DisableChunkEncodingIfConfiguredPlugin(SdkClientConfiguration config) {
        S3Configuration serviceConfiguration = (S3Configuration)config.option(SdkClientOption.SERVICE_CONFIGURATION);
        boolean isServiceConfigurationPresent = serviceConfiguration != null;
        boolean shouldAddDisableChunkEncoding = false;
        boolean isChunkedEncodingEnabledConfigured = false;
        boolean isChunkedEncodingEnabledDisabled = false;
        boolean configuresDisableChunkEncoding = false;
        if (isServiceConfigurationPresent) {
            isChunkedEncodingEnabledConfigured = serviceConfiguration.toBuilder().chunkedEncodingEnabled() != null;
            isChunkedEncodingEnabledDisabled = !serviceConfiguration.chunkedEncodingEnabled();
            boolean bl = configuresDisableChunkEncoding = isChunkedEncodingEnabledConfigured && isChunkedEncodingEnabledDisabled;
            if (configuresDisableChunkEncoding) {
                shouldAddDisableChunkEncoding = true;
            }
        }
        this.configuresDisableChunkEncoding = shouldAddDisableChunkEncoding;
        this.isChunkedEncodingEnabledConfigured = isChunkedEncodingEnabledConfigured;
        this.isChunkedEncodingEnabledDisabled = isChunkedEncodingEnabledDisabled;
        this.isServiceConfigurationPresent = isServiceConfigurationPresent;
    }

    @Override
    public void configureClient(SdkServiceClientConfiguration.Builder config) {
        if (this.configuresDisableChunkEncoding) {
            LOG.debug(() -> String.format("chunkedEncodingEnabled was explicitly disabled in the configuration, adding `S3DisableChunkEncodingAuthSchemeProvider` auth provider wrapper.", new Object[0]));
            S3ServiceClientConfiguration.Builder s3Config = (S3ServiceClientConfiguration.Builder)config;
            S3DisableChunkEncodingAuthSchemeProvider disablingAuthSchemeProvider = S3DisableChunkEncodingAuthSchemeProvider.create(s3Config.authSchemeProvider());
            s3Config.authSchemeProvider(disablingAuthSchemeProvider);
        }
    }
}

