/*
 * Decompiled with CFR 0.152.
 */
package org.nlogo.agent;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.nlogo.agent.Link;
import org.nlogo.agent.LinkManager;
import org.nlogo.agent.Turtle;
import org.nlogo.agent.World;
import org.nlogo.api.AgentException;
import org.nlogo.api.Constants;
import org.nlogo.util.Exceptions;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public strictfp class TieManager {
    private final World world;
    final LinkManager linkManager;
    int tieCount = 0;

    TieManager(World world, LinkManager linkManager) {
        this.world = world;
        this.linkManager = linkManager;
    }

    public void reset() {
        this.tieCount = 0;
    }

    public void setTieMode(Link link, String mode) {
        if (link.isTied()) {
            if (mode.equals("none")) {
                --this.tieCount;
            }
        } else if (!mode.equals("none")) {
            ++this.tieCount;
        }
    }

    List<Turtle> tiedTurtles(Turtle root2) {
        Turtle t;
        ArrayList<Turtle> myTies = new ArrayList<Turtle>();
        if (this.linkManager.srcMap.containsKey(root2)) {
            for (Link link : this.linkManager.srcMap.get(root2)) {
                if (!link.isTied()) continue;
                t = link.end2();
                myTies.add(t);
            }
        }
        if (this.linkManager.destMap.containsKey(root2)) {
            for (Link link : this.linkManager.destMap.get(root2)) {
                if (link.getBreed().isDirected() || !link.isTied()) continue;
                t = link.end1();
                myTies.add(t);
            }
        }
        return myTies;
    }

    void turtleMoved(Turtle root2, double newX, double newY, double originalXcor, double originalYcor) {
        this.turtleMoved(root2, newX, newY, originalXcor, originalYcor, new HashSet<Turtle>());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void turtleMoved(Turtle root2, double newX, double newY, double originalXcor, double originalYcor, Set<Turtle> seenTurtles) {
        boolean weroot = false;
        try {
            if (seenTurtles.isEmpty()) {
                seenTurtles.add(root2);
                weroot = true;
            }
            List<Turtle> myTies = this.tiedTurtles(root2);
            Iterator<Turtle> i = myTies.iterator();
            while (i.hasNext()) {
                Turtle t = i.next();
                if (t.id == -1L || seenTurtles.contains(t)) {
                    i.remove();
                    continue;
                }
                seenTurtles.add(t);
            }
            for (Turtle t : myTies) {
                double changex = newX - originalXcor;
                double changey = newY - originalYcor;
                try {
                    t.xandycor(t.xcor + changex, t.ycor + changey, seenTurtles);
                }
                catch (AgentException ex) {
                    Exceptions.ignore(ex);
                }
            }
        }
        finally {
            if (weroot) {
                seenTurtles.clear();
            }
        }
    }

    void turtleTurned(Turtle root2, double newHeading, double originalHeading) {
        this.turtleTurned(root2, newHeading, originalHeading, new HashSet<Turtle>());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void turtleTurned(Turtle root2, double newHeading, double originalHeading, Set<Turtle> seenTurtles) {
        boolean weroot = false;
        try {
            if (seenTurtles.isEmpty()) {
                seenTurtles.add(root2);
                weroot = true;
            }
            List<Turtle> myTies = this.tiedTurtles(root2);
            Iterator<Turtle> i = myTies.iterator();
            while (i.hasNext()) {
                Turtle t = i.next();
                if (t.id == -1L || seenTurtles.contains(t)) {
                    i.remove();
                    continue;
                }
                seenTurtles.add(t);
            }
            for (Turtle t : myTies) {
                try {
                    Link link = this.linkManager.findLink(root2, t, this.world.links(), true);
                    boolean rigid = link.mode().equals("fixed");
                    double dh = Turtle.subtractHeadings(newHeading, originalHeading);
                    double dist = this.world.protractor().distance(root2.xcor, root2.ycor, t.xcor, t.ycor, true);
                    if (dist == 0.0) {
                        if (!rigid) continue;
                        t.heading(t.heading + dh, seenTurtles);
                        continue;
                    }
                    double towards = this.world.protractor().towards(root2, t, true);
                    double oldHeadingRadians = StrictMath.toRadians(towards);
                    double newHeadingRadians = StrictMath.toRadians(towards + dh);
                    double ocos = StrictMath.cos(oldHeadingRadians);
                    double osin = StrictMath.sin(oldHeadingRadians);
                    double ncos = StrictMath.cos(newHeadingRadians);
                    double nsin = StrictMath.sin(newHeadingRadians);
                    if (StrictMath.abs(ocos) < Constants.Infinitesimal()) {
                        ocos = 0.0;
                    }
                    if (StrictMath.abs(osin) < Constants.Infinitesimal()) {
                        osin = 0.0;
                    }
                    if (StrictMath.abs(ncos) < Constants.Infinitesimal()) {
                        ncos = 0.0;
                    }
                    if (StrictMath.abs(nsin) < Constants.Infinitesimal()) {
                        nsin = 0.0;
                    }
                    double oldtx = root2.xcor + dist * osin;
                    double oldty = root2.ycor + dist * ocos;
                    double newtx = root2.xcor + dist * nsin;
                    double newty = root2.ycor + dist * ncos;
                    double dx = newtx - oldtx;
                    double dy = newty - oldty;
                    Set<Turtle> snapshot = seenTurtles;
                    try {
                        if (rigid) {
                            snapshot = new HashSet<Turtle>(seenTurtles);
                        }
                        t.xandycor(t.xcor + dx, t.ycor + dy, seenTurtles);
                    }
                    finally {
                        if (rigid) {
                            seenTurtles = snapshot;
                        }
                    }
                    if (!rigid) continue;
                    t.heading(t.heading + dh, seenTurtles);
                }
                catch (AgentException ex) {
                    Exceptions.ignore(ex);
                }
            }
        }
        finally {
            if (weroot) {
                seenTurtles.clear();
            }
        }
    }
}

