/*
 * Decompiled with CFR 0.152.
 */
package org.nlogo.api;

public strictfp class Matrix3D {
    double xx = 1.0;
    double xy;
    double xz;
    double xo;
    double yx;
    double yy = 1.0;
    double yz;
    double yo;
    double zx;
    double zy;
    double zz = 1.0;
    double zo;
    static final double pi = Math.PI;

    public void scale(double f2) {
        this.xx *= f2;
        this.xy *= f2;
        this.xz *= f2;
        this.xo *= f2;
        this.yx *= f2;
        this.yy *= f2;
        this.yz *= f2;
        this.yo *= f2;
        this.zx *= f2;
        this.zy *= f2;
        this.zz *= f2;
        this.zo *= f2;
    }

    public void scale(double xf, double yf, double zf) {
        this.xx *= xf;
        this.xy *= xf;
        this.xz *= xf;
        this.xo *= xf;
        this.yx *= yf;
        this.yy *= yf;
        this.yz *= yf;
        this.yo *= yf;
        this.zx *= zf;
        this.zy *= zf;
        this.zz *= zf;
        this.zo *= zf;
    }

    public void translate(double x2, double y, double z) {
        this.xo += x2;
        this.yo += y;
        this.zo += z;
    }

    public void yrot(double theta) {
        double ct = StrictMath.cos(theta *= Math.PI / 180);
        double st = StrictMath.sin(theta);
        double Nxx = this.xx * ct + this.zx * st;
        double Nxy = this.xy * ct + this.zy * st;
        double Nxz = this.xz * ct + this.zz * st;
        double Nxo = this.xo * ct + this.zo * st;
        double Nzx = this.zx * ct - this.xx * st;
        double Nzy = this.zy * ct - this.xy * st;
        double Nzz = this.zz * ct - this.xz * st;
        double Nzo = this.zo * ct - this.xo * st;
        this.xo = Nxo;
        this.xx = Nxx;
        this.xy = Nxy;
        this.xz = Nxz;
        this.zo = Nzo;
        this.zx = Nzx;
        this.zy = Nzy;
        this.zz = Nzz;
    }

    public void xrot(double theta) {
        double ct = StrictMath.cos(theta *= Math.PI / 180);
        double st = StrictMath.sin(theta);
        double Nyx = this.yx * ct + this.zx * st;
        double Nyy = this.yy * ct + this.zy * st;
        double Nyz = this.yz * ct + this.zz * st;
        double Nyo = this.yo * ct + this.zo * st;
        double Nzx = this.zx * ct - this.yx * st;
        double Nzy = this.zy * ct - this.yy * st;
        double Nzz = this.zz * ct - this.yz * st;
        double Nzo = this.zo * ct - this.yo * st;
        this.yo = Nyo;
        this.yx = Nyx;
        this.yy = Nyy;
        this.yz = Nyz;
        this.zo = Nzo;
        this.zx = Nzx;
        this.zy = Nzy;
        this.zz = Nzz;
    }

    public void zrot(double theta) {
        double ct = StrictMath.cos(theta *= Math.PI / 180);
        double st = StrictMath.sin(theta);
        double Nyx = this.yx * ct + this.xx * st;
        double Nyy = this.yy * ct + this.xy * st;
        double Nyz = this.yz * ct + this.xz * st;
        double Nyo = this.yo * ct + this.xo * st;
        double Nxx = this.xx * ct - this.yx * st;
        double Nxy = this.xy * ct - this.yy * st;
        double Nxz = this.xz * ct - this.yz * st;
        double Nxo = this.xo * ct - this.yo * st;
        this.yo = Nyo;
        this.yx = Nyx;
        this.yy = Nyy;
        this.yz = Nyz;
        this.xo = Nxo;
        this.xx = Nxx;
        this.xy = Nxy;
        this.xz = Nxz;
    }

    public void vrot(double x2, double y, double z, double u, double v, double w, double theta) {
        Matrix3D rot = new Matrix3D();
        double us = u * u;
        double vs = v * v;
        double ws = w * w;
        double costheta = StrictMath.cos(theta);
        double sintheta = StrictMath.sin(theta);
        double l2 = us + vs + ws;
        double l = StrictMath.sqrt(l2);
        rot.xx = (us + (vs + ws) * costheta) / l2;
        rot.xy = (u * v * (1.0 - costheta) - w * l * sintheta) / l2;
        rot.xz = (u * w * (1.0 - costheta) + v * l * sintheta) / l2;
        rot.xo = (x2 * (vs + ws) - u * (y * v + z * w) + (u * (y * v + z * w) - x2 * (vs + ws)) * costheta + (y * w - z * v) * l * sintheta) / l2;
        rot.yx = (u * v * (1.0 - costheta) + w * l * sintheta) / l2;
        rot.yy = (vs + (us + ws) * costheta) / l2;
        rot.yz = (v * w * (1.0 - costheta) - u * l * sintheta) / l2;
        rot.yo = (y * (us + ws) - v * (x2 * u + z * w) + (v * (x2 * u + z * w) - y * (us + ws)) * costheta + (z * u - x2 * w) * l * sintheta) / l2;
        rot.zx = (u * w * (1.0 - costheta) - v * l * sintheta) / l2;
        rot.zy = (v * w * (1.0 - costheta) + u * l * sintheta) / l2;
        rot.zz = (ws + (us + vs) * costheta) / l2;
        rot.zo = (z * (us + vs) - w * (x2 * u + y * v) + (w * (x2 * u + y * v) - z * (us + vs)) * costheta + (x2 * v - y * u) * l * sintheta) / l2;
        this.mult(rot);
    }

    public void mult(Matrix3D rhs) {
        double lxx = this.xx * rhs.xx + this.yx * rhs.xy + this.zx * rhs.xz;
        double lxy = this.xy * rhs.xx + this.yy * rhs.xy + this.zy * rhs.xz;
        double lxz = this.xz * rhs.xx + this.yz * rhs.xy + this.zz * rhs.xz;
        double lxo = this.xo * rhs.xx + this.yo * rhs.xy + this.zo * rhs.xz + rhs.xo;
        double lyx = this.xx * rhs.yx + this.yx * rhs.yy + this.zx * rhs.yz;
        double lyy = this.xy * rhs.yx + this.yy * rhs.yy + this.zy * rhs.yz;
        double lyz = this.xz * rhs.yx + this.yz * rhs.yy + this.zz * rhs.yz;
        double lyo = this.xo * rhs.yx + this.yo * rhs.yy + this.zo * rhs.yz + rhs.yo;
        double lzx = this.xx * rhs.zx + this.yx * rhs.zy + this.zx * rhs.zz;
        double lzy = this.xy * rhs.zx + this.yy * rhs.zy + this.zy * rhs.zz;
        double lzz = this.xz * rhs.zx + this.yz * rhs.zy + this.zz * rhs.zz;
        double lzo = this.xo * rhs.zx + this.yo * rhs.zy + this.zo * rhs.zz + rhs.zo;
        this.xx = lxx;
        this.xy = lxy;
        this.xz = lxz;
        this.xo = lxo;
        this.yx = lyx;
        this.yy = lyy;
        this.yz = lyz;
        this.yo = lyo;
        this.zx = lzx;
        this.zy = lzy;
        this.zz = lzz;
        this.zo = lzo;
    }

    public void unit() {
        this.xo = 0.0;
        this.xx = 1.0;
        this.xy = 0.0;
        this.xz = 0.0;
        this.yo = 0.0;
        this.yx = 0.0;
        this.yy = 1.0;
        this.yz = 0.0;
        this.zo = 0.0;
        this.zx = 0.0;
        this.zy = 0.0;
        this.zz = 1.0;
    }

    public void transform(double[] v, double[] tv, int nvert) {
        double lxx = this.xx;
        double lxy = this.xy;
        double lxz = this.xz;
        double lxo = this.xo;
        double lyx = this.yx;
        double lyy = this.yy;
        double lyz = this.yz;
        double lyo = this.yo;
        double lzx = this.zx;
        double lzy = this.zy;
        double lzz = this.zz;
        double lzo = this.zo;
        int i = nvert * 3;
        while ((i -= 3) >= 0) {
            double x2 = v[i];
            double y = v[i + 1];
            double z = v[i + 2];
            tv[i] = x2 * lxx + y * lxy + z * lxz + lxo;
            tv[i + 1] = x2 * lyx + y * lyy + z * lyz + lyo;
            tv[i + 2] = x2 * lzx + y * lzy + z * lzz + lzo;
        }
    }

    public String toString() {
        return "[" + this.xo + "," + this.xx + "," + this.xy + "," + this.xz + ";" + this.yo + "," + this.yx + "," + this.yy + "," + this.yz + ";" + this.zo + "," + this.zx + "," + this.zy + "," + this.zz + "]";
    }
}

