/*
 * Decompiled with CFR 0.152.
 */
package org.nlogo.sdm.gui;

import java.awt.Color;
import java.awt.Component;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.nlogo.api.CompilerException;
import org.nlogo.api.I18N;
import org.nlogo.api.TokenType;
import org.nlogo.editor.Colorizer;
import org.nlogo.sdm.gui.AggregateModelEditor;
import org.nlogo.sdm.gui.AggregateProceduresTab;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
strictfp class AggregateTabs
extends JTabbedPane
implements ChangeListener {
    private final AggregateProceduresTab proceduresTab;
    private final AggregateModelEditor editor;
    private static final Color ERROR_COLOR = Color.RED;

    AggregateTabs(JPanel activePanel, AggregateModelEditor editor2, Colorizer<TokenType> colorizer) {
        this.addChangeListener(this);
        this.editor = editor2;
        this.proceduresTab = new AggregateProceduresTab(colorizer);
        this.add(I18N.guiJ().get("tools.sdm.diagram"), activePanel);
        this.add(I18N.guiJ().get("tabs.code"), this.proceduresTab);
        this.setSelectedComponent(activePanel);
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        this.proceduresTab.setText(this.editor.toNetLogoCode());
    }

    void recolorTab(Component component, boolean hasError) {
        int index = this.indexOfComponent(component);
        this.setForegroundAt(index, hasError ? ERROR_COLOR : null);
    }

    void setError(CompilerException e) {
        if (e != null) {
            this.setSelectedComponent(this.proceduresTab);
        }
        this.proceduresTab.setError(e);
        this.setForegroundAt(this.indexOfComponent(this.proceduresTab), e != null ? ERROR_COLOR : null);
    }
}

