/*
 * Decompiled with CFR 0.152.
 */
package org.nlogo.shape;

import java.awt.Color;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.geom.Line2D;
import java.util.StringTokenizer;
import org.nlogo.api.Constants;
import org.nlogo.api.GraphicsInterface;
import org.nlogo.shape.Element;

public strictfp class Line
extends Element
implements Cloneable {
    static final long serialVersionUID = 0L;
    private Point start;
    private Point end;
    private String modifiedPoint;

    public Line(Point start2, Point last2, Color color) {
        super(color);
        this.start = start2;
        this.end = last2;
    }

    public void setFilled(boolean fill2) {
    }

    public Object clone() {
        Line newLine = (Line)super.clone();
        newLine.start = (Point)newLine.start.clone();
        newLine.end = (Point)newLine.end.clone();
        return newLine;
    }

    public Rectangle getBounds() {
        return this.createRect(this.start, this.end);
    }

    public boolean contains(Point p) {
        Line2D.Double check2 = new Line2D.Double(this.start, this.end);
        return check2.ptSegDist(p) < 3.0;
    }

    public void modify(Point start2, Point last2) {
        this.end.x = last2.x;
        this.end.y = last2.y;
    }

    public void reshapeElement(Point oldPoint, Point newPoint) {
        if (this.modifiedPoint.equals("start")) {
            this.start = newPoint;
        }
        if (this.modifiedPoint.equals("end")) {
            this.end = newPoint;
        }
    }

    public void moveElement(int xOffset, int yOffset) {
        this.start.x += xOffset;
        this.start.y += yOffset;
        this.end.x += xOffset;
        this.end.y += yOffset;
    }

    public Point[] getHandles() {
        return new Point[]{this.start, this.end};
    }

    public void rotateLeft() {
        int temp = this.start.x;
        this.start.x = this.start.y;
        this.start.y = Constants.ShapeWidth() - temp;
        temp = this.end.x;
        this.end.x = this.end.y;
        this.end.y = Constants.ShapeWidth() - temp;
    }

    public void rotateRight() {
        int temp = this.start.x;
        this.start.x = Constants.ShapeWidth() - this.start.y;
        this.start.y = temp;
        temp = this.end.x;
        this.end.x = Constants.ShapeWidth() - this.end.y;
        this.end.y = temp;
    }

    public void flipHorizontal() {
        this.start.x = Constants.ShapeWidth() - this.start.x;
        this.end.x = Constants.ShapeWidth() - this.end.x;
    }

    public void flipVertical() {
        this.start.y = Constants.ShapeWidth() - this.start.y;
        this.end.y = Constants.ShapeWidth() - this.end.y;
    }

    public void draw(GraphicsInterface g, Color turtleColor, double scale, double angle) {
        g.setColor(this.getColor(turtleColor));
        g.drawLine(this.start.x, this.start.y, this.end.x, this.end.y);
    }

    public void fill(GraphicsInterface g) {
    }

    public String toString() {
        return "Line " + this.c.getRGB() + " " + this.marked + " " + this.start.x + " " + this.start.y + " " + this.end.x + " " + this.end.y;
    }

    public String toReadableString() {
        return "Line with color " + this.c + " and bounds " + this.getBounds();
    }

    public static Line parseLine(String text2) {
        StringTokenizer tokenizer = new StringTokenizer(text2);
        tokenizer.nextToken();
        String color = tokenizer.nextToken();
        boolean b1 = Boolean.valueOf(tokenizer.nextToken());
        int x1 = Integer.valueOf(tokenizer.nextToken());
        int y1 = Integer.valueOf(tokenizer.nextToken());
        int x2 = Integer.valueOf(tokenizer.nextToken());
        int y2 = Integer.valueOf(tokenizer.nextToken());
        if (x1 == x2 && y1 == y2) {
            return null;
        }
        Line line = new Line(new Point(x1, y1), new Point(x2, y2), Color.decode(color));
        line.setMarked(b1);
        return line;
    }

    public void setModifiedPoint(Point modified) {
        if (modified.equals(this.start)) {
            this.modifiedPoint = "start";
        } else if (modified.equals(this.end)) {
            this.modifiedPoint = "end";
        }
    }

    public Point getStart() {
        return this.start;
    }

    public Point getEnd() {
        return this.end;
    }
}

