/*
 * Decompiled with CFR 0.152.
 */
package org.nlogo.shape.editor;

import java.awt.Color;
import java.awt.Cursor;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.Observable;
import java.util.Observer;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.undo.AbstractUndoableEdit;
import javax.swing.undo.UndoableEdit;
import org.nlogo.api.I18N;
import org.nlogo.api.Shape;
import org.nlogo.awt.ColumnLayout;
import org.nlogo.shape.Circle;
import org.nlogo.shape.Element;
import org.nlogo.shape.Line;
import org.nlogo.shape.Polygon;
import org.nlogo.shape.Rectangle;
import org.nlogo.shape.VectorShape;
import org.nlogo.shape.editor.ColorCellRenderer;
import org.nlogo.shape.editor.ShapePreview;
import org.nlogo.shape.editor.ShapeView;
import org.nlogo.swing.ButtonPanel;
import org.nlogo.swing.ColorIcon;
import org.nlogo.swing.TextField;
import org.nlogo.swing.Utils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
strictfp class EditorDialog
extends JDialog
implements Observer {
    private final VectorShape originalShape;
    private final VectorShape shape;
    private final VectorShapeContainer container;
    private final ShapeView shapeView;
    private Class<? extends Element> elementType = null;
    private Color elementColor;
    private boolean editingElements = false;
    private final ShapePreview[] previews;
    private final TextField nameText;
    private final JToggleButton editElements;
    private final JButton deleteSelected;
    private final JButton duplicateSelected;
    private final JButton bringToFront;
    private final JButton sendToBack;
    private final JButton undoButton;
    private UndoableEdit undoableEdit;
    private final JComboBox colorSelection;
    private boolean fillShapes = true;
    private boolean shapeRotatable = true;
    private boolean snapToGrid = true;

    EditorDialog(VectorShapeContainer cont, final VectorShape originalShape, int x2, int y, boolean nameEditable) {
        super((Frame)null, true);
        this.container = cont;
        this.originalShape = originalShape;
        this.shape = (VectorShape)originalShape.clone();
        this.shape.addObserver(this);
        this.shapeView = new ShapeView(this, this.shape);
        this.shape.addObserver(this.shapeView);
        this.setResizable(false);
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                EditorDialog.this.saveShape();
                EditorDialog.this.setVisible(false);
                EditorDialog.this.dispose();
            }
        });
        Utils.addEscKeyAction(this, (Action)new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                if (!originalShape.toString().equals(EditorDialog.this.getCurrentShape().toString()) && 0 != JOptionPane.showConfirmDialog(EditorDialog.this, "You may lose changes made to this shape. Do you want to cancel anyway?", "Confirm Cancel", 0)) {
                    return;
                }
                EditorDialog.this.dispose();
            }
        });
        JPanel leftPanel = new JPanel();
        leftPanel.setLayout(new ColumnLayout(0, 0.5f, 0.0f));
        JPanel rightPanel = new JPanel();
        rightPanel.setLayout(new ColumnLayout(0, 0.5f, 0.0f));
        JToolBar editingToolBar = new JToolBar();
        editingToolBar.setFloatable(false);
        editingToolBar.setLayout(new GridLayout(4, 2));
        ButtonGroup editingToolGroup = new ButtonGroup();
        this.editElements = new JToggleButton(new ImageIcon(EditorDialog.class.getResource("/images/shapes-editor/arrow.gif")), false);
        this.editElements.putClientProperty("Quaqua.Button.style", "square");
        this.editElements.setToolTipText("Select");
        this.editElements.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                EditorDialog.this.editingElements = EditorDialog.this.editElements.isSelected();
                EditorDialog.this.shapeView.deselectAll();
                EditorDialog.this.deleteSelected.setEnabled(false);
                EditorDialog.this.duplicateSelected.setEnabled(false);
                if (EditorDialog.this.editingElements) {
                    EditorDialog.this.shapeView.setCursor(Cursor.getPredefinedCursor(0));
                } else {
                    EditorDialog.this.shapeView.setCursor(Cursor.getPredefinedCursor(1));
                }
                if (EditorDialog.this.shapeView.drawingPolygon()) {
                    EditorDialog.this.shapeView.selfFinishPolygon(true);
                }
            }
        });
        editingToolGroup.add(this.editElements);
        editingToolBar.add(this.editElements);
        this.deleteSelected = new JButton("Delete");
        this.deleteSelected.setEnabled(false);
        this.deleteSelected.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                EditorDialog.this.undoableEdit = new UndoableDeleteEdit(EditorDialog.this.shapeView.getSelectedElement(), EditorDialog.this.shape.getElements().indexOf(EditorDialog.this.shapeView.getSelectedElement()));
                EditorDialog.this.undoButton.setEnabled(EditorDialog.this.undoableEdit.canUndo());
                EditorDialog.this.shape.remove(EditorDialog.this.shapeView.getSelectedElement());
                EditorDialog.this.shapeView.deselectAll();
                if (EditorDialog.this.shape.getElements().isEmpty()) {
                    EditorDialog.this.deleteSelected.setEnabled(false);
                    EditorDialog.this.bringToFront.setEnabled(false);
                    EditorDialog.this.sendToBack.setEnabled(false);
                    EditorDialog.this.shape.changed();
                }
            }
        });
        this.duplicateSelected = new JButton("Duplicate");
        this.duplicateSelected.setEnabled(false);
        this.duplicateSelected.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (EditorDialog.this.shapeView.getSelectedElement() != null) {
                    Element newElement = (Element)EditorDialog.this.shapeView.getSelectedElement().clone();
                    EditorDialog.this.shape.add(newElement);
                    EditorDialog.this.makeUndoableDraw(newElement);
                }
            }
        });
        this.bringToFront = new JButton("Bring to front");
        this.bringToFront.setEnabled(false);
        this.bringToFront.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                EditorDialog.this.makeUndoableModification(EditorDialog.this.shapeView.getSelectedElement(), EditorDialog.this.shape.getElements().indexOf(EditorDialog.this.shapeView.getSelectedElement()));
                EditorDialog.this.shape.remove(EditorDialog.this.shapeView.getSelectedElement());
                EditorDialog.this.shape.add(EditorDialog.this.shapeView.getSelectedElement());
            }
        });
        this.sendToBack = new JButton("Send to back");
        this.sendToBack.setEnabled(false);
        this.sendToBack.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                EditorDialog.this.makeUndoableModification(EditorDialog.this.shapeView.getSelectedElement(), EditorDialog.this.shape.getElements().indexOf(EditorDialog.this.shapeView.getSelectedElement()));
                EditorDialog.this.shape.remove(EditorDialog.this.shapeView.getSelectedElement());
                EditorDialog.this.shape.addAtPosition(0, EditorDialog.this.shapeView.getSelectedElement());
            }
        });
        this.undoButton = new JButton("Undo");
        this.undoButton.setEnabled(false);
        this.undoButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                EditorDialog.this.undoableEdit.undo();
                EditorDialog.this.undoButton.setEnabled(EditorDialog.this.undoableEdit.canUndo());
                EditorDialog.this.shapeView.deselectAll();
            }
        });
        this.addToolBarButton(editingToolBar, editingToolGroup, new CreateAction("line", Line.class, "Draw line", false));
        this.addToolBarButton(editingToolBar, editingToolGroup, new CreateAction("rectangle-filled", Rectangle.class, "Draw filled rectangle", true));
        this.addToolBarButton(editingToolBar, editingToolGroup, new CreateAction("rectangle", Rectangle.class, "Draw rectangle", false));
        this.addToolBarButton(editingToolBar, editingToolGroup, new CreateAction("circle-filled", Circle.class, "Draw filled circle", true));
        this.addToolBarButton(editingToolBar, editingToolGroup, new CreateAction("circle", Circle.class, "Draw circle", false));
        this.addToolBarButton(editingToolBar, editingToolGroup, new CreateAction("polygon-filled", Polygon.class, "Draw filled polygon", true));
        this.addToolBarButton(editingToolBar, editingToolGroup, new CreateAction("polygon", Polygon.class, "Draw polygon", false));
        ArrayList<Integer> colors = new ArrayList<Integer>(org.nlogo.api.Color.getColorNamesArray().length);
        ButtonGroup colorGroup = new ButtonGroup();
        JToolBar colorGrid = new JToolBar();
        colorGrid.setFloatable(false);
        colorGrid.setLayout(new GridLayout(4, 4));
        for (int icolor = 0; icolor < org.nlogo.api.Color.getColorNamesArray().length; ++icolor) {
            String userstr = "Draw in " + org.nlogo.api.Color.getColorNameByIndex(icolor);
            AbstractButton button = this.addToolBarButton(colorGrid, colorGroup, new ColorAction(org.nlogo.api.Color.getColorNameByIndex(icolor), new Color(org.nlogo.api.Color.getARGBByIndex(icolor)), userstr));
            if (icolor == this.shape.getEditableColorIndex()) {
                button.setSelected(true);
            }
            colors.add(icolor);
        }
        this.colorSelection = new JComboBox<Object>(colors.toArray());
        this.colorSelection.setRenderer(new ColorCellRenderer());
        this.colorSelection.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                EditorDialog.this.setEditableColor();
            }
        });
        final JCheckBox snapToGridButton = new JCheckBox("Snap to grid", true);
        snapToGridButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                EditorDialog.this.snapToGrid = snapToGridButton.isSelected();
            }
        });
        final JCheckBox rotatableButton = new JCheckBox("Rotatable", true);
        rotatableButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                EditorDialog.this.shapeRotatable = rotatableButton.isSelected();
                for (int i = 0; i < EditorDialog.this.previews.length; ++i) {
                    EditorDialog.this.previews[i].updateRotation(EditorDialog.this.shapeRotatable);
                }
                EditorDialog.this.shape.setRotatable(EditorDialog.this.shapeRotatable);
                EditorDialog.this.shapeView.repaint();
            }
        });
        JButton rotateLeftButton = new JButton("Rotate Left");
        rotateLeftButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (EditorDialog.this.shapeView.hasSelectedElement()) {
                    EditorDialog.this.makeUndoableModification(EditorDialog.this.shapeView.getSelectedElement(), EditorDialog.this.shape.getElements().indexOf(EditorDialog.this.shapeView.getSelectedElement()));
                    EditorDialog.this.shapeView.getSelectedElement().rotateLeft();
                } else {
                    EditorDialog.this.undoableEdit = null;
                    EditorDialog.this.undoButton.setEnabled(false);
                    EditorDialog.this.shape.rotateLeft();
                }
                EditorDialog.this.shapeView.repaint();
            }
        });
        JButton rotateRightButton = new JButton("Rotate Right");
        rotateRightButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (EditorDialog.this.shapeView.hasSelectedElement()) {
                    EditorDialog.this.makeUndoableModification(EditorDialog.this.shapeView.getSelectedElement(), EditorDialog.this.shape.getElements().indexOf(EditorDialog.this.shapeView.getSelectedElement()));
                    EditorDialog.this.shapeView.getSelectedElement().rotateRight();
                } else {
                    EditorDialog.this.undoableEdit = null;
                    EditorDialog.this.undoButton.setEnabled(false);
                    EditorDialog.this.shape.rotateRight();
                }
                EditorDialog.this.shapeView.repaint();
            }
        });
        JButton flipHorizontalButton = new JButton("Flip Horizontal");
        flipHorizontalButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (EditorDialog.this.shapeView.hasSelectedElement()) {
                    EditorDialog.this.makeUndoableModification(EditorDialog.this.shapeView.getSelectedElement(), EditorDialog.this.shape.getElements().indexOf(EditorDialog.this.shapeView.getSelectedElement()));
                    EditorDialog.this.shapeView.getSelectedElement().flipHorizontal();
                } else {
                    EditorDialog.this.undoableEdit = null;
                    EditorDialog.this.undoButton.setEnabled(false);
                    EditorDialog.this.shape.flipHorizontal();
                }
                EditorDialog.this.shapeView.repaint();
            }
        });
        JButton flipVerticalButton = new JButton("Flip Vertical");
        flipVerticalButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (EditorDialog.this.shapeView.hasSelectedElement()) {
                    EditorDialog.this.makeUndoableModification(EditorDialog.this.shapeView.getSelectedElement(), EditorDialog.this.shape.getElements().indexOf(EditorDialog.this.shapeView.getSelectedElement()));
                    EditorDialog.this.shapeView.getSelectedElement().flipVertical();
                } else {
                    EditorDialog.this.undoableEdit = null;
                    EditorDialog.this.undoButton.setEnabled(false);
                    EditorDialog.this.shape.flipVertical();
                }
                EditorDialog.this.shapeView.repaint();
            }
        });
        leftPanel.add(editingToolBar);
        leftPanel.add(snapToGridButton);
        leftPanel.add(colorGrid);
        leftPanel.add(Box.createVerticalStrut(10));
        leftPanel.add(new JLabel("Color that changes:"));
        leftPanel.add(Box.createVerticalStrut(3));
        leftPanel.add(this.colorSelection);
        leftPanel.add(this.deleteSelected);
        leftPanel.add(this.duplicateSelected);
        leftPanel.add(this.bringToFront);
        leftPanel.add(this.sendToBack);
        leftPanel.add(this.undoButton);
        leftPanel.add(rotatableButton);
        rightPanel.add(rotateLeftButton);
        rightPanel.add(rotateRightButton);
        rightPanel.add(flipHorizontalButton);
        rightPanel.add(flipVerticalButton);
        JButton cancel = new JButton(I18N.guiJ().get("common.buttons.cancel"));
        cancel.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                EditorDialog.this.dispose();
            }
        });
        JButton done = new JButton(I18N.guiJ().get("common.buttons.ok"));
        done.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                EditorDialog.this.saveShape();
            }
        });
        this.previews = new ShapePreview[5];
        this.previews[0] = new ShapePreview(this.shape, 9, 5);
        this.previews[1] = new ShapePreview(this.shape, 12, -4);
        this.previews[2] = new ShapePreview(this.shape, 20, 3);
        this.previews[3] = new ShapePreview(this.shape, 30, -2);
        this.previews[4] = new ShapePreview(this.shape, 50, 1);
        for (int i = 0; i < this.previews.length; ++i) {
            this.shape.addObserver(this.previews[i]);
        }
        int borderWidth = 10;
        JPanel previewPanel = new JPanel();
        previewPanel.setLayout(new BoxLayout(previewPanel, 0));
        for (int i = 0; i < this.previews.length; ++i) {
            previewPanel.add(this.previews[i]);
        }
        JPanel graphicPanel = new JPanel();
        graphicPanel.setLayout(new BoxLayout(graphicPanel, 1));
        graphicPanel.add(this.shapeView);
        graphicPanel.add(previewPanel);
        JPanel drawingPanel = new JPanel();
        drawingPanel.setLayout(new BoxLayout(drawingPanel, 0));
        drawingPanel.add(Box.createHorizontalStrut(borderWidth));
        drawingPanel.add(leftPanel);
        drawingPanel.add(Box.createHorizontalStrut(15));
        drawingPanel.add(graphicPanel);
        drawingPanel.add(Box.createHorizontalStrut(15));
        drawingPanel.add(rightPanel);
        drawingPanel.add(Box.createHorizontalStrut(borderWidth));
        ButtonPanel buttonPanel = new ButtonPanel(new JButton[]{done, cancel});
        JLabel nameLabel = new JLabel("Name");
        this.nameText = new TextField(4);
        JPanel namePanel = new JPanel();
        namePanel.setLayout(new BoxLayout(namePanel, 0));
        namePanel.add(Box.createHorizontalStrut(borderWidth));
        namePanel.add(Box.createHorizontalStrut(5));
        namePanel.add(nameLabel);
        namePanel.add(Box.createHorizontalStrut(5));
        namePanel.add(this.nameText);
        namePanel.add(Box.createHorizontalStrut(borderWidth));
        this.getContentPane().setLayout(new BoxLayout(this.getContentPane(), 1));
        this.getContentPane().add(Box.createVerticalStrut(borderWidth));
        this.getContentPane().add(namePanel);
        this.getContentPane().add(Box.createVerticalStrut(15));
        this.getContentPane().add(drawingPanel);
        this.getContentPane().add(Box.createVerticalStrut(15));
        this.getContentPane().add(buttonPanel);
        this.getContentPane().add(Box.createVerticalStrut(borderWidth));
        this.nameText.setText(this.shape.getName());
        this.shapeRotatable = this.shape.isRotatable();
        rotatableButton.setSelected(this.shapeRotatable);
        for (int i = 0; i < this.previews.length; ++i) {
            this.previews[i].updateRotation(this.shapeRotatable);
        }
        this.colorSelection.setSelectedIndex(this.shape.getEditableColorIndex());
        this.elementColor = EditorDialog.getColor(this.shape.getEditableColorIndex());
        this.setLocation(x2 + 10, y + 10);
        this.setTitle("Shape");
        this.setNameEditable(nameEditable);
        this.pack();
        this.getRootPane().setDefaultButton(done);
        this.nameText.requestFocus();
        this.setEditingElements(true);
        this.setVisible(true);
        this.shape.changed();
    }

    Class<? extends Element> getElementType() {
        return this.elementType;
    }

    Color getElementColor() {
        return this.elementColor;
    }

    boolean fillShapes() {
        return this.fillShapes;
    }

    boolean isRotatable() {
        return this.shapeRotatable;
    }

    boolean snapToGrid() {
        return this.snapToGrid;
    }

    boolean editingElements() {
        return this.editingElements;
    }

    void setEditingElements(boolean e) {
        this.editingElements = e;
        this.editElements.setSelected(e);
        if (e) {
            this.shapeView.setCursor(Cursor.getPredefinedCursor(0));
        } else {
            this.shapeView.setCursor(Cursor.getPredefinedCursor(1));
        }
    }

    public void makeUndoableModification(Element el, int z) {
        this.undoableEdit = new UndoableModification(el, z);
        this.undoButton.setEnabled(this.undoableEdit.canUndo());
    }

    public void makeUndoableDraw(Element el) {
        this.undoableEdit = new UndoableDraw(el);
        this.undoButton.setEnabled(this.undoableEdit.canUndo());
    }

    public void makeUndoableUnfinishedPolygon() {
        this.undoableEdit = new UndoableUnfinishedPolygon();
        this.undoButton.setEnabled(this.undoableEdit.canUndo());
    }

    @Override
    public void update(Observable o, Object obj) {
        this.deleteSelected.setEnabled(this.shapeView.hasSelectedElement());
        this.duplicateSelected.setEnabled(this.shapeView.hasSelectedElement());
        this.bringToFront.setEnabled(this.shapeView.hasSelectedElement());
        this.sendToBack.setEnabled(this.shapeView.hasSelectedElement());
    }

    private void saveShape() {
        int overwrite;
        String name;
        if (this.nameText.getText().equals("")) {
            name = JOptionPane.showInputDialog(this, "Name:", "Name Shape", -1);
            if (name == null) {
                return;
            }
        } else {
            name = this.nameText.getText();
        }
        if ((name = name.toLowerCase()) == null || name.equals("")) {
            return;
        }
        String originalName = this.originalShape.getName();
        if (this.container.exists(name) && !name.equals(originalName) && (overwrite = JOptionPane.showConfirmDialog(this, "A shape with this name already exists. Do you want to replace it?", "Confirm Overwrite", 0)) != 0) {
            return;
        }
        VectorShape newShape = this.shape;
        newShape.setName(name);
        newShape.setRotatable(this.shapeRotatable);
        newShape.markRecolorableElements(EditorDialog.getColor(this.shape.getEditableColorIndex()), this.shape.getEditableColorIndex());
        this.container.update(this.originalShape, newShape);
        this.dispose();
    }

    private VectorShape getCurrentShape() {
        VectorShape currentShape = (VectorShape)this.shape.clone();
        currentShape.setName(this.nameText.getText());
        currentShape.setRotatable(this.shapeRotatable);
        currentShape.markRecolorableElements(EditorDialog.getColor(this.shape.getEditableColorIndex()), this.shape.getEditableColorIndex());
        return currentShape;
    }

    private void setEditableColor() {
        this.shape.setEditableColorIndex(this.colorSelection.getSelectedIndex());
        this.shape.markRecolorableElements(EditorDialog.getColor(this.shape.getEditableColorIndex()), this.shape.getEditableColorIndex());
    }

    private AbstractButton addToolBarButton(JToolBar toolbar, ButtonGroup group, Action action) {
        JToggleButton newButton = new JToggleButton(action){

            public Insets getInsets() {
                return new Insets(3, 3, 3, 3);
            }
        };
        newButton.setText(null);
        newButton.putClientProperty("Quaqua.Button.style", "square");
        toolbar.add(newButton);
        group.add(newButton);
        return newButton;
    }

    static Color getColor(int index) {
        return new Color(org.nlogo.api.Color.getARGBByIndex(index));
    }

    private void setNameEditable(boolean editable) {
        this.nameText.setEnabled(editable);
    }

    public static interface VectorShapeContainer {
        public boolean exists(String var1);

        public void update(Shape var1, Shape var2);
    }

    private strictfp class UndoableUnfinishedPolygon
    extends AbstractUndoableEdit {
        private UndoableUnfinishedPolygon() {
        }

        public void undo() {
            super.undo();
            EditorDialog.this.shapeView.setTempElement(null);
        }
    }

    private strictfp class UndoableDeleteEdit
    extends AbstractUndoableEdit {
        private final Element deletedElement;
        private final int zOrder;

        public UndoableDeleteEdit(Element el, int zOrder) {
            this.deletedElement = (Element)el.clone();
            this.zOrder = zOrder;
        }

        public void undo() {
            super.undo();
            EditorDialog.this.shape.addAtPosition(this.zOrder, this.deletedElement);
        }
    }

    private strictfp class UndoableDraw
    extends AbstractUndoableEdit {
        private final Element newElement;

        public UndoableDraw(Element newElement) {
            this.newElement = newElement;
        }

        public void undo() {
            super.undo();
            EditorDialog.this.shape.remove(this.newElement);
        }
    }

    private strictfp class UndoableModification
    extends AbstractUndoableEdit {
        private final Element originalElement;
        private final Element modifiedElement;
        private final int zOrder;

        public UndoableModification(Element el, int zOrder) {
            this.originalElement = (Element)el.clone();
            this.modifiedElement = el;
            this.zOrder = zOrder;
        }

        public void undo() {
            super.undo();
            EditorDialog.this.shape.remove(this.modifiedElement);
            EditorDialog.this.shape.addAtPosition(this.zOrder, this.originalElement);
            if (EditorDialog.this.shapeView.hasSelectedElement()) {
                EditorDialog.this.shapeView.selectElement(this.originalElement);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private strictfp class CreateAction
    extends AbstractAction {
        private final Class<? extends Element> typeID;
        private final boolean filled;

        CreateAction(String name, Class<? extends Element> typeID, String toolTip, boolean filled) {
            super(name);
            this.typeID = typeID;
            this.filled = filled;
            this.putValue("SmallIcon", new ImageIcon(CreateAction.class.getResource("/images/shapes-editor/" + name + ".gif")));
            if (toolTip != null) {
                this.putValue("ShortDescription", toolTip);
            }
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (EditorDialog.this.shapeView.drawingPolygon()) {
                EditorDialog.this.shapeView.selfFinishPolygon(true);
            }
            EditorDialog.this.elementType = this.typeID;
            EditorDialog.this.fillShapes = this.filled;
            EditorDialog.this.editingElements = false;
            EditorDialog.this.shapeView.deselectAll();
            EditorDialog.this.shapeView.setCursor(Cursor.getPredefinedCursor(1));
        }
    }

    private strictfp class ColorAction
    extends AbstractAction {
        private final Color color;

        ColorAction(String name, Color color, String toolTip) {
            super(name);
            this.color = color;
            this.putValue("SmallIcon", new ColorIcon(color, 13, 13));
            if (toolTip != null) {
                this.putValue("ShortDescription", toolTip);
            }
        }

        public void actionPerformed(ActionEvent e) {
            EditorDialog.this.elementColor = this.color;
            if (EditorDialog.this.editingElements && EditorDialog.this.shapeView.getSelectedElement() != null) {
                EditorDialog.this.makeUndoableModification(EditorDialog.this.shapeView.getSelectedElement(), EditorDialog.this.shape.getElements().indexOf(EditorDialog.this.shapeView.getSelectedElement()));
                EditorDialog.this.shapeView.getSelectedElement().setColor(this.color);
                EditorDialog.this.shapeView.repaint();
            }
        }
    }
}

