/*
 * Decompiled with CFR 0.152.
 */
package org.nlogo.window;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.nlogo.agent.World;
import org.nlogo.api.AgentException;
import org.nlogo.api.CompilerException;
import org.nlogo.api.JobOwner;
import org.nlogo.api.LogoException;
import org.nlogo.api.Program;
import org.nlogo.api.ValueConstraint;
import org.nlogo.nvm.CompilerResults;
import org.nlogo.nvm.Procedure;
import org.nlogo.util.Exceptions;
import org.nlogo.window.Event;
import org.nlogo.window.Events;
import org.nlogo.window.ExternalFileInterface;
import org.nlogo.window.GUIWorkspace;
import org.nlogo.window.InterfaceGlobalWidget;
import org.nlogo.window.JobWidget;
import org.nlogo.window.ProceduresInterface;
import org.nlogo.window.Widget;
import org.nlogo.workspace.AbstractWorkspace;
import scala.Some;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public strictfp class CompilerManager
implements Event.LinkChild,
Events.CompileMoreSourceEvent.Handler,
Events.InterfaceGlobalEvent.Handler,
Events.LoadBeginEvent.Handler,
Events.LoadEndEvent.Handler,
Events.WidgetAddedEvent.Handler,
Events.WidgetRemovedEvent.Handler,
Events.CompileAllEvent.Handler {
    private final GUIWorkspace workspace;
    private final ProceduresInterface proceduresInterface;
    public final Set<JobOwner> widgets = new HashSet<JobOwner>();
    public final Set<InterfaceGlobalWidget> globalWidgets = new HashSet<InterfaceGlobalWidget>();
    private boolean isLoading = false;

    public CompilerManager(GUIWorkspace workspace, ProceduresInterface proceduresInterface) {
        this.workspace = workspace;
        this.proceduresInterface = proceduresInterface;
    }

    @Override
    public Object getLinkParent() {
        return this.workspace;
    }

    @Override
    public void handle(Events.LoadBeginEvent e) {
        this.isLoading = true;
        this.widgets.clear();
        this.globalWidgets.clear();
        this.workspace.world.clearLinks();
        this.workspace.world.program(this.workspace.world.newProgram());
        this.workspace.world.rememberOldProgram();
        Program program = this.workspace.world.newProgram();
        this.workspace.world.program(program);
        this.workspace.world.turtleBreedShapes.setUpBreedShapes(true, program.breeds());
        this.workspace.world.linkBreedShapes.setUpBreedShapes(true, program.linkBreeds());
    }

    @Override
    public void handle(Events.LoadEndEvent e) {
        this.isLoading = false;
        this.compileAll();
    }

    private void compileAll() {
        new Events.RemoveAllJobsEvent().raise(this);
        this.workspace.world.displayOn(true);
        if (!this.isLoading) {
            boolean proceed = this.compileProcedures();
            if (proceed) {
                this.workspace.world.realloc();
                this.workspace.world.rememberOldProgram();
                this.setGlobalVariables();
                this.compileWidgets();
            } else {
                this.updateInterfaceGlobalConstraints();
                this.resetWidgetProcedures();
            }
        }
    }

    private boolean compileProcedures() {
        this.workspace.world.program(this.workspace.world.newProgram());
        try {
            CompilerResults results = this.workspace.compiler().compileProgram(this.proceduresInterface.innerSource(), this.workspace.world.newProgram(this.getGlobalVariableNames()), this.workspace.getExtensionManager());
            this.workspace.setProcedures(results.proceduresMap());
            for (Procedure procedure : this.workspace.getProcedures().values()) {
                if (procedure.fileName.equals("")) {
                    procedure.setOwner(this.proceduresInterface);
                    continue;
                }
                if (procedure.fileName.equals("aggregate")) {
                    procedure.setOwner(this.workspace.aggregateManager());
                    continue;
                }
                procedure.setOwner(new ExternalFileInterface(procedure.fileName));
            }
            this.workspace.init();
            this.workspace.world.program(results.program());
            new Events.CompiledEvent(this.proceduresInterface, results.program(), null, null).raise(this);
            return true;
        }
        catch (CompilerException error) {
            if (AbstractWorkspace.isApplet()) {
                System.err.println("CompilerException: " + error);
                error.printStackTrace();
                new Events.CompiledEvent(this.proceduresInterface, null, null, error).raise(this);
            }
            if (error.fileName().equals("")) {
                new Events.CompiledEvent(this.proceduresInterface, null, null, error).raise(this);
            } else if (error.fileName().equals("aggregate")) {
                new Events.CompiledEvent(this.workspace.aggregateManager(), null, null, error).raise(this);
            } else {
                new Events.CompiledEvent(new ExternalFileInterface(error.fileName()), null, null, error).raise(this);
            }
            return false;
        }
    }

    private void setGlobalVariables() {
        for (InterfaceGlobalWidget w : this.globalWidgets) {
            try {
                this.workspace.world.setObserverVariableByName(w.name(), w.valueObject());
            }
            catch (AgentException ex) {
                throw new IllegalStateException(ex);
            }
            catch (LogoException ex) {
                throw new IllegalStateException(ex);
            }
        }
    }

    private void updateInterfaceGlobalConstraints() {
        for (InterfaceGlobalWidget w : this.globalWidgets) {
            w.updateConstraints();
        }
    }

    private void compileSource(JobOwner owner, List<Events.CompiledEvent> errorEvents) {
        try {
            CompilerResults results = this.workspace.compiler().compileMoreCode(owner.source(), Some.apply(owner.classDisplayName() + " '" + owner.displayName() + "'"), this.workspace.world.program(), this.workspace.getProcedures(), this.workspace.getExtensionManager());
            if (!results.procedures().isEmpty()) {
                results.head().init(this.workspace);
                results.head().setOwner(owner);
                new Events.CompiledEvent(owner, this.workspace.world.program(), results.head(), null).raise(this);
            }
        }
        catch (CompilerException error) {
            errorEvents.add(new Events.CompiledEvent(owner, this.workspace.world.program(), null, error));
        }
    }

    private void compileWidgets() {
        ArrayList<Events.CompiledEvent> errorEvents = new ArrayList<Events.CompiledEvent>();
        Iterator<JobOwner> iter2 = this.widgets.iterator();
        if (!iter2.hasNext()) {
            new Events.CompiledEvent(null, this.workspace.world.program(), null, null).raise(this);
        }
        while (iter2.hasNext()) {
            JobOwner owner = iter2.next();
            if (owner.isCommandCenter()) continue;
            this.compileSource(owner, errorEvents);
        }
        for (Events.CompiledEvent event : errorEvents) {
            event.raise(this);
        }
        this.updateInterfaceGlobalConstraints();
    }

    private void resetWidgetProcedures() {
        for (JobOwner owner : this.widgets) {
            if (!(owner instanceof JobWidget)) continue;
            ((JobWidget)owner).procedure(null);
        }
    }

    @Override
    public void handle(Events.CompileMoreSourceEvent e) {
        JobOwner owner = e.owner;
        if (this.isLoading) {
            this.widgets.add(owner);
            return;
        }
        if (owner.isCommandCenter()) {
            try {
                CompilerResults results = this.workspace.compiler().compileMoreCode(owner.source(), Some.apply(owner.classDisplayName()), this.workspace.world.program(), this.workspace.getProcedures(), this.workspace.getExtensionManager());
                results.head().init(this.workspace);
                results.head().setOwner(owner);
                new Events.CompiledEvent(owner, this.workspace.world.program(), results.head(), null).raise(this);
            }
            catch (CompilerException error) {
                new Events.CompiledEvent(owner, this.workspace.world.program(), null, error).raise(this);
            }
        } else {
            this.compileWidgets();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handle(Events.InterfaceGlobalEvent e) {
        block11: {
            InterfaceGlobalWidget widget = e.widget;
            this.globalWidgets.add(e.widget);
            if (e.nameChanged) {
                this.compileAll();
            } else if (this.workspace.world.observerOwnsIndexOf(widget.name().toUpperCase()) != -1) {
                if (e.updating) {
                    widget.valueObject(this.workspace.world.getObserverVariableByName(widget.name()));
                }
                try {
                    Object val = widget.valueObject();
                    if (val == this.workspace.world.getObserverVariableByName(widget.name())) break block11;
                    World world = this.workspace.world;
                    synchronized (world) {
                        this.workspace.world.setObserverVariableByName(widget.name(), widget.valueObject());
                    }
                }
                catch (ValueConstraint.Violation ex) {
                    Exceptions.ignore(ex);
                }
                catch (AgentException ex) {
                    throw new IllegalStateException(ex);
                }
                catch (LogoException ex) {
                    Exceptions.ignore(ex);
                }
            }
        }
    }

    @Override
    public void handle(Events.WidgetAddedEvent e) {
        Widget w = e.widget;
        if (w instanceof JobOwner) {
            this.widgets.add((JobOwner)((Object)w));
        }
        if (w instanceof InterfaceGlobalWidget) {
            this.globalWidgets.add((InterfaceGlobalWidget)((Object)w));
        }
    }

    @Override
    public void handle(Events.CompileAllEvent e) {
        this.compileAll();
    }

    @Override
    public void handle(Events.WidgetRemovedEvent e) {
        this.widgets.remove(e.widget);
        this.globalWidgets.remove(e.widget);
    }

    private List<String> getGlobalVariableNames() {
        ArrayList<String> result2 = new ArrayList<String>();
        for (InterfaceGlobalWidget w : this.globalWidgets) {
            result2.add(w.name());
        }
        return result2;
    }
}

