/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.asm.util;

import java.io.FileInputStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.objectweb.asm.AnnotationVisitor;
import org.objectweb.asm.Attribute;
import org.objectweb.asm.ClassAdapter;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.FieldVisitor;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.TryCatchBlockNode;
import org.objectweb.asm.tree.analysis.Analyzer;
import org.objectweb.asm.tree.analysis.Frame;
import org.objectweb.asm.tree.analysis.SimpleVerifier;
import org.objectweb.asm.util.CheckAnnotationAdapter;
import org.objectweb.asm.util.CheckFieldAdapter;
import org.objectweb.asm.util.CheckMethodAdapter;
import org.objectweb.asm.util.TraceMethodVisitor;

public class CheckClassAdapter
extends ClassAdapter {
    private int version;
    private boolean start;
    private boolean source;
    private boolean outer;
    private boolean end;
    private Map labels = new HashMap();
    private boolean checkDataFlow;

    public static void main(String[] stringArray) throws Exception {
        if (stringArray.length != 1) {
            System.err.println("Verifies the given class.");
            System.err.println("Usage: CheckClassAdapter <fully qualified class name or class file name>");
            return;
        }
        ClassReader classReader = stringArray[0].endsWith(".class") ? new ClassReader(new FileInputStream(stringArray[0])) : new ClassReader(stringArray[0]);
        CheckClassAdapter.verify(classReader, false, new PrintWriter(System.err));
    }

    public static void verify(ClassReader classReader, ClassLoader classLoader, boolean bl, PrintWriter printWriter) {
        ClassNode classNode = new ClassNode();
        classReader.accept(new CheckClassAdapter(classNode, false), 2);
        Type type = classNode.superName == null ? null : Type.getObjectType(classNode.superName);
        List list2 = classNode.methods;
        ArrayList<Type> arrayList = new ArrayList<Type>();
        Iterator iterator2 = classNode.interfaces.iterator();
        while (iterator2.hasNext()) {
            arrayList.add(Type.getObjectType(iterator2.next().toString()));
        }
        for (int i = 0; i < list2.size(); ++i) {
            MethodNode methodNode = (MethodNode)list2.get(i);
            SimpleVerifier simpleVerifier = new SimpleVerifier(Type.getObjectType(classNode.name), type, arrayList, (classNode.access | 0x200) != 0);
            Analyzer analyzer = new Analyzer(simpleVerifier);
            if (classLoader != null) {
                simpleVerifier.setClassLoader(classLoader);
            }
            try {
                analyzer.analyze(classNode.name, methodNode);
                if (!bl) {
                    continue;
                }
            }
            catch (Exception exception) {
                exception.printStackTrace(printWriter);
            }
            CheckClassAdapter.printAnalyzerResult(methodNode, analyzer, printWriter);
        }
        printWriter.flush();
    }

    public static void verify(ClassReader classReader, boolean bl, PrintWriter printWriter) {
        CheckClassAdapter.verify(classReader, null, bl, printWriter);
    }

    static void printAnalyzerResult(MethodNode methodNode, Analyzer analyzer, PrintWriter printWriter) {
        int n;
        Frame[] frameArray = analyzer.getFrames();
        TraceMethodVisitor traceMethodVisitor = new TraceMethodVisitor();
        printWriter.println(methodNode.name + methodNode.desc);
        for (n = 0; n < methodNode.instructions.size(); ++n) {
            methodNode.instructions.get(n).accept(traceMethodVisitor);
            StringBuffer stringBuffer = new StringBuffer();
            Frame frame = frameArray[n];
            if (frame == null) {
                stringBuffer.append('?');
            } else {
                int n2;
                for (n2 = 0; n2 < frame.getLocals(); ++n2) {
                    stringBuffer.append(CheckClassAdapter.getShortName(frame.getLocal(n2).toString())).append(' ');
                }
                stringBuffer.append(" : ");
                for (n2 = 0; n2 < frame.getStackSize(); ++n2) {
                    stringBuffer.append(CheckClassAdapter.getShortName(frame.getStack(n2).toString())).append(' ');
                }
            }
            while (stringBuffer.length() < methodNode.maxStack + methodNode.maxLocals + 1) {
                stringBuffer.append(' ');
            }
            printWriter.print(Integer.toString(n + 100000).substring(1));
            printWriter.print(" " + stringBuffer + " : " + traceMethodVisitor.buf);
        }
        for (n = 0; n < methodNode.tryCatchBlocks.size(); ++n) {
            ((TryCatchBlockNode)methodNode.tryCatchBlocks.get(n)).accept(traceMethodVisitor);
            printWriter.print(" " + traceMethodVisitor.buf);
        }
        printWriter.println();
    }

    private static String getShortName(String string2) {
        int n = string2.lastIndexOf(47);
        int n2 = string2.length();
        if (string2.charAt(n2 - 1) == ';') {
            --n2;
        }
        return n == -1 ? string2 : string2.substring(n + 1, n2);
    }

    public CheckClassAdapter(ClassVisitor classVisitor) {
        this(classVisitor, true);
    }

    public CheckClassAdapter(ClassVisitor classVisitor, boolean bl) {
        super(classVisitor);
        this.checkDataFlow = bl;
    }

    public void visit(int n, int n2, String string2, String string3, String string4, String[] stringArray) {
        if (this.start) {
            throw new IllegalStateException("visit must be called only once");
        }
        this.start = true;
        this.checkState();
        CheckClassAdapter.checkAccess(n2, 423473);
        if (string2 == null || !string2.endsWith("package-info")) {
            CheckMethodAdapter.checkInternalName(string2, "class name");
        }
        if ("java/lang/Object".equals(string2)) {
            if (string4 != null) {
                throw new IllegalArgumentException("The super class name of the Object class must be 'null'");
            }
        } else {
            CheckMethodAdapter.checkInternalName(string4, "super class name");
        }
        if (string3 != null) {
            CheckMethodAdapter.checkClassSignature(string3);
        }
        if ((n2 & 0x200) != 0 && !"java/lang/Object".equals(string4)) {
            throw new IllegalArgumentException("The super class name of interfaces must be 'java/lang/Object'");
        }
        if (stringArray != null) {
            for (int i = 0; i < stringArray.length; ++i) {
                CheckMethodAdapter.checkInternalName(stringArray[i], "interface name at index " + i);
            }
        }
        this.version = n;
        this.cv.visit(n, n2, string2, string3, string4, stringArray);
    }

    public void visitSource(String string2, String string3) {
        this.checkState();
        if (this.source) {
            throw new IllegalStateException("visitSource can be called only once.");
        }
        this.source = true;
        this.cv.visitSource(string2, string3);
    }

    public void visitOuterClass(String string2, String string3, String string4) {
        this.checkState();
        if (this.outer) {
            throw new IllegalStateException("visitOuterClass can be called only once.");
        }
        this.outer = true;
        if (string2 == null) {
            throw new IllegalArgumentException("Illegal outer class owner");
        }
        if (string4 != null) {
            CheckMethodAdapter.checkMethodDesc(string4);
        }
        this.cv.visitOuterClass(string2, string3, string4);
    }

    public void visitInnerClass(String string2, String string3, String string4, int n) {
        this.checkState();
        CheckMethodAdapter.checkInternalName(string2, "class name");
        if (string3 != null) {
            CheckMethodAdapter.checkInternalName(string3, "outer class name");
        }
        if (string4 != null) {
            CheckMethodAdapter.checkIdentifier(string4, "inner class name");
        }
        CheckClassAdapter.checkAccess(n, 30239);
        this.cv.visitInnerClass(string2, string3, string4, n);
    }

    public FieldVisitor visitField(int n, String string2, String string3, String string4, Object object) {
        this.checkState();
        CheckClassAdapter.checkAccess(n, 413919);
        CheckMethodAdapter.checkUnqualifiedName(this.version, string2, "field name");
        CheckMethodAdapter.checkDesc(string3, false);
        if (string4 != null) {
            CheckMethodAdapter.checkFieldSignature(string4);
        }
        if (object != null) {
            CheckMethodAdapter.checkConstant(object);
        }
        FieldVisitor fieldVisitor = this.cv.visitField(n, string2, string3, string4, object);
        return new CheckFieldAdapter(fieldVisitor);
    }

    public MethodVisitor visitMethod(int n, String string2, String string3, String string4, String[] stringArray) {
        this.checkState();
        CheckClassAdapter.checkAccess(n, 400895);
        CheckMethodAdapter.checkMethodIdentifier(this.version, string2, "method name");
        CheckMethodAdapter.checkMethodDesc(string3);
        if (string4 != null) {
            CheckMethodAdapter.checkMethodSignature(string4);
        }
        if (stringArray != null) {
            for (int i = 0; i < stringArray.length; ++i) {
                CheckMethodAdapter.checkInternalName(stringArray[i], "exception name at index " + i);
            }
        }
        CheckMethodAdapter checkMethodAdapter = this.checkDataFlow ? new CheckMethodAdapter(n, string2, string3, this.cv.visitMethod(n, string2, string3, string4, stringArray), this.labels) : new CheckMethodAdapter(this.cv.visitMethod(n, string2, string3, string4, stringArray), this.labels);
        checkMethodAdapter.version = this.version;
        return checkMethodAdapter;
    }

    public AnnotationVisitor visitAnnotation(String string2, boolean bl) {
        this.checkState();
        CheckMethodAdapter.checkDesc(string2, false);
        return new CheckAnnotationAdapter(this.cv.visitAnnotation(string2, bl));
    }

    public void visitAttribute(Attribute attribute) {
        this.checkState();
        if (attribute == null) {
            throw new IllegalArgumentException("Invalid attribute (must not be null)");
        }
        this.cv.visitAttribute(attribute);
    }

    public void visitEnd() {
        this.checkState();
        this.end = true;
        this.cv.visitEnd();
    }

    private void checkState() {
        if (!this.start) {
            throw new IllegalStateException("Cannot visit member before visit has been called.");
        }
        if (this.end) {
            throw new IllegalStateException("Cannot visit member after visitEnd has been called.");
        }
    }

    static void checkAccess(int n, int n2) {
        int n3;
        int n4;
        if ((n & ~n2) != 0) {
            throw new IllegalArgumentException("Invalid access flags: " + n);
        }
        int n5 = (n & 1) == 0 ? 0 : 1;
        int n6 = (n & 2) == 0 ? 0 : 1;
        int n7 = n4 = (n & 4) == 0 ? 0 : 1;
        if (n5 + n6 + n4 > 1) {
            throw new IllegalArgumentException("public private and protected are mutually exclusive: " + n);
        }
        int n8 = (n & 0x10) == 0 ? 0 : 1;
        int n9 = n3 = (n & 0x400) == 0 ? 0 : 1;
        if (n8 + n3 > 1) {
            throw new IllegalArgumentException("final and abstract are mutually exclusive: " + n);
        }
    }
}

