/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.asm.util;

import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Map;
import org.objectweb.asm.AnnotationVisitor;
import org.objectweb.asm.Attribute;
import org.objectweb.asm.Label;
import org.objectweb.asm.MethodAdapter;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Opcodes;
import org.objectweb.asm.Type;
import org.objectweb.asm.util.CheckAnnotationAdapter;
import org.objectweb.asm.util.CheckMethodAdapter$1;

public class CheckMethodAdapter
extends MethodAdapter {
    public int version;
    private boolean startCode;
    private boolean endCode;
    private boolean endMethod;
    private final Map labels;
    private static final int[] TYPE;
    private static Field labelStatusField;
    static /* synthetic */ Class class$org$objectweb$asm$Label;

    public CheckMethodAdapter(MethodVisitor methodVisitor) {
        this(methodVisitor, new HashMap());
    }

    public CheckMethodAdapter(MethodVisitor methodVisitor, Map map2) {
        super(methodVisitor);
        this.labels = map2;
    }

    public CheckMethodAdapter(int n, String string2, String string3, MethodVisitor methodVisitor, Map map2) {
        this(new CheckMethodAdapter$1(n, string2, string3, null, null, methodVisitor), map2);
    }

    public AnnotationVisitor visitAnnotation(String string2, boolean bl) {
        this.checkEndMethod();
        CheckMethodAdapter.checkDesc(string2, false);
        return new CheckAnnotationAdapter(this.mv.visitAnnotation(string2, bl));
    }

    public AnnotationVisitor visitAnnotationDefault() {
        this.checkEndMethod();
        return new CheckAnnotationAdapter(this.mv.visitAnnotationDefault(), false);
    }

    public AnnotationVisitor visitParameterAnnotation(int n, String string2, boolean bl) {
        this.checkEndMethod();
        CheckMethodAdapter.checkDesc(string2, false);
        return new CheckAnnotationAdapter(this.mv.visitParameterAnnotation(n, string2, bl));
    }

    public void visitAttribute(Attribute attribute) {
        this.checkEndMethod();
        if (attribute == null) {
            throw new IllegalArgumentException("Invalid attribute (must not be null)");
        }
        this.mv.visitAttribute(attribute);
    }

    public void visitCode() {
        this.startCode = true;
        this.mv.visitCode();
    }

    public void visitFrame(int n, int n2, Object[] objectArray, int n3, Object[] objectArray2) {
        int n4;
        int n5;
        int n6;
        switch (n) {
            case -1: 
            case 0: {
                n6 = Integer.MAX_VALUE;
                n5 = Integer.MAX_VALUE;
                break;
            }
            case 3: {
                n6 = 0;
                n5 = 0;
                break;
            }
            case 4: {
                n6 = 0;
                n5 = 1;
                break;
            }
            case 1: 
            case 2: {
                n6 = 3;
                n5 = 0;
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid frame type " + n);
            }
        }
        if (n2 > n6) {
            throw new IllegalArgumentException("Invalid nLocal=" + n2 + " for frame type " + n);
        }
        if (n3 > n5) {
            throw new IllegalArgumentException("Invalid nStack=" + n3 + " for frame type " + n);
        }
        if (n != 2) {
            if (n2 > 0 && (objectArray == null || objectArray.length < n2)) {
                throw new IllegalArgumentException("Array local[] is shorter than nLocal");
            }
            for (n4 = 0; n4 < n2; ++n4) {
                CheckMethodAdapter.checkFrameValue(objectArray[n4]);
            }
        }
        if (n3 > 0 && (objectArray2 == null || objectArray2.length < n3)) {
            throw new IllegalArgumentException("Array stack[] is shorter than nStack");
        }
        for (n4 = 0; n4 < n3; ++n4) {
            CheckMethodAdapter.checkFrameValue(objectArray2[n4]);
        }
        this.mv.visitFrame(n, n2, objectArray, n3, objectArray2);
    }

    public void visitInsn(int n) {
        this.checkStartCode();
        this.checkEndCode();
        CheckMethodAdapter.checkOpcode(n, 0);
        this.mv.visitInsn(n);
    }

    public void visitIntInsn(int n, int n2) {
        this.checkStartCode();
        this.checkEndCode();
        CheckMethodAdapter.checkOpcode(n, 1);
        switch (n) {
            case 16: {
                CheckMethodAdapter.checkSignedByte(n2, "Invalid operand");
                break;
            }
            case 17: {
                CheckMethodAdapter.checkSignedShort(n2, "Invalid operand");
                break;
            }
            default: {
                if (n2 >= 4 && n2 <= 11) break;
                throw new IllegalArgumentException("Invalid operand (must be an array type code T_...): " + n2);
            }
        }
        this.mv.visitIntInsn(n, n2);
    }

    public void visitVarInsn(int n, int n2) {
        this.checkStartCode();
        this.checkEndCode();
        CheckMethodAdapter.checkOpcode(n, 2);
        CheckMethodAdapter.checkUnsignedShort(n2, "Invalid variable index");
        this.mv.visitVarInsn(n, n2);
    }

    public void visitTypeInsn(int n, String string2) {
        this.checkStartCode();
        this.checkEndCode();
        CheckMethodAdapter.checkOpcode(n, 3);
        CheckMethodAdapter.checkInternalName(string2, "type");
        if (n == 187 && string2.charAt(0) == '[') {
            throw new IllegalArgumentException("NEW cannot be used to create arrays: " + string2);
        }
        this.mv.visitTypeInsn(n, string2);
    }

    public void visitFieldInsn(int n, String string2, String string3, String string4) {
        this.checkStartCode();
        this.checkEndCode();
        CheckMethodAdapter.checkOpcode(n, 4);
        CheckMethodAdapter.checkInternalName(string2, "owner");
        CheckMethodAdapter.checkUnqualifiedName(this.version, string3, "name");
        CheckMethodAdapter.checkDesc(string4, false);
        this.mv.visitFieldInsn(n, string2, string3, string4);
    }

    public void visitMethodInsn(int n, String string2, String string3, String string4) {
        this.checkStartCode();
        this.checkEndCode();
        CheckMethodAdapter.checkOpcode(n, 5);
        CheckMethodAdapter.checkMethodIdentifier(this.version, string3, "name");
        CheckMethodAdapter.checkInternalName(string2, "owner");
        CheckMethodAdapter.checkMethodDesc(string4);
        if (n == 186 && string2 != "java/lang/dyn/Dynamic") {
            throw new IllegalArgumentException("INVOKEDYNAMIC cannot be used with another owner than INVOKEDYNAMIC_OWNER");
        }
        this.mv.visitMethodInsn(n, string2, string3, string4);
    }

    public void visitJumpInsn(int n, Label label) {
        this.checkStartCode();
        this.checkEndCode();
        CheckMethodAdapter.checkOpcode(n, 6);
        this.checkLabel(label, false, "label");
        CheckMethodAdapter.checkNonDebugLabel(label);
        this.mv.visitJumpInsn(n, label);
    }

    public void visitLabel(Label label) {
        this.checkStartCode();
        this.checkEndCode();
        this.checkLabel(label, false, "label");
        if (this.labels.get(label) != null) {
            throw new IllegalArgumentException("Already visited label");
        }
        this.labels.put(label, new Integer(this.labels.size()));
        this.mv.visitLabel(label);
    }

    public void visitLdcInsn(Object object) {
        this.checkStartCode();
        this.checkEndCode();
        if (!(object instanceof Type)) {
            CheckMethodAdapter.checkConstant(object);
        }
        this.mv.visitLdcInsn(object);
    }

    public void visitIincInsn(int n, int n2) {
        this.checkStartCode();
        this.checkEndCode();
        CheckMethodAdapter.checkUnsignedShort(n, "Invalid variable index");
        CheckMethodAdapter.checkSignedShort(n2, "Invalid increment");
        this.mv.visitIincInsn(n, n2);
    }

    public void visitTableSwitchInsn(int n, int n2, Label label, Label[] labelArray) {
        this.checkStartCode();
        this.checkEndCode();
        if (n2 < n) {
            throw new IllegalArgumentException("Max = " + n2 + " must be greater than or equal to min = " + n);
        }
        this.checkLabel(label, false, "default label");
        CheckMethodAdapter.checkNonDebugLabel(label);
        if (labelArray == null || labelArray.length != n2 - n + 1) {
            throw new IllegalArgumentException("There must be max - min + 1 labels");
        }
        for (int i = 0; i < labelArray.length; ++i) {
            this.checkLabel(labelArray[i], false, "label at index " + i);
            CheckMethodAdapter.checkNonDebugLabel(labelArray[i]);
        }
        this.mv.visitTableSwitchInsn(n, n2, label, labelArray);
    }

    public void visitLookupSwitchInsn(Label label, int[] nArray, Label[] labelArray) {
        this.checkEndCode();
        this.checkStartCode();
        this.checkLabel(label, false, "default label");
        CheckMethodAdapter.checkNonDebugLabel(label);
        if (nArray == null || labelArray == null || nArray.length != labelArray.length) {
            throw new IllegalArgumentException("There must be the same number of keys and labels");
        }
        for (int i = 0; i < labelArray.length; ++i) {
            this.checkLabel(labelArray[i], false, "label at index " + i);
            CheckMethodAdapter.checkNonDebugLabel(labelArray[i]);
        }
        this.mv.visitLookupSwitchInsn(label, nArray, labelArray);
    }

    public void visitMultiANewArrayInsn(String string2, int n) {
        this.checkStartCode();
        this.checkEndCode();
        CheckMethodAdapter.checkDesc(string2, false);
        if (string2.charAt(0) != '[') {
            throw new IllegalArgumentException("Invalid descriptor (must be an array type descriptor): " + string2);
        }
        if (n < 1) {
            throw new IllegalArgumentException("Invalid dimensions (must be greater than 0): " + n);
        }
        if (n > string2.lastIndexOf(91) + 1) {
            throw new IllegalArgumentException("Invalid dimensions (must not be greater than dims(desc)): " + n);
        }
        this.mv.visitMultiANewArrayInsn(string2, n);
    }

    public void visitTryCatchBlock(Label label, Label label2, Label label3, String string2) {
        this.checkStartCode();
        this.checkEndCode();
        this.checkLabel(label, false, "start label");
        this.checkLabel(label2, false, "end label");
        this.checkLabel(label3, false, "handler label");
        CheckMethodAdapter.checkNonDebugLabel(label);
        CheckMethodAdapter.checkNonDebugLabel(label2);
        CheckMethodAdapter.checkNonDebugLabel(label3);
        if (this.labels.get(label) != null || this.labels.get(label2) != null || this.labels.get(label3) != null) {
            throw new IllegalStateException("Try catch blocks must be visited before their labels");
        }
        if (string2 != null) {
            CheckMethodAdapter.checkInternalName(string2, "type");
        }
        this.mv.visitTryCatchBlock(label, label2, label3, string2);
    }

    public void visitLocalVariable(String string2, String string3, String string4, Label label, Label label2, int n) {
        this.checkStartCode();
        this.checkEndCode();
        CheckMethodAdapter.checkUnqualifiedName(this.version, string2, "name");
        CheckMethodAdapter.checkDesc(string3, false);
        this.checkLabel(label, true, "start label");
        this.checkLabel(label2, true, "end label");
        CheckMethodAdapter.checkUnsignedShort(n, "Invalid variable index");
        int n2 = (Integer)this.labels.get(label);
        int n3 = (Integer)this.labels.get(label2);
        if (n3 < n2) {
            throw new IllegalArgumentException("Invalid start and end labels (end must be greater than start)");
        }
        this.mv.visitLocalVariable(string2, string3, string4, label, label2, n);
    }

    public void visitLineNumber(int n, Label label) {
        this.checkStartCode();
        this.checkEndCode();
        CheckMethodAdapter.checkUnsignedShort(n, "Invalid line number");
        this.checkLabel(label, true, "start label");
        this.mv.visitLineNumber(n, label);
    }

    public void visitMaxs(int n, int n2) {
        this.checkStartCode();
        this.checkEndCode();
        this.endCode = true;
        CheckMethodAdapter.checkUnsignedShort(n, "Invalid max stack");
        CheckMethodAdapter.checkUnsignedShort(n2, "Invalid max locals");
        this.mv.visitMaxs(n, n2);
    }

    public void visitEnd() {
        this.checkEndMethod();
        this.endMethod = true;
        this.mv.visitEnd();
    }

    void checkStartCode() {
        if (!this.startCode) {
            throw new IllegalStateException("Cannot visit instructions before visitCode has been called.");
        }
    }

    void checkEndCode() {
        if (this.endCode) {
            throw new IllegalStateException("Cannot visit instructions after visitMaxs has been called.");
        }
    }

    void checkEndMethod() {
        if (this.endMethod) {
            throw new IllegalStateException("Cannot visit elements after visitEnd has been called.");
        }
    }

    static void checkFrameValue(Object object) {
        if (object == Opcodes.TOP || object == Opcodes.INTEGER || object == Opcodes.FLOAT || object == Opcodes.LONG || object == Opcodes.DOUBLE || object == Opcodes.NULL || object == Opcodes.UNINITIALIZED_THIS) {
            return;
        }
        if (object instanceof String) {
            CheckMethodAdapter.checkInternalName((String)object, "Invalid stack frame value");
            return;
        }
        if (!(object instanceof Label)) {
            throw new IllegalArgumentException("Invalid stack frame value: " + object);
        }
    }

    static void checkOpcode(int n, int n2) {
        if (n < 0 || n > 199 || TYPE[n] != n2) {
            throw new IllegalArgumentException("Invalid opcode: " + n);
        }
    }

    static void checkSignedByte(int n, String string2) {
        if (n < -128 || n > 127) {
            throw new IllegalArgumentException(string2 + " (must be a signed byte): " + n);
        }
    }

    static void checkSignedShort(int n, String string2) {
        if (n < Short.MIN_VALUE || n > Short.MAX_VALUE) {
            throw new IllegalArgumentException(string2 + " (must be a signed short): " + n);
        }
    }

    static void checkUnsignedShort(int n, String string2) {
        if (n < 0 || n > 65535) {
            throw new IllegalArgumentException(string2 + " (must be an unsigned short): " + n);
        }
    }

    static void checkConstant(Object object) {
        if (!(object instanceof Integer || object instanceof Float || object instanceof Long || object instanceof Double || object instanceof String)) {
            throw new IllegalArgumentException("Invalid constant: " + object);
        }
    }

    static void checkUnqualifiedName(int n, String string2, String string3) {
        if ((n & 0xFFFF) < 49) {
            CheckMethodAdapter.checkIdentifier(string2, string3);
        } else {
            for (int i = 0; i < string2.length(); ++i) {
                if (".;[/".indexOf(string2.charAt(i)) == -1) continue;
                throw new IllegalArgumentException("Invalid " + string3 + " (must be a valid unqualified name): " + string2);
            }
        }
    }

    static void checkIdentifier(String string2, String string3) {
        CheckMethodAdapter.checkIdentifier(string2, 0, -1, string3);
    }

    static void checkIdentifier(String string2, int n, int n2, String string3) {
        if (string2 == null || (n2 == -1 ? string2.length() <= n : n2 <= n)) {
            throw new IllegalArgumentException("Invalid " + string3 + " (must not be null or empty)");
        }
        if (!Character.isJavaIdentifierStart(string2.charAt(n))) {
            throw new IllegalArgumentException("Invalid " + string3 + " (must be a valid Java identifier): " + string2);
        }
        int n3 = n2 == -1 ? string2.length() : n2;
        for (int i = n + 1; i < n3; ++i) {
            if (Character.isJavaIdentifierPart(string2.charAt(i))) continue;
            throw new IllegalArgumentException("Invalid " + string3 + " (must be a valid Java identifier): " + string2);
        }
    }

    static void checkMethodIdentifier(int n, String string2, String string3) {
        if (string2 == null || string2.length() == 0) {
            throw new IllegalArgumentException("Invalid " + string3 + " (must not be null or empty)");
        }
        if ("<init>".equals(string2) || "<clinit>".equals(string2)) {
            return;
        }
        if ((n & 0xFFFF) >= 49) {
            for (int i = 0; i < string2.length(); ++i) {
                if (".;[/<>".indexOf(string2.charAt(i)) == -1) continue;
                throw new IllegalArgumentException("Invalid " + string3 + " (must be a valid unqualified name): " + string2);
            }
            return;
        }
        if (!Character.isJavaIdentifierStart(string2.charAt(0))) {
            throw new IllegalArgumentException("Invalid " + string3 + " (must be a '<init>', '<clinit>' or a valid Java identifier): " + string2);
        }
        for (int i = 1; i < string2.length(); ++i) {
            if (Character.isJavaIdentifierPart(string2.charAt(i))) continue;
            throw new IllegalArgumentException("Invalid " + string3 + " (must be '<init>' or '<clinit>' or a valid Java identifier): " + string2);
        }
    }

    static void checkInternalName(String string2, String string3) {
        if (string2 == null || string2.length() == 0) {
            throw new IllegalArgumentException("Invalid " + string3 + " (must not be null or empty)");
        }
        if (string2.charAt(0) == '[') {
            CheckMethodAdapter.checkDesc(string2, false);
        } else {
            CheckMethodAdapter.checkInternalName(string2, 0, -1, string3);
        }
    }

    static void checkInternalName(String string2, int n, int n2, String string3) {
        int n3 = n2 == -1 ? string2.length() : n2;
        try {
            int n4;
            int n5 = n;
            do {
                if ((n4 = string2.indexOf(47, n5 + 1)) == -1 || n4 > n3) {
                    n4 = n3;
                }
                CheckMethodAdapter.checkIdentifier(string2, n5, n4, null);
                n5 = n4 + 1;
            } while (n4 != n3);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new IllegalArgumentException("Invalid " + string3 + " (must be a fully qualified class name in internal form): " + string2);
        }
    }

    static void checkDesc(String string2, boolean bl) {
        int n = CheckMethodAdapter.checkDesc(string2, 0, bl);
        if (n != string2.length()) {
            throw new IllegalArgumentException("Invalid descriptor: " + string2);
        }
    }

    static int checkDesc(String string2, int n, boolean bl) {
        if (string2 == null || n >= string2.length()) {
            throw new IllegalArgumentException("Invalid type descriptor (must not be null or empty)");
        }
        switch (string2.charAt(n)) {
            case 'V': {
                if (bl) {
                    return n + 1;
                }
                throw new IllegalArgumentException("Invalid descriptor: " + string2);
            }
            case 'B': 
            case 'C': 
            case 'D': 
            case 'F': 
            case 'I': 
            case 'J': 
            case 'S': 
            case 'Z': {
                return n + 1;
            }
            case '[': {
                int n2;
                for (n2 = n + 1; n2 < string2.length() && string2.charAt(n2) == '['; ++n2) {
                }
                if (n2 < string2.length()) {
                    return CheckMethodAdapter.checkDesc(string2, n2, false);
                }
                throw new IllegalArgumentException("Invalid descriptor: " + string2);
            }
            case 'L': {
                int n3 = string2.indexOf(59, n);
                if (n3 == -1 || n3 - n < 2) {
                    throw new IllegalArgumentException("Invalid descriptor: " + string2);
                }
                try {
                    CheckMethodAdapter.checkInternalName(string2, n + 1, n3, null);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw new IllegalArgumentException("Invalid descriptor: " + string2);
                }
                return n3 + 1;
            }
        }
        throw new IllegalArgumentException("Invalid descriptor: " + string2);
    }

    static void checkMethodDesc(String string2) {
        if (string2 == null || string2.length() == 0) {
            throw new IllegalArgumentException("Invalid method descriptor (must not be null or empty)");
        }
        if (string2.charAt(0) != '(' || string2.length() < 3) {
            throw new IllegalArgumentException("Invalid descriptor: " + string2);
        }
        int n = 1;
        if (string2.charAt(n) != ')') {
            do {
                if (string2.charAt(n) != 'V') continue;
                throw new IllegalArgumentException("Invalid descriptor: " + string2);
            } while ((n = CheckMethodAdapter.checkDesc(string2, n, false)) < string2.length() && string2.charAt(n) != ')');
        }
        if ((n = CheckMethodAdapter.checkDesc(string2, n + 1, true)) != string2.length()) {
            throw new IllegalArgumentException("Invalid descriptor: " + string2);
        }
    }

    static void checkClassSignature(String string2) {
        int n = 0;
        if (CheckMethodAdapter.getChar(string2, 0) == '<') {
            n = CheckMethodAdapter.checkFormalTypeParameters(string2, n);
        }
        n = CheckMethodAdapter.checkClassTypeSignature(string2, n);
        while (CheckMethodAdapter.getChar(string2, n) == 'L') {
            n = CheckMethodAdapter.checkClassTypeSignature(string2, n);
        }
        if (n != string2.length()) {
            throw new IllegalArgumentException(string2 + ": error at index " + n);
        }
    }

    static void checkMethodSignature(String string2) {
        int n = 0;
        if (CheckMethodAdapter.getChar(string2, 0) == '<') {
            n = CheckMethodAdapter.checkFormalTypeParameters(string2, n);
        }
        n = CheckMethodAdapter.checkChar('(', string2, n);
        while ("ZCBSIFJDL[T".indexOf(CheckMethodAdapter.getChar(string2, n)) != -1) {
            n = CheckMethodAdapter.checkTypeSignature(string2, n);
        }
        n = CheckMethodAdapter.getChar(string2, n = CheckMethodAdapter.checkChar(')', string2, n)) == 'V' ? ++n : CheckMethodAdapter.checkTypeSignature(string2, n);
        while (CheckMethodAdapter.getChar(string2, n) == '^') {
            if (CheckMethodAdapter.getChar(string2, ++n) == 'L') {
                n = CheckMethodAdapter.checkClassTypeSignature(string2, n);
                continue;
            }
            n = CheckMethodAdapter.checkTypeVariableSignature(string2, n);
        }
        if (n != string2.length()) {
            throw new IllegalArgumentException(string2 + ": error at index " + n);
        }
    }

    static void checkFieldSignature(String string2) {
        int n = CheckMethodAdapter.checkFieldTypeSignature(string2, 0);
        if (n != string2.length()) {
            throw new IllegalArgumentException(string2 + ": error at index " + n);
        }
    }

    private static int checkFormalTypeParameters(String string2, int n) {
        n = CheckMethodAdapter.checkChar('<', string2, n);
        n = CheckMethodAdapter.checkFormalTypeParameter(string2, n);
        while (CheckMethodAdapter.getChar(string2, n) != '>') {
            n = CheckMethodAdapter.checkFormalTypeParameter(string2, n);
        }
        return n + 1;
    }

    private static int checkFormalTypeParameter(String string2, int n) {
        n = CheckMethodAdapter.checkIdentifier(string2, n);
        if ("L[T".indexOf(CheckMethodAdapter.getChar(string2, n = CheckMethodAdapter.checkChar(':', string2, n))) != -1) {
            n = CheckMethodAdapter.checkFieldTypeSignature(string2, n);
        }
        while (CheckMethodAdapter.getChar(string2, n) == ':') {
            n = CheckMethodAdapter.checkFieldTypeSignature(string2, n + 1);
        }
        return n;
    }

    private static int checkFieldTypeSignature(String string2, int n) {
        switch (CheckMethodAdapter.getChar(string2, n)) {
            case 'L': {
                return CheckMethodAdapter.checkClassTypeSignature(string2, n);
            }
            case '[': {
                return CheckMethodAdapter.checkTypeSignature(string2, n + 1);
            }
        }
        return CheckMethodAdapter.checkTypeVariableSignature(string2, n);
    }

    private static int checkClassTypeSignature(String string2, int n) {
        n = CheckMethodAdapter.checkChar('L', string2, n);
        n = CheckMethodAdapter.checkIdentifier(string2, n);
        while (CheckMethodAdapter.getChar(string2, n) == '/') {
            n = CheckMethodAdapter.checkIdentifier(string2, n + 1);
        }
        if (CheckMethodAdapter.getChar(string2, n) == '<') {
            n = CheckMethodAdapter.checkTypeArguments(string2, n);
        }
        while (CheckMethodAdapter.getChar(string2, n) == '.') {
            if (CheckMethodAdapter.getChar(string2, n = CheckMethodAdapter.checkIdentifier(string2, n + 1)) != '<') continue;
            n = CheckMethodAdapter.checkTypeArguments(string2, n);
        }
        return CheckMethodAdapter.checkChar(';', string2, n);
    }

    private static int checkTypeArguments(String string2, int n) {
        n = CheckMethodAdapter.checkChar('<', string2, n);
        n = CheckMethodAdapter.checkTypeArgument(string2, n);
        while (CheckMethodAdapter.getChar(string2, n) != '>') {
            n = CheckMethodAdapter.checkTypeArgument(string2, n);
        }
        return n + 1;
    }

    private static int checkTypeArgument(String string2, int n) {
        char c = CheckMethodAdapter.getChar(string2, n);
        if (c == '*') {
            return n + 1;
        }
        if (c == '+' || c == '-') {
            ++n;
        }
        return CheckMethodAdapter.checkFieldTypeSignature(string2, n);
    }

    private static int checkTypeVariableSignature(String string2, int n) {
        n = CheckMethodAdapter.checkChar('T', string2, n);
        n = CheckMethodAdapter.checkIdentifier(string2, n);
        return CheckMethodAdapter.checkChar(';', string2, n);
    }

    private static int checkTypeSignature(String string2, int n) {
        switch (CheckMethodAdapter.getChar(string2, n)) {
            case 'B': 
            case 'C': 
            case 'D': 
            case 'F': 
            case 'I': 
            case 'J': 
            case 'S': 
            case 'Z': {
                return n + 1;
            }
        }
        return CheckMethodAdapter.checkFieldTypeSignature(string2, n);
    }

    private static int checkIdentifier(String string2, int n) {
        if (!Character.isJavaIdentifierStart(CheckMethodAdapter.getChar(string2, n))) {
            throw new IllegalArgumentException(string2 + ": identifier expected at index " + n);
        }
        ++n;
        while (Character.isJavaIdentifierPart(CheckMethodAdapter.getChar(string2, n))) {
            ++n;
        }
        return n;
    }

    private static int checkChar(char c, String string2, int n) {
        if (CheckMethodAdapter.getChar(string2, n) == c) {
            return n + 1;
        }
        throw new IllegalArgumentException(string2 + ": '" + c + "' expected at index " + n);
    }

    private static char getChar(String string2, int n) {
        return n < string2.length() ? string2.charAt(n) : (char)'\u0000';
    }

    void checkLabel(Label label, boolean bl, String string2) {
        if (label == null) {
            throw new IllegalArgumentException("Invalid " + string2 + " (must not be null)");
        }
        if (bl && this.labels.get(label) == null) {
            throw new IllegalArgumentException("Invalid " + string2 + " (must be visited first)");
        }
    }

    private static void checkNonDebugLabel(Label label) {
        Field field2 = CheckMethodAdapter.getLabelStatusField();
        int n = 0;
        try {
            n = field2 == null ? 0 : (Integer)field2.get(label);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new Error("Internal error");
        }
        if ((n & 1) != 0) {
            throw new IllegalArgumentException("Labels used for debug info cannot be reused for control flow");
        }
    }

    private static Field getLabelStatusField() {
        if (labelStatusField == null && (labelStatusField = CheckMethodAdapter.getLabelField("a")) == null) {
            labelStatusField = CheckMethodAdapter.getLabelField("status");
        }
        return labelStatusField;
    }

    private static Field getLabelField(String string2) {
        try {
            Field field2 = (class$org$objectweb$asm$Label == null ? (class$org$objectweb$asm$Label = CheckMethodAdapter.class$("org.objectweb.asm.Label")) : class$org$objectweb$asm$Label).getDeclaredField(string2);
            field2.setAccessible(true);
            return field2;
        }
        catch (NoSuchFieldException noSuchFieldException) {
            return null;
        }
    }

    static /* synthetic */ Class class$(String string2) {
        try {
            return Class.forName(string2);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        String string2 = "BBBBBBBBBBBBBBBBCCIAADDDDDAAAAAAAAAAAAAAAAAAAABBBBBBBBDDDDDAAAAAAAAAAAAAAAAAAAABBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBJBBBBBBBBBBBBBBBBBBBBHHHHHHHHHHHHHHHHDKLBBBBBBFFFFGGGGGECEBBEEBBAMHHAA";
        TYPE = new int[string2.length()];
        for (int i = 0; i < TYPE.length; ++i) {
            CheckMethodAdapter.TYPE[i] = string2.charAt(i) - 65 - 1;
        }
    }
}

