/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.CompilerPass;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.jscomp.jarjar.com.google.common.base.Preconditions;
import com.google.javascript.jscomp.jarjar.com.google.common.base.Strings;
import com.google.javascript.jscomp.jarjar.com.google.common.collect.ImmutableSet;
import com.google.javascript.jscomp.jarjar.javax.annotation.Nullable;
import com.google.javascript.jscomp.parsing.parser.FeatureSet;
import com.google.javascript.rhino.InputId;
import com.google.javascript.rhino.Node;
import com.google.javascript.rhino.Token;
import com.google.javascript.rhino.jstype.FunctionType;
import com.google.javascript.rhino.jstype.JSType;
import java.util.Objects;

public final class AstValidator
implements CompilerPass {
    private final AbstractCompiler compiler;
    private final ViolationHandler violationHandler;
    private Node currentScript;
    private TypeInfoValidation typeValidationMode = TypeInfoValidation.NONE;
    private final boolean isScriptFeatureValidationEnabled;

    public AstValidator(AbstractCompiler compiler, ViolationHandler handler, boolean validateScriptFeatures) {
        this.compiler = compiler;
        this.violationHandler = handler;
        this.isScriptFeatureValidationEnabled = validateScriptFeatures;
    }

    public AstValidator(AbstractCompiler compiler) {
        this(compiler, false);
    }

    public AstValidator(AbstractCompiler compiler, boolean validateScriptFeatures) {
        this(compiler, new ViolationHandler(){

            @Override
            public void handleViolation(String message, Node n) {
                throw new IllegalStateException(message + ". Reference node:\n" + n.toStringTree() + "\n Parent node:\n" + (n.hasParent() ? n.getParent().toStringTree() : " no parent "));
            }
        }, validateScriptFeatures);
    }

    public AstValidator setTypeValidationMode(TypeInfoValidation mode) {
        this.typeValidationMode = mode;
        return this;
    }

    @Override
    public void process(Node externs, Node root) {
        if (externs != null) {
            this.validateCodeRoot(externs);
        }
        if (root != null) {
            this.validateCodeRoot(root);
        }
    }

    public void validateRoot(Node n) {
        this.validateNodeType(Token.ROOT, n);
        this.validateProperties(n);
        this.validateChildCount(n, 2);
        this.validateCodeRoot(n.getFirstChild());
        this.validateCodeRoot(n.getLastChild());
    }

    public void validateCodeRoot(Node n) {
        this.validateNodeType(Token.ROOT, n);
        for (Node c = n.getFirstChild(); c != null; c = c.getNext()) {
            this.validateScript(c);
        }
    }

    public void validateScript(Node n) {
        this.validateNodeType(Token.SCRIPT, n);
        this.validateHasSourceName(n);
        this.validateHasInputId(n);
        this.currentScript = n;
        if (n.hasChildren() && n.getFirstChild().isModuleBody()) {
            this.validateProperties(n);
            this.validateChildCount(n, 1);
            this.validateModuleContents(n.getFirstChild());
        } else {
            this.validateStatements(n.getFirstChild());
        }
    }

    public void validateModuleContents(Node n) {
        this.validateNodeType(Token.MODULE_BODY, n);
        this.validateStatements(n.getFirstChild());
    }

    public void validateStatements(Node n) {
        while (n != null) {
            this.validateStatement(n);
            n = n.getNext();
        }
    }

    public void validateStatement(Node n) {
        this.validateStatement(n, false);
    }

    public void validateStatement(Node n, boolean isAmbient) {
        switch (n.getToken()) {
            case LABEL: {
                this.validateLabel(n);
                return;
            }
            case BLOCK: {
                this.validateBlock(n);
                return;
            }
            case FUNCTION: {
                if (isAmbient) {
                    this.validateFunctionSignature(n);
                } else {
                    this.validateFunctionStatement(n);
                }
                return;
            }
            case WITH: {
                this.validateWith(n);
                return;
            }
            case FOR: {
                this.validateFor(n);
                return;
            }
            case FOR_IN: {
                this.validateForIn(n);
                return;
            }
            case FOR_OF: {
                this.validateForOf(n);
                return;
            }
            case FOR_AWAIT_OF: {
                this.validateForAwaitOf(n);
                return;
            }
            case WHILE: {
                this.validateWhile(n);
                return;
            }
            case DO: {
                this.validateDo(n);
                return;
            }
            case SWITCH: {
                this.validateSwitch(n);
                return;
            }
            case IF: {
                this.validateIf(n);
                return;
            }
            case CONST: 
            case VAR: 
            case LET: {
                this.validateNameDeclarationHelper(n, n.getToken(), n);
                return;
            }
            case EXPR_RESULT: {
                this.validateExprStmt(n);
                return;
            }
            case RETURN: {
                this.validateReturn(n);
                return;
            }
            case THROW: {
                this.validateThrow(n);
                return;
            }
            case TRY: {
                this.validateTry(n);
                return;
            }
            case BREAK: {
                this.validateBreak(n);
                return;
            }
            case CONTINUE: {
                this.validateContinue(n);
                return;
            }
            case EMPTY: 
            case DEBUGGER: {
                this.validateProperties(n);
                this.validateChildless(n);
                return;
            }
            case CLASS: {
                this.validateClassDeclaration(n, isAmbient);
                return;
            }
            case IMPORT: {
                this.validateImport(n);
                return;
            }
            case EXPORT: {
                this.validateExport(n, isAmbient);
                return;
            }
            case INTERFACE: {
                this.validateInterface(n);
                return;
            }
            case ENUM: {
                this.validateEnum(n);
                return;
            }
            case TYPE_ALIAS: {
                this.validateTypeAlias(n);
                return;
            }
            case DECLARE: {
                this.validateAmbientDeclaration(n);
                return;
            }
            case NAMESPACE: {
                this.validateNamespace(n, isAmbient);
                return;
            }
        }
        this.violation("Expected statement but was " + (Object)((Object)n.getToken()) + ".", n);
    }

    public void validateExpression(Node n) {
        this.validateTypeInformation(n);
        switch (n.getToken()) {
            case NEW_TARGET: {
                this.validateFeature(FeatureSet.Feature.NEW_TARGET, n);
                this.validateProperties(n);
                this.validateChildless(n);
                return;
            }
            case IMPORT_META: {
                this.validateFeature(FeatureSet.Feature.IMPORT_META, n);
                this.validateProperties(n);
                this.validateChildless(n);
                return;
            }
            case FALSE: 
            case NULL: 
            case THIS: 
            case TRUE: {
                this.validateProperties(n);
                this.validateChildless(n);
                return;
            }
            case DELPROP: 
            case POS: 
            case NEG: 
            case NOT: 
            case TYPEOF: 
            case VOID: 
            case BITNOT: 
            case CAST: {
                this.validateUnaryOp(n);
                return;
            }
            case INC: 
            case DEC: {
                this.validateIncDecOp(n);
                return;
            }
            case ASSIGN: {
                this.validateAssignmentExpression(n);
                return;
            }
            case ASSIGN_EXPONENT: {
                this.validateFeature(FeatureSet.Feature.EXPONENT_OP, n);
                this.validateCompoundAssignmentExpression(n);
                return;
            }
            case ASSIGN_BITOR: 
            case ASSIGN_BITXOR: 
            case ASSIGN_BITAND: 
            case ASSIGN_LSH: 
            case ASSIGN_RSH: 
            case ASSIGN_URSH: 
            case ASSIGN_ADD: 
            case ASSIGN_SUB: 
            case ASSIGN_MUL: 
            case ASSIGN_DIV: 
            case ASSIGN_MOD: {
                this.validateCompoundAssignmentExpression(n);
                return;
            }
            case ASSIGN_COALESCE: {
                this.validateFeature(FeatureSet.Feature.NULL_COALESCE_OP, n);
            }
            case ASSIGN_OR: 
            case ASSIGN_AND: {
                this.validateFeature(FeatureSet.Feature.LOGICAL_ASSIGNMENT, n);
                this.validateCompoundAssignmentExpression(n);
                return;
            }
            case HOOK: {
                this.validateTrinaryOp(n);
                return;
            }
            case STRINGLIT: {
                this.validateStringLit(n);
                return;
            }
            case NUMBER: {
                this.validateNumber(n);
                return;
            }
            case BIGINT: {
                this.validateBigInt(n);
                return;
            }
            case NAME: {
                this.validateName(n);
                return;
            }
            case EXPONENT: {
                this.validateFeature(FeatureSet.Feature.EXPONENT_OP, n);
                this.validateBinaryOp(n);
                return;
            }
            case COALESCE: {
                this.validateFeature(FeatureSet.Feature.NULL_COALESCE_OP, n);
                this.validateBinaryOp(n);
                return;
            }
            case COMMA: 
            case OR: 
            case AND: 
            case BITOR: 
            case BITXOR: 
            case BITAND: 
            case EQ: 
            case NE: 
            case SHEQ: 
            case SHNE: 
            case LT: 
            case GT: 
            case LE: 
            case GE: 
            case INSTANCEOF: 
            case IN: 
            case LSH: 
            case RSH: 
            case URSH: 
            case SUB: 
            case ADD: 
            case MUL: 
            case MOD: 
            case DIV: {
                this.validateBinaryOp(n);
                return;
            }
            case GETELEM: {
                this.validateGetElem(n);
                return;
            }
            case OPTCHAIN_GETELEM: {
                this.validateOptChainGetElem(n);
                return;
            }
            case GETPROP: {
                this.validateGetProp(n);
                return;
            }
            case OPTCHAIN_GETPROP: {
                this.validateOptChainGetProp(n);
                return;
            }
            case ARRAYLIT: {
                this.validateArrayLit(n);
                return;
            }
            case OBJECTLIT: {
                this.validateObjectLit(n);
                return;
            }
            case REGEXP: {
                this.validateRegExpLit(n);
                return;
            }
            case CALL: {
                this.validateCall(n);
                return;
            }
            case OPTCHAIN_CALL: {
                this.validateOptChainCall(n);
                return;
            }
            case NEW: {
                this.validateNew(n);
                return;
            }
            case FUNCTION: {
                this.validateFunctionExpression(n);
                return;
            }
            case CLASS: {
                this.validateClass(n);
                return;
            }
            case TEMPLATELIT: {
                this.validateTemplateLit(n);
                return;
            }
            case TAGGED_TEMPLATELIT: {
                this.validateTaggedTemplateLit(n);
                return;
            }
            case YIELD: {
                this.validateYield(n);
                return;
            }
            case AWAIT: {
                this.validateAwait(n);
                return;
            }
            case DYNAMIC_IMPORT: {
                this.validateFeature(FeatureSet.Feature.DYNAMIC_IMPORT, n);
                this.validateUnaryOp(n);
                return;
            }
        }
        this.violation("Expected expression but was " + (Object)((Object)n.getToken()), n);
    }

    private void validatePseudoExpression(Node n, Token ... allowedPseudoexpressions) {
        switch (n.getToken()) {
            case EMPTY: {
                this.validateProperties(n);
                this.validateChildless(n);
                break;
            }
            case ITER_SPREAD: {
                this.validateProperties(n);
                this.validateChildCount(n);
                this.validateFeature(FeatureSet.Feature.SPREAD_EXPRESSIONS, n);
                this.validateExpression(n.getFirstChild());
                break;
            }
            default: {
                this.validateExpression(n);
                return;
            }
        }
        ImmutableSet<Token> set = ImmutableSet.copyOf(allowedPseudoexpressions);
        if (!set.contains((Object)n.getToken())) {
            this.violation("Expected expression or " + set + " but was " + (Object)((Object)n.getToken()), n);
        }
    }

    private void validateTypeInformation(Node n) {
        JSType type;
        if (this.typeValidationMode.equals((Object)TypeInfoValidation.NONE)) {
            return;
        }
        if (this.typeValidationMode.equals((Object)TypeInfoValidation.JSTYPE) && (type = n.getJSType()) != null && !type.isResolved()) {
            this.violation("Found unresolved type " + type, n);
        }
        switch (n.getToken()) {
            case CALL: {
                if (n.getFirstChild().isSuper()) break;
                this.validateCallType(n);
                break;
            }
            default: {
                this.expectSomeTypeInformation(n);
            }
        }
    }

    private void validateCallType(Node callNode) {
        switch (this.typeValidationMode) {
            case JSTYPE: {
                Node callee = callNode.getFirstChild();
                JSType calleeType = Preconditions.checkNotNull(callee.getJSType(), "Callee of\n\n%s\nhas no type.", (Object)callNode.toStringTree());
                if (!calleeType.isFunctionType()) break;
                FunctionType calleeFunctionType = calleeType.toMaybeFunctionType();
                JSType returnType = calleeFunctionType.getReturnType();
                if (callNode.getJSTypeBeforeCast() != null || returnType.isUnknownType()) break;
                this.expectMatchingTypeInformation(callNode, returnType);
                break;
            }
            case COLOR: {
                Node callee = callNode.getFirstChild();
                Preconditions.checkNotNull(callee.getColor(), "Callee of\n\n%s\nhas no color.", (Object)callNode.toStringTree());
                break;
            }
            case NONE: {
                throw new AssertionError();
            }
        }
    }

    private void expectSomeTypeInformation(Node n) {
        switch (this.typeValidationMode) {
            case JSTYPE: {
                if (n.getJSType() != null) break;
                this.violation("Type information missing\n" + this.compiler.toSource(NodeUtil.getEnclosingStatement(n)), n);
                break;
            }
            case COLOR: {
                if (n.getColor() != null) break;
                this.violation("Color information missing\n" + this.compiler.toSource(NodeUtil.getEnclosingStatement(n)), n);
                break;
            }
            case NONE: {
                throw new AssertionError();
            }
        }
    }

    private void expectMatchingTypeInformation(Node n, JSType expectedTypeI) {
        JSType typeI = n.getJSType();
        if (!Objects.equals(expectedTypeI, typeI)) {
            this.violation("Expected type: " + AstValidator.getTypeAnnotationString(expectedTypeI) + " Actual type: " + AstValidator.getTypeAnnotationString(typeI), n);
        }
    }

    private static String getTypeAnnotationString(@Nullable JSType typeI) {
        if (typeI == null) {
            return "NO TYPE INFORMATION";
        }
        return "{" + typeI.toAnnotationString(JSType.Nullability.EXPLICIT) + "}";
    }

    private void validateYield(Node n) {
        this.validateFeature(FeatureSet.Feature.GENERATORS, n);
        this.validateNodeType(Token.YIELD, n);
        this.validateProperties(n);
        this.validateChildCountIn(n, 0, 1);
        if (n.hasChildren()) {
            this.validateExpression(n.getFirstChild());
        }
        this.validateYieldWithinGeneratorFunction(n);
    }

    private void validateYieldWithinGeneratorFunction(Node n) {
        Node parentFunction = NodeUtil.getEnclosingFunction(n);
        if (parentFunction == null || !parentFunction.isGeneratorFunction()) {
            this.violation("'yield' expression is not within a generator function", n);
        } else if (this.isInParameterListOfFunction(n, parentFunction)) {
            this.violation("'yield' expression is not allowed in a parameter list", n);
        }
    }

    private void validateAwait(Node n) {
        this.validateFeature(FeatureSet.Feature.ASYNC_FUNCTIONS, n);
        this.validateNodeType(Token.AWAIT, n);
        this.validateProperties(n);
        this.validateChildCount(n);
        this.validateExpression(n.getFirstChild());
        this.validateAwaitWithinAsyncFunction(n);
    }

    private void validateAwaitWithinAsyncFunction(Node n) {
        Node parentFunction = NodeUtil.getEnclosingFunction(n);
        if (parentFunction == null || !parentFunction.isAsyncFunction()) {
            this.violation("'await' expression is not within an async function", n);
        } else if (this.isInParameterListOfFunction(n, parentFunction)) {
            this.violation("'await' expression is not allowed in a parameter list", n);
        }
    }

    private boolean isInParameterListOfFunction(Node child, Node functionNode) {
        Node paramList = Preconditions.checkNotNull(functionNode.getSecondChild(), functionNode);
        for (Node parent = child.getParent(); parent != functionNode; parent = parent.getParent()) {
            Preconditions.checkNotNull(parent, "{} not contained in function {}", (Object)child, (Object)functionNode);
            if (parent != paramList) continue;
            return true;
        }
        return false;
    }

    private void validateImport(Node n) {
        this.validateFeature(FeatureSet.Feature.MODULES, n);
        this.validateNodeType(Token.IMPORT, n);
        this.validateProperties(n);
        this.validateChildCount(n);
        if (n.getFirstChild().isName()) {
            this.validateName(n.getFirstChild());
        } else {
            this.validateNodeType(Token.EMPTY, n.getFirstChild());
        }
        Node secondChild = n.getSecondChild();
        switch (secondChild.getToken()) {
            case IMPORT_SPECS: {
                this.validateImportSpecifiers(secondChild);
                break;
            }
            case IMPORT_STAR: {
                this.validateNonEmptyString(secondChild);
                break;
            }
            default: {
                this.validateNodeType(Token.EMPTY, secondChild);
            }
        }
        this.validateStringLit(n.getChildAtIndex(2));
    }

    private void validateImportSpecifiers(Node n) {
        this.validateNodeType(Token.IMPORT_SPECS, n);
        for (Node c = n.getFirstChild(); c != null; c = c.getNext()) {
            this.validateImportSpecifier(c);
        }
    }

    private void validateImportSpecifier(Node n) {
        this.validateNodeType(Token.IMPORT_SPEC, n);
        this.validateProperties(n);
        this.validateChildCount(n, 2);
        for (Node c = n.getFirstChild(); c != null; c = c.getNext()) {
            this.validateName(c);
        }
    }

    private void validateExport(Node n, boolean isAmbient) {
        this.validateFeature(FeatureSet.Feature.MODULES, n);
        this.validateNodeType(Token.EXPORT, n);
        if (n.getBooleanProp(Node.EXPORT_ALL_FROM)) {
            this.validateProperties(n);
            this.validateChildCount(n, 2);
            this.validateNodeType(Token.EMPTY, n.getFirstChild());
            this.validateStringLit(n.getSecondChild());
        } else if (n.getBooleanProp(Node.EXPORT_DEFAULT)) {
            this.validateProperties(n);
            this.validateChildCount(n, 1);
            this.validateExpression(n.getFirstChild());
        } else {
            this.validateProperties(n);
            this.validateChildCountIn(n, 1, 2);
            if (n.getFirstChild().getToken() == Token.EXPORT_SPECS) {
                this.validateExportSpecifiers(n.getFirstChild());
            } else {
                this.validateStatement(n.getFirstChild(), isAmbient);
            }
            if (n.hasTwoChildren()) {
                this.validateStringLit(n.getSecondChild());
            }
        }
    }

    private void validateExportSpecifiers(Node n) {
        this.validateNodeType(Token.EXPORT_SPECS, n);
        for (Node c = n.getFirstChild(); c != null; c = c.getNext()) {
            this.validateExportSpecifier(c);
        }
    }

    private void validateExportSpecifier(Node n) {
        this.validateNodeType(Token.EXPORT_SPEC, n);
        this.validateProperties(n);
        this.validateChildCount(n, 2);
        for (Node c = n.getFirstChild(); c != null; c = c.getNext()) {
            this.validateName(c);
        }
    }

    private void validateTaggedTemplateLit(Node n) {
        this.validateFeature(FeatureSet.Feature.TEMPLATE_LITERALS, n);
        this.validateNodeType(Token.TAGGED_TEMPLATELIT, n);
        this.validateProperties(n);
        this.validateChildCount(n);
        this.validateExpression(n.getFirstChild());
        this.validateTemplateLit(n.getLastChild());
    }

    private void validateTemplateLit(Node n) {
        this.validateFeature(FeatureSet.Feature.TEMPLATE_LITERALS, n);
        this.validateNodeType(Token.TEMPLATELIT, n);
        for (Node child = n.getFirstChild(); child != null; child = child.getNext()) {
            if (child.isTemplateLitString()) {
                this.validateTemplateLitString(child);
                continue;
            }
            this.validateTemplateLitSub(child);
        }
    }

    private void validateTemplateLitString(Node n) {
        this.validateNodeType(Token.TEMPLATELIT_STRING, n);
        this.validateProperties(n);
        this.validateChildCount(n);
        try {
            n.getRawString();
        }
        catch (UnsupportedOperationException e) {
            this.violation("Invalid TEMPLATELIT_STRING node.", n);
        }
    }

    private void validateTemplateLitSub(Node n) {
        this.validateNodeType(Token.TEMPLATELIT_SUB, n);
        this.validateProperties(n);
        this.validateChildCount(n);
        this.validateExpression(n.getFirstChild());
    }

    private void validateInterface(Node n) {
        this.validateNodeType(Token.INTERFACE, n);
        this.validateProperties(n);
        this.validateChildCount(n);
        Node name = n.getFirstChild();
        this.validateName(name);
        Node superTypes = name.getNext();
        if (superTypes.isEmpty()) {
            this.validateProperties(superTypes);
            this.validateChildless(superTypes);
        } else {
            this.validateInterfaceExtends(superTypes);
        }
        this.validateInterfaceMembers(n.getLastChild());
    }

    private void validateInterfaceExtends(Node n) {
        this.validateNodeType(Token.INTERFACE_EXTENDS, n);
        for (Node c = n.getFirstChild(); c != null; c = c.getNext()) {
            this.validateNamedType(c);
        }
    }

    private void validateInterfaceMembers(Node n) {
        this.validateNodeType(Token.INTERFACE_MEMBERS, n);
        for (Node c = n.getFirstChild(); c != null; c = c.getNext()) {
            this.validateInterfaceMember(c);
        }
    }

    private void validateInterfaceMember(Node n) {
        switch (n.getToken()) {
            case MEMBER_FUNCTION_DEF: {
                this.validateProperties(n);
                this.validateChildCount(n);
                this.validateFunctionSignature(n.getFirstChild());
                break;
            }
            case MEMBER_VARIABLE_DEF: {
                this.validateProperties(n);
                this.validateChildless(n);
                break;
            }
            case INDEX_SIGNATURE: {
                this.validateProperties(n);
                this.validateChildCount(n);
                Node child = n.getFirstChild();
                this.validateProperties(child);
                this.validateChildless(child);
                break;
            }
            case CALL_SIGNATURE: {
                this.validateProperties(n);
                this.validateChildCount(n);
                break;
            }
            default: {
                this.violation("Interface contained member of invalid type " + (Object)((Object)n.getToken()), n);
            }
        }
    }

    private void validateEnum(Node n) {
        this.validateNodeType(Token.ENUM, n);
        this.validateName(n.getFirstChild());
        this.validateEnumMembers(n.getLastChild());
    }

    private void validateEnumMembers(Node n) {
        this.validateNodeType(Token.ENUM_MEMBERS, n);
        for (Node c = n.getFirstChild(); c != null; c = c.getNext()) {
            this.validateEnumStringKey(c);
        }
    }

    private void validateEnumStringKey(Node n) {
        this.validateNodeType(Token.STRING_KEY, n);
        this.validateObjectLiteralKeyName(n);
        this.validateProperties(n);
        this.validateChildCount(n, 0);
    }

    private void validateClassDeclaration(Node n, boolean isAmbient) {
        this.validateClassHelper(n, isAmbient);
        this.validateName(n.getFirstChild());
    }

    private void validateClass(Node n) {
        this.validateClassHelper(n, false);
    }

    private void validateClassHelper(Node n, boolean isAmbient) {
        this.validateFeature(FeatureSet.Feature.CLASSES, n);
        this.validateNodeType(Token.CLASS, n);
        this.validateProperties(n);
        this.validateChildCount(n);
        Node name = n.getFirstChild();
        if (name.isEmpty()) {
            this.validateProperties(name);
            this.validateChildless(name);
        } else {
            this.validateName(name);
        }
        Node superClass = name.getNext();
        if (superClass.isEmpty()) {
            this.validateProperties(superClass);
            this.validateChildless(superClass);
        } else {
            this.validateFeature(FeatureSet.Feature.CLASS_EXTENDS, n);
            this.validateExpression(superClass);
        }
        this.validateClassMembers(n.getLastChild(), isAmbient);
    }

    private void validateClassMembers(Node n, boolean isAmbient) {
        this.validateNodeType(Token.CLASS_MEMBERS, n);
        for (Node c = n.getFirstChild(); c != null; c = c.getNext()) {
            this.validateClassMember(c, isAmbient);
        }
    }

    private void validateClassMember(Node n, boolean isAmbient) {
        switch (n.getToken()) {
            case MEMBER_FUNCTION_DEF: {
                this.validateFeature(FeatureSet.Feature.MEMBER_DECLARATIONS, n);
                this.validateObjectLiteralKeyName(n);
                this.validateProperties(n);
                this.validateChildCount(n);
                this.validateMemberFunction(n, isAmbient);
                break;
            }
            case GETTER_DEF: 
            case SETTER_DEF: {
                this.validateFeature(FeatureSet.Feature.CLASS_GETTER_SETTER, n);
                this.validateObjectLiteralKeyName(n);
                this.validateObjectLitKey(n);
                this.validateProperties(n);
                this.validateChildCount(n);
                this.validateMemberFunction(n, isAmbient);
                break;
            }
            case MEMBER_VARIABLE_DEF: {
                this.validateProperties(n);
                this.validateChildless(n);
                break;
            }
            case COMPUTED_PROP: {
                this.validateComputedPropClassMethod(n);
                break;
            }
            case MEMBER_FIELD_DEF: {
                this.validateClassField(n);
                break;
            }
            case COMPUTED_FIELD_DEF: {
                this.validateComputedPropClassField(n);
                break;
            }
            case INDEX_SIGNATURE: {
                this.validateProperties(n);
                this.validateChildCount(n);
                Node child = n.getFirstChild();
                this.validateProperties(child);
                this.validateChildless(child);
                break;
            }
            case CALL_SIGNATURE: {
                this.validateProperties(n);
                this.validateChildCount(n);
                break;
            }
            case EMPTY: {
                break;
            }
            default: {
                this.violation("Class contained member of invalid type " + (Object)((Object)n.getToken()), n);
            }
        }
    }

    private void validateMemberFunction(Node n, boolean isAmbient) {
        Node function = n.getFirstChild();
        if (isAmbient) {
            this.validateFunctionSignature(function);
        } else {
            this.validateFunctionExpression(function);
        }
    }

    private void validateClassField(Node n) {
        this.validateFeature(FeatureSet.Feature.PUBLIC_CLASS_FIELDS, n);
        this.validateNonEmptyString(n);
        if (n.hasChildren()) {
            this.validateExpression(n.getFirstChild());
        }
    }

    private void validateComputedPropClassField(Node n) {
        this.validateFeature(FeatureSet.Feature.PUBLIC_CLASS_FIELDS, n);
        this.validateExpression(n.getFirstChild());
        if (n.getSecondChild() != null) {
            this.validateExpression(n.getSecondChild());
        }
    }

    private void validateBlock(Node n) {
        this.validateNodeType(Token.BLOCK, n);
        for (Node c = n.getFirstChild(); c != null; c = c.getNext()) {
            this.validateStatement(c);
        }
    }

    private void validateHasSourceName(Node n) {
        String sourceName = n.getSourceFileName();
        if (Strings.isNullOrEmpty(sourceName)) {
            this.violation("Missing 'source name' annotation.", n);
        }
    }

    private void validateHasInputId(Node n) {
        InputId inputId = n.getInputId();
        if (inputId == null) {
            this.violation("Missing 'input id' annotation.", n);
        }
    }

    private void validateLabel(Node n) {
        this.validateNodeType(Token.LABEL, n);
        this.validateProperties(n);
        this.validateChildCount(n);
        this.validateLabelName(n.getFirstChild());
        this.validateStatement(n.getLastChild());
    }

    private void validateLabelName(Node n) {
        this.validateNodeType(Token.LABEL_NAME, n);
        this.validateNonEmptyString(n);
        this.validateProperties(n);
        this.validateChildCount(n);
    }

    private void validateNonEmptyString(Node n) {
        if (this.validateNonNullString(n) && n.getString().isEmpty()) {
            this.violation("Expected non-empty string.", n);
        }
    }

    private void validateEmptyString(Node n) {
        if (this.validateNonNullString(n) && !n.getString().isEmpty()) {
            this.violation("Expected empty string.", n);
        }
    }

    private boolean validateNonNullString(Node n) {
        try {
            if (n.getString() == null) {
                this.violation("Expected non-null string.", n);
                return false;
            }
        }
        catch (Exception e) {
            this.violation("Expected non-null string.", n);
            return false;
        }
        return true;
    }

    private void validateName(Node n) {
        this.validateNodeType(Token.NAME, n);
        this.validateNonEmptyString(n);
        this.validateProperties(n);
        this.validateChildCount(n);
        this.validateTypeInformation(n);
    }

    private void validateOptionalName(Node n) {
        boolean isEmpty;
        this.validateNodeType(Token.NAME, n);
        this.validateNonNullString(n);
        this.validateProperties(n);
        this.validateChildCount(n);
        boolean bl = isEmpty = n.getString() != null && n.getString().isEmpty();
        if (!isEmpty) {
            this.validateTypeInformation(n);
        }
    }

    private void validateEmptyName(Node n) {
        this.validateNodeType(Token.NAME, n);
        this.validateEmptyString(n);
        this.validateProperties(n);
        this.validateChildCount(n);
    }

    private void validateFunctionStatement(Node n) {
        this.validateNodeType(Token.FUNCTION, n);
        this.validateProperties(n);
        this.validateChildCount(n);
        this.validateName(n.getFirstChild());
        this.validateParameters(n.getSecondChild());
        this.validateFunctionBody(n.getLastChild(), false);
        this.validateFunctionFeatures(n);
        if (n.getParent().isBlock() && !n.getGrandparent().isFunction()) {
            this.validateFeature(FeatureSet.Feature.BLOCK_SCOPED_FUNCTION_DECLARATION, n);
        }
    }

    private void validateFunctionExpression(Node n) {
        this.validateFunctionExpressionHelper(n, false);
    }

    private void validateFunctionSignature(Node n) {
        this.validateFunctionExpressionHelper(n, true);
    }

    private void validateFunctionExpressionHelper(Node n, boolean isAmbient) {
        this.validateNodeType(Token.FUNCTION, n);
        this.validateProperties(n);
        this.validateChildCount(n);
        this.validateParameters(n.getSecondChild());
        Node name = n.getFirstChild();
        Node body = n.getLastChild();
        if (n.isArrowFunction()) {
            this.validateEmptyName(name);
            if (body.isBlock()) {
                this.validateBlock(body);
            } else {
                this.validateExpression(body);
            }
        } else {
            this.validateOptionalName(name);
            this.validateFunctionBody(body, isAmbient);
        }
        this.validateFunctionFeatures(n);
    }

    private void validateFunctionFeatures(Node n) {
        if (n.isArrowFunction()) {
            this.validateFeature(FeatureSet.Feature.ARROW_FUNCTIONS, n);
        }
        if (n.isGeneratorFunction()) {
            this.validateFeature(FeatureSet.Feature.GENERATORS, n);
        }
        if (n.isAsyncFunction()) {
            this.validateFeature(FeatureSet.Feature.ASYNC_FUNCTIONS, n);
        }
        if (n.isAsyncFunction() && n.isGeneratorFunction()) {
            this.validateFeature(FeatureSet.Feature.ASYNC_GENERATORS, n);
        }
    }

    private void validateFunctionBody(Node n, boolean noBlock) {
        if (noBlock) {
            this.validateNodeType(Token.EMPTY, n);
        } else {
            this.validateBlock(n);
        }
    }

    private void validateParameters(Node n) {
        this.validateNodeType(Token.PARAM_LIST, n);
        if (n.hasTrailingComma()) {
            this.validateFeature(FeatureSet.Feature.TRAILING_COMMA_IN_PARAM_LIST, n);
        }
        for (Node c = n.getFirstChild(); c != null; c = c.getNext()) {
            if (c.isRest()) {
                this.validateRestParameters(Token.PARAM_LIST, c);
                continue;
            }
            if (c.isDefaultValue()) {
                this.validateFeature(FeatureSet.Feature.DEFAULT_PARAMETERS, c);
                this.validateDefaultValue(Token.PARAM_LIST, c);
                continue;
            }
            if (c.isName()) {
                this.validateName(c);
                continue;
            }
            if (c.isArrayPattern()) {
                this.validateArrayPattern(Token.PARAM_LIST, c);
                continue;
            }
            this.validateObjectPattern(Token.PARAM_LIST, c);
        }
    }

    private void validateDefaultValue(Token contextType, Node n) {
        this.validateProperties(n);
        this.validateChildCount(n);
        this.validateLHS(contextType, n.getFirstChild());
        this.validateExpression(n.getLastChild());
    }

    private void validateCall(Node n) {
        Node callee;
        this.validateNodeType(Token.CALL, n);
        this.validateProperties(n);
        this.validateMinimumChildCount(n, 1);
        if (n.hasTrailingComma()) {
            this.validateFeature(FeatureSet.Feature.TRAILING_COMMA_IN_PARAM_LIST, n);
        }
        if ((callee = n.getFirstChild()).isSuper()) {
            this.validateSuper(callee);
        } else {
            this.validateExpression(callee);
        }
        for (Node c = callee.getNext(); c != null; c = c.getNext()) {
            this.validatePseudoExpression(c, Token.ITER_SPREAD);
        }
    }

    private void validateOptChainCall(Node node) {
        this.validateFeature(FeatureSet.Feature.OPTIONAL_CHAINING, node);
        this.validateNodeType(Token.OPTCHAIN_CALL, node);
        this.validateProperties(node);
        this.validateMinimumChildCount(node, 1);
        Node callee = node.getFirstChild();
        this.validateExpression(callee);
        if (node.hasTrailingComma()) {
            this.validateFeature(FeatureSet.Feature.TRAILING_COMMA_IN_PARAM_LIST, node);
        }
        for (Node argument = callee.getNext(); argument != null; argument = argument.getNext()) {
            this.validatePseudoExpression(argument, Token.ITER_SPREAD);
        }
        this.validateFirstNodeOfOptChain(node);
    }

    private void validateSuper(Node superNode) {
        this.validateFeature(FeatureSet.Feature.SUPER, superNode);
        this.validateProperties(superNode);
        this.validateChildless(superNode);
        this.validateTypeInformation(superNode);
        Node superParent = superNode.getParent();
        Node methodNode = NodeUtil.getEnclosingNonArrowFunction(superParent);
        if (NodeUtil.isNormalGet(superParent) && superNode.isFirstChildOf(superParent)) {
            if (methodNode == null || !NodeUtil.isMethodDeclaration(methodNode)) {
                this.violation("super property references are only allowed in methods", superNode);
            }
        } else if (superParent.isCall() && superNode.isFirstChildOf(superParent)) {
            if (methodNode == null || !NodeUtil.isEs6Constructor(methodNode)) {
                this.violation("super constructor call is only allowed in a constructor method", superNode);
            } else {
                Node extendsNode = methodNode.getParent().getParent().getParent().getSecondChild();
                if (extendsNode.isEmpty()) {
                    this.violation("super constructor call in a class that extends nothing", superNode);
                }
            }
        } else {
            this.violation("`super` is a syntax error here", superNode);
        }
    }

    private void validateRestParameters(Token contextType, Node n) {
        this.validateFeature(FeatureSet.Feature.REST_PARAMETERS, n);
        this.validateRest(contextType, n);
    }

    private void validateArrayPatternRest(Token contextType, Node n) {
        this.validateFeature(FeatureSet.Feature.ARRAY_PATTERN_REST, n);
        this.validateRest(contextType, n);
    }

    private void validateObjectPatternRest(Token contextType, Node n) {
        this.validateFeature(FeatureSet.Feature.OBJECT_PATTERN_REST, n);
        this.validateRest(contextType, n);
    }

    private void validateRest(Token contextType, Node n) {
        switch (n.getToken()) {
            case ITER_REST: 
            case OBJECT_REST: {
                break;
            }
            default: {
                this.violation("Unexpected node type.", n);
                return;
            }
        }
        this.validateProperties(n);
        this.validateChildCount(n);
        this.validateLHS(contextType, n.getFirstChild());
        if (n.getNext() != null) {
            this.violation("Rest parameters must come after all other parameters.", n);
        }
    }

    private void validateObjectSpread(Node n) {
        this.validateProperties(n);
        this.validateChildCount(n);
        this.validateFeature(FeatureSet.Feature.OBJECT_LITERALS_WITH_SPREAD, n);
        this.validateExpression(n.getFirstChild());
    }

    private void validateNew(Node n) {
        this.validateNodeType(Token.NEW, n);
        this.validateProperties(n);
        this.validateMinimumChildCount(n, 1);
        if (n.hasTrailingComma()) {
            this.validateFeature(FeatureSet.Feature.TRAILING_COMMA_IN_PARAM_LIST, n);
        }
        this.validateExpression(n.getFirstChild());
        for (Node c = n.getSecondChild(); c != null; c = c.getNext()) {
            this.validatePseudoExpression(c, Token.ITER_SPREAD);
        }
    }

    private void validateNameDeclarationHelper(Node statement, Token declaration, Node n) {
        this.validateProperties(n);
        this.validateMinimumChildCount(n, 1);
        for (Node c = n.getFirstChild(); c != null; c = c.getNext()) {
            this.validateNameDeclarationChild(statement, declaration, c);
        }
        if (declaration.equals((Object)Token.LET)) {
            this.validateFeature(FeatureSet.Feature.LET_DECLARATIONS, n);
        } else if (declaration.equals((Object)Token.CONST)) {
            this.validateFeature(FeatureSet.Feature.CONST_DECLARATIONS, n);
        }
    }

    private void validateNameDeclarationChild(Node statement, Token declaration, Node n) {
        int maxValues;
        int minValues;
        boolean inEnhancedFor = NodeUtil.isEnhancedFor(statement);
        boolean inForIn = statement.isForIn();
        if (inForIn && declaration.equals((Object)Token.VAR)) {
            minValues = 0;
            maxValues = 1;
        } else if (inEnhancedFor) {
            minValues = 0;
            maxValues = 0;
        } else if (n.isDestructuringLhs() || declaration.equals((Object)Token.CONST)) {
            minValues = 1;
            maxValues = 1;
        } else {
            minValues = 0;
            maxValues = 1;
        }
        if (n.isName()) {
            this.validateNonEmptyString(n);
            this.validateProperties(n);
            this.validateChildCountIn(n, minValues, maxValues);
            if (n.hasChildren()) {
                this.validateExpression(n.getFirstChild());
            }
        } else if (n.isDestructuringLhs()) {
            this.validateProperties(n);
            this.validateChildCountIn(n, 1 + minValues, 1 + maxValues);
            Node c = n.getFirstChild();
            switch (c.getToken()) {
                case ARRAY_PATTERN: {
                    this.validateArrayPattern(declaration, c);
                    break;
                }
                case OBJECT_PATTERN: {
                    this.validateObjectPattern(declaration, c);
                    break;
                }
                default: {
                    this.violation("Invalid destructuring lhs first child for " + (Object)((Object)declaration) + " node", n);
                }
            }
            if (n.hasTwoChildren()) {
                this.validateExpression(n.getSecondChild());
            }
        } else {
            this.violation("Invalid child for " + (Object)((Object)declaration) + " node", n);
        }
    }

    private void validateLHS(Token contextType, Node n) {
        switch (n.getToken()) {
            case NAME: {
                this.validateName(n);
                break;
            }
            case ARRAY_PATTERN: {
                this.validateArrayPattern(contextType, n);
                break;
            }
            case OBJECT_PATTERN: {
                this.validateObjectPattern(contextType, n);
                break;
            }
            case GETELEM: 
            case GETPROP: {
                this.validateGetPropGetElemInLHS(contextType, n);
                break;
            }
            case CAST: {
                this.validateLHS(contextType, n.getOnlyChild());
                break;
            }
            default: {
                this.violation("Invalid child for " + (Object)((Object)contextType) + " node", n);
            }
        }
    }

    private void validateGetPropGetElemInLHS(Token contextType, Node n) {
        if (contextType == Token.CONST || contextType == Token.LET || contextType == Token.VAR || contextType == Token.PARAM_LIST) {
            this.violation("Invalid child for " + (Object)((Object)contextType) + " node", n);
            return;
        }
        switch (n.getToken()) {
            case GETPROP: {
                this.validateGetProp(n);
                break;
            }
            case GETELEM: {
                this.validateGetElem(n);
                break;
            }
            default: {
                throw new IllegalStateException("Expected GETPROP or GETELEM but instead got node " + (Object)((Object)n.getToken()));
            }
        }
    }

    private void validateArrayPattern(Token type, Node n) {
        this.validateFeature(FeatureSet.Feature.ARRAY_DESTRUCTURING, n);
        this.validateNodeType(Token.ARRAY_PATTERN, n);
        block5: for (Node c = n.getFirstChild(); c != null; c = c.getNext()) {
            switch (c.getToken()) {
                case DEFAULT_VALUE: {
                    this.validateDefaultValue(type, c);
                    continue block5;
                }
                case ITER_REST: {
                    this.validateArrayPatternRest(type, c);
                    continue block5;
                }
                case EMPTY: {
                    this.validateProperties(c);
                    this.validateChildless(c);
                    continue block5;
                }
                default: {
                    this.validateLHS(type, c);
                }
            }
        }
    }

    private void validateObjectPattern(Token type, Node n) {
        this.validateFeature(FeatureSet.Feature.OBJECT_DESTRUCTURING, n);
        this.validateNodeType(Token.OBJECT_PATTERN, n);
        block5: for (Node c = n.getFirstChild(); c != null; c = c.getNext()) {
            switch (c.getToken()) {
                case STRING_KEY: {
                    this.validateObjectPatternStringKey(type, c);
                    continue block5;
                }
                case OBJECT_REST: {
                    this.validateObjectPatternRest(type, c);
                    continue block5;
                }
                case COMPUTED_PROP: {
                    this.validateObjectPatternComputedPropKey(type, c);
                    continue block5;
                }
                default: {
                    this.violation("Invalid object pattern child for " + (Object)((Object)type) + " node", n);
                }
            }
        }
    }

    private void validateFor(Node n) {
        this.validateNodeType(Token.FOR, n);
        this.validateProperties(n);
        this.validateChildCount(n, 4);
        Node target = n.getFirstChild();
        if (NodeUtil.isNameDeclaration(target)) {
            this.validateNameDeclarationHelper(n, target.getToken(), target);
        } else {
            this.validatePseudoExpression(target, Token.EMPTY);
        }
        this.validatePseudoExpression(n.getSecondChild(), Token.EMPTY);
        this.validatePseudoExpression(n.getChildAtIndex(2), Token.EMPTY);
        this.validateBlock(n.getLastChild());
    }

    private void validateForIn(Node n) {
        this.validateNodeType(Token.FOR_IN, n);
        this.validateProperties(n);
        this.validateChildCount(n);
        this.validateEnhancedForVarOrAssignmentTarget(n, n.getFirstChild());
        this.validateExpression(n.getSecondChild());
        this.validateBlock(n.getLastChild());
    }

    private void validateForOf(Node n) {
        this.validateFeature(FeatureSet.Feature.FOR_OF, n);
        this.validateNodeType(Token.FOR_OF, n);
        this.validateProperties(n);
        this.validateChildCount(n);
        this.validateEnhancedForVarOrAssignmentTarget(n, n.getFirstChild());
        this.validateExpression(n.getSecondChild());
        this.validateBlock(n.getLastChild());
    }

    private void validateForAwaitOf(Node n) {
        this.validateFeature(FeatureSet.Feature.FOR_AWAIT_OF, n);
        this.validateNodeType(Token.FOR_AWAIT_OF, n);
        this.validateProperties(n);
        this.validateChildCount(n);
        this.validateEnhancedForVarOrAssignmentTarget(n, n.getFirstChild());
        this.validateExpression(n.getSecondChild());
        this.validateBlock(n.getLastChild());
    }

    private void validateEnhancedForVarOrAssignmentTarget(Node forNode, Node n) {
        if (NodeUtil.isNameDeclaration(n)) {
            this.validateProperties(n);
            this.validateChildCount(n, 1);
            this.validateNameDeclarationHelper(forNode, n.getToken(), n);
        } else {
            this.validateLHS(n.getParent().getToken(), n);
        }
    }

    private void validateWith(Node n) {
        this.validateNodeType(Token.WITH, n);
        this.validateProperties(n);
        this.validateChildCount(n);
        this.validateExpression(n.getFirstChild());
        this.validateBlock(n.getLastChild());
    }

    private void validateWhile(Node n) {
        this.validateNodeType(Token.WHILE, n);
        this.validateProperties(n);
        this.validateChildCount(n);
        this.validateExpression(n.getFirstChild());
        this.validateBlock(n.getLastChild());
    }

    private void validateDo(Node n) {
        this.validateNodeType(Token.DO, n);
        this.validateProperties(n);
        this.validateChildCount(n);
        this.validateBlock(n.getFirstChild());
        this.validateExpression(n.getLastChild());
    }

    private void validateIf(Node n) {
        this.validateNodeType(Token.IF, n);
        this.validateProperties(n);
        this.validateChildCountIn(n, 2, 3);
        this.validateExpression(n.getFirstChild());
        this.validateBlock(n.getSecondChild());
        if (n.hasXChildren(3)) {
            this.validateBlock(n.getLastChild());
        }
    }

    private void validateExprStmt(Node n) {
        this.validateNodeType(Token.EXPR_RESULT, n);
        this.validateProperties(n);
        this.validateChildCount(n);
        this.validateExpression(n.getFirstChild());
    }

    private void validateReturn(Node n) {
        this.validateNodeType(Token.RETURN, n);
        this.validateProperties(n);
        this.validateMaximumChildCount(n, 1);
        if (n.hasChildren()) {
            this.validateExpression(n.getFirstChild());
        }
    }

    private void validateThrow(Node n) {
        this.validateNodeType(Token.THROW, n);
        this.validateProperties(n);
        this.validateChildCount(n);
        this.validateExpression(n.getFirstChild());
    }

    private void validateBreak(Node n) {
        this.validateNodeType(Token.BREAK, n);
        this.validateProperties(n);
        this.validateMaximumChildCount(n, 1);
        if (n.hasChildren()) {
            this.validateLabelName(n.getFirstChild());
        }
    }

    private void validateContinue(Node n) {
        this.validateNodeType(Token.CONTINUE, n);
        this.validateProperties(n);
        this.validateMaximumChildCount(n, 1);
        if (n.hasChildren()) {
            this.validateLabelName(n.getFirstChild());
        }
    }

    private void validateTry(Node n) {
        this.validateNodeType(Token.TRY, n);
        this.validateProperties(n);
        this.validateChildCountIn(n, 2, 3);
        this.validateBlock(n.getFirstChild());
        boolean seenCatchOrFinally = false;
        Node catches = n.getSecondChild();
        this.validateNodeType(Token.BLOCK, catches);
        this.validateProperties(catches);
        this.validateMaximumChildCount(catches, 1);
        if (catches.hasChildren()) {
            this.validateCatch(catches.getFirstChild());
            seenCatchOrFinally = true;
        }
        if (n.hasXChildren(3)) {
            this.validateBlock(n.getLastChild());
            seenCatchOrFinally = true;
        }
        if (!seenCatchOrFinally) {
            this.violation("Missing catch or finally for try statement.", n);
        }
    }

    private void validateCatch(Node n) {
        this.validateNodeType(Token.CATCH, n);
        this.validateProperties(n);
        this.validateChildCount(n);
        Node caught = n.getFirstChild();
        if (caught.isName()) {
            this.validateName(caught);
        } else if (caught.isArrayPattern()) {
            this.validateArrayPattern(Token.CATCH, caught);
        } else if (caught.isObjectPattern()) {
            this.validateObjectPattern(Token.CATCH, caught);
        } else if (caught.isEmpty()) {
            this.validateNoCatchBinding(caught);
        } else {
            this.violation("Unexpected catch binding: " + caught, n);
        }
        this.validateBlock(n.getLastChild());
    }

    private void validateNoCatchBinding(Node n) {
        this.validateFeature(FeatureSet.Feature.OPTIONAL_CATCH_BINDING, n);
        this.validateProperties(n);
        this.validateChildCount(n);
    }

    private void validateSwitch(Node n) {
        this.validateNodeType(Token.SWITCH, n);
        this.validateProperties(n);
        this.validateMinimumChildCount(n, 1);
        this.validateExpression(n.getFirstChild());
        int defaults = 0;
        for (Node c = n.getSecondChild(); c != null; c = c.getNext()) {
            this.validateSwitchMember(c);
            if (!c.isDefaultCase()) continue;
            ++defaults;
        }
        if (defaults > 1) {
            this.violation("Expected at most 1 'default' in switch but was " + defaults, n);
        }
    }

    private void validateSwitchMember(Node n) {
        switch (n.getToken()) {
            case CASE: {
                this.validateCase(n);
                return;
            }
            case DEFAULT_CASE: {
                this.validateDefaultCase(n);
                return;
            }
        }
        this.violation("Expected switch member but was " + (Object)((Object)n.getToken()), n);
    }

    private void validateDefaultCase(Node n) {
        this.validateNodeType(Token.DEFAULT_CASE, n);
        this.validateProperties(n);
        this.validateChildCount(n);
        this.validateBlock(n.getLastChild());
    }

    private void validateCase(Node n) {
        this.validateNodeType(Token.CASE, n);
        this.validateProperties(n);
        this.validateChildCount(n);
        this.validateExpression(n.getFirstChild());
        this.validateBlock(n.getLastChild());
    }

    private void validateChildless(Node n) {
        this.validateChildCount(n, 0);
    }

    private void validateAssignmentExpression(Node n) {
        this.validateProperties(n);
        this.validateChildCount(n);
        this.validateLHS(n.getToken(), n.getFirstChild());
        this.validateExpression(n.getLastChild());
    }

    private void validateCompoundAssignmentExpression(Node n) {
        this.validateProperties(n);
        this.validateChildCount(n);
        Token contextType = n.getToken();
        Node lhs = n.getFirstChild();
        this.validateAssignmentOpTarget(lhs, contextType);
        this.validateExpression(n.getLastChild());
    }

    private void validateAssignmentOpTarget(Node lhs, Token contextType) {
        switch (lhs.getToken()) {
            case NAME: {
                this.validateName(lhs);
                break;
            }
            case GETELEM: 
            case GETPROP: {
                this.validateGetPropGetElemInLHS(contextType, lhs);
                break;
            }
            case CAST: {
                this.validateProperties(lhs);
                this.validateChildCount(lhs, 1);
                this.validateAssignmentOpTarget(lhs.getFirstChild(), contextType);
                break;
            }
            default: {
                this.violation("Invalid child for " + (Object)((Object)contextType) + " node", lhs);
            }
        }
    }

    private void validateGetElem(Node n) {
        Preconditions.checkArgument(n.isGetElem(), n);
        this.validateProperties(n);
        this.validateChildCount(n, 2);
        this.validatePropertyReferenceTarget(n.getFirstChild());
        this.validateExpression(n.getLastChild());
    }

    private void validateOptChainGetElem(Node node) {
        this.validateFeature(FeatureSet.Feature.OPTIONAL_CHAINING, node);
        Preconditions.checkArgument(node.isOptChainGetElem(), node);
        this.validateProperties(node);
        this.validateChildCount(node, 2);
        this.validateExpression(node.getFirstChild());
        this.validateExpression(node.getLastChild());
        this.validateFirstNodeOfOptChain(node);
    }

    private void validateGetProp(Node n) {
        this.validateNodeType(Token.GETPROP, n);
        this.validatePropertyReferenceTarget(n.getFirstChild());
        this.validateProperties(n);
        this.validateChildCount(n);
        this.validateNonEmptyString(n);
    }

    private void validateOptChainGetProp(Node node) {
        this.validateFeature(FeatureSet.Feature.OPTIONAL_CHAINING, node);
        this.validateNodeType(Token.OPTCHAIN_GETPROP, node);
        this.validateExpression(node.getFirstChild());
        this.validateFirstNodeOfOptChain(node);
        this.validateProperties(node);
        this.validateChildCount(node);
        this.validateNonEmptyString(node);
    }

    private void validatePropertyReferenceTarget(Node objectNode) {
        if (objectNode.isSuper()) {
            this.validateSuper(objectNode);
        } else {
            this.validateExpression(objectNode);
        }
    }

    private void validateRegExpLit(Node n) {
        this.validateNodeType(Token.REGEXP, n);
        this.validateProperties(n);
        this.validateChildCountIn(n, 1, 2);
        for (Node c = n.getFirstChild(); c != null; c = c.getNext()) {
            this.validateStringLit(c);
        }
    }

    private void validateStringLit(Node n) {
        this.validateNodeType(Token.STRINGLIT, n);
        this.validateProperties(n);
        this.validateChildCount(n);
        try {
            n.getString();
        }
        catch (UnsupportedOperationException e) {
            this.violation("Invalid STRING node.", n);
        }
    }

    private void validateNumber(Node n) {
        this.validateNodeType(Token.NUMBER, n);
        this.validateProperties(n);
        this.validateChildCount(n);
        try {
            n.getDouble();
        }
        catch (UnsupportedOperationException e) {
            this.violation("Invalid NUMBER node.", n);
        }
    }

    private void validateBigInt(Node n) {
        this.validateNodeType(Token.BIGINT, n);
        this.validateProperties(n);
        this.validateChildCount(n);
        try {
            n.getBigInt();
        }
        catch (UnsupportedOperationException e) {
            this.violation("Invalid BIGINT node.", n);
        }
    }

    private void validateArrayLit(Node n) {
        this.validateNodeType(Token.ARRAYLIT, n);
        Node c = n.getFirstChild();
        if (c != null) {
            this.validatePseudoExpression(c, Token.EMPTY, Token.ITER_SPREAD);
        }
    }

    private void validateObjectLit(Node n) {
        this.validateNodeType(Token.OBJECTLIT, n);
        for (Node c = n.getFirstChild(); c != null; c = c.getNext()) {
            this.validateObjectLitKey(c);
        }
    }

    private void validateObjectLitKey(Node n) {
        switch (n.getToken()) {
            case GETTER_DEF: {
                this.validateObjectLitGetKey(n);
                return;
            }
            case SETTER_DEF: {
                this.validateObjectLitSetKey(n);
                return;
            }
            case STRING_KEY: {
                this.validateObjectLitStringKey(n);
                return;
            }
            case MEMBER_FUNCTION_DEF: {
                this.validateClassMember(n, false);
                if (n.isStaticMember()) {
                    this.violation("Keys in an object literal should not be static.", n);
                }
                return;
            }
            case COMPUTED_PROP: {
                this.validateObjectLitComputedPropKey(n);
                return;
            }
            case OBJECT_SPREAD: {
                this.validateObjectSpread(n);
                return;
            }
        }
        this.violation("Expected object literal key expression but was " + (Object)((Object)n.getToken()), n);
    }

    private void validateObjectLitGetKey(Node n) {
        Node functionParams;
        this.validateFeature(FeatureSet.Feature.GETTER, n);
        this.validateNodeType(Token.GETTER_DEF, n);
        this.validateProperties(n);
        this.validateChildCount(n);
        this.validateObjectLiteralKeyName(n);
        Node function = n.getFirstChild();
        this.validateFunctionExpression(function);
        if (!function.getFirstChild().getString().isEmpty()) {
            this.violation("Expected unnamed function expression.", n);
        }
        if ((functionParams = function.getSecondChild()).hasChildren()) {
            this.violation("get methods must not have parameters.", n);
        }
    }

    private void validateObjectLitSetKey(Node n) {
        Node functionParams;
        this.validateFeature(FeatureSet.Feature.SETTER, n);
        this.validateNodeType(Token.SETTER_DEF, n);
        this.validateProperties(n);
        this.validateChildCount(n);
        this.validateObjectLiteralKeyName(n);
        Node function = n.getFirstChild();
        this.validateFunctionExpression(function);
        if (!function.getFirstChild().getString().isEmpty()) {
            this.violation("Expected unnamed function expression.", n);
        }
        if (!(functionParams = function.getSecondChild()).hasOneChild()) {
            this.violation("set methods must have exactly one parameter.", n);
        }
    }

    private void validateObjectLitStringKey(Node n) {
        this.validateNodeType(Token.STRING_KEY, n);
        this.validateObjectLiteralKeyName(n);
        this.validateProperties(n);
        this.validateChildCount(n, 1);
        this.validateExpression(n.getFirstChild());
        if (n.getBooleanProp(Node.IS_SHORTHAND_PROPERTY)) {
            this.validateFeature(FeatureSet.Feature.EXTENDED_OBJECT_LITERALS, n);
        }
    }

    private void validateObjectPatternStringKey(Token type, Node n) {
        this.validateNodeType(Token.STRING_KEY, n);
        this.validateObjectLiteralKeyName(n);
        this.validateProperties(n);
        this.validateChildCount(n, 1);
        Node c = n.getFirstChild();
        switch (c.getToken()) {
            case DEFAULT_VALUE: {
                this.validateDefaultValue(type, c);
                break;
            }
            default: {
                this.validateLHS(type, c);
            }
        }
    }

    private void validateObjectLitComputedPropKey(Node n) {
        this.validateFeature(FeatureSet.Feature.COMPUTED_PROPERTIES, n);
        this.validateNodeType(Token.COMPUTED_PROP, n);
        this.validateProperties(n);
        this.validateChildCount(n);
        this.validateExpression(n.getFirstChild());
        this.validateExpression(n.getLastChild());
    }

    private void validateObjectPatternComputedPropKey(Token type, Node n) {
        this.validateFeature(FeatureSet.Feature.COMPUTED_PROPERTIES, n);
        this.validateNodeType(Token.COMPUTED_PROP, n);
        this.validateProperties(n);
        this.validateChildCount(n);
        this.validateExpression(n.getFirstChild());
        if (n.getLastChild().isDefaultValue()) {
            this.validateDefaultValue(type, n.getLastChild());
        } else {
            this.validateLHS(n.getLastChild().getToken(), n.getLastChild());
        }
    }

    private void validateComputedPropClassMethod(Node n) {
        this.validateFeature(FeatureSet.Feature.COMPUTED_PROPERTIES, n);
        this.validateNodeType(Token.COMPUTED_PROP, n);
        this.validateExpression(n.getFirstChild());
        if (n.getBooleanProp(Node.COMPUTED_PROP_VARIABLE)) {
            this.validateProperties(n);
            this.validateChildCount(n, 1);
        } else {
            this.validateProperties(n);
            this.validateChildCount(n, 2);
            this.validateFunctionExpression(n.getLastChild());
            if (n.getBooleanProp(Node.COMPUTED_PROP_GETTER)) {
                this.validateObjectLitComputedPropGetKey(n);
            } else if (n.getBooleanProp(Node.COMPUTED_PROP_SETTER)) {
                this.validateObjectLitComputedPropSetKey(n);
            }
        }
    }

    private void validateObjectLitComputedPropGetKey(Node n) {
        Node functionParams;
        this.validateFeature(FeatureSet.Feature.COMPUTED_PROPERTIES, n);
        this.validateNodeType(Token.COMPUTED_PROP, n);
        this.validateProperties(n);
        this.validateChildCount(n);
        Node function = n.getLastChild();
        this.validateFunctionExpression(function);
        if (!function.getFirstChild().getString().isEmpty()) {
            this.violation("Expected unnamed function expression.", n);
        }
        if ((functionParams = function.getSecondChild()).hasChildren()) {
            this.violation("get methods must not have parameters.", n);
        }
    }

    private void validateObjectLitComputedPropSetKey(Node n) {
        Node functionParams;
        this.validateFeature(FeatureSet.Feature.COMPUTED_PROPERTIES, n);
        this.validateNodeType(Token.COMPUTED_PROP, n);
        this.validateProperties(n);
        this.validateChildCount(n);
        Node function = n.getLastChild();
        this.validateFunctionExpression(function);
        if (!function.getFirstChild().getString().isEmpty()) {
            this.violation("Expected unnamed function expression.", n);
        }
        if (!(functionParams = function.getSecondChild()).hasOneChild()) {
            this.violation("set methods must have exactly one parameter.", n);
        }
    }

    private void validateObjectLiteralKeyName(Node n) {
        if (n.isQuotedString()) {
            try {
                n.getString();
            }
            catch (UnsupportedOperationException e) {
                this.violation("getString failed for" + (Object)((Object)n.getToken()), n);
            }
        } else {
            this.validateNonEmptyString(n);
        }
    }

    private void validateIncDecOp(Node n) {
        this.validateProperties(n);
        this.validateChildCount(n, 1);
        this.validateAssignmentOpTarget(n.getFirstChild(), n.getToken());
    }

    private void validateUnaryOp(Node n) {
        this.validateProperties(n);
        this.validateChildCount(n, 1);
        this.validateExpression(n.getFirstChild());
    }

    private void validateBinaryOp(Node n) {
        this.validateProperties(n);
        this.validateChildCount(n, 2);
        this.validateExpression(n.getFirstChild());
        this.validateExpression(n.getLastChild());
    }

    private void validateTrinaryOp(Node n) {
        this.validateProperties(n);
        this.validateChildCount(n, 3);
        Node first = n.getFirstChild();
        this.validateExpression(first);
        this.validateExpression(first.getNext());
        this.validateExpression(n.getLastChild());
    }

    private void validateNamedType(Node n) {
        this.validateNodeType(Token.NAMED_TYPE, n);
        this.validateProperties(n);
        this.validateChildCount(n);
        this.validateName(n.getFirstChild());
    }

    private void validateTypeAlias(Node n) {
        this.validateNodeType(Token.TYPE_ALIAS, n);
        this.validateProperties(n);
        this.validateChildCount(n);
    }

    private void validateAmbientDeclaration(Node n) {
        this.validateNodeType(Token.DECLARE, n);
        this.validateAmbientDeclarationHelper(n.getFirstChild());
    }

    private void validateAmbientDeclarationHelper(Node n) {
        switch (n.getToken()) {
            case CONST: 
            case VAR: 
            case LET: {
                this.validateNameDeclarationHelper(n.getParent(), n.getToken(), n);
                break;
            }
            case FUNCTION: {
                this.validateFunctionSignature(n);
                break;
            }
            case CLASS: {
                this.validateClassDeclaration(n, true);
                break;
            }
            case ENUM: {
                this.validateEnum(n);
                break;
            }
            case NAMESPACE: {
                this.validateNamespace(n, true);
                break;
            }
            case TYPE_ALIAS: {
                this.validateTypeAlias(n);
                break;
            }
            case EXPORT: {
                this.validateExport(n, true);
                break;
            }
        }
    }

    private void validateNamespace(Node n, boolean isAmbient) {
        this.validateNodeType(Token.NAMESPACE, n);
        this.validateProperties(n);
        this.validateChildCount(n);
        this.validateNamespaceName(n.getFirstChild());
        this.validateNamespaceElements(n.getLastChild(), isAmbient);
    }

    private void validateNamespaceName(Node n) {
        switch (n.getToken()) {
            case NAME: {
                this.validateName(n);
                break;
            }
            case GETPROP: {
                this.validateGetProp(n);
                break;
            }
        }
    }

    private void validateNamespaceElements(Node n, boolean isAmbient) {
        this.validateNodeType(Token.NAMESPACE_ELEMENTS, n);
        for (Node c = n.getFirstChild(); c != null; c = c.getNext()) {
            if (isAmbient) {
                this.validateAmbientDeclarationHelper(c);
                continue;
            }
            this.validateStatement(c);
        }
    }

    private void violation(String message, Node n) {
        this.violationHandler.handleViolation(message, n);
    }

    private void validateFirstNodeOfOptChain(Node n) {
        if (!NodeUtil.isOptChainNode(n.getFirstChild()) && !n.isOptionalChainStart()) {
            this.violation("Start of optional chain node " + (Object)((Object)n.getToken()) + " is not marked as the start.", n);
        }
    }

    private void validateNodeType(Token type, Node n) {
        if (n.getToken() != type) {
            this.violation("Expected " + (Object)((Object)type) + " but was " + (Object)((Object)n.getToken()), n);
        }
    }

    private void validateChildCount(Node n) {
        int expectedArity = Token.arity(n.getToken());
        if (expectedArity != -1) {
            this.validateChildCount(n, expectedArity);
        }
    }

    private void validateChildCount(Node n, int expected) {
        int count = n.getChildCount();
        if (expected != count) {
            this.violation("Expected " + expected + " children, but was " + count, n);
        }
    }

    private void validateChildCountIn(Node n, int min, int max) {
        if (max == min) {
            this.validateChildCount(n, min);
            return;
        }
        int count = n.getChildCount();
        if (count < min || count > max) {
            this.violation("Expected child count in [" + min + ", " + max + "], but was " + count, n);
        }
    }

    private void validateMinimumChildCount(Node n, int i) {
        boolean valid = false;
        if (i == 1) {
            valid = n.hasChildren();
        } else if (i == 2) {
            valid = n.hasMoreThanOneChild();
        } else {
            boolean bl = valid = n.getChildCount() >= i;
        }
        if (!valid) {
            this.violation("Expected at least " + i + " children, but was " + n.getChildCount(), n);
        }
    }

    private void validateMaximumChildCount(Node n, int i) {
        boolean valid = false;
        if (i == 1) {
            valid = !n.hasMoreThanOneChild();
        } else if (i == -1) {
            valid = true;
        } else {
            boolean bl = valid = n.getChildCount() <= i;
        }
        if (!valid) {
            this.violation("Expected no more than " + i + " children, but was " + n.getChildCount(), n);
        }
    }

    private void validateFeature(FeatureSet.Feature feature, Node n) {
        if (!n.isFromExterns() && !this.compiler.getFeatureSet().has(feature)) {
            this.violation("AST should not contain " + (Object)((Object)feature), n);
        }
        if (!this.isScriptFeatureValidationEnabled || this.currentScript == null) {
            return;
        }
        FeatureSet scriptFeatures = NodeUtil.getFeatureSetOfScript(this.currentScript);
        if (scriptFeatures == null || !NodeUtil.getFeatureSetOfScript(this.currentScript).has(feature)) {
            this.violation("SCRIPT node should be marked as containing feature " + (Object)((Object)feature), this.currentScript);
        }
    }

    private void validateProperties(Node n) {
        n.validateProperties((String errorMessage) -> this.violation((String)errorMessage, n));
    }

    static enum TypeInfoValidation {
        JSTYPE,
        COLOR,
        NONE;

    }

    public static interface ViolationHandler {
        public void handleViolation(String var1, Node var2);
    }
}

