/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.jscomp.jarjar.com.google.common.base.Preconditions;
import com.google.javascript.jscomp.jarjar.com.google.common.collect.BiMap;
import com.google.javascript.jscomp.jarjar.com.google.common.collect.HashBiMap;
import com.google.javascript.rhino.Node;
import java.util.HashSet;
import java.util.Set;

public class ChangeVerifier {
    private final AbstractCompiler compiler;
    private final BiMap<Node, Node> clonesByCurrent = HashBiMap.create();
    private int snapshotChange;

    ChangeVerifier(AbstractCompiler compiler) {
        this.compiler = compiler;
    }

    ChangeVerifier snapshot(Node root) {
        this.clonesByCurrent.clear();
        this.snapshotChange = this.compiler.getChangeStamp();
        Node snapshot = root.cloneTree();
        this.associateClones(root, snapshot);
        return this;
    }

    void checkRecordedChanges(Node current) {
        this.checkRecordedChanges("", current);
    }

    void checkRecordedChanges(String passName, Node root) {
        this.verifyScopeChangesHaveBeenRecorded(passName, root);
    }

    private void associateClones(Node n, Node snapshot) {
        if (n.isRoot() || NodeUtil.isChangeScopeRoot(n)) {
            this.clonesByCurrent.put(n, snapshot);
        }
        Node child = n.getFirstChild();
        Node snapshotChild = snapshot.getFirstChild();
        while (child != null) {
            this.associateClones(child, snapshotChild);
            child = child.getNext();
            snapshotChild = snapshotChild.getNext();
        }
    }

    private void verifyScopeChangesHaveBeenRecorded(String passName, Node root) {
        final String passNameMsg = passName.isEmpty() ? "" : passName + ": ";
        final HashSet<Node> snapshotScopeNodes = new HashSet<Node>();
        NodeUtil.visitPreOrder((Node)this.clonesByCurrent.get(root), new NodeUtil.Visitor(){

            @Override
            public void visit(Node oldNode) {
                if (NodeUtil.isChangeScopeRoot(oldNode)) {
                    snapshotScopeNodes.add(oldNode);
                }
            }
        });
        NodeUtil.visitPreOrder(root, new NodeUtil.Visitor(){

            @Override
            public void visit(Node n) {
                if (n.isRoot()) {
                    ChangeVerifier.this.verifyRoot(n);
                } else if (NodeUtil.isChangeScopeRoot(n)) {
                    Node clone2 = (Node)ChangeVerifier.this.clonesByCurrent.get(n);
                    snapshotScopeNodes.remove(clone2);
                    ChangeVerifier.this.verifyNode(passNameMsg, n);
                    if (clone2 == null) {
                        ChangeVerifier.this.verifyNewNode(passNameMsg, n);
                    } else {
                        ChangeVerifier.this.verifyNodeChange(passNameMsg, n, clone2);
                    }
                }
            }
        });
        this.verifyDeletedScopeNodes(passNameMsg, snapshotScopeNodes);
    }

    private void verifyDeletedScopeNodes(String passNameMsg, Set<Node> deletedScopeNodes) {
        for (Node snapshotScopeNode : deletedScopeNodes) {
            Node currentNode = (Node)this.clonesByCurrent.inverse().get(snapshotScopeNode);
            if (currentNode.isDeleted()) continue;
            throw new IllegalStateException(passNameMsg + "deleted scope was not reported:\n" + currentNode.toStringTree());
        }
    }

    private void verifyNode(String passNameMsg, Node n) {
        if (n.isDeleted()) {
            throw new IllegalStateException(passNameMsg + "existing scope is improperly marked as deleted:\n" + n.toStringTree());
        }
    }

    private void verifyNewNode(String passNameMsg, Node n) {
        int changeTime = n.getChangeTime();
        if (changeTime == 0 || changeTime < this.snapshotChange) {
            throw new IllegalStateException(passNameMsg + "new scope not explicitly marked as changed:\n" + n.toStringTree());
        }
    }

    private void verifyRoot(Node root) {
        Preconditions.checkState(root.isRoot());
        if (root.getChangeTime() != 0) {
            throw new IllegalStateException("Root nodes should never be marked as changed.");
        }
    }

    private void verifyNodeChange(String passNameMsg, Node n, Node snapshot) {
        if (n.isRoot()) {
            return;
        }
        if (n.getChangeTime() > snapshot.getChangeTime()) {
            if (ChangeVerifier.equalsExcludingFunctions(n, snapshot)) {
                throw new IllegalStateException(passNameMsg + "unchanged scope marked as changed: " + this.getNameForNode(n));
            }
        } else if (!ChangeVerifier.equalsExcludingFunctions(n, snapshot)) {
            throw new IllegalStateException(passNameMsg + "changed scope not marked as changed: " + this.getNameForNode(n));
        }
    }

    String getNameForNode(Node n) {
        String sourceName = NodeUtil.getSourceName(n);
        switch (n.getToken()) {
            case SCRIPT: {
                return "SCRIPT: " + sourceName;
            }
            case FUNCTION: {
                String fnName = NodeUtil.getNearestFunctionName(n);
                if (fnName == null) {
                    fnName = "anonymous@" + n.getLineno() + ":" + n.getCharno();
                }
                return "FUNCTION: " + fnName + " in " + sourceName;
            }
        }
        throw new IllegalStateException("unexpected Node type");
    }

    private static boolean equalsExcludingFunctions(Node thisNode, Node thatNode) {
        if (thisNode == null || thatNode == null) {
            return thisNode == null && thatNode == null;
        }
        if (!thisNode.isEquivalentWithSideEffectsToShallow(thatNode)) {
            return false;
        }
        if (thisNode.getChildCount() != thatNode.getChildCount()) {
            return false;
        }
        if (thisNode.isFunction() && thatNode.isFunction() && NodeUtil.isFunctionDeclaration(thisNode) != NodeUtil.isFunctionDeclaration(thatNode)) {
            return false;
        }
        if (thisNode.hasParent() && thisNode.getParent().isParamList() && thisNode.isUnusedParameter() != thatNode.isUnusedParameter()) {
            return false;
        }
        Node thisChild = thisNode.getFirstChild();
        for (Node thatChild = thatNode.getFirstChild(); thisChild != null && thatChild != null; thisChild = thisChild.getNext(), thatChild = thatChild.getNext()) {
            if (thisChild.isFunction() || thisChild.isScript()) {
                String thatName;
                String thisName;
                if (thatChild.getToken() != thisChild.getToken()) {
                    return false;
                }
                if (!thisChild.isFunction() || !NodeUtil.isFunctionDeclaration(thisChild) || (thisName = thisChild.getFirstChild().getString()).equals(thatName = thatChild.getFirstChild().getString())) continue;
                return false;
            }
            if (ChangeVerifier.equalsExcludingFunctions(thisChild, thatChild)) continue;
            return false;
        }
        return true;
    }
}

