/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.CompilerPass;
import com.google.javascript.jscomp.DiagnosticType;
import com.google.javascript.jscomp.NodeTraversal;
import com.google.javascript.jscomp.Scope;
import com.google.javascript.jscomp.Var;
import com.google.javascript.jscomp.jarjar.com.google.common.base.Preconditions;
import com.google.javascript.jscomp.jarjar.com.google.common.collect.ImmutableMap;
import com.google.javascript.jscomp.jarjar.com.google.common.collect.Sets;
import com.google.javascript.jscomp.jarjar.javax.annotation.Nullable;
import com.google.javascript.jscomp.modules.ModuleMetadataMap;
import com.google.javascript.rhino.JSDocInfo;
import com.google.javascript.rhino.JSTypeExpression;
import com.google.javascript.rhino.Node;
import com.google.javascript.rhino.QualifiedName;
import java.util.HashSet;

public class CheckMissingRequires
extends NodeTraversal.AbstractModuleCallback
implements CompilerPass {
    public static final DiagnosticType MISSING_REQUIRE = DiagnosticType.warning("JSC_MISSING_REQUIRE", "''{0}'' references a fully qualified namespace, which is disallowed by the style guide.\nPlease add a goog.require, assign or destructure it into an alias, and use the alias instead.");
    public static final DiagnosticType MISSING_REQUIRE_TYPE = DiagnosticType.disabled("JSC_MISSING_REQUIRE_TYPE", "''{0}'' references a fully qualified namespace, which is disallowed by the style guide.\nPlease add a goog.requireType, assign or destructure it into an alias, and use the alias instead.");
    public static final DiagnosticType MISSING_REQUIRE_IN_PROVIDES_FILE = DiagnosticType.warning("JSC_MISSING_REQUIRE_IN_PROVIDES_FILE", "''{0}'' references a namespace which was not required by this file.\nPlease add a goog.require.");
    public static final DiagnosticType MISSING_REQUIRE_TYPE_IN_PROVIDES_FILE = DiagnosticType.disabled("JSC_MISSING_REQUIRE_TYPE_IN_PROVIDES_FILE", "''{0}'' references a namespace which was not required by this file.\nPlease add a goog.requireType.");
    private final HashSet<String> templateParamNames = new HashSet();
    private final ImmutableMap<String, ModuleMetadataMap.ModuleMetadata> moduleByNamespace;

    public CheckMissingRequires(AbstractCompiler compiler, ModuleMetadataMap moduleMetadataMap) {
        super(compiler, moduleMetadataMap);
        this.moduleByNamespace = moduleMetadataMap.getModulesByGoogNamespace();
    }

    @Override
    public void process(Node externs, Node root) {
        NodeTraversal.traverse(this.compiler, root, this);
    }

    @Override
    public boolean shouldTraverse(NodeTraversal t, Node n, @Nullable ModuleMetadataMap.ModuleMetadata currentModule, Node scopeRoot) {
        if (currentModule == null) {
            return true;
        }
        this.visitNode(t, n, Preconditions.checkNotNull(currentModule));
        return true;
    }

    @Override
    public void visit(NodeTraversal t, Node n, @Nullable ModuleMetadataMap.ModuleMetadata currentModule, @Nullable Node scopeRoot) {
        if (currentModule != null && n == currentModule.rootNode()) {
            this.templateParamNames.clear();
        }
    }

    private void visitNode(NodeTraversal t, Node n, ModuleMetadataMap.ModuleMetadata currentModule) {
        JSDocInfo info = n.getJSDocInfo();
        if (info != null) {
            this.visitJsDocInfo(t, currentModule, info);
        }
        if (n.isQualifiedName() && !n.getParent().isGetProp()) {
            QualifiedName qualifiedName = n.getQualifiedNameObject();
            String root = qualifiedName.getRoot();
            if (root.equals("this") || root.equals("super")) {
                return;
            }
            this.visitQualifiedName(t, n, currentModule, n.getQualifiedNameObject(), true);
        }
    }

    private void visitJsDocInfo(NodeTraversal t, ModuleMetadataMap.ModuleMetadata currentModule, JSDocInfo info) {
        this.templateParamNames.addAll(info.getTemplateTypeNames());
        this.templateParamNames.addAll(info.getTypeTransformations().keySet());
        if (info.hasType()) {
            this.visitJsDocExpr(t, currentModule, info.getType(), false);
        }
        for (String param : info.getParameterNames()) {
            if (!info.hasParameterType(param)) continue;
            this.visitJsDocExpr(t, currentModule, info.getParameterType(param), false);
        }
        if (info.hasReturnType()) {
            this.visitJsDocExpr(t, currentModule, info.getReturnType(), false);
        }
        if (info.hasEnumParameterType()) {
            this.visitJsDocExpr(t, currentModule, info.getEnumParameterType(), false);
        }
        if (info.hasTypedefType()) {
            this.visitJsDocExpr(t, currentModule, info.getTypedefType(), false);
        }
        if (info.hasThisType()) {
            this.visitJsDocExpr(t, currentModule, info.getThisType(), false);
        }
        if (info.hasBaseType()) {
            this.visitJsDocExpr(t, currentModule, info.getBaseType(), true);
        }
        for (JSTypeExpression expr : info.getExtendedInterfaces()) {
            this.visitJsDocExpr(t, currentModule, expr, true);
        }
        for (JSTypeExpression expr : info.getImplementedInterfaces()) {
            this.visitJsDocExpr(t, currentModule, expr, true);
        }
    }

    private void visitJsDocExpr(NodeTraversal t, ModuleMetadataMap.ModuleMetadata currentModule, JSTypeExpression expr, boolean isStrongReference) {
        for (Node typeNode : expr.getAllTypeNodes()) {
            this.visitQualifiedName(t, typeNode, currentModule, QualifiedName.of(typeNode.getString()), isStrongReference);
        }
    }

    private void visitQualifiedName(NodeTraversal t, Node n, ModuleMetadataMap.ModuleMetadata currentFile, QualifiedName qualifiedName, boolean isStrongReference) {
        if (qualifiedName.isSimple() && this.templateParamNames.contains(qualifiedName.getRoot())) {
            return;
        }
        if (qualifiedName.isSimple() && qualifiedName.getRoot().equals("xid")) {
            return;
        }
        Var var = (Var)t.getScope().getVar(qualifiedName.getRoot());
        if (var != null && ((Scope)var.getScope()).isLocal()) {
            return;
        }
        for (QualifiedName subName = qualifiedName; subName != null; subName = subName.getOwner()) {
            DiagnosticType toReport;
            String namespace = subName.join();
            if (namespace.equals("goog.module")) {
                return;
            }
            if (currentFile.googNamespaces().contains(namespace)) {
                return;
            }
            ModuleMetadataMap.ModuleMetadata requiredFile = this.moduleByNamespace.get(namespace);
            if (requiredFile == null) continue;
            if (currentFile.isModule()) {
                toReport = isStrongReference ? MISSING_REQUIRE : MISSING_REQUIRE_TYPE;
            } else if (!CheckMissingRequires.hasAcceptableRequire(currentFile, subName, requiredFile, isStrongReference)) {
                toReport = isStrongReference ? MISSING_REQUIRE_IN_PROVIDES_FILE : MISSING_REQUIRE_TYPE_IN_PROVIDES_FILE;
            } else {
                return;
            }
            t.report(n, toReport, namespace);
            return;
        }
    }

    private static boolean hasAcceptableRequire(ModuleMetadataMap.ModuleMetadata rdep, QualifiedName namespace, ModuleMetadataMap.ModuleMetadata dep, boolean isStrongReference) {
        Sets.SetView acceptableRequires = rdep.stronglyRequiredGoogNamespaces().elementSet();
        if (!isStrongReference) {
            acceptableRequires = Sets.union(acceptableRequires, rdep.weaklyRequiredGoogNamespaces().elementSet());
        }
        acceptableRequires = Sets.intersection(acceptableRequires, dep.googNamespaces().elementSet());
        for (QualifiedName parent = namespace; parent != null; parent = parent.getOwner()) {
            if (!acceptableRequires.contains(parent.join())) continue;
            return true;
        }
        return false;
    }
}

