/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.CompilerPass;
import com.google.javascript.jscomp.ControlFlowGraph;
import com.google.javascript.jscomp.DataFlowAnalysis;
import com.google.javascript.jscomp.LiveVariablesAnalysis;
import com.google.javascript.jscomp.NodeTraversal;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.jscomp.Scope;
import com.google.javascript.jscomp.SyntacticScopeCreator;
import com.google.javascript.jscomp.Var;
import com.google.javascript.jscomp.graph.DiGraph;
import com.google.javascript.jscomp.jarjar.com.google.common.base.Preconditions;
import com.google.javascript.rhino.IR;
import com.google.javascript.rhino.Node;
import java.util.ArrayDeque;
import java.util.Collection;
import java.util.Deque;
import java.util.Map;

class DeadAssignmentsElimination
extends NodeTraversal.AbstractScopedCallback
implements CompilerPass {
    private final AbstractCompiler compiler;
    private LiveVariablesAnalysis liveness;
    private final Deque<BailoutInformation> functionStack;

    public DeadAssignmentsElimination(AbstractCompiler compiler) {
        this.compiler = compiler;
        this.functionStack = new ArrayDeque<BailoutInformation>();
    }

    @Override
    public void process(Node externs, Node root) {
        Preconditions.checkNotNull(externs);
        Preconditions.checkNotNull(root);
        Preconditions.checkState(this.compiler.getLifeCycleStage().isNormalized());
        NodeTraversal.traverse(this.compiler, root, this);
    }

    @Override
    public void visit(NodeTraversal t, Node n, Node parent) {
        if (this.functionStack.isEmpty()) {
            return;
        }
        if (n.isFunction()) {
            this.functionStack.peekFirst().containsFunction = true;
        } else if (this.isRemovableAssign(n)) {
            this.functionStack.peekFirst().containsRemovableAssign = true;
        }
    }

    @Override
    public void enterScope(NodeTraversal t) {
        if (t.inFunctionBlockScope()) {
            this.functionStack.addFirst(new BailoutInformation());
        }
    }

    @Override
    public void exitScope(NodeTraversal t) {
        if (t.inFunctionBlockScope()) {
            this.eliminateDeadAssignments(t);
            this.functionStack.removeFirst();
        }
    }

    private void eliminateDeadAssignments(NodeTraversal t) {
        Preconditions.checkArgument(t.inFunctionBlockScope());
        Preconditions.checkState(!this.functionStack.isEmpty());
        if (!this.compiler.hasScopeChanged(t.getScopeRoot().getParent())) {
            return;
        }
        BailoutInformation currentFunction = this.functionStack.peekFirst();
        if (currentFunction.containsFunction) {
            return;
        }
        if (!currentFunction.containsRemovableAssign) {
            return;
        }
        Scope blockScope = t.getScope();
        Scope functionScope = blockScope.getParent();
        if (100 < blockScope.getVarCount() + functionScope.getVarCount()) {
            return;
        }
        ControlFlowGraph<Node> cfg = t.getControlFlowGraph();
        SyntacticScopeCreator scopeCreator = new SyntacticScopeCreator(this.compiler);
        NodeUtil.AllVarsDeclaredInFunction allVarsDeclaredInFunction = NodeUtil.getAllVarsDeclaredInFunction(this.compiler, scopeCreator, functionScope);
        this.liveness = new LiveVariablesAnalysis(cfg, functionScope, blockScope, this.compiler, scopeCreator, allVarsDeclaredInFunction);
        this.liveness.analyze();
        Map<String, Var> allVarsInFn = this.liveness.getAllVariables();
        this.tryRemoveDeadAssignments(t, cfg, allVarsInFn);
    }

    boolean isRemovableAssign(Node n) {
        return NodeUtil.isAssignmentOp(n) && n.getFirstChild().isName() || n.isInc() || n.isDec();
    }

    private void tryRemoveDeadAssignments(NodeTraversal t, ControlFlowGraph<Node> cfg, Map<String, Var> allVarsInFn) {
        Collection nodes = cfg.getNodes();
        block5: for (DiGraph.DiGraphNode diGraphNode : nodes) {
            DataFlowAnalysis.LinearFlowState state = (DataFlowAnalysis.LinearFlowState)diGraphNode.getAnnotation();
            Node n = (Node)diGraphNode.getValue();
            if (n == null) continue;
            switch (n.getToken()) {
                case IF: 
                case WHILE: 
                case DO: {
                    this.tryRemoveAssignment(t, NodeUtil.getConditionExpression(n), state, allVarsInFn);
                    continue block5;
                }
                case FOR: 
                case FOR_IN: 
                case FOR_OF: 
                case FOR_AWAIT_OF: {
                    if (!n.isVanillaFor()) continue block5;
                    this.tryRemoveAssignment(t, NodeUtil.getConditionExpression(n), state, allVarsInFn);
                    continue block5;
                }
                case SWITCH: 
                case CASE: 
                case RETURN: {
                    if (!n.hasChildren()) continue block5;
                    this.tryRemoveAssignment(t, n.getFirstChild(), state, allVarsInFn);
                    continue block5;
                }
            }
            this.tryRemoveAssignment(t, n, state, allVarsInFn);
        }
    }

    private void tryRemoveAssignment(NodeTraversal t, Node n, DataFlowAnalysis.LinearFlowState<LiveVariablesAnalysis.LiveVariableLattice> state, Map<String, Var> allVarsInFn) {
        this.tryRemoveAssignment(t, n, n, state, allVarsInFn);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void tryRemoveAssignment(NodeTraversal t, Node n, Node exprRoot, DataFlowAnalysis.LinearFlowState<LiveVariablesAnalysis.LiveVariableLattice> state, Map<String, Var> allVarsInFn) {
        Node parent = n.getParent();
        boolean isDeclarationNode = NodeUtil.isNameDeclaration(parent);
        if (NodeUtil.isAssignmentOp(n) || n.isInc() || n.isDec() || isDeclarationNode) {
            if (parent.isConst()) {
                return;
            }
            Node lhs = isDeclarationNode ? n : n.getFirstChild();
            Node rhs = NodeUtil.getRValueOfLValue(lhs);
            if (rhs != null) {
                this.tryRemoveAssignment(t, rhs, exprRoot, state, allVarsInFn);
                rhs = NodeUtil.getRValueOfLValue(lhs);
            }
            if (isDeclarationNode && lhs.getNext() != null) {
                this.tryRemoveAssignment(t, lhs.getNext(), exprRoot, state, allVarsInFn);
            }
            if (isDeclarationNode && (rhs == null || NodeUtil.isAnyFor(parent.getParent()))) {
                return;
            }
            if (!lhs.isName()) {
                return;
            }
            String name = lhs.getString();
            Scope scope = t.getScope();
            Preconditions.checkState(scope.isFunctionBlockScope() || scope.isBlockScope());
            if (!allVarsInFn.containsKey(name)) {
                return;
            }
            Var var = allVarsInFn.get(name);
            if (this.liveness.getEscapedLocals().contains(var)) {
                return;
            }
            if (rhs != null && rhs.isName() && rhs.getString().equals(var.getName()) && n.isAssign()) {
                rhs.detach();
                n.replaceWith(rhs);
                this.compiler.reportChangeToEnclosingScope(rhs);
                return;
            }
            int index = this.liveness.getVarIndex(var.getName());
            if (state.getOut().isLive(index)) {
                return;
            }
            if (state.getIn().isLive(index) && this.isVariableStillLiveWithinExpression(n, exprRoot, var.getName())) {
                return;
            }
            if (n.isAssign()) {
                rhs.detach();
                n.replaceWith(rhs);
            } else if (NodeUtil.isAssignmentOp(n)) {
                rhs.detach();
                lhs.detach();
                Node op = new Node(NodeUtil.getOpFromAssignmentOp(n), lhs, rhs);
                n.replaceWith(op);
            } else if (n.isInc() || n.isDec()) {
                if (parent.isExprResult()) {
                    n.replaceWith(IR.voidNode(IR.number(0.0).srcref(n)));
                } else if (n.isComma() && n != parent.getLastChild()) {
                    n.detach();
                } else {
                    if (!parent.isVanillaFor() || NodeUtil.getConditionExpression(parent) == n) return;
                    n.replaceWith(IR.empty());
                }
            } else {
                if (!isDeclarationNode) throw new IllegalStateException("Unknown statement");
                rhs.detach();
                IR.exprResult(rhs).insertAfter(parent);
                rhs.getParent().srcref(rhs);
            }
            this.compiler.reportChangeToEnclosingScope(parent);
            return;
        }
        Node c = n.getFirstChild();
        while (c != null) {
            Node next = c.getNext();
            if (!ControlFlowGraph.isEnteringNewCfgNode(c)) {
                this.tryRemoveAssignment(t, c, exprRoot, state, allVarsInFn);
            }
            c = next;
        }
    }

    private boolean isVariableStillLiveWithinExpression(Node n, Node exprRoot, String variable) {
        while (n != exprRoot) {
            VariableLiveness state = VariableLiveness.MAYBE_LIVE;
            switch (n.getParent().getToken()) {
                case OR: 
                case AND: 
                case COALESCE: {
                    if (n.getNext() == null || (state = this.isVariableReadBeforeKill(n.getNext(), variable)) != VariableLiveness.KILL) break;
                    state = VariableLiveness.MAYBE_LIVE;
                    break;
                }
                case HOOK: {
                    if (n.getNext() == null || n.getNext().getNext() == null) break;
                    state = this.checkHookBranchReadBeforeKill(n.getNext(), n.getNext().getNext(), variable);
                    break;
                }
                default: {
                    for (Node sibling = n.getNext(); sibling != null && (state = this.isVariableReadBeforeKill(sibling, variable)) == VariableLiveness.MAYBE_LIVE; sibling = sibling.getNext()) {
                    }
                }
            }
            if (state == VariableLiveness.READ) {
                return true;
            }
            if (state == VariableLiveness.KILL) {
                return false;
            }
            n = n.getParent();
        }
        return false;
    }

    private VariableLiveness isVariableReadBeforeKill(Node n, String variable) {
        if (ControlFlowGraph.isEnteringNewCfgNode(n)) {
            return VariableLiveness.MAYBE_LIVE;
        }
        if (n.isName() && variable.equals(n.getString())) {
            if (NodeUtil.isNameDeclOrSimpleAssignLhs(n, n.getParent())) {
                Preconditions.checkState(n.getParent().isAssign(), n.getParent());
                Node rhs = n.getNext();
                VariableLiveness state = this.isVariableReadBeforeKill(rhs, variable);
                if (state == VariableLiveness.READ) {
                    return state;
                }
                return VariableLiveness.KILL;
            }
            return VariableLiveness.READ;
        }
        switch (n.getToken()) {
            case OR: 
            case AND: 
            case COALESCE: {
                VariableLiveness v1 = this.isVariableReadBeforeKill(n.getFirstChild(), variable);
                VariableLiveness v2 = this.isVariableReadBeforeKill(n.getLastChild(), variable);
                if (v1 != VariableLiveness.MAYBE_LIVE) {
                    return v1;
                }
                if (v2 == VariableLiveness.READ) {
                    return VariableLiveness.READ;
                }
                return VariableLiveness.MAYBE_LIVE;
            }
            case HOOK: {
                VariableLiveness first = this.isVariableReadBeforeKill(n.getFirstChild(), variable);
                if (first != VariableLiveness.MAYBE_LIVE) {
                    return first;
                }
                return this.checkHookBranchReadBeforeKill(n.getSecondChild(), n.getLastChild(), variable);
            }
        }
        for (Node child = n.getFirstChild(); child != null; child = child.getNext()) {
            VariableLiveness state = this.isVariableReadBeforeKill(child, variable);
            if (state == VariableLiveness.MAYBE_LIVE) continue;
            return state;
        }
        return VariableLiveness.MAYBE_LIVE;
    }

    private VariableLiveness checkHookBranchReadBeforeKill(Node trueCase, Node falseCase, String variable) {
        VariableLiveness v1 = this.isVariableReadBeforeKill(trueCase, variable);
        VariableLiveness v2 = this.isVariableReadBeforeKill(falseCase, variable);
        if (v1 == VariableLiveness.READ || v2 == VariableLiveness.READ) {
            return VariableLiveness.READ;
        }
        if (v1 == VariableLiveness.KILL && v2 == VariableLiveness.KILL) {
            return VariableLiveness.KILL;
        }
        return VariableLiveness.MAYBE_LIVE;
    }

    private static enum VariableLiveness {
        MAYBE_LIVE,
        READ,
        KILL;

    }

    private static final class BailoutInformation {
        boolean containsFunction;
        boolean containsRemovableAssign;

        private BailoutInformation() {
        }
    }
}

