/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.javascript.jscomp.CheckLevel;
import com.google.javascript.jscomp.DiagnosticGroup;
import com.google.javascript.jscomp.JSError;
import com.google.javascript.jscomp.WarningsGuard;
import com.google.javascript.jscomp.base.Tri;
import com.google.javascript.jscomp.jarjar.javax.annotation.Nullable;

public final class DiagnosticGroupWarningsGuard
extends WarningsGuard {
    private static final long serialVersionUID = 1L;
    private final DiagnosticGroup group;
    private final CheckLevel level;

    public DiagnosticGroupWarningsGuard(DiagnosticGroup group, CheckLevel level) {
        this.group = group;
        this.level = level;
    }

    @Override
    @Nullable
    public CheckLevel level(JSError error) {
        return this.group.matches(error) ? this.level : null;
    }

    @Override
    public Tri mustRunChecks(DiagnosticGroup otherGroup) {
        if (this.level.isOn()) {
            return otherGroup.getTypes().stream().anyMatch(this.group::matches) ? Tri.TRUE : Tri.UNKNOWN;
        }
        return otherGroup.getTypes().stream().allMatch(this.group::matches) ? Tri.FALSE : Tri.UNKNOWN;
    }

    public String toString() {
        return this.group + "(" + this.level + ")";
    }
}

