/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.AstAnalyzer;
import com.google.javascript.jscomp.AstFactory;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.jscomp.OptionalChainRewriter;
import com.google.javascript.jscomp.Scope;
import com.google.javascript.jscomp.colors.StandardColors;
import com.google.javascript.jscomp.jarjar.com.google.common.annotations.VisibleForTesting;
import com.google.javascript.jscomp.jarjar.com.google.common.base.MoreObjects;
import com.google.javascript.jscomp.jarjar.com.google.common.base.Preconditions;
import com.google.javascript.jscomp.jarjar.com.google.common.base.Supplier;
import com.google.javascript.jscomp.jarjar.com.google.common.collect.ImmutableSet;
import com.google.javascript.jscomp.jarjar.javax.annotation.Nullable;
import com.google.javascript.rhino.IR;
import com.google.javascript.rhino.Node;
import com.google.javascript.rhino.QualifiedName;
import com.google.javascript.rhino.Token;
import com.google.javascript.rhino.jstype.JSType;
import com.google.javascript.rhino.jstype.JSTypeNative;
import java.util.ArrayDeque;
import java.util.EnumSet;

class ExpressionDecomposer {
    private final AbstractCompiler compiler;
    private final AstAnalyzer astAnalyzer;
    private final AstFactory astFactory;
    private final Supplier<String> safeNameIdSupplier;
    private final ImmutableSet<String> knownConstantFunctions;
    private final Scope scope;
    private final EnumSet<Workaround> enabledWorkarounds;
    @Nullable
    private final JSType unknownType;
    private static final int MAX_ITERATIONS = 1000;
    private String tempNamePrefix = "JSCompiler_temp";
    private String resultNamePrefix = "JSCompiler_inline_result";
    private static final QualifiedName WINDOW_LOCATION_ASSIGN = QualifiedName.of("window.location.assign");

    ExpressionDecomposer(AbstractCompiler compiler, Supplier<String> safeNameIdSupplier, ImmutableSet<String> constFunctionNames, Scope scope, EnumSet<Workaround> enabledWorkarounds) {
        Preconditions.checkNotNull(compiler);
        Preconditions.checkNotNull(safeNameIdSupplier);
        Preconditions.checkNotNull(constFunctionNames);
        this.compiler = compiler;
        this.astAnalyzer = compiler.getAstAnalyzer();
        this.astFactory = compiler.createAstFactory();
        this.safeNameIdSupplier = safeNameIdSupplier;
        this.knownConstantFunctions = constFunctionNames;
        this.scope = scope;
        this.enabledWorkarounds = enabledWorkarounds;
        this.unknownType = compiler.hasTypeCheckingRun() && !compiler.hasOptimizationColors() ? compiler.getTypeRegistry().getNativeType(JSTypeNative.UNKNOWN_TYPE) : null;
    }

    void maybeExposeExpression(Node expression) {
        int i = 0;
        while (DecompositionType.DECOMPOSABLE == this.canExposeExpression(expression)) {
            this.exposeExpression(expression);
            if (++i <= 1000) continue;
            throw new IllegalStateException("DecomposeExpression depth exceeded on:\n" + expression.toStringTree());
        }
    }

    private void exposeExpression(Node expression) {
        this.rewriteAllContainingOptionalChains(expression);
        Node expressionRoot = ExpressionDecomposer.findExpressionRoot(expression);
        Preconditions.checkNotNull(expressionRoot);
        Preconditions.checkState(NodeUtil.isStatement(expressionRoot), expressionRoot);
        this.exposeExpression(expressionRoot, expression);
    }

    private void exposeExpression(Node expressionRoot, Node subExpression) {
        Node nodeWithNonconditionalParent = ExpressionDecomposer.findNonconditionalParent(subExpression, expressionRoot);
        boolean hasFollowingSideEffects = this.astAnalyzer.mayHaveSideEffects(nodeWithNonconditionalParent);
        Node exprInjectionPoint = ExpressionDecomposer.findInjectionPoint(nodeWithNonconditionalParent);
        DecompositionState state = new DecompositionState();
        state.sideEffects = hasFollowingSideEffects;
        state.extractBeforeStatement = exprInjectionPoint;
        Node lastExposedSubexpression = null;
        Node expressionToExpose = nodeWithNonconditionalParent;
        Node expressionParent = expressionToExpose.getParent();
        while (expressionParent != expressionRoot) {
            Preconditions.checkState(!ExpressionDecomposer.isConditionalOp(expressionParent) || expressionToExpose.isFirstChildOf(expressionParent), expressionParent);
            if (expressionParent.isAssign()) {
                if (!this.isSafeAssign(expressionParent, state.sideEffects) && !expressionToExpose.isFirstChildOf(expressionParent)) {
                    Node left = expressionParent.getFirstChild();
                    switch (left.getToken()) {
                        case GETELEM: {
                            this.decomposeSubExpressions(left.getLastChild(), null, state);
                        }
                        case GETPROP: {
                            this.decomposeSubExpressions(left.getFirstChild(), null, state);
                            break;
                        }
                        default: {
                            throw new IllegalStateException("Expected a property access: " + left.toStringTree());
                        }
                    }
                }
            } else if (expressionParent.isCall() && NodeUtil.isNormalGet(expressionParent.getFirstChild())) {
                Node callee = expressionParent.getFirstChild();
                if (callee != expressionToExpose) {
                    this.decomposeSubExpressions(callee.getNext(), expressionToExpose, state);
                }
                if (this.isExpressionTreeUnsafe(callee, state.sideEffects) && lastExposedSubexpression != callee.getFirstChild()) {
                    state.sideEffects = true;
                    this.rewriteCallExpression(expressionParent, state);
                }
            } else {
                this.decomposeSubExpressions(expressionParent.getFirstChild(), expressionToExpose, state);
            }
            lastExposedSubexpression = expressionToExpose;
            expressionToExpose = expressionParent;
            expressionParent = expressionToExpose.getParent();
        }
        if (nodeWithNonconditionalParent != subExpression) {
            Node parent = nodeWithNonconditionalParent.getParent();
            boolean needResult = !parent.isExprResult();
            this.extractConditional(nodeWithNonconditionalParent, exprInjectionPoint, needResult);
        }
    }

    private void rewriteAllContainingOptionalChains(Node subExpression) {
        OptionalChainRewriter.Builder optChainRewriterBuilder = OptionalChainRewriter.builder(this.compiler).setTmpVarNameCreator(this::getTempConstantValueName).setScope(this.scope);
        ArrayDeque<OptionalChainRewriter> rewriters = new ArrayDeque<OptionalChainRewriter>();
        Node exprParent = subExpression.getParent();
        while (!NodeUtil.isStatement(exprParent)) {
            Node callee;
            if (NodeUtil.isEndOfFullOptChain(exprParent)) {
                rewriters.addFirst(optChainRewriterBuilder.build(exprParent));
            } else if (exprParent.isCall() && NodeUtil.isOptChainGet(callee = exprParent.getFirstChild())) {
                rewriters.addFirst(optChainRewriterBuilder.build(callee));
            }
            exprParent = exprParent.getParent();
        }
        for (OptionalChainRewriter rewriter : rewriters) {
            rewriter.rewrite();
        }
    }

    void moveExpression(Node expression) {
        String resultName = this.getResultValueName();
        Node injectionPoint = ExpressionDecomposer.findInjectionPoint(expression);
        Preconditions.checkNotNull(injectionPoint);
        Node injectionPointParent = injectionPoint.getParent();
        Preconditions.checkNotNull(injectionPointParent);
        Preconditions.checkState(NodeUtil.isStatementBlock(injectionPointParent));
        expression.replaceWith(IR.name(resultName).copyTypeFrom(expression));
        Node newExpressionRoot = NodeUtil.newVarNode(resultName, expression);
        newExpressionRoot.getFirstChild().copyTypeFrom(expression);
        newExpressionRoot.insertBefore(injectionPoint);
        this.compiler.reportChangeToEnclosingScope(injectionPointParent);
    }

    private static Node findNonconditionalParent(Node subExpression, Node expressionRoot) {
        Node result = subExpression;
        Node child = subExpression;
        Node parent = child.getParent();
        while (parent != expressionRoot) {
            if (ExpressionDecomposer.isConditionalOp(parent) && !child.isFirstChildOf(parent)) {
                result = parent;
            }
            child = parent;
            parent = child.getParent();
        }
        if (NodeUtil.isOptChainNode(result)) {
            result = NodeUtil.getEndOfOptChainSegment(result);
        }
        return result;
    }

    private void decomposeSubExpressions(Node n, Node stopNode, DecompositionState state) {
        if (n == null || n == stopNode) {
            return;
        }
        this.decomposeSubExpressions(n.getNext(), stopNode, state);
        if (NodeUtil.mayBeObjectLitKey(n) || n.isComputedProp()) {
            if (n.isComputedProp()) {
                this.decomposeSubExpressions(n.getSecondChild(), stopNode, state);
            }
            n = n.getFirstChild();
        } else if (n.isTemplateLitSub()) {
            n = n.getFirstChild();
        } else if (!n.isSpread() && !IR.mayBeExpression(n)) {
            return;
        }
        if (this.isExpressionTreeUnsafe(n, state.sideEffects)) {
            state.sideEffects = true;
            state.extractBeforeStatement = this.extractExpression(n, state.extractBeforeStatement);
        }
    }

    private Node extractConditional(Node expr, Node injectionPoint, boolean needResult) {
        Node parent = expr.getParent();
        String tempName = this.getTempValueName();
        Node first = expr.getFirstChild();
        Node second = first.getNext();
        Node last = expr.getLastChild();
        expr.detachChildren();
        Node cond = null;
        Node trueExpr = this.astFactory.createBlock(new Node[0]).srcref(expr);
        Node falseExpr = this.astFactory.createBlock(new Node[0]).srcref(expr);
        switch (expr.getToken()) {
            case HOOK: {
                cond = first;
                trueExpr.addChildToFront(this.astFactory.exprResult(ExpressionDecomposer.buildResultExpression(second, needResult, tempName)));
                falseExpr.addChildToFront(this.astFactory.exprResult(ExpressionDecomposer.buildResultExpression(last, needResult, tempName)));
                break;
            }
            case AND: {
                cond = ExpressionDecomposer.buildResultExpression(first, needResult, tempName);
                trueExpr.addChildToFront(this.astFactory.exprResult(ExpressionDecomposer.buildResultExpression(last, needResult, tempName)));
                break;
            }
            case OR: {
                cond = ExpressionDecomposer.buildResultExpression(first, needResult, tempName);
                falseExpr.addChildToFront(this.astFactory.exprResult(ExpressionDecomposer.buildResultExpression(last, needResult, tempName)));
                break;
            }
            case COALESCE: {
                String tempNameAssign = this.getTempValueName();
                Node tempVarNodeAssign = this.astFactory.createSingleVarNameDeclaration(tempNameAssign).srcrefTreeIfMissing(expr);
                tempVarNodeAssign.insertBefore(injectionPoint);
                Node assignLhs = ExpressionDecomposer.buildResultExpression(first, true, tempNameAssign);
                Node nullNode = this.astFactory.createNull().srcref(expr);
                cond = this.astFactory.createNe(assignLhs, nullNode).srcref(expr);
                trueExpr.addChildToFront(this.astFactory.exprResult(ExpressionDecomposer.buildResultExpression(this.astFactory.createName(tempNameAssign, AstFactory.type(first)).srcref(expr), needResult, tempName)));
                falseExpr.addChildToFront(this.astFactory.exprResult(ExpressionDecomposer.buildResultExpression(last, needResult, tempName)));
                break;
            }
            default: {
                throw new IllegalStateException("Unexpected expression: " + expr);
            }
        }
        Node ifNode = falseExpr.hasChildren() ? this.astFactory.createIf(cond, trueExpr, falseExpr) : this.astFactory.createIf(cond, trueExpr);
        ifNode.srcrefIfMissing(expr);
        if (needResult) {
            Node tempVarNode = this.astFactory.createSingleVarNameDeclaration(tempName).srcrefTreeIfMissing(expr);
            tempVarNode.insertBefore(injectionPoint);
            ifNode.insertAfter(tempVarNode);
            Node replacementValueNode = IR.name(tempName).copyTypeFrom(expr);
            expr.replaceWith(replacementValueNode);
        } else {
            Preconditions.checkArgument(parent.isExprResult());
            parent.replaceWith(ifNode);
        }
        return ifNode;
    }

    private static Node buildResultExpression(Node expr, boolean needResult, String tempName) {
        if (needResult) {
            return IR.assign(IR.name(tempName).copyTypeFrom(expr), expr).copyTypeFrom(expr).srcrefTree(expr);
        }
        return expr;
    }

    private boolean isConstantNameNode(Node n) {
        return n.isName() && (NodeUtil.isConstantVar(n, this.scope) || this.knownConstantFunctions.contains(n.getString()));
    }

    private Node extractExpression(Node expr, Node injectionPoint) {
        Node tempNameValue;
        Preconditions.checkState(!NodeUtil.isLogicalAssignmentOp(expr), expr);
        Node parent = expr.getParent();
        boolean isLhsOfAssignOp = NodeUtil.isAssignmentOp(parent) && !parent.isAssign() && expr.isFirstChildOf(parent);
        Node firstExtractedNode = null;
        if (isLhsOfAssignOp && NodeUtil.isNormalGet(expr)) {
            for (Node n = expr.getFirstChild(); n != null; n = n.getNext()) {
                if (n.isStringLit() || this.isConstantNameNode(n)) continue;
                Node extractedNode = this.extractExpression(n, injectionPoint);
                if (firstExtractedNode != null) continue;
                firstExtractedNode = extractedNode;
            }
        }
        String tempName = this.getTempConstantValueName();
        Node replacementValueNode = IR.name(tempName).copyTypeFrom(expr).srcref(expr);
        if (isLhsOfAssignOp) {
            Preconditions.checkState(expr.isName() || NodeUtil.isNormalGet(expr), expr);
            Node opNode = new Node(NodeUtil.getOpFromAssignmentOp(parent)).copyTypeFrom(parent).srcrefIfMissing(parent);
            Node rightOperand = parent.getLastChild();
            parent.setToken(Token.ASSIGN);
            rightOperand.replaceWith(opNode);
            opNode.addChildToFront(replacementValueNode);
            opNode.addChildToBack(rightOperand);
            tempNameValue = expr.cloneTree();
        } else if (expr.isSpread()) {
            Node spreadCopy = expr.cloneNode();
            spreadCopy.addChildToBack(replacementValueNode);
            expr.replaceWith(spreadCopy);
            switch (parent.getToken()) {
                case ARRAYLIT: 
                case CALL: 
                case NEW: {
                    tempNameValue = this.astFactory.createArraylit(expr).srcref(expr.getOnlyChild());
                    break;
                }
                case OBJECTLIT: {
                    tempNameValue = this.astFactory.createObjectLit(expr).srcref(expr.getOnlyChild());
                    break;
                }
                default: {
                    throw new IllegalStateException("Unexpected parent of SPREAD:" + parent.toStringTree());
                }
            }
        } else {
            expr.replaceWith(replacementValueNode);
            tempNameValue = expr;
        }
        Node tempVarNode = NodeUtil.newVarNode(tempName, tempNameValue);
        tempVarNode.getFirstChild().copyTypeFrom(tempNameValue);
        tempVarNode.getFirstChild().setInferredConstantVar(true);
        Scope containingHoistScope = (Scope)this.scope.getClosestHoistScope();
        containingHoistScope.declare(tempName, tempVarNode.getFirstChild(), null);
        tempVarNode.insertBefore(injectionPoint);
        if (firstExtractedNode == null) {
            firstExtractedNode = tempVarNode;
        }
        Preconditions.checkState(firstExtractedNode.isVar());
        return firstExtractedNode;
    }

    private void rewriteCallExpression(Node call, DecompositionState state) {
        Node receiverNode;
        Node getVarNode;
        Preconditions.checkArgument(call.isCall(), call);
        Node first = call.getFirstChild();
        Preconditions.checkArgument(NodeUtil.isNormalGet(first), first);
        JSType fnCallType = null;
        if (this.astFactory.isAddingTypes()) {
            JSType fnType = first.getJSType();
            fnCallType = fnType.isFunctionType() ? fnType.toMaybeFunctionType().getPropertyType("call") : this.unknownType;
        }
        state.extractBeforeStatement = getVarNode = this.extractExpression(first, state.extractBeforeStatement);
        Node getExprNode = getVarNode.getFirstFirstChild();
        Preconditions.checkArgument(NodeUtil.isNormalGet(getExprNode), getExprNode);
        Node origThisValue = getExprNode.getFirstChild();
        Node functionNameNode = getVarNode.getFirstChild().cloneNode();
        if (origThisValue.isThis()) {
            receiverNode = origThisValue.cloneNode();
        } else if (origThisValue.isSuper()) {
            receiverNode = this.astFactory.createThis(AstFactory.type(origThisValue)).srcref(origThisValue);
        } else {
            Node thisVarNode;
            state.extractBeforeStatement = thisVarNode = this.extractExpression(origThisValue, state.extractBeforeStatement);
            receiverNode = thisVarNode.getFirstChild().cloneNode();
        }
        call.removeFirstChild();
        call.addChildToFront(receiverNode);
        call.addChildToFront(this.astFactory.createGetProp(functionNameNode, "call", AstFactory.type(fnCallType, StandardColors.TOP_OBJECT)).srcrefTreeIfMissing(call));
        call.putBooleanProp(Node.FREE_CALL, false);
    }

    @VisibleForTesting
    public void setTempNamePrefix(String prefix) {
        this.tempNamePrefix = prefix;
    }

    private String getTempValueName() {
        return this.tempNamePrefix + "$jscomp$" + this.safeNameIdSupplier.get();
    }

    @VisibleForTesting
    public void setResultNamePrefix(String prefix) {
        this.resultNamePrefix = prefix;
    }

    private String getResultValueName() {
        return this.resultNamePrefix + "$jscomp$" + this.safeNameIdSupplier.get();
    }

    private String getTempConstantValueName() {
        return this.tempNamePrefix + "_const" + "$jscomp$" + this.safeNameIdSupplier.get();
    }

    private boolean isTempConstantValueName(Node name) {
        return name.isName() && name.getString().startsWith(this.tempNamePrefix + "_const" + "$jscomp$");
    }

    @Nullable
    static Node findInjectionPoint(Node subExpression) {
        Node expressionRoot = ExpressionDecomposer.findExpressionRoot(subExpression);
        Preconditions.checkNotNull(expressionRoot);
        Node injectionPoint = expressionRoot;
        Node parent = injectionPoint.getParent();
        while (parent.isLabel()) {
            injectionPoint = parent;
            parent = injectionPoint.getParent();
        }
        Preconditions.checkState(NodeUtil.isStatementBlock(parent), parent);
        return injectionPoint;
    }

    private static boolean isConditionalOp(Node n) {
        switch (n.getToken()) {
            case HOOK: 
            case AND: 
            case OR: 
            case COALESCE: 
            case OPTCHAIN_GETELEM: 
            case OPTCHAIN_GETPROP: 
            case OPTCHAIN_CALL: {
                return true;
            }
        }
        return false;
    }

    @Nullable
    private static Node findExpressionRoot(Node subExpression) {
        Node child = subExpression;
        for (Node current : child.getAncestors()) {
            Node parent = current.getParent();
            switch (current.getToken()) {
                case EXPR_RESULT: 
                case IF: 
                case SWITCH: 
                case RETURN: 
                case THROW: {
                    Preconditions.checkState(child.isFirstChildOf(current));
                    return current;
                }
                case VAR: 
                case LET: 
                case CONST: {
                    if (NodeUtil.isAnyFor(parent)) break;
                    return current;
                }
                case FOR: {
                    if (child.isFirstChildOf(current)) {
                        return current;
                    }
                }
                case FOR_IN: 
                case FOR_OF: 
                case FOR_AWAIT_OF: 
                case DO: 
                case WHILE: 
                case SCRIPT: 
                case BLOCK: 
                case LABEL: 
                case CASE: 
                case DEFAULT_CASE: 
                case DEFAULT_VALUE: 
                case PARAM_LIST: {
                    return null;
                }
            }
            child = current;
        }
        throw new IllegalStateException("Unexpected AST structure.");
    }

    DecompositionType canExposeExpression(Node subExpression) {
        Node expressionRoot = ExpressionDecomposer.findExpressionRoot(subExpression);
        if (expressionRoot != null) {
            return this.isSubexpressionMovable(expressionRoot, subExpression);
        }
        return DecompositionType.UNDECOMPOSABLE;
    }

    private DecompositionType isSubexpressionMovable(Node expressionRoot, Node subExpression) {
        boolean requiresDecomposition = false;
        boolean seenSideEffects = this.astAnalyzer.mayHaveSideEffects(subExpression);
        if (NodeUtil.isOptChainNode(subExpression) && !NodeUtil.isEndOfFullOptChain(subExpression)) {
            requiresDecomposition = true;
        }
        Node child = subExpression;
        for (Node parent : child.getAncestors()) {
            if (NodeUtil.isNameDeclaration(parent) && !child.isFirstChildOf(parent)) {
                return DecompositionType.UNDECOMPOSABLE;
            }
            if (parent == expressionRoot) {
                return requiresDecomposition ? DecompositionType.DECOMPOSABLE : DecompositionType.MOVABLE;
            }
            if (ExpressionDecomposer.isConditionalOp(parent)) {
                if (child != parent.getFirstChild()) {
                    requiresDecomposition = true;
                }
            } else if (!this.isSafeAssign(parent, seenSideEffects)) {
                EvaluationDirection direction = ExpressionDecomposer.getEvaluationDirection(parent);
                Node n = this.getFirstEvaluatedChild(parent, direction);
                while (n != null && n != child) {
                    if (this.isExpressionTreeUnsafe(n, seenSideEffects)) {
                        seenSideEffects = true;
                        requiresDecomposition = true;
                    }
                    n = this.getNextEvaluatedSibling(n, direction);
                }
                Node first = parent.getFirstChild();
                if (requiresDecomposition && parent.isCall() && NodeUtil.isNormalGet(first)) {
                    return DecompositionType.DECOMPOSABLE;
                }
            }
            child = parent;
        }
        throw new IllegalStateException("Unexpected.");
    }

    private static EvaluationDirection getEvaluationDirection(Node node) {
        switch (node.getToken()) {
            case DEFAULT_VALUE: 
            case DESTRUCTURING_LHS: 
            case ASSIGN: {
                if (!node.getFirstChild().isDestructuringPattern()) break;
                return EvaluationDirection.REVERSE;
            }
        }
        return EvaluationDirection.FORWARD;
    }

    private Node getFirstEvaluatedChild(Node parent, EvaluationDirection direction) {
        return direction == EvaluationDirection.FORWARD ? parent.getFirstChild() : parent.getLastChild();
    }

    private Node getNextEvaluatedSibling(Node node, EvaluationDirection direction) {
        return direction == EvaluationDirection.FORWARD ? node.getNext() : node.getPrevious();
    }

    private boolean isSafeAssign(Node n, boolean seenSideEffects) {
        if (n.isAssign()) {
            Node lhs = n.getFirstChild();
            switch (lhs.getToken()) {
                case NAME: {
                    return true;
                }
                case GETPROP: {
                    return !this.isExpressionTreeUnsafe(lhs.getFirstChild(), seenSideEffects);
                }
                case GETELEM: {
                    return !this.isExpressionTreeUnsafe(lhs.getFirstChild(), seenSideEffects) && !this.isExpressionTreeUnsafe(lhs.getLastChild(), seenSideEffects);
                }
            }
        }
        return false;
    }

    private boolean isExpressionTreeUnsafe(Node tree, boolean followingSideEffectsExist) {
        if (tree.isSpread() && this.isTempConstantValueName(tree.getOnlyChild())) {
            return false;
        }
        if (followingSideEffectsExist) {
            Node parent = tree.getParent();
            if (NodeUtil.isObjectCallMethod(parent, "call") && tree.isFirstChildOf(parent) && (this.isTempConstantValueName(tree.getFirstChild()) || this.knownConstantFunctions.contains(tree.getFirstChild().getQualifiedName()))) {
                return false;
            }
            if (this.enabledWorkarounds.contains((Object)Workaround.BROKEN_IE11_LOCATION_ASSIGN) && WINDOW_LOCATION_ASSIGN.matches(tree)) {
                return false;
            }
            return NodeUtil.canBeSideEffected(tree, this.knownConstantFunctions, this.scope);
        }
        return this.astAnalyzer.mayHaveSideEffects(tree);
    }

    private static enum EvaluationDirection {
        FORWARD,
        REVERSE;

    }

    private static class DecompositionState {
        boolean sideEffects;
        Node extractBeforeStatement;

        private DecompositionState() {
        }

        public String toString() {
            return MoreObjects.toStringHelper(this).add("sideEffects", this.sideEffects).add("extractBeforeStatement", this.extractBeforeStatement).toString();
        }
    }

    public static enum Workaround {
        BROKEN_IE11_LOCATION_ASSIGN;

    }

    static enum DecompositionType {
        UNDECOMPOSABLE,
        MOVABLE,
        DECOMPOSABLE;

    }
}

