/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.CodingConvention;
import com.google.javascript.jscomp.CompilerInput;
import com.google.javascript.jscomp.CompilerPass;
import com.google.javascript.jscomp.DiagnosticType;
import com.google.javascript.jscomp.FindExportableNodes;
import com.google.javascript.jscomp.JSError;
import com.google.javascript.jscomp.NodeTraversal;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.jscomp.Scope;
import com.google.javascript.jscomp.SyntacticScopeCreator;
import com.google.javascript.jscomp.jarjar.com.google.common.annotations.VisibleForTesting;
import com.google.javascript.jscomp.jarjar.com.google.common.base.Preconditions;
import com.google.javascript.jscomp.jarjar.javax.annotation.Nullable;
import com.google.javascript.rhino.IR;
import com.google.javascript.rhino.Node;
import com.google.javascript.rhino.jstype.JSType;
import com.google.javascript.rhino.jstype.JSTypeNative;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;

public class GenerateExports
implements CompilerPass {
    private static final String PROTOTYPE_PROPERTY = "prototype";
    private final AbstractCompiler compiler;
    @Nullable
    private final String exportSymbolFunction;
    @Nullable
    private final String exportPropertyFunction;
    private final boolean allowNonGlobalExports;
    private final Set<String> exportedVariables = new HashSet<String>();
    static final DiagnosticType MISSING_EXPORT_CONVENTION = DiagnosticType.error("JSC_MISSING_EXPORT_CONVENTION", "@export cannot be used without defining a exportProperty and exportSymbol function in the coding convention");
    @VisibleForTesting
    public static final DiagnosticType MISSING_GOOG_FOR_EXPORT = DiagnosticType.error("JSC_MISSING_EXPORT_SYMBOL_DEFINITION", "@export cannot be used without including closure/base.js or other definition of {0} and {1}");

    GenerateExports(AbstractCompiler compiler, boolean allowNonGlobalExports, @Nullable String exportSymbolFunction, @Nullable String exportPropertyFunction) {
        Preconditions.checkNotNull(compiler);
        this.compiler = compiler;
        this.allowNonGlobalExports = allowNonGlobalExports;
        this.exportSymbolFunction = exportSymbolFunction;
        this.exportPropertyFunction = exportPropertyFunction;
    }

    Set<String> getExportedVariableNames() {
        return this.exportedVariables;
    }

    @Override
    public void process(Node externs, Node root) {
        FindExportableNodes findExportableNodes = new FindExportableNodes(this.compiler, this.allowNonGlobalExports);
        NodeTraversal.traverse(this.compiler, root, findExportableNodes);
        LinkedHashMap<String, Node> exports = findExportableNodes.getExports();
        LinkedHashMap<Node, String> es6Exports = findExportableNodes.getEs6ClassExports();
        LinkedHashSet<String> localExports = findExportableNodes.getLocalExports();
        for (String string : localExports) {
            this.addExtern(string);
        }
        if (!(exports.isEmpty() && es6Exports.isEmpty() || this.validateExportMethodsIncluded(exports, es6Exports, root))) {
            return;
        }
        for (Map.Entry entry : es6Exports.entrySet()) {
            this.addExportForEs6Method((Node)entry.getKey(), (String)entry.getValue());
        }
        for (Map.Entry entry : exports.entrySet()) {
            String export = (String)entry.getKey();
            Node context = (Node)entry.getValue();
            this.addExportMethod(exports, export, context);
        }
    }

    private boolean validateExportMethodsIncluded(Map<String, Node> exports, Map<Node, String> es6Exports, Node root) {
        Node errorLocation = !exports.isEmpty() ? exports.values().stream().findFirst().get() : (Node)es6Exports.keySet().stream().findFirst().get();
        if (this.exportSymbolFunction == null || this.exportPropertyFunction == null) {
            this.compiler.report(JSError.make(errorLocation, MISSING_EXPORT_CONVENTION, new String[0]));
            return false;
        }
        if (!this.includesExportMethods(root.getParent())) {
            this.compiler.report(JSError.make(errorLocation, MISSING_GOOG_FOR_EXPORT, this.exportSymbolFunction, this.exportPropertyFunction));
            this.declareExportMethodsInExterns(errorLocation);
            return true;
        }
        return true;
    }

    private boolean includesExportMethods(Node root) {
        Scope globalScope = new SyntacticScopeCreator(this.compiler).createScope(root, (Scope)null);
        String exportPropertyRoot = NodeUtil.getRootOfQualifiedName(this.exportPropertyFunction);
        String exportSymbolRoot = NodeUtil.getRootOfQualifiedName(this.exportSymbolFunction);
        return globalScope.hasSlot(exportPropertyRoot) && globalScope.hasSlot(exportSymbolRoot);
    }

    private void declareExportMethodsInExterns(Node srcref) {
        String exportSymbolRoot;
        String exportPropertyRoot = NodeUtil.getRootOfQualifiedName(this.exportPropertyFunction);
        if (exportPropertyRoot.equals(exportSymbolRoot = NodeUtil.getRootOfQualifiedName(this.exportSymbolFunction))) {
            this.declareSyntheticExternsVar(exportPropertyRoot, srcref);
        } else {
            this.declareSyntheticExternsVar(exportPropertyRoot, srcref);
            this.declareSyntheticExternsVar(exportSymbolRoot, srcref);
        }
    }

    private void declareSyntheticExternsVar(String name, Node srcref) {
        CompilerInput syntheticInput = this.compiler.getSynthesizedExternsInput();
        Node syntheticVarRoot = syntheticInput.getAstRoot(this.compiler);
        Node varDeclaration = IR.var(IR.name(name)).srcrefTree(srcref);
        varDeclaration.setStaticSourceFile(this.compiler.getSynthesizedExternsInput().getSourceFile());
        syntheticVarRoot.addChildToBack(varDeclaration);
        this.compiler.reportChangeToEnclosingScope(varDeclaration);
    }

    private void addExtern(String export) {
        Node objectPrototype = NodeUtil.newQName(this.compiler, "Object.prototype");
        JSType objCtor = this.compiler.getTypeRegistry().getNativeType(JSTypeNative.OBJECT_FUNCTION_TYPE);
        objectPrototype.getFirstChild().setJSType(objCtor);
        Node propstmt = IR.exprResult(IR.getprop(objectPrototype, export));
        propstmt.srcrefTree(this.getSynthesizedExternsRoot());
        propstmt.setOriginalName(export);
        this.getSynthesizedExternsRoot().addChildToBack(propstmt);
        this.compiler.reportChangeToEnclosingScope(propstmt);
    }

    private void recordExportSymbol(String qname) {
        int dot = qname.indexOf(46);
        if (dot == -1) {
            this.exportedVariables.add(qname);
        } else {
            this.exportedVariables.add(qname.substring(0, dot));
        }
    }

    private void addExportForEs6Method(Node memberFunction, String ownerName) {
        Preconditions.checkArgument(memberFunction.isMemberFunctionDef(), memberFunction);
        Preconditions.checkArgument(!ownerName.isEmpty(), ownerName);
        String fullExport = ownerName + "." + memberFunction.getString();
        this.addExportPropertyCall(ownerName, memberFunction, fullExport, memberFunction.getString());
    }

    private void addExportMethod(Map<String, Node> exports, String export, Node context) {
        String methodOwnerName = null;
        boolean isEs5StylePrototypeAssignment = false;
        String propertyName = null;
        if (context.getFirstChild().isGetProp()) {
            Node node = context.getFirstChild();
            Node ownerNode = node.getFirstChild();
            methodOwnerName = ownerNode.getQualifiedName();
            if (ownerNode.isGetProp() && ownerNode.getString().equals(PROTOTYPE_PROPERTY)) {
                isEs5StylePrototypeAssignment = true;
            }
            propertyName = node.getString();
        }
        boolean useExportSymbol = true;
        if (isEs5StylePrototypeAssignment) {
            useExportSymbol = false;
        } else if (methodOwnerName != null && exports.containsKey(methodOwnerName)) {
            useExportSymbol = false;
        }
        if (useExportSymbol) {
            this.addExportSymbolCall(export, context);
        } else {
            this.addExportPropertyCall(methodOwnerName, context, export, propertyName);
        }
    }

    private void addExportPropertyCall(String methodOwnerName, Node context, String export, String propertyName) {
        Preconditions.checkNotNull(methodOwnerName);
        Node call = IR.call(NodeUtil.newQName(this.compiler, this.exportPropertyFunction, context, this.exportPropertyFunction), NodeUtil.newQName(this.compiler, methodOwnerName, context, this.exportPropertyFunction), IR.string(propertyName), NodeUtil.newQName(this.compiler, export, context, this.exportPropertyFunction));
        Node expression = IR.exprResult(call).srcrefTreeIfMissing(context);
        this.addStatement(context, expression);
    }

    private void addExportSymbolCall(String export, Node context) {
        this.recordExportSymbol(export);
        Node call = IR.call(NodeUtil.newQName(this.compiler, this.exportSymbolFunction, context, export), IR.string(export), NodeUtil.newQName(this.compiler, export, context, export));
        Node expression = IR.exprResult(call).srcrefTreeIfMissing(context);
        this.addStatement(context, expression);
    }

    private void addStatement(Node context, Node stmt) {
        Node next;
        Node n;
        CodingConvention convention = this.compiler.getCodingConvention();
        Node exprRoot = n = context;
        while (!NodeUtil.isStatementBlock(exprRoot.getParent())) {
            exprRoot = exprRoot.getParent();
        }
        while ((next = exprRoot.getNext()) != null && NodeUtil.isExprCall(next) && convention.getClassesDefinedByCall(next.getFirstChild()) != null) {
            exprRoot = next;
        }
        stmt.insertAfter(exprRoot);
        this.compiler.reportChangeToEnclosingScope(stmt);
    }

    private Node getSynthesizedExternsRoot() {
        return this.compiler.getSynthesizedExternsInput().getAstRoot(this.compiler);
    }
}

