/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.CompilerOptions;
import com.google.javascript.jscomp.CompilerPass;
import com.google.javascript.rhino.Node;

class InjectRuntimeLibraries
implements CompilerPass {
    private final AbstractCompiler compiler;
    private final Stage stage;
    private static final String RUNTIME_TYPE_CHECK_LIB = "runtime_type_check";

    private InjectRuntimeLibraries(AbstractCompiler compiler, Stage stage) {
        this.compiler = compiler;
        this.stage = stage;
    }

    @Override
    public void process(Node externs, Node root) {
        CompilerOptions options = this.compiler.getOptions();
        switch (this.stage) {
            case CHECKS: {
                this.injectCheckLibraries(options);
                return;
            }
            case OPTIMIZATIONS: {
                this.injectOptimizationsLibraries(options);
                return;
            }
        }
        throw new AssertionError();
    }

    private void injectCheckLibraries(CompilerOptions options) {
        if (options.runtimeTypeCheck || options.forceLibraryInjection.contains(RUNTIME_TYPE_CHECK_LIB)) {
            this.compiler.ensureLibraryInjected(RUNTIME_TYPE_CHECK_LIB, true);
        }
    }

    private void injectOptimizationsLibraries(CompilerOptions options) {
        for (String forced : options.forceLibraryInjection) {
            if (forced.equals(RUNTIME_TYPE_CHECK_LIB)) continue;
            this.compiler.ensureLibraryInjected(forced, true);
        }
    }

    public static InjectRuntimeLibraries forChecks(AbstractCompiler compiler) {
        return new InjectRuntimeLibraries(compiler, Stage.CHECKS);
    }

    public static InjectRuntimeLibraries forOptimizations(AbstractCompiler compiler) {
        return new InjectRuntimeLibraries(compiler, Stage.OPTIMIZATIONS);
    }

    private static enum Stage {
        CHECKS,
        OPTIMIZATIONS;

    }
}

