/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.AbstractScope;
import com.google.javascript.jscomp.CompilerInput;
import com.google.javascript.jscomp.ControlFlowAnalysis;
import com.google.javascript.jscomp.ControlFlowGraph;
import com.google.javascript.jscomp.DiagnosticType;
import com.google.javascript.jscomp.JSChunk;
import com.google.javascript.jscomp.JSError;
import com.google.javascript.jscomp.MemoizedScopeCreator;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.jscomp.Platform;
import com.google.javascript.jscomp.Scope;
import com.google.javascript.jscomp.ScopeCreator;
import com.google.javascript.jscomp.SyntacticScopeCreator;
import com.google.javascript.jscomp.TypedScope;
import com.google.javascript.jscomp.base.JSCompObjects;
import com.google.javascript.jscomp.jarjar.com.google.common.base.Preconditions;
import com.google.javascript.jscomp.jarjar.javax.annotation.Nullable;
import com.google.javascript.jscomp.modules.ModuleMetadataMap;
import com.google.javascript.rhino.InputId;
import com.google.javascript.rhino.Node;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.Iterator;
import java.util.List;

public class NodeTraversal {
    private final AbstractCompiler compiler;
    private final Callback callback;
    private final ScopedCallback scopeCallback;
    private final ScopeCreator scopeCreator;
    private final boolean obeyDestructuringAndDefaultValueExecutionOrder;
    private Node currentNode;
    private Node currentScript;
    private Node currentChangeScope;
    private final Deque<AbstractScope<?, ?>> scopes = new ArrayDeque();
    private final List<Node> scopeRoots = new ArrayList<Node>();
    private final Deque<Object> cfgs = new ArrayDeque<Object>();
    private String sourceName;
    private InputId inputId;
    private CompilerInput compilerInput;
    private static final String MISSING_SOURCE = "[source unknown]";

    public static Builder builder() {
        return new Builder();
    }

    private NodeTraversal(Builder builder) {
        this.compiler = Preconditions.checkNotNull(builder.compiler);
        this.callback = Preconditions.checkNotNull(builder.callback);
        this.scopeCallback = this.callback instanceof ScopedCallback ? (ScopedCallback)this.callback : null;
        this.scopeCreator = builder.scopeCreator == null ? new SyntacticScopeCreator(this.compiler) : builder.scopeCreator;
        this.obeyDestructuringAndDefaultValueExecutionOrder = builder.obeyDestructuringAndDefaultValueExecutionOrder;
    }

    private void throwUnexpectedException(Throwable unexpectedException) {
        String message = unexpectedException.getMessage();
        if (this.currentScript != null) {
            message = unexpectedException.getMessage() + "\n" + this.formatNodeContext("Node", this.currentNode) + (this.currentNode == null ? "" : this.formatNodeContext("Parent", this.currentNode.getParent()));
        }
        this.compiler.throwInternalError(message, unexpectedException);
    }

    private String formatNodeContext(String label, Node n) {
        if (n == null) {
            return "  " + label + ": NULL";
        }
        return "  " + label + "(" + n.toString(false, false, false) + "): " + this.formatNodePosition(n);
    }

    private void traverse(Node root) {
        try {
            this.initTraversal(root);
            this.currentNode = root;
            this.pushScope(root);
            this.traverseBranch(root, null);
            this.popScope();
        }
        catch (Error | Exception unexpectedException) {
            this.throwUnexpectedException(unexpectedException);
        }
    }

    public static void traverse(AbstractCompiler compiler, Node root, Callback cb) {
        NodeTraversal.builder().setCompiler(compiler).setCallback(cb).traverse(root);
    }

    private void traverseRoots(Node externs, Node root) {
        try {
            Node scopeRoot = externs.getParent();
            Preconditions.checkNotNull(scopeRoot);
            this.initTraversal(scopeRoot);
            this.currentNode = scopeRoot;
            this.pushScope(scopeRoot);
            this.traverseBranch(externs, scopeRoot);
            Preconditions.checkState(root.getParent() == scopeRoot);
            this.traverseBranch(root, scopeRoot);
            this.popScope();
        }
        catch (Error | Exception unexpectedException) {
            this.throwUnexpectedException(unexpectedException);
        }
    }

    public static void traverseRoots(AbstractCompiler compiler, Callback cb, Node externs, Node root) {
        NodeTraversal.builder().setCompiler(compiler).setCallback(cb).traverseRoots(externs, root);
    }

    private String formatNodePosition(Node n) {
        String sourceFileName = this.getBestSourceFileName(n);
        if (sourceFileName == null) {
            return "[source unknown]\n";
        }
        int lineNumber = n.getLineno();
        int columnNumber = n.getCharno();
        String src = this.compiler.getSourceLine(sourceFileName, lineNumber);
        if (src == null) {
            src = MISSING_SOURCE;
        }
        return sourceFileName + ":" + lineNumber + ":" + columnNumber + "\n" + src + "\n";
    }

    private void traverseWithScope(Node root, AbstractScope<?, ?> s) {
        Preconditions.checkState(s.isGlobal() || s.isModuleScope(), s);
        try {
            this.initTraversal(root);
            this.currentNode = root;
            this.pushScope(s);
            this.traverseBranch(root, null);
            this.popScope();
        }
        catch (Error | Exception unexpectedException) {
            this.throwUnexpectedException(unexpectedException);
        }
    }

    private void traverseAtScope(AbstractScope<?, ?> s) {
        Node n = s.getRootNode();
        this.initTraversal(n);
        this.currentNode = n;
        ArrayDeque parentScopes = new ArrayDeque();
        for (Object temp = s.getParent(); temp != null; temp = ((AbstractScope)temp).getParent()) {
            parentScopes.push(temp);
        }
        while (!parentScopes.isEmpty()) {
            this.pushScope((AbstractScope)parentScopes.pop(), true);
        }
        if (n.isFunction()) {
            if (this.callback.shouldTraverse(this, n, null)) {
                this.pushScope(s);
                Node fnName = n.getFirstChild();
                Node args = fnName.getNext();
                Node body = args.getNext();
                if (!NodeUtil.isFunctionDeclaration(n)) {
                    this.traverseBranch(fnName, n);
                }
                this.traverseBranch(args, n);
                this.traverseBranch(body, n);
                this.popScope();
                this.callback.visit(this, n, null);
            }
        } else if (n.isClass()) {
            if (this.callback.shouldTraverse(this, n, null)) {
                this.pushScope(s);
                Node className = n.getFirstChild();
                Node body = n.getLastChild();
                if (NodeUtil.isClassExpression(n)) {
                    this.traverseBranch(className, n);
                }
                this.traverseBranch(body, n);
                this.popScope();
                this.callback.visit(this, n, null);
            }
        } else if (n.isBlock()) {
            if (this.callback.shouldTraverse(this, n, null)) {
                this.pushScope(s);
                this.traverseChildren(n);
                this.popScope();
                this.callback.visit(this, n, null);
            }
        } else if (NodeUtil.isAnyFor(n)) {
            if (this.callback.shouldTraverse(this, n, null)) {
                this.pushScope(s);
                Node forAssignmentParam = n.getFirstChild();
                Node forIterableParam = forAssignmentParam.getNext();
                Node forBodyScope = forIterableParam.getNext();
                this.traverseBranch(forAssignmentParam, n);
                this.traverseBranch(forIterableParam, n);
                this.traverseBranch(forBodyScope, n);
                this.popScope();
                this.callback.visit(this, n, null);
            }
        } else if (n.isSwitch()) {
            if (this.callback.shouldTraverse(this, n, null)) {
                this.pushScope(s);
                this.traverseChildren(n);
                this.popScope();
                this.callback.visit(this, n, null);
            }
        } else {
            Preconditions.checkState(s.isGlobal() || s.isModuleScope(), "Expected global or module scope. Got:", s);
            this.traverseWithScope(n, s);
        }
    }

    public static void traverseScopeRoots(AbstractCompiler compiler, @Nullable Node root, @Nullable List<Node> scopeNodes, final Callback cb, final boolean traverseNested) {
        if (scopeNodes == null) {
            NodeTraversal.traverse(compiler, root, cb);
            return;
        }
        class TraverseScopeRootsCallback
        implements ScopedCallback {
            boolean insideScopeNode = false;
            Node scopeNode = null;

            TraverseScopeRootsCallback() {
            }

            @Override
            public boolean shouldTraverse(NodeTraversal t, Node n, Node parent) {
                if (this.scopeNode == n) {
                    this.insideScopeNode = true;
                }
                return (traverseNested || this.scopeNode == n || !NodeUtil.isChangeScopeRoot(n)) && cb.shouldTraverse(t, n, parent);
            }

            @Override
            public void visit(NodeTraversal t, Node n, Node parent) {
                if (this.scopeNode == n) {
                    this.insideScopeNode = false;
                }
                cb.visit(t, n, parent);
            }

            @Override
            public void enterScope(NodeTraversal t) {
                if (this.insideScopeNode && cb instanceof ScopedCallback) {
                    ((ScopedCallback)cb).enterScope(t);
                }
            }

            @Override
            public void exitScope(NodeTraversal t) {
                if (this.insideScopeNode && cb instanceof ScopedCallback) {
                    ((ScopedCallback)cb).exitScope(t);
                }
            }
        }
        TraverseScopeRootsCallback scb = new TraverseScopeRootsCallback();
        MemoizedScopeCreator scopeCreator = new MemoizedScopeCreator(new SyntacticScopeCreator(compiler));
        Iterator<Node> iterator = scopeNodes.iterator();
        while (iterator.hasNext()) {
            Node scopeNode;
            scb.scopeNode = scopeNode = iterator.next();
            NodeTraversal.builder().setCompiler(compiler).setCallback(scb).setScopeCreator(scopeCreator).build().traverseScopeRoot(scopeNode);
        }
    }

    private void traverseScopeRoot(Node scopeRoot) {
        try {
            this.initTraversal(scopeRoot);
            this.currentNode = scopeRoot;
            this.initScopeRoots(scopeRoot.getParent());
            this.traverseBranch(scopeRoot, scopeRoot.getParent());
        }
        catch (Error | Exception unexpectedException) {
            this.throwUnexpectedException(unexpectedException);
        }
    }

    public AbstractCompiler getCompiler() {
        return this.compiler;
    }

    public String getSourceName() {
        if (this.sourceName == null) {
            this.sourceName = this.currentScript != null ? this.currentScript.getSourceFileName() : "";
        }
        return this.sourceName;
    }

    public CompilerInput getInput() {
        InputId inputId = this.getInputId();
        if (this.compilerInput == null && inputId != null) {
            this.compilerInput = this.compiler.getInput(inputId);
        }
        return this.compilerInput;
    }

    public JSChunk getChunk() {
        CompilerInput input = this.getInput();
        return input == null ? null : input.getChunk();
    }

    public Node getCurrentNode() {
        return this.currentNode;
    }

    private void handleScript(Node n, Node parent) {
        if (Platform.isThreadInterrupted()) {
            throw new RuntimeException(new InterruptedException());
        }
        this.setChangeScope(n);
        this.currentNode = n;
        this.currentScript = n;
        this.clearScriptState();
        if (this.callback.shouldTraverse(this, n, parent)) {
            this.traverseChildren(n);
            this.currentNode = n;
            this.callback.visit(this, n, parent);
        }
        this.setChangeScope(null);
    }

    private void handleFunction(Node n, Node parent) {
        Node changeScope = this.currentChangeScope;
        this.setChangeScope(n);
        this.currentNode = n;
        if (this.callback.shouldTraverse(this, n, parent)) {
            this.traverseFunction(n, parent);
            this.currentNode = n;
            this.callback.visit(this, n, parent);
        }
        this.setChangeScope(changeScope);
    }

    private void handleModule(Node n, Node parent) {
        this.pushScope(n);
        this.currentNode = n;
        if (this.callback.shouldTraverse(this, n, parent)) {
            this.currentNode = n;
            this.traverseChildren(n);
            this.callback.visit(this, n, parent);
        }
        this.popScope();
    }

    private void handleDestructuringOrDefaultValue(Node n, Node parent) {
        this.currentNode = n;
        if (this.callback.shouldTraverse(this, n, parent)) {
            Node first = n.getFirstChild();
            Node second = first.getNext();
            if (second != null) {
                Preconditions.checkState(second.getNext() == null, second);
                this.traverseBranch(second, n);
            }
            this.traverseBranch(first, n);
            this.currentNode = n;
            this.callback.visit(this, n, parent);
        }
    }

    private void traverseBranch(Node n, Node parent) {
        switch (n.getToken()) {
            case SCRIPT: {
                this.handleScript(n, parent);
                return;
            }
            case FUNCTION: {
                this.handleFunction(n, parent);
                return;
            }
            case MODULE_BODY: {
                this.handleModule(n, parent);
                return;
            }
            case CLASS: {
                this.handleClass(n, parent);
                return;
            }
            case CLASS_MEMBERS: {
                this.handleClassMembers(n, parent);
                return;
            }
            case DEFAULT_VALUE: 
            case DESTRUCTURING_LHS: {
                if (!this.obeyDestructuringAndDefaultValueExecutionOrder) break;
                this.handleDestructuringOrDefaultValue(n, parent);
                return;
            }
        }
        this.currentNode = n;
        if (!this.callback.shouldTraverse(this, n, parent)) {
            return;
        }
        boolean createsBlockScope = NodeUtil.createsBlockScope(n);
        if (createsBlockScope) {
            this.pushScope(n);
        }
        Node child = n.getFirstChild();
        while (child != null) {
            Node next = child.getNext();
            this.traverseBranch(child, n);
            child = next;
        }
        if (createsBlockScope) {
            this.popScope();
        }
        this.currentNode = n;
        this.callback.visit(this, n, parent);
    }

    private void traverseFunction(Node n, Node parent) {
        boolean isFunctionDeclaration;
        Node fnName = n.getFirstChild();
        boolean bl = isFunctionDeclaration = parent != null && NodeUtil.isFunctionDeclaration(n);
        if (isFunctionDeclaration) {
            this.traverseBranch(fnName, n);
        }
        this.currentNode = n;
        this.pushScope(n);
        if (!isFunctionDeclaration) {
            this.traverseBranch(fnName, n);
        }
        Node args = fnName.getNext();
        Node body = args.getNext();
        this.traverseBranch(args, n);
        this.traverseBranch(body, n);
        this.popScope();
    }

    private void handleClass(Node n, Node parent) {
        this.currentNode = n;
        if (!this.callback.shouldTraverse(this, n, parent)) {
            return;
        }
        Node className = n.getFirstChild();
        Node extendsClause = className.getNext();
        Node body = extendsClause.getNext();
        boolean isClassExpression = NodeUtil.isClassExpression(n);
        this.traverseBranch(extendsClause, n);
        Node child = body.getFirstChild();
        while (child != null) {
            Node next = child.getNext();
            if (child.isComputedProp()) {
                this.traverseBranch(child.getFirstChild(), child);
            }
            child = next;
        }
        if (!isClassExpression) {
            this.traverseBranch(className, n);
        }
        this.currentNode = n;
        this.pushScope(n);
        if (isClassExpression) {
            this.traverseBranch(className, n);
        }
        this.traverseBranch(body, n);
        this.popScope();
        this.currentNode = n;
        this.callback.visit(this, n, parent);
    }

    private void handleClassMembers(Node n, Node parent) {
        this.currentNode = n;
        if (!this.callback.shouldTraverse(this, n, parent)) {
            return;
        }
        Node child = n.getFirstChild();
        while (child != null) {
            Node next = child.getNext();
            if (child.isComputedProp()) {
                this.currentNode = n;
                if (this.callback.shouldTraverse(this, child, n)) {
                    this.traverseBranch(child.getLastChild(), child);
                    this.currentNode = n;
                    this.callback.visit(this, child, n);
                }
            } else {
                this.traverseBranch(child, n);
            }
            child = next;
        }
        this.currentNode = n;
        this.callback.visit(this, n, parent);
    }

    private void traverseChildren(Node n) {
        Node child = n.getFirstChild();
        while (child != null) {
            Node next = child.getNext();
            this.traverseBranch(child, n);
            child = next;
        }
    }

    public Node getEnclosingFunction() {
        Node root = this.getCfgRoot();
        return root.isFunction() ? root : null;
    }

    private void recordScopeRoot(Node node) {
        if (NodeUtil.isValidCfgRoot(node)) {
            this.cfgs.push(node);
        }
    }

    private void pushScope(Node node) {
        Preconditions.checkNotNull(this.currentNode);
        Preconditions.checkNotNull(node);
        this.scopeRoots.add(node);
        this.recordScopeRoot(node);
        if (this.scopeCallback != null) {
            this.scopeCallback.enterScope(this);
        }
    }

    private void pushScope(AbstractScope<?, ?> s) {
        this.pushScope(s, false);
    }

    private void pushScope(AbstractScope<?, ?> s, boolean quietly) {
        Preconditions.checkNotNull(this.currentNode);
        this.scopes.push(s);
        this.recordScopeRoot(s.getRootNode());
        if (!quietly && this.scopeCallback != null) {
            this.scopeCallback.enterScope(this);
        }
    }

    private void popScope() {
        this.popScope(false);
    }

    private void popScope(boolean quietly) {
        int roots;
        Node scopeRoot;
        if (!quietly && this.scopeCallback != null) {
            this.scopeCallback.exitScope(this);
        }
        if (NodeUtil.isValidCfgRoot(scopeRoot = (roots = this.scopeRoots.size()) > 0 ? this.scopeRoots.remove(roots - 1) : this.scopes.pop().getRootNode())) {
            this.cfgs.pop();
        }
    }

    public AbstractScope<?, ?> getAbstractScope() {
        AbstractScope<?, ?> scope = this.scopes.peek();
        for (Node scopeRoot : this.scopeRoots) {
            scope = this.scopeCreator.createScope(scopeRoot, scope);
            this.scopes.push(scope);
        }
        this.scopeRoots.clear();
        return scope;
    }

    private AbstractScope<?, ?> instantiateScopes(int count) {
        Preconditions.checkArgument(count <= this.scopeRoots.size());
        AbstractScope<?, ?> scope = this.scopes.peek();
        for (int i = 0; i < count; ++i) {
            scope = this.scopeCreator.createScope(this.scopeRoots.get(i), scope);
            this.scopes.push(scope);
        }
        this.scopeRoots.subList(0, count).clear();
        return scope;
    }

    public boolean isHoistScope() {
        return NodeTraversal.isHoistScopeRootNode(this.getScopeRoot());
    }

    public Node getClosestHoistScopeRoot() {
        int roots;
        for (int i = roots = this.scopeRoots.size(); i > 0; --i) {
            Node rootNode = this.scopeRoots.get(i - 1);
            if (!NodeTraversal.isHoistScopeRootNode(rootNode)) continue;
            return rootNode;
        }
        return ((AbstractScope)this.scopes.peek().getClosestHoistScope()).getRootNode();
    }

    public AbstractScope<?, ?> getClosestContainerScope() {
        for (int i = this.scopeRoots.size(); i > 0; --i) {
            if (NodeUtil.createsBlockScope(this.scopeRoots.get(i - 1))) continue;
            return this.instantiateScopes(i);
        }
        return this.scopes.peek().getClosestContainerScope();
    }

    public AbstractScope<?, ?> getClosestHoistScope() {
        for (int i = this.scopeRoots.size(); i > 0; --i) {
            if (!NodeTraversal.isHoistScopeRootNode(this.scopeRoots.get(i - 1))) continue;
            return this.instantiateScopes(i);
        }
        return this.scopes.peek().getClosestHoistScope();
    }

    private static boolean isHoistScopeRootNode(Node n) {
        switch (n.getToken()) {
            case SCRIPT: 
            case FUNCTION: 
            case MODULE_BODY: 
            case ROOT: {
                return true;
            }
        }
        return NodeUtil.isFunctionBlock(n);
    }

    public Scope getScope() {
        return this.getAbstractScope().untyped();
    }

    public TypedScope getTypedScope() {
        return this.getAbstractScope().typed();
    }

    public ControlFlowGraph<Node> getControlFlowGraph() {
        ControlFlowGraph<Node> result;
        Object o = this.cfgs.peek();
        if (o instanceof Node) {
            Node cfgRoot = (Node)o;
            ControlFlowAnalysis cfa = new ControlFlowAnalysis(this.compiler, false, true);
            cfa.process(null, cfgRoot);
            result = cfa.getCfg();
            this.cfgs.pop();
            this.cfgs.push(result);
        } else {
            result = (ControlFlowGraph<Node>)o;
        }
        return result;
    }

    public Node getScopeRoot() {
        int roots = this.scopeRoots.size();
        if (roots > 0) {
            return this.scopeRoots.get(roots - 1);
        }
        AbstractScope<?, ?> s = this.scopes.peek();
        return s != null ? s.getRootNode() : null;
    }

    private Node getCfgRoot() {
        Object o = this.cfgs.peek();
        Node result = o instanceof Node ? (Node)o : (Node)((ControlFlowGraph)o).getEntry().getValue();
        return result;
    }

    public ScopeCreator getScopeCreator() {
        return this.scopeCreator;
    }

    public boolean inGlobalScope() {
        return this.getScopeDepth() == 0;
    }

    public boolean inModuleScope() {
        return NodeUtil.isModuleScopeRoot(this.getScopeRoot());
    }

    public boolean inGlobalOrModuleScope() {
        return this.inGlobalScope() || this.inModuleScope();
    }

    public boolean inFunctionBlockScope() {
        return NodeUtil.isFunctionBlock(this.getScopeRoot());
    }

    public boolean inGlobalHoistScope() {
        Node cfgRoot = this.getCfgRoot();
        Preconditions.checkState(cfgRoot.isScript() || cfgRoot.isRoot() || cfgRoot.isBlock() || cfgRoot.isFunction() || cfgRoot.isModuleBody(), cfgRoot);
        return cfgRoot.isScript() || cfgRoot.isRoot() || cfgRoot.isBlock();
    }

    public boolean inModuleHoistScope() {
        Node moduleRoot = this.getCfgRoot();
        if (moduleRoot.isFunction()) {
            moduleRoot = moduleRoot.getLastChild();
        }
        return NodeUtil.isModuleScopeRoot(moduleRoot);
    }

    int getScopeDepth() {
        int sum = this.scopes.size() + this.scopeRoots.size();
        Preconditions.checkState(sum > 0);
        return sum - 1;
    }

    public void report(Node n, DiagnosticType diagnosticType, String ... arguments) {
        JSError error = JSError.make(n, diagnosticType, arguments);
        this.compiler.report(error);
    }

    public void reportCodeChange() {
        Node changeScope = this.currentChangeScope;
        Preconditions.checkNotNull(changeScope);
        Preconditions.checkState(NodeUtil.isChangeScopeRoot(changeScope), changeScope);
        this.compiler.reportChangeToChangeScope(changeScope);
    }

    public void reportCodeChange(Node n) {
        this.compiler.reportChangeToEnclosingScope(n);
    }

    @Nullable
    Node getCurrentScript() {
        return this.currentScript;
    }

    private void setChangeScope(Node n) {
        this.currentChangeScope = n;
    }

    private Node getEnclosingScript(Node n) {
        while (n != null && !n.isScript()) {
            n = n.getParent();
        }
        return n;
    }

    private void initTraversal(Node traversalRoot) {
        Node script;
        if (Platform.isThreadInterrupted()) {
            throw new RuntimeException(new InterruptedException());
        }
        Node changeScope = NodeUtil.getEnclosingChangeScopeRoot(traversalRoot);
        this.setChangeScope(changeScope);
        this.currentScript = script = this.getEnclosingScript(changeScope);
        this.clearScriptState();
    }

    private void initScopeRoots(Node n) {
        ArrayDeque<Node> queuedScopeRoots = new ArrayDeque<Node>();
        while (n != null) {
            if (this.isScopeRoot(n)) {
                queuedScopeRoots.addFirst(n);
            }
            n = n.getParent();
        }
        for (Node queuedScopeRoot : queuedScopeRoots) {
            this.pushScope(queuedScopeRoot);
        }
    }

    private boolean isScopeRoot(Node n) {
        if (n.isRoot() && n.getParent() == null) {
            return true;
        }
        if (n.isFunction()) {
            return true;
        }
        return NodeUtil.createsBlockScope(n);
    }

    private void clearScriptState() {
        this.inputId = null;
        this.sourceName = null;
        this.compilerInput = null;
    }

    InputId getInputId() {
        if (this.currentScript != null && this.inputId == null) {
            this.inputId = this.currentScript.getInputId();
        }
        return this.inputId;
    }

    private String getBestSourceFileName(Node n) {
        return n == null ? this.getSourceName() : n.getSourceFileName();
    }

    public static final class Builder {
        private Callback callback;
        private AbstractCompiler compiler;
        private ScopeCreator scopeCreator;
        private boolean obeyDestructuringAndDefaultValueExecutionOrder = false;

        private Builder() {
        }

        public Builder setCallback(Callback x) {
            this.callback = x;
            return this;
        }

        public Builder setCallback(final AbstractPostOrderCallbackInterface x) {
            this.callback = new AbstractPostOrderCallback(){

                @Override
                public void visit(NodeTraversal t, Node n, Node parent) {
                    x.visit(t, n, parent);
                }
            };
            return this;
        }

        public Builder setCompiler(AbstractCompiler x) {
            this.compiler = x;
            return this;
        }

        public Builder setScopeCreator(ScopeCreator x) {
            this.scopeCreator = x;
            return this;
        }

        public Builder setObeyDestructuringAndDefaultValueExecutionOrder(boolean x) {
            this.obeyDestructuringAndDefaultValueExecutionOrder = x;
            return this;
        }

        public NodeTraversal build() {
            return new NodeTraversal(this);
        }

        public void traverse(Node root) {
            this.build().traverse(root);
        }

        void traverseAtScope(AbstractScope<?, ?> scope) {
            this.build().traverseAtScope(scope);
        }

        void traverseRoots(Node externs, Node root) {
            this.build().traverseRoots(externs, root);
        }

        void traverseWithScope(Node root, AbstractScope<?, ?> s) {
            this.build().traverseWithScope(root, s);
        }
    }

    public static abstract class AbstractChangedScopeCallback
    extends AbstractPreOrderCallback {
        abstract void enterChangedScopeRoot(AbstractCompiler var1, Node var2);

        @Override
        public final boolean shouldTraverse(NodeTraversal t, Node n, Node parent) {
            if (NodeUtil.isChangeScopeRoot(n) && t.getCompiler().hasScopeChanged(n)) {
                this.enterChangedScopeRoot(t.getCompiler(), n);
            }
            return true;
        }
    }

    public static abstract class AbstractModuleCallback
    implements Callback {
        protected final AbstractCompiler compiler;
        private final ModuleMetadataMap moduleMetadataMap;
        @Nullable
        private ModuleMetadataMap.ModuleMetadata currentModule;
        @Nullable
        private Node scopeRoot;
        private boolean inLoadModule;

        AbstractModuleCallback(AbstractCompiler compiler, ModuleMetadataMap moduleMetadataMap) {
            this.compiler = compiler;
            this.moduleMetadataMap = moduleMetadataMap;
        }

        protected void enterModule(ModuleMetadataMap.ModuleMetadata currentModule, Node moduleScopeRoot) {
        }

        protected void exitModule(ModuleMetadataMap.ModuleMetadata oldModule, Node moduleScopeRoot) {
        }

        @Override
        public final boolean shouldTraverse(NodeTraversal t, Node n, Node parent) {
            switch (n.getToken()) {
                case SCRIPT: {
                    this.currentModule = this.moduleMetadataMap.getModulesByPath().get(t.getInput().getPath().toString());
                    Preconditions.checkNotNull(this.currentModule);
                    this.scopeRoot = n.hasChildren() && n.getFirstChild().isModuleBody() ? n.getFirstChild() : n;
                    this.enterModule(this.currentModule, this.scopeRoot);
                    break;
                }
                case BLOCK: {
                    if (!NodeUtil.isBundledGoogModuleScopeRoot(n)) break;
                    this.scopeRoot = n;
                    this.inLoadModule = true;
                    break;
                }
                case CALL: {
                    if (!this.inLoadModule || !n.getFirstChild().matchesQualifiedName("goog.module")) break;
                    ModuleMetadataMap.ModuleMetadata newModule = this.moduleMetadataMap.getModulesByGoogNamespace().get(n.getLastChild().getString());
                    Preconditions.checkNotNull(newModule);
                    if (JSCompObjects.identical(newModule, this.currentModule)) break;
                    this.currentModule = newModule;
                    this.enterModule(this.currentModule, this.scopeRoot);
                    break;
                }
            }
            return this.shouldTraverse(t, n, this.currentModule, this.scopeRoot);
        }

        protected boolean shouldTraverse(NodeTraversal t, Node n, @Nullable ModuleMetadataMap.ModuleMetadata currentModule, @Nullable Node moduleScopeRoot) {
            return true;
        }

        @Override
        public final void visit(NodeTraversal t, Node n, Node parent) {
            switch (n.getToken()) {
                case SCRIPT: {
                    Preconditions.checkNotNull(this.currentModule);
                    this.exitModule(this.currentModule, this.scopeRoot);
                    this.currentModule = null;
                    this.scopeRoot = null;
                    break;
                }
                case BLOCK: {
                    if (!NodeUtil.isBundledGoogModuleScopeRoot(n)) break;
                    Preconditions.checkNotNull(this.currentModule);
                    this.exitModule(this.currentModule, this.scopeRoot);
                    this.scopeRoot = n.getGrandparent().getGrandparent();
                    this.inLoadModule = false;
                    this.currentModule = this.moduleMetadataMap.getModulesByPath().get(t.getInput().getPath().toString());
                    Preconditions.checkNotNull(this.currentModule);
                    break;
                }
            }
            this.visit(t, n, this.currentModule, this.scopeRoot);
        }

        protected void visit(NodeTraversal t, Node n, @Nullable ModuleMetadataMap.ModuleMetadata currentModule, @Nullable Node moduleScopeRoot) {
        }
    }

    public static abstract class AbstractShallowStatementCallback
    implements Callback {
        @Override
        public final boolean shouldTraverse(NodeTraversal nodeTraversal, Node n, Node parent) {
            return parent == null || NodeUtil.isControlStructure(parent) || NodeUtil.isStatementBlock(parent);
        }
    }

    public static abstract class AbstractShallowCallback
    implements Callback {
        @Override
        public final boolean shouldTraverse(NodeTraversal nodeTraversal, Node n, Node parent) {
            return parent == null || !parent.isFunction() || n == parent.getFirstChild();
        }
    }

    public static abstract class AbstractScopedCallback
    implements ScopedCallback {
        @Override
        public final boolean shouldTraverse(NodeTraversal nodeTraversal, Node n, Node parent) {
            return true;
        }

        @Override
        public void enterScope(NodeTraversal t) {
        }

        @Override
        public void exitScope(NodeTraversal t) {
        }
    }

    public static abstract class AbstractPreOrderCallback
    implements Callback {
        @Override
        public final void visit(NodeTraversal t, Node n, Node parent) {
        }
    }

    @FunctionalInterface
    public static interface AbstractPostOrderCallbackInterface {
        public void visit(NodeTraversal var1, Node var2, Node var3);
    }

    public static abstract class ExternsSkippingCallback
    implements Callback {
        @Override
        public final boolean shouldTraverse(NodeTraversal t, Node n, Node parent) {
            return !n.isScript() || !n.isFromExterns() || NodeUtil.isFromTypeSummary(n);
        }
    }

    public static abstract class AbstractPostOrderCallback
    implements Callback {
        @Override
        public final boolean shouldTraverse(NodeTraversal nodeTraversal, Node n, Node parent) {
            return true;
        }
    }

    public static interface ScopedCallback
    extends Callback {
        public void enterScope(NodeTraversal var1);

        public void exitScope(NodeTraversal var1);
    }

    public static interface Callback {
        public boolean shouldTraverse(NodeTraversal var1, Node var2, Node var3);

        public void visit(NodeTraversal var1, Node var2, Node var3);
    }
}

