/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.CompilerPass;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.jscomp.OptimizeCalls;
import com.google.javascript.jscomp.diagnostic.LogFile;
import com.google.javascript.jscomp.jarjar.com.google.common.annotations.VisibleForTesting;
import com.google.javascript.jscomp.jarjar.com.google.common.base.Preconditions;
import com.google.javascript.rhino.IR;
import com.google.javascript.rhino.Node;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

class OptimizeReturns
implements OptimizeCalls.CallGraphCompilerPass,
CompilerPass {
    private final AbstractCompiler compiler;
    private LogFile decisionsLog;

    OptimizeReturns(AbstractCompiler compiler) {
        this.compiler = compiler;
    }

    @Override
    @VisibleForTesting
    public void process(Node externs, Node root) {
        OptimizeCalls.builder().setCompiler(this.compiler).setConsiderExterns(false).addPass(this).build().process(externs, root);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void process(Node externs, Node root, OptimizeCalls.ReferenceMap definitions) {
        try (LogFile logFile = this.compiler.createOrReopenIndexedLog(this.getClass(), "decisions.log", new String[0]);){
            ArrayList<Node> refs;
            String key;
            this.decisionsLog = logFile;
            ArrayList<ArrayList<Node>> toOptimize = new ArrayList<ArrayList<Node>>();
            for (Map.Entry<String, ArrayList<Node>> entry : definitions.getNameReferences()) {
                key = entry.getKey();
                if (!this.isCandidate(key, refs = entry.getValue())) continue;
                this.decisionsLog.log("name %s\tremoving return value", key);
                toOptimize.add(refs);
            }
            for (Map.Entry<String, ArrayList<Node>> entry : definitions.getPropReferences()) {
                key = entry.getKey();
                if (!this.isCandidate(key, refs = entry.getValue())) continue;
                this.decisionsLog.log("property %s\tremoving return value", key);
                toOptimize.add(refs);
            }
            for (ArrayList arrayList : toOptimize) {
                for (Node fn : OptimizeCalls.ReferenceMap.getFunctionNodes(arrayList).values()) {
                    this.rewriteReturns(fn);
                }
            }
        }
        finally {
            this.decisionsLog = null;
        }
    }

    private boolean isCandidate(String name, List<Node> refs) {
        if (!OptimizeCalls.mayBeOptimizableName(this.compiler, name)) {
            this.decisionsLog.log("%s\tnot an optimizable name", name);
            return false;
        }
        boolean seenCandidateDefiniton = false;
        boolean seenUse = false;
        for (Node n : refs) {
            if (OptimizeCalls.ReferenceMap.isCallTarget(n) || OptimizeCalls.ReferenceMap.isOptChainCallTarget(n)) {
                Node callNode = OptimizeCalls.ReferenceMap.getCallOrNewNodeForTarget(n);
                if (NodeUtil.isExpressionResultUsed(callNode)) {
                    this.decisionsLog.log("%s\treturn value used: %s", name, callNode.getLocation());
                    return false;
                }
                seenUse = true;
                continue;
            }
            if (this.isCandidateDefinition(n)) {
                seenCandidateDefiniton = true;
                continue;
            }
            if (OptimizeCalls.isAllowedReference(n)) continue;
            this.decisionsLog.log("%s\tdisallowed reference: %s", name, n.getLocation());
            return false;
        }
        if (!seenUse) {
            this.decisionsLog.log("%s\tno usage seen", name);
            return false;
        }
        if (!seenCandidateDefiniton) {
            this.decisionsLog.log("%s\tno definition seen", name);
            return false;
        }
        return true;
    }

    private boolean isCandidateDefinition(Node n) {
        Node parent = n.getParent();
        if (parent.isFunction() && NodeUtil.isFunctionDeclaration(parent)) {
            return true;
        }
        return OptimizeCalls.ReferenceMap.isSimpleAssignmentTarget(n) ? OptimizeReturns.isCandidateFunction(parent.getLastChild()) : (n.isName() ? n.hasChildren() && OptimizeReturns.isCandidateFunction(n.getFirstChild()) : this.isClassMemberDefinition(n));
    }

    private boolean isClassMemberDefinition(Node n) {
        return n.isMemberFunctionDef() && n.getParent().isClassMembers();
    }

    private static boolean isCandidateFunction(Node n) {
        switch (n.getToken()) {
            case FUNCTION: {
                return !NodeUtil.isNamedFunctionExpression(n);
            }
            case COMMA: 
            case CAST: {
                return OptimizeReturns.isCandidateFunction(n.getLastChild());
            }
            case HOOK: {
                return OptimizeReturns.isCandidateFunction(n.getSecondChild()) && OptimizeReturns.isCandidateFunction(n.getLastChild());
            }
            case OR: 
            case AND: 
            case COALESCE: {
                return OptimizeReturns.isCandidateFunction(n.getFirstChild()) && OptimizeReturns.isCandidateFunction(n.getLastChild());
            }
        }
        return false;
    }

    private void rewriteReturns(Node fnNode) {
        Preconditions.checkState(fnNode.isFunction());
        final Node body = fnNode.getLastChild();
        NodeUtil.visitPostOrder(body, new NodeUtil.Visitor(){

            @Override
            public void visit(Node n) {
                if (n.isReturn() && n.hasOneChild()) {
                    Node result = n.getFirstChild();
                    boolean keepValue = !OptimizeReturns.this.isRemovableValue(result);
                    result.detach();
                    if (keepValue) {
                        IR.exprResult(result).srcref(result).insertBefore(n);
                    } else {
                        NodeUtil.markFunctionsDeleted(result, OptimizeReturns.this.compiler);
                    }
                    OptimizeReturns.this.compiler.reportChangeToEnclosingScope(body);
                }
            }
        }, new NodeUtil.MatchShallowStatement());
    }

    private boolean isRemovableValue(Node n) {
        switch (n.getToken()) {
            case TEMPLATELIT: 
            case ARRAYLIT: {
                for (Node child = n.getFirstChild(); child != null; child = child.getNext()) {
                    if (child.isEmpty() || this.isRemovableValue(child)) continue;
                    return false;
                }
                return true;
            }
            case REGEXP: 
            case STRINGLIT: 
            case NUMBER: 
            case NULL: 
            case TRUE: 
            case FALSE: 
            case TEMPLATELIT_STRING: {
                return true;
            }
            case CAST: 
            case TEMPLATELIT_SUB: 
            case NOT: 
            case VOID: 
            case NEG: {
                return this.isRemovableValue(n.getFirstChild());
            }
        }
        return false;
    }
}

