/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.javascript.jscomp.CompilerOptions;
import com.google.javascript.jscomp.PassFactory;
import com.google.javascript.jscomp.graph.GraphvizGraph;
import com.google.javascript.jscomp.graph.LinkedDirectedGraph;
import com.google.javascript.jscomp.jarjar.com.google.common.collect.ImmutableList;
import com.google.javascript.jscomp.jarjar.com.google.common.collect.Iterables;
import java.util.List;

public abstract class PassConfig {
    protected final CompilerOptions options;

    public PassConfig(CompilerOptions options) {
        this.options = options;
    }

    protected List<PassFactory> getWhitespaceOnlyPasses() {
        return ImmutableList.of();
    }

    protected List<PassFactory> getTranspileOnlyPasses() {
        return ImmutableList.of();
    }

    protected abstract List<PassFactory> getChecks();

    protected abstract List<PassFactory> getOptimizations();

    protected abstract List<PassFactory> getFinalizations();

    GraphvizGraph getPassGraph() {
        LinkedDirectedGraph<String, String> graph = LinkedDirectedGraph.createWithoutAnnotations();
        Iterable<PassFactory> allPasses = Iterables.concat(this.getChecks(), this.getOptimizations());
        String lastPass = null;
        String loopStart = null;
        for (PassFactory pass : allPasses) {
            String passName = pass.getName();
            int i = 1;
            while (graph.hasNode(passName)) {
                passName = pass.getName() + i++;
            }
            graph.createNode((Object)passName);
            if (loopStart == null && pass.isRunInFixedPointLoop()) {
                loopStart = passName;
            } else if (loopStart != null && !pass.isRunInFixedPointLoop()) {
                graph.connect(lastPass, "loop", loopStart);
                loopStart = null;
            }
            if (lastPass != null) {
                graph.connect(lastPass, "", passName);
            }
            lastPass = passName;
        }
        return graph;
    }

    static final void addPassFactoryBefore(List<PassFactory> factoryList, PassFactory factory, String passName) {
        factoryList.add(PassConfig.findPassIndexByName(factoryList, passName), factory);
    }

    static final void replacePassFactory(List<PassFactory> factoryList, PassFactory factory) {
        factoryList.set(PassConfig.findPassIndexByName(factoryList, factory.getName()), factory);
    }

    static int findPassIndexByName(List<PassFactory> factoryList, String name) {
        for (int i = 0; i < factoryList.size(); ++i) {
            if (!factoryList.get(i).getName().equals(name)) continue;
            return i;
        }
        throw new IllegalArgumentException("No factory named '" + name + "' in the factory list");
    }

    final PassConfig getBasePassConfig() {
        PassConfig current = this;
        while (current instanceof PassConfigDelegate) {
            current = ((PassConfigDelegate)current).delegate;
        }
        return current;
    }

    public static class PassConfigDelegate
    extends PassConfig {
        private final PassConfig delegate;

        protected PassConfigDelegate(PassConfig delegate) {
            super(delegate.options);
            this.delegate = delegate;
        }

        @Override
        protected List<PassFactory> getWhitespaceOnlyPasses() {
            return this.delegate.getWhitespaceOnlyPasses();
        }

        @Override
        protected List<PassFactory> getChecks() {
            return this.delegate.getChecks();
        }

        @Override
        protected List<PassFactory> getOptimizations() {
            return this.delegate.getOptimizations();
        }

        @Override
        protected List<PassFactory> getFinalizations() {
            return this.delegate.getFinalizations();
        }

        @Override
        protected List<PassFactory> getTranspileOnlyPasses() {
            return this.delegate.getTranspileOnlyPasses();
        }
    }
}

