/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.javascript.jscomp.AbstractPeepholeOptimization;
import com.google.javascript.jscomp.CodingConvention;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.jscomp.jarjar.com.google.common.base.Joiner;
import com.google.javascript.jscomp.jarjar.com.google.common.base.Preconditions;
import com.google.javascript.jscomp.jarjar.com.google.common.collect.ImmutableSet;
import com.google.javascript.rhino.IR;
import com.google.javascript.rhino.Node;
import com.google.javascript.rhino.Token;

class PeepholeSubstituteAlternateSyntax
extends AbstractPeepholeOptimization {
    private final boolean late;
    private static final int STRING_SPLIT_OVERHEAD = ".split('.')".length();
    private static final ImmutableSet<String> BUILTIN_EXTERNS = ImmutableSet.of("Object", "Array", "Error", "RegExp", "Math");
    private static final ImmutableSet<String> STANDARD_OBJECT_CONSTRUCTORS = ImmutableSet.of("Object", "Array", "Error");

    PeepholeSubstituteAlternateSyntax(boolean late) {
        this.late = late;
    }

    @Override
    public Node optimizeSubtree(Node node) {
        switch (node.getToken()) {
            case ASSIGN_SUB: {
                return this.reduceSubstractionAssignment(node);
            }
            case TRUE: 
            case FALSE: {
                return this.reduceTrueFalse(node);
            }
            case NEW: {
                node = this.tryFoldStandardConstructors(node);
                if (!node.isCall()) {
                    return node;
                }
            }
            case CALL: {
                Node result = this.tryFoldLiteralConstructor(node);
                if (result == node && (result = this.tryFoldSimpleFunctionCall(node)) == node) {
                    result = this.tryFoldImmediateCallToBoundFunction(node);
                }
                return result;
            }
            case RETURN: {
                return this.tryReduceReturn(node);
            }
            case EXPR_RESULT: {
                if (node.getFirstChild().isComma()) {
                    return this.trySplitComma(node);
                }
                return node;
            }
            case NAME: {
                return this.tryReplaceUndefined(node);
            }
            case ARRAYLIT: {
                return this.tryMinimizeArrayLiteral(node);
            }
            case GETPROP: {
                return this.tryMinimizeWindowRefs(node);
            }
            case TEMPLATELIT: {
                return this.tryTurnTemplateStringsToStrings(node);
            }
            case MUL: 
            case AND: 
            case OR: 
            case BITOR: 
            case BITXOR: 
            case BITAND: 
            case COALESCE: {
                return this.tryRotateAssociativeOperator(node);
            }
        }
        return node;
    }

    private Node tryMinimizeWindowRefs(Node node) {
        Node nameNode;
        if (!this.isASTNormalized()) {
            return node;
        }
        Preconditions.checkArgument(node.isGetProp());
        if (node.getFirstChild().isName() && "window".equals((nameNode = node.getFirstChild()).getString()) && BUILTIN_EXTERNS.contains(node.getString())) {
            Node newNameNode = IR.name(node.getString());
            Node parentNode = node.getParent();
            newNameNode.srcref(node);
            node.replaceWith(newNameNode);
            if (parentNode.isCall() || parentNode.isOptChainCall()) {
                parentNode.putBooleanProp(Node.FREE_CALL, true);
            }
            this.reportChangeToEnclosingScope(parentNode);
            return newNameNode;
        }
        return node;
    }

    private Node tryRotateAssociativeOperator(Node n) {
        if (!this.late) {
            return n;
        }
        Preconditions.checkArgument(NodeUtil.isAssociative(n.getToken()));
        Node rhs = n.getLastChild();
        if (n.getToken() == rhs.getToken()) {
            Node first = n.removeFirstChild();
            Node second = rhs.removeFirstChild();
            Node third = rhs.getLastChild().detach();
            Node newLhs = new Node(n.getToken(), first, second).srcrefIfMissing(n);
            Node newRoot = new Node(rhs.getToken(), newLhs, third).srcrefIfMissing(rhs);
            n.replaceWith(newRoot);
            this.reportChangeToEnclosingScope(newRoot);
            return newRoot;
        }
        if (NodeUtil.isCommutative(n.getToken()) && !this.mayHaveSideEffects(n)) {
            Node lhs = n.getFirstChild();
            while (lhs.getToken() == n.getToken()) {
                lhs = lhs.getFirstChild();
            }
            int precedence = NodeUtil.precedence(n.getToken());
            int lhsPrecedence = NodeUtil.precedence(lhs.getToken());
            int rhsPrecedence = NodeUtil.precedence(rhs.getToken());
            if (rhsPrecedence == precedence && lhsPrecedence != precedence) {
                rhs.detach();
                lhs.replaceWith(rhs);
                n.addChildToBack(lhs);
                this.reportChangeToEnclosingScope(n);
                return n;
            }
        }
        return n;
    }

    private Node tryFoldSimpleFunctionCall(Node n) {
        String targetName;
        Preconditions.checkState(n.isCall(), n);
        Node callTarget = n.getFirstChild();
        if (callTarget == null || !callTarget.isName()) {
            return n;
        }
        switch (targetName = callTarget.getString()) {
            case "Boolean": {
                int paramCount = n.getChildCount() - 1;
                if (paramCount != 1) break;
                Node value = n.getLastChild().detach();
                Node replacement = NodeUtil.isBooleanResult(value) ? value : IR.not(IR.not(value).srcref(n));
                n.replaceWith(replacement);
                this.reportChangeToEnclosingScope(replacement);
                break;
            }
            case "String": {
                Node value = callTarget.getNext();
                if (value == null || value.getNext() != null || !NodeUtil.isImmutableValue(value)) break;
                Node addition = IR.add(IR.string("").srcref(callTarget), value.detach());
                n.replaceWith(addition);
                this.reportChangeToEnclosingScope(addition);
                return addition;
            }
        }
        return n;
    }

    private Node tryFoldImmediateCallToBoundFunction(Node n) {
        Preconditions.checkState(n.isCall());
        Node callTarget = n.getFirstChild();
        CodingConvention.Bind bind = this.getCodingConvention().describeFunctionBind(callTarget, false, false);
        if (bind != null) {
            bind.target.detach();
            callTarget.replaceWith(bind.target);
            callTarget = bind.target;
            PeepholeSubstituteAlternateSyntax.addParameterAfter(bind.parameters, callTarget);
            if (bind.thisValue != null && !NodeUtil.isUndefined(bind.thisValue)) {
                Node newCallTarget = IR.getprop(callTarget.cloneTree(), "call");
                this.markNewScopesChanged(newCallTarget);
                callTarget.replaceWith(newCallTarget);
                this.markFunctionsDeleted(callTarget);
                bind.thisValue.cloneTree().insertAfter(newCallTarget);
                n.putBooleanProp(Node.FREE_CALL, false);
            } else {
                n.putBooleanProp(Node.FREE_CALL, true);
            }
            this.reportChangeToEnclosingScope(n);
        }
        return n;
    }

    private static void addParameterAfter(Node parameterList, Node after) {
        if (parameterList != null) {
            PeepholeSubstituteAlternateSyntax.addParameterAfter(parameterList.getNext(), after);
            parameterList.cloneTree().insertAfter(after);
        }
    }

    private Node splitComma(Node n, boolean insert, Node insertAfter) {
        while (n.isComma()) {
            Node left = n.getFirstChild();
            Node right = n.getLastChild();
            n.detachChildren();
            if (right.isComma()) {
                this.splitComma(right, true, insertAfter);
            } else {
                Node newStatement = IR.exprResult(right);
                newStatement.srcrefIfMissing(right);
                newStatement.insertAfter(insertAfter);
            }
            n = left;
        }
        if (insert) {
            Node newStatement = IR.exprResult(n);
            newStatement.srcrefIfMissing(n);
            newStatement.insertAfter(insertAfter);
            return newStatement;
        }
        return n;
    }

    private Node trySplitComma(Node n) {
        if (this.late) {
            return n;
        }
        Preconditions.checkState(n.isExprResult());
        if (n.getParent().isLabel()) {
            return n;
        }
        Node comma = n.getFirstChild();
        Preconditions.checkState(comma.isComma());
        Node leftmost = this.splitComma(comma, false, n);
        n.removeChildren();
        n.addChildToFront(leftmost);
        n.srcref(leftmost);
        this.reportChangeToEnclosingScope(leftmost);
        return leftmost;
    }

    private Node tryReplaceUndefined(Node n) {
        if (this.isASTNormalized() && NodeUtil.isUndefined(n) && !NodeUtil.isLValue(n)) {
            Node replacement = NodeUtil.newUndefinedNode(n);
            n.replaceWith(replacement);
            this.reportChangeToEnclosingScope(replacement);
            return replacement;
        }
        return n;
    }

    private Node tryReduceReturn(Node n) {
        Node result = n.getFirstChild();
        if (result != null) {
            switch (result.getToken()) {
                case VOID: {
                    Node operand = result.getFirstChild();
                    if (this.mayHaveSideEffects(operand)) break;
                    n.removeFirstChild();
                    this.reportChangeToEnclosingScope(n);
                    break;
                }
                case NAME: {
                    String name = result.getString();
                    if (!name.equals("undefined")) break;
                    n.removeFirstChild();
                    this.reportChangeToEnclosingScope(n);
                    break;
                }
            }
        }
        return n;
    }

    private Node tryFoldStandardConstructors(Node n) {
        Preconditions.checkState(n.isNew());
        if (this.canFoldStandardConstructors(n)) {
            n.setToken(Token.CALL);
            n.putBooleanProp(Node.FREE_CALL, true);
            this.reportChangeToEnclosingScope(n);
        }
        return n;
    }

    private boolean canFoldStandardConstructors(Node n) {
        if (this.isASTNormalized() && n.getFirstChild().isName()) {
            String className = n.getFirstChild().getString();
            if (STANDARD_OBJECT_CONSTRUCTORS.contains(className)) {
                return true;
            }
            if ("RegExp".equals(className) && (n.getSecondChild() == null || n.getSecondChild().isStringLit())) {
                return true;
            }
        }
        return false;
    }

    private Node tryFoldLiteralConstructor(Node n) {
        Preconditions.checkArgument(n.isCall() || n.isNew());
        Node constructorNameNode = n.getFirstChild();
        Node newLiteralNode = null;
        if (this.isASTNormalized() && constructorNameNode.isName()) {
            Node arg0;
            FoldArrayAction action;
            boolean constructorHasArgs;
            String className = constructorNameNode.getString();
            boolean bl = constructorHasArgs = constructorNameNode.getNext() != null;
            if ("Object".equals(className) && !constructorHasArgs) {
                newLiteralNode = IR.objectlit(new Node[0]);
            } else if ("Array".equals(className) && ((action = PeepholeSubstituteAlternateSyntax.isSafeToFoldArrayConstructor(arg0 = constructorNameNode.getNext())) == FoldArrayAction.SAFE_TO_FOLD_WITH_ARGS || action == FoldArrayAction.SAFE_TO_FOLD_WITHOUT_ARGS)) {
                newLiteralNode = IR.arraylit(new Node[0]);
                n.removeFirstChild();
                Node elements = n.removeChildren();
                if (action == FoldArrayAction.SAFE_TO_FOLD_WITH_ARGS) {
                    newLiteralNode.addChildrenToFront(elements);
                }
            }
            if (newLiteralNode != null) {
                n.replaceWith(newLiteralNode);
                this.reportChangeToEnclosingScope(newLiteralNode);
                return newLiteralNode;
            }
        }
        return n;
    }

    private static FoldArrayAction isSafeToFoldArrayConstructor(Node arg) {
        FoldArrayAction action = FoldArrayAction.NOT_SAFE_TO_FOLD;
        if (arg == null) {
            action = FoldArrayAction.SAFE_TO_FOLD_WITHOUT_ARGS;
        } else if (arg.getNext() != null) {
            action = FoldArrayAction.SAFE_TO_FOLD_WITH_ARGS;
        } else {
            switch (arg.getToken()) {
                case STRINGLIT: {
                    action = FoldArrayAction.SAFE_TO_FOLD_WITH_ARGS;
                    break;
                }
                case NUMBER: {
                    if (arg.getDouble() != 0.0) break;
                    action = FoldArrayAction.SAFE_TO_FOLD_WITHOUT_ARGS;
                    break;
                }
                case ARRAYLIT: {
                    action = FoldArrayAction.SAFE_TO_FOLD_WITH_ARGS;
                    break;
                }
            }
        }
        return action;
    }

    private Node reduceSubstractionAssignment(Node n) {
        Node right = n.getLastChild();
        boolean isNegative = false;
        if (right.isNeg()) {
            isNegative = true;
            right = right.getOnlyChild();
        }
        if (right.isNumber() && right.getDouble() == 1.0) {
            Node left = n.removeFirstChild();
            Node newNode = isNegative ? IR.inc(left, false) : IR.dec(left, false);
            n.replaceWith(newNode);
            this.reportChangeToEnclosingScope(newNode);
            return newNode;
        }
        return n;
    }

    private Node reduceTrueFalse(Node n) {
        if (this.late) {
            switch (n.getParent().getToken()) {
                case EQ: 
                case GT: 
                case GE: 
                case LE: 
                case LT: 
                case NE: {
                    Node number = IR.number(n.isTrue() ? 1.0 : 0.0);
                    n.replaceWith(number);
                    this.reportChangeToEnclosingScope(number);
                    return number;
                }
            }
            Node not = IR.not(IR.number(n.isTrue() ? 0.0 : 1.0));
            not.srcrefTreeIfMissing(n);
            n.replaceWith(not);
            this.reportChangeToEnclosingScope(not);
            return not;
        }
        return n;
    }

    private Node tryMinimizeArrayLiteral(Node n) {
        boolean allStrings = true;
        for (Node cur = n.getFirstChild(); cur != null; cur = cur.getNext()) {
            if (cur.isStringLit()) continue;
            allStrings = false;
        }
        if (allStrings) {
            return this.tryMinimizeStringArrayLiteral(n);
        }
        return n;
    }

    private Node tryMinimizeStringArrayLiteral(Node n) {
        if (!this.late) {
            return n;
        }
        int numElements = n.getChildCount();
        int saving = numElements * 2 - STRING_SPLIT_OVERHEAD;
        if (saving <= 0) {
            return n;
        }
        Object[] strings = new String[numElements];
        int idx = 0;
        for (Node cur = n.getFirstChild(); cur != null; cur = cur.getNext()) {
            strings[idx++] = cur.getString();
        }
        String delimiter = PeepholeSubstituteAlternateSyntax.pickDelimiter((String[])strings);
        if (delimiter != null) {
            String template = Joiner.on(delimiter).join(strings);
            Node call = IR.call(IR.getprop(IR.string(template), "split"), IR.string("" + delimiter));
            call.srcrefTreeIfMissing(n);
            n.replaceWith(call);
            this.reportChangeToEnclosingScope(call);
            return call;
        }
        return n;
    }

    private Node tryTurnTemplateStringsToStrings(Node n) {
        Preconditions.checkState(n.isTemplateLit(), n);
        if (n.getParent().isTaggedTemplateLit()) {
            return n;
        }
        String string = this.getSideEffectFreeStringValue(n);
        if (string == null) {
            return n;
        }
        Node stringNode = IR.string(string).srcref(n);
        n.replaceWith(stringNode);
        this.reportChangeToEnclosingScope(stringNode);
        return stringNode;
    }

    private static String pickDelimiter(String[] strings) {
        boolean allLength1 = true;
        for (String s : strings) {
            if (s.length() == 1) continue;
            allLength1 = false;
            break;
        }
        if (allLength1) {
            return "";
        }
        String[] delimiters = new String[]{" ", ";", ",", "{", "}", null};
        int i = 0;
        block1: while (delimiters[i] != null) {
            for (String cur : strings) {
                if (!cur.contains(delimiters[i])) {
                    continue;
                }
                ++i;
                continue block1;
            }
        }
        return delimiters[i];
    }

    private static enum FoldArrayAction {
        NOT_SAFE_TO_FOLD,
        SAFE_TO_FOLD_WITH_ARGS,
        SAFE_TO_FOLD_WITHOUT_ARGS;

    }
}

