/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.CompilerInput;
import com.google.javascript.jscomp.jarjar.com.google.common.collect.Iterables;
import com.google.javascript.jscomp.jarjar.com.google.common.util.concurrent.Futures;
import com.google.javascript.jscomp.jarjar.com.google.common.util.concurrent.ListeningExecutorService;
import com.google.javascript.jscomp.jarjar.com.google.common.util.concurrent.MoreExecutors;
import java.util.ArrayList;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

class PrebuildAst {
    private final AbstractCompiler compiler;
    private final int numParallelThreads;

    PrebuildAst(AbstractCompiler compiler, int numParalleThreads) {
        this.compiler = compiler;
        this.numParallelThreads = numParalleThreads;
    }

    void prebuild(Iterable<CompilerInput> allInputs) {
        ThreadFactory threadFactory = r -> {
            Thread t = new Thread(null, r, "jscompiler-PrebuildAst", 0x4000000L);
            t.setDaemon(true);
            return t;
        };
        ThreadPoolExecutor poolExecutor = new ThreadPoolExecutor(this.numParallelThreads, this.numParallelThreads, Integer.MAX_VALUE, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), threadFactory);
        ListeningExecutorService executorService = MoreExecutors.listeningDecorator(poolExecutor);
        ArrayList<Future> futureList = new ArrayList<Future>(Iterables.size(allInputs));
        for (CompilerInput input : allInputs) {
            futureList.add(executorService.submit(() -> input.getAstRoot(this.compiler)));
        }
        poolExecutor.shutdown();
        try {
            Futures.allAsList(futureList).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw new RuntimeException(e);
        }
    }
}

