/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.CompilerPass;
import com.google.javascript.jscomp.Es6ToEs3Util;
import com.google.javascript.jscomp.JSError;
import com.google.javascript.jscomp.NodeTraversal;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.jscomp.TranspilationPasses;
import com.google.javascript.jscomp.parsing.parser.FeatureSet;
import com.google.javascript.rhino.Node;

public final class RewriteClassFields
implements NodeTraversal.Callback,
CompilerPass {
    private final AbstractCompiler compiler;

    public RewriteClassFields(AbstractCompiler compiler) {
        this.compiler = compiler;
    }

    @Override
    public void process(Node externs, Node root) {
        NodeTraversal.traverse(this.compiler, root, this);
        TranspilationPasses.maybeMarkFeaturesAsTranspiledAway(this.compiler, FeatureSet.Feature.PUBLIC_CLASS_FIELDS, new FeatureSet.Feature[0]);
    }

    @Override
    public boolean shouldTraverse(NodeTraversal t, Node n, Node parent) {
        if (n.isScript()) {
            FeatureSet scriptFeatures = NodeUtil.getFeatureSetOfScript(n);
            return scriptFeatures == null || scriptFeatures.contains(FeatureSet.Feature.PUBLIC_CLASS_FIELDS);
        }
        return true;
    }

    @Override
    public void visit(NodeTraversal t, Node n, Node parent) {
        if (n.isMemberFieldDef() || n.isComputedFieldDef()) {
            this.compiler.report(JSError.make(n, Es6ToEs3Util.CANNOT_CONVERT_YET, "Public class fields"));
        }
    }
}

