/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp.colors;

import com.google.javascript.jscomp.colors.$AutoValue_Color;
import com.google.javascript.jscomp.colors.ColorId;
import com.google.javascript.jscomp.colors.DebugInfo;
import com.google.javascript.jscomp.colors.StandardColors;
import com.google.javascript.jscomp.jarjar.com.google.auto.value.AutoValue;
import com.google.javascript.jscomp.jarjar.com.google.common.base.Preconditions;
import com.google.javascript.jscomp.jarjar.com.google.common.collect.ImmutableSet;
import com.google.javascript.jscomp.jarjar.com.google.common.collect.Iterables;
import com.google.javascript.jscomp.jarjar.javax.annotation.Nullable;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.TreeSet;

@AutoValue
public abstract class Color {
    public abstract ColorId getId();

    public abstract DebugInfo getDebugInfo();

    public abstract ImmutableSet<Color> getPrototypes();

    public abstract ImmutableSet<Color> getInstanceColors();

    public abstract boolean isInvalidating();

    public abstract boolean getPropertiesKeepOriginalName();

    public abstract boolean isConstructor();

    public abstract ImmutableSet<String> getOwnProperties();

    @Nullable
    public abstract ColorId getBoxId();

    public abstract boolean isClosureAssert();

    public abstract ImmutableSet<Color> getUnionElements();

    public static Builder singleBuilder() {
        return new $AutoValue_Color.Builder().setClosureAssert(false).setConstructor(false).setDebugInfo(DebugInfo.EMPTY).setInstanceColors(ImmutableSet.of()).setInvalidating(false).setOwnProperties(ImmutableSet.of()).setPropertiesKeepOriginalName(false).setPrototypes(ImmutableSet.of()).setUnionElements(ImmutableSet.of());
    }

    public static Color createUnion(Set<Color> elements) {
        switch (elements.size()) {
            case 0: {
                throw new IllegalStateException();
            }
            case 1: {
                return Iterables.getOnlyElement(elements);
            }
        }
        TreeSet<String> debugTypenames = new TreeSet<String>();
        ImmutableSet.Builder instanceColors = ImmutableSet.builder();
        ImmutableSet.Builder prototypes = ImmutableSet.builder();
        ImmutableSet.Builder newElements = ImmutableSet.builder();
        ImmutableSet.Builder ids = ImmutableSet.builder();
        ImmutableSet.Builder ownProperties = ImmutableSet.builder();
        boolean isClosureAssert = true;
        boolean isConstructor = true;
        boolean isInvalidating = false;
        boolean propertiesKeepOriginalName = false;
        for (Color element : elements) {
            if (element.isUnion()) {
                for (Color nestedElement : element.getUnionElements()) {
                    newElements.add(nestedElement);
                    ids.add(nestedElement.getId());
                    debugTypenames.add(nestedElement.getDebugInfo().getCompositeTypename());
                }
            } else {
                newElements.add(element);
                ids.add(element.getId());
                debugTypenames.add(element.getDebugInfo().getCompositeTypename());
            }
            instanceColors.addAll(element.getInstanceColors());
            isClosureAssert &= element.isClosureAssert();
            isConstructor &= element.isConstructor();
            isInvalidating |= element.isInvalidating();
            ownProperties.addAll(element.getOwnProperties());
            propertiesKeepOriginalName |= element.getPropertiesKeepOriginalName();
            prototypes.addAll(element.getPrototypes());
        }
        debugTypenames.remove("");
        DebugInfo debugInfo = debugTypenames.isEmpty() ? DebugInfo.EMPTY : DebugInfo.builder().setCompositeTypename("(" + String.join((CharSequence)"|", debugTypenames) + ")").build();
        return new $AutoValue_Color.Builder().setClosureAssert(isClosureAssert).setConstructor(isConstructor).setDebugInfo(debugInfo).setId(ColorId.union((Set<ColorId>)((Object)ids.build()))).setInstanceColors((ImmutableSet<Color>)instanceColors.build()).setInvalidating(isInvalidating).setOwnProperties((ImmutableSet<String>)ownProperties.build()).setPropertiesKeepOriginalName(propertiesKeepOriginalName).setPrototypes((ImmutableSet<Color>)prototypes.build()).setUnionElements((ImmutableSet<Color>)newElements.build()).buildUnion();
    }

    Color() {
    }

    public final boolean isPrimitive() {
        Preconditions.checkState(!this.isUnion(), this);
        return StandardColors.PRIMITIVE_COLORS.containsKey(this.getId());
    }

    public final boolean isUnion() {
        return !this.getUnionElements().isEmpty();
    }

    public Color subtractNullOrVoid() {
        Preconditions.checkState(this.isUnion());
        if (!this.getUnionElements().contains(StandardColors.NULL_OR_VOID)) {
            return this;
        }
        LinkedHashSet<Color> elements = new LinkedHashSet<Color>(this.getUnionElements());
        elements.remove(StandardColors.NULL_OR_VOID);
        return Color.createUnion(elements);
    }

    @AutoValue.Builder
    public static abstract class Builder {
        public abstract Builder setId(ColorId var1);

        public abstract Builder setInvalidating(boolean var1);

        public abstract Builder setPropertiesKeepOriginalName(boolean var1);

        public abstract Builder setConstructor(boolean var1);

        public abstract Builder setOwnProperties(ImmutableSet<String> var1);

        public abstract Builder setDebugInfo(DebugInfo var1);

        public abstract Builder setClosureAssert(boolean var1);

        public abstract Builder setInstanceColors(ImmutableSet<Color> var1);

        public abstract Builder setPrototypes(ImmutableSet<Color> var1);

        abstract Builder setUnionElements(ImmutableSet<Color> var1);

        abstract Builder setBoxId(@Nullable ColorId var1);

        public Builder setPrototype(Color x) {
            return this.setPrototypes(x == null ? ImmutableSet.of() : ImmutableSet.of(x));
        }

        public Builder setInstanceColor(Color x) {
            return this.setInstanceColors(x == null ? ImmutableSet.of() : ImmutableSet.of(x));
        }

        abstract Color buildInternal();

        public final Color build() {
            Color result = this.buildInternal();
            Preconditions.checkState(result.getUnionElements().isEmpty(), result);
            Preconditions.checkState(result.getBoxId() == null, result);
            Preconditions.checkState(!StandardColors.AXIOMATIC_COLORS.containsKey(result.getId()), result);
            return result;
        }

        private final Color buildUnion() {
            Color result = this.buildInternal();
            Preconditions.checkState(result.getUnionElements().size() > 1, result);
            Preconditions.checkState(result.getBoxId() == null, result);
            return result;
        }

        final Color buildAxiomatic() {
            Preconditions.checkState(StandardColors.AXIOMATIC_COLORS == null, "StandardColors are all defined");
            Color result = this.buildInternal();
            Preconditions.checkState(result.getUnionElements().isEmpty(), result);
            Preconditions.checkState(!result.getDebugInfo().getCompositeTypename().isEmpty(), result);
            return result;
        }
    }
}

