/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp.disambiguate;

import com.google.javascript.jscomp.colors.Color;
import com.google.javascript.jscomp.colors.ColorRegistry;
import com.google.javascript.jscomp.colors.StandardColors;
import com.google.javascript.jscomp.disambiguate.ColorGraphNode;
import com.google.javascript.jscomp.disambiguate.ColorGraphNodeFactory;
import com.google.javascript.jscomp.graph.DiGraph;
import com.google.javascript.jscomp.graph.LinkedDirectedGraph;
import com.google.javascript.jscomp.graph.LowestCommonAncestorFinder;
import com.google.javascript.jscomp.jarjar.com.google.common.base.Preconditions;
import com.google.javascript.jscomp.jarjar.com.google.common.collect.ImmutableSet;
import java.util.Collection;

final class ColorGraphBuilder {
    private final ColorRegistry registry;
    private final ColorGraphNodeFactory nodeFactory;
    private final LowestCommonAncestorFinder<ColorGraphNode, Object> lcaFinder;
    private final LinkedDirectedGraph.LinkedDiGraphNode<ColorGraphNode, Object> topNode;
    private LinkedDirectedGraph<ColorGraphNode, Object> colorHoldsInstanceGraph = LinkedDirectedGraph.createWithoutAnnotations();

    ColorGraphBuilder(ColorGraphNodeFactory nodeFactory, LowestCommonAncestorFinder.Factory<ColorGraphNode, Object> lcaFinderFactory, ColorRegistry registry) {
        this.registry = registry;
        this.nodeFactory = nodeFactory;
        this.lcaFinder = lcaFinderFactory.create(this.colorHoldsInstanceGraph);
        this.topNode = this.colorHoldsInstanceGraph.createNode((Object)this.nodeFactory.createNode(StandardColors.UNKNOWN));
    }

    public void add(ColorGraphNode flat) {
        this.addInternal(flat);
    }

    public void addAll(Collection<ColorGraphNode> flats) {
        flats.forEach(this::add);
    }

    public LinkedDirectedGraph<ColorGraphNode, Object> build() {
        this.colorHoldsInstanceGraph.getNodes().forEach(this::connectUnionWithAncestors);
        LinkedDirectedGraph<ColorGraphNode, Object> temp = this.colorHoldsInstanceGraph;
        this.colorHoldsInstanceGraph = null;
        return temp;
    }

    private void connectUnionWithAncestors(LinkedDirectedGraph.LinkedDiGraphNode<ColorGraphNode, Object> unionNode) {
        ColorGraphNode flatUnion = unionNode.getValue();
        if (!flatUnion.getColor().isUnion()) {
            return;
        }
        Preconditions.checkState(!unionNode.getOutEdges().isEmpty());
        ImmutableSet graphNodes = flatUnion.getColor().getUnionElements().stream().map(this.nodeFactory::createNode).collect(ImmutableSet.toImmutableSet());
        for (ColorGraphNode lca : this.lcaFinder.findAll(graphNodes)) {
            this.connectSourceToDest((LinkedDirectedGraph.LinkedDiGraphNode)Preconditions.checkNotNull(this.colorHoldsInstanceGraph.getNode((Object)lca)), EdgeReason.ALGEBRAIC, unionNode);
        }
    }

    private LinkedDirectedGraph.LinkedDiGraphNode<ColorGraphNode, Object> addInternal(Color color) {
        return this.addInternal(this.nodeFactory.createNode(color));
    }

    private LinkedDirectedGraph.LinkedDiGraphNode<ColorGraphNode, Object> addInternal(ColorGraphNode node) {
        DiGraph.DiGraphNode flatNode = this.colorHoldsInstanceGraph.getNode((Object)node);
        if (flatNode != null) {
            return flatNode;
        }
        flatNode = this.colorHoldsInstanceGraph.createNode((Object)node);
        if (node.getColor().isUnion()) {
            for (Color alt : node.getColor().getUnionElements()) {
                this.connectSourceToDest((LinkedDirectedGraph.LinkedDiGraphNode<ColorGraphNode, Object>)flatNode, EdgeReason.ALGEBRAIC, this.addInternal(alt));
            }
            return flatNode;
        }
        Color color = node.getColor();
        ImmutableSet<Color> supertypes = this.registry.getDisambiguationSupertypes(color);
        if (supertypes.isEmpty()) {
            this.connectSourceToDest(this.topNode, EdgeReason.ALGEBRAIC, (LinkedDirectedGraph.LinkedDiGraphNode<ColorGraphNode, Object>)flatNode);
        } else {
            for (Color supertype : supertypes) {
                this.connectSourceToDest(this.addInternal(supertype), EdgeReason.CAN_HOLD, (LinkedDirectedGraph.LinkedDiGraphNode<ColorGraphNode, Object>)flatNode);
            }
        }
        for (Color prototype : color.getPrototypes()) {
            this.addInternal(prototype);
        }
        for (Color instanceColor : color.getInstanceColors()) {
            this.addInternal(instanceColor);
        }
        return flatNode;
    }

    private void connectSourceToDest(LinkedDirectedGraph.LinkedDiGraphNode<ColorGraphNode, Object> source, EdgeReason reason, LinkedDirectedGraph.LinkedDiGraphNode<ColorGraphNode, Object> dest) {
        if (source.equals(dest) || this.colorHoldsInstanceGraph.isConnectedInDirection((ColorGraphNode)((Object)source), t -> true, (ColorGraphNode)((Object)dest))) {
            return;
        }
        this.colorHoldsInstanceGraph.connect(source, (Object)reason, dest);
    }

    static enum EdgeReason {
        ALGEBRAIC,
        CAN_HOLD;

    }
}

