/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp.graph;

import com.google.javascript.jscomp.graph.Annotation;
import com.google.javascript.jscomp.graph.Graph;
import com.google.javascript.jscomp.graph.GraphNode;
import com.google.javascript.jscomp.graph.GraphvizGraph;
import com.google.javascript.jscomp.graph.SubGraph;
import com.google.javascript.jscomp.graph.UndiGraph;
import com.google.javascript.jscomp.jarjar.com.google.common.base.Predicate;
import com.google.javascript.jscomp.jarjar.com.google.common.base.Predicates;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public final class LinkedUndirectedGraph<N, E>
extends UndiGraph<N, E>
implements GraphvizGraph {
    protected final Map<N, LinkedUndirectedGraphNode<N, E>> nodes = new LinkedHashMap<N, LinkedUndirectedGraphNode<N, E>>();
    private final boolean useNodeAnnotations;
    private final boolean useEdgeAnnotations;

    @Override
    public SubGraph<N, E> newSubGraph() {
        return new Graph.SimpleSubGraph(this);
    }

    public static <N, E> LinkedUndirectedGraph<N, E> create() {
        return new LinkedUndirectedGraph<N, E>(true, true);
    }

    protected LinkedUndirectedGraph(boolean useNodeAnnotations, boolean useEdgeAnnotations) {
        this.useNodeAnnotations = useNodeAnnotations;
        this.useEdgeAnnotations = useEdgeAnnotations;
    }

    @Override
    public void connect(N srcValue, E edgeValue, N destValue) {
        LinkedUndirectedGraphNode src = (LinkedUndirectedGraphNode)this.getNodeOrFail(srcValue);
        LinkedUndirectedGraphNode dest = (LinkedUndirectedGraphNode)this.getNodeOrFail(destValue);
        LinkedUndirectedGraphEdge edge = this.useEdgeAnnotations ? new AnnotatedLinkedUndirectedGraphEdge(src, edgeValue, dest) : new LinkedUndirectedGraphEdge(src, edgeValue, dest);
        src.getNeighborEdges().add(edge);
        dest.getNeighborEdges().add(edge);
    }

    @Override
    public void disconnect(N srcValue, N destValue) {
        LinkedUndirectedGraphNode src = (LinkedUndirectedGraphNode)this.getNodeOrFail(srcValue);
        LinkedUndirectedGraphNode dest = (LinkedUndirectedGraphNode)this.getNodeOrFail(destValue);
        for (UndiGraph.UndiGraphEdge<N, E> edge : this.getUndirectedGraphEdges(srcValue, destValue)) {
            src.getNeighborEdges().remove(edge);
            dest.getNeighborEdges().remove(edge);
        }
    }

    @Override
    public UndiGraph.UndiGraphNode<N, E> createUndirectedGraphNode(N nodeValue) {
        return this.nodes.computeIfAbsent(nodeValue, k -> this.useNodeAnnotations ? new AnnotatedLinkedUndirectedGraphNode(k) : new LinkedUndirectedGraphNode(k));
    }

    @Override
    public List<GraphNode<N, E>> getNeighborNodes(N value) {
        UndiGraph.UndiGraphNode<N, E> uNode = this.getUndirectedGraphNode(value);
        return ((LinkedUndirectedGraphNode)uNode).neighborList();
    }

    @Override
    public List<UndiGraph.UndiGraphEdge<N, E>> getUndirectedGraphEdges(N n1, N n2) {
        UndiGraph.UndiGraphNode dNode1 = this.nodes.get(n1);
        if (dNode1 == null) {
            return null;
        }
        UndiGraph.UndiGraphNode dNode2 = this.nodes.get(n2);
        if (dNode2 == null) {
            return null;
        }
        ArrayList edges = new ArrayList();
        for (UndiGraph.UndiGraphEdge outEdge : dNode1.getNeighborEdges()) {
            if (outEdge.getNodeA() != dNode2 && outEdge.getNodeB() != dNode2) continue;
            edges.add(outEdge);
        }
        return edges;
    }

    @Override
    public UndiGraph.UndiGraphNode<N, E> getUndirectedGraphNode(N nodeValue) {
        return this.nodes.get(nodeValue);
    }

    @Override
    public Collection<UndiGraph.UndiGraphNode<N, E>> getUndirectedGraphNodes() {
        return Collections.unmodifiableCollection(this.nodes.values());
    }

    @Override
    public GraphNode<N, E> createNode(N value) {
        return this.createUndirectedGraphNode(value);
    }

    @Override
    public List<Graph.GraphEdge<N, E>> getEdges(N n1, N n2) {
        return Collections.unmodifiableList(this.getUndirectedGraphEdges(n1, n2));
    }

    @Override
    public List<Graph.GraphEdge<N, E>> getEdges() {
        ArrayList<Graph.GraphEdge<N, UndiGraph.UndiGraphEdge<N, E>>> result = new ArrayList<Graph.GraphEdge<N, UndiGraph.UndiGraphEdge<N, E>>>();
        for (LinkedUndirectedGraphNode<N, E> node : this.nodes.values()) {
            for (UndiGraph.UndiGraphEdge<N, E> edge : node.getNeighborEdges()) {
                if (edge.getNodeA() != node) continue;
                result.add(edge);
            }
        }
        return result;
    }

    @Override
    public Graph.GraphEdge<N, E> getFirstEdge(N n1, N n2) {
        UndiGraph.UndiGraphNode dNode1 = (UndiGraph.UndiGraphNode)this.getNodeOrFail(n1);
        UndiGraph.UndiGraphNode dNode2 = (UndiGraph.UndiGraphNode)this.getNodeOrFail(n2);
        for (UndiGraph.UndiGraphEdge outEdge : dNode1.getNeighborEdges()) {
            if (outEdge.getNodeA() != dNode2 && outEdge.getNodeB() != dNode2) continue;
            return outEdge;
        }
        return null;
    }

    @Override
    public GraphNode<N, E> getNode(N value) {
        return this.getUndirectedGraphNode(value);
    }

    @Override
    public boolean isConnected(N n1, N n2) {
        return this.isConnected(n1, Predicates.alwaysTrue(), n2);
    }

    @Override
    public boolean isConnected(N n1, E e, N n2) {
        return this.isConnected(n1, Predicates.equalTo(e), n2);
    }

    @Override
    private boolean isConnected(N n1, Predicate<E> edgePredicate, N n2) {
        UndiGraph.UndiGraphNode dNode1 = this.nodes.get(n1);
        if (dNode1 == null) {
            return false;
        }
        UndiGraph.UndiGraphNode dNode2 = this.nodes.get(n2);
        if (dNode2 == null) {
            return false;
        }
        for (UndiGraph.UndiGraphEdge outEdge : dNode1.getNeighborEdges()) {
            if ((outEdge.getNodeA() != dNode1 || outEdge.getNodeB() != dNode2) && (outEdge.getNodeA() != dNode2 || outEdge.getNodeB() != dNode1) || !edgePredicate.apply(outEdge.getValue())) continue;
            return true;
        }
        return false;
    }

    @Override
    public List<GraphvizGraph.GraphvizEdge> getGraphvizEdges() {
        ArrayList<GraphvizGraph.GraphvizEdge> edgeList = new ArrayList<GraphvizGraph.GraphvizEdge>();
        for (LinkedUndirectedGraphNode<N, E> node : this.nodes.values()) {
            for (UndiGraph.UndiGraphEdge<N, E> edge : node.getNeighborEdges()) {
                if (edge.getNodeA() != node) continue;
                edgeList.add((GraphvizGraph.GraphvizEdge)((Object)edge));
            }
        }
        return edgeList;
    }

    @Override
    public String getName() {
        return "LinkedUndirectedGraph";
    }

    @Override
    public List<GraphvizGraph.GraphvizNode> getGraphvizNodes() {
        ArrayList<GraphvizGraph.GraphvizNode> nodeList = new ArrayList<GraphvizGraph.GraphvizNode>(this.nodes.size());
        for (LinkedUndirectedGraphNode<N, E> node : this.nodes.values()) {
            nodeList.add(node);
        }
        return nodeList;
    }

    @Override
    public boolean isDirected() {
        return false;
    }

    @Override
    public Collection<GraphNode<N, E>> getNodes() {
        return Collections.unmodifiableCollection(this.nodes.values());
    }

    @Override
    public int getNodeCount() {
        return this.nodes.size();
    }

    @Override
    public int getNodeDegree(N value) {
        UndiGraph.UndiGraphNode<N, E> uNode = this.getUndirectedGraphNode(value);
        if (uNode == null) {
            throw new IllegalArgumentException(value + " not found in graph");
        }
        return uNode.getNeighborEdges().size();
    }

    static class AnnotatedLinkedUndirectedGraphEdge<N, E>
    extends LinkedUndirectedGraphEdge<N, E> {
        protected Annotation annotation;

        AnnotatedLinkedUndirectedGraphEdge(UndiGraph.UndiGraphNode<N, E> nodeA, E edgeValue, UndiGraph.UndiGraphNode<N, E> nodeB) {
            super(nodeA, edgeValue, nodeB);
        }

        @Override
        public <A extends Annotation> A getAnnotation() {
            return (A)this.annotation;
        }

        @Override
        public void setAnnotation(Annotation data) {
            this.annotation = data;
        }
    }

    static class LinkedUndirectedGraphEdge<N, E>
    implements UndiGraph.UndiGraphEdge<N, E>,
    GraphvizGraph.GraphvizEdge {
        private final UndiGraph.UndiGraphNode<N, E> nodeA;
        private final UndiGraph.UndiGraphNode<N, E> nodeB;
        protected final E value;

        LinkedUndirectedGraphEdge(UndiGraph.UndiGraphNode<N, E> nodeA, E edgeValue, UndiGraph.UndiGraphNode<N, E> nodeB) {
            this.value = edgeValue;
            this.nodeA = nodeA;
            this.nodeB = nodeB;
        }

        @Override
        public E getValue() {
            return this.value;
        }

        @Override
        public GraphNode<N, E> getNodeA() {
            return this.nodeA;
        }

        @Override
        public GraphNode<N, E> getNodeB() {
            return this.nodeB;
        }

        @Override
        public <A extends Annotation> A getAnnotation() {
            throw new UnsupportedOperationException("Graph initialized with edge annotations turned off");
        }

        @Override
        public void setAnnotation(Annotation data) {
            throw new UnsupportedOperationException("Graph initialized with edge annotations turned off");
        }

        @Override
        public String getColor() {
            return "black";
        }

        @Override
        public String getLabel() {
            return String.valueOf(this.value);
        }

        @Override
        public String getNode1Id() {
            return ((LinkedUndirectedGraphNode)this.nodeA).getId();
        }

        @Override
        public String getNode2Id() {
            return ((LinkedUndirectedGraphNode)this.nodeB).getId();
        }

        public String toString() {
            return this.nodeA + " -- " + this.nodeB;
        }
    }

    static class AnnotatedLinkedUndirectedGraphNode<N, E>
    extends LinkedUndirectedGraphNode<N, E> {
        protected Annotation annotation;

        AnnotatedLinkedUndirectedGraphNode(N nodeValue) {
            super(nodeValue);
        }

        @Override
        public <A extends Annotation> A getAnnotation() {
            return (A)this.annotation;
        }

        @Override
        public void setAnnotation(Annotation data) {
            this.annotation = data;
        }
    }

    static class LinkedUndirectedGraphNode<N, E>
    implements UndiGraph.UndiGraphNode<N, E>,
    GraphvizGraph.GraphvizNode {
        private final List<UndiGraph.UndiGraphEdge<N, E>> neighborEdges = new ArrayList<UndiGraph.UndiGraphEdge<N, E>>();
        private final N value;

        LinkedUndirectedGraphNode(N nodeValue) {
            this.value = nodeValue;
        }

        @Override
        public List<UndiGraph.UndiGraphEdge<N, E>> getNeighborEdges() {
            return this.neighborEdges;
        }

        @Override
        public Iterator<UndiGraph.UndiGraphEdge<N, E>> getNeighborEdgesIterator() {
            return this.neighborEdges.iterator();
        }

        @Override
        public <A extends Annotation> A getAnnotation() {
            throw new UnsupportedOperationException("Graph initialized with node annotations turned off");
        }

        @Override
        public void setAnnotation(Annotation data) {
            throw new UnsupportedOperationException("Graph initialized with node annotations turned off");
        }

        @Override
        public N getValue() {
            return this.value;
        }

        @Override
        public String getColor() {
            return "white";
        }

        @Override
        public String getId() {
            return "LDN" + this.hashCode();
        }

        @Override
        public String getLabel() {
            return String.valueOf(this.value);
        }

        private List<GraphNode<N, E>> neighborList() {
            ArrayList result = new ArrayList(this.neighborEdges.size());
            for (UndiGraph.UndiGraphEdge<N, E> edge : this.neighborEdges) {
                if (edge.getNodeA() == this) {
                    result.add(edge.getNodeB());
                    continue;
                }
                result.add(edge.getNodeA());
            }
            return result;
        }
    }
}

