/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp.lint;

import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.CompilerPass;
import com.google.javascript.jscomp.DiagnosticType;
import com.google.javascript.jscomp.JSError;
import com.google.javascript.jscomp.NodeTraversal;
import com.google.javascript.jscomp.jarjar.com.google.common.collect.ImmutableSet;
import com.google.javascript.rhino.Node;
import com.google.javascript.rhino.jstype.JSType;
import com.google.javascript.rhino.jstype.JSTypeNative;
import com.google.javascript.rhino.jstype.TemplatizedType;

public final class CheckArrayWithGoogObject
extends NodeTraversal.AbstractPostOrderCallback
implements CompilerPass {
    final AbstractCompiler compiler;
    private static final ImmutableSet<String> GOOG_OBJECT_METHODS = ImmutableSet.of("goog.object.forEach", "goog.object.filter", "goog.object.map", "goog.object.some", "goog.object.every", "goog.object.getCount", new String[]{"goog.object.getAnyKey", "goog.object.getAnyValue", "goog.object.contains", "goog.object.getValues", "goog.object.getKeys", "goog.object.findKey", "goog.object.findValue", "goog.object.isEmpty", "goog.object.clear", "goog.object.remove", "goog.object.equals", "goog.object.clone", "goog.object.transpose"});
    public static final DiagnosticType ARRAY_PASSED_TO_GOOG_OBJECT = DiagnosticType.warning("JSC_ARRAY_PASSED_TO_GOOG_OBJECT", "{0} expects an object, not an array. Did you mean to use goog.array?");

    public CheckArrayWithGoogObject(AbstractCompiler compiler) {
        this.compiler = compiler;
    }

    public boolean isGoogObjectIterationOverArray(Node n) {
        if (!n.isCall()) {
            return false;
        }
        if (!n.getFirstChild().isQualifiedName()) {
            return false;
        }
        String name = n.getFirstChild().getQualifiedName();
        if (!GOOG_OBJECT_METHODS.contains(name)) {
            return false;
        }
        Node firstArg = n.getSecondChild();
        if (firstArg == null) {
            return false;
        }
        JSType type = firstArg.getJSType();
        return type != null && this.containsArray(type);
    }

    private boolean containsArray(JSType type) {
        if (type.isArrayType()) {
            return true;
        }
        TemplatizedType templatizedType = type.toMaybeTemplatizedType();
        if (templatizedType != null && templatizedType.getReferencedType().isArrayType()) {
            return true;
        }
        if (type.isUnionType()) {
            JSType arrayType = this.compiler.getTypeRegistry().getNativeType(JSTypeNative.ARRAY_TYPE);
            for (JSType alternate : type.toMaybeUnionType().getAlternates()) {
                if (!alternate.isSubtypeOf(arrayType)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public void visit(NodeTraversal unused, Node n, Node parent) {
        if (this.isGoogObjectIterationOverArray(n)) {
            this.compiler.report(JSError.make(n, ARRAY_PASSED_TO_GOOG_OBJECT, n.getFirstChild().getQualifiedName()));
        }
    }

    @Override
    public void process(Node externs, Node root) {
        NodeTraversal.traverse(this.compiler, root, this);
    }
}

