/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.rhino;

import com.google.javascript.jscomp.serialization.NodeProperty;
import com.google.javascript.rhino.Node;

final class PropTranslator {
    private static final Node.Prop[] protoToRhinoProp = new Node.Prop[NodeProperty.values().length];
    private static final NodeProperty[] rhinoToProtoProp = new NodeProperty[Node.Prop.values().length];

    static NodeProperty serialize(Node.Prop x) {
        return rhinoToProtoProp[x.ordinal()];
    }

    static Node.Prop deserialize(NodeProperty x) {
        return protoToRhinoProp[x.ordinal()];
    }

    private PropTranslator() {
        throw new AssertionError();
    }

    private static final void setProps() {
        for (Node.Prop rhinoProp : Node.Prop.values()) {
            NodeProperty protoProp = PropTranslator.serializeProp(rhinoProp);
            if (protoProp == null) continue;
            PropTranslator.protoToRhinoProp[protoProp.ordinal()] = rhinoProp;
            PropTranslator.rhinoToProtoProp[rhinoProp.ordinal()] = protoProp;
        }
    }

    private static final NodeProperty serializeProp(Node.Prop prop) {
        switch (prop) {
            case ARROW_FN: {
                return NodeProperty.ARROW_FN;
            }
            case ASYNC_FN: {
                return NodeProperty.ASYNC_FN;
            }
            case GENERATOR_FN: {
                return NodeProperty.GENERATOR_FN;
            }
            case YIELD_ALL: {
                return NodeProperty.YIELD_ALL;
            }
            case IS_PARENTHESIZED: {
                return NodeProperty.IS_PARENTHESIZED;
            }
            case SYNTHETIC: {
                return NodeProperty.SYNTHETIC;
            }
            case ADDED_BLOCK: {
                return NodeProperty.ADDED_BLOCK;
            }
            case STATIC_MEMBER: {
                return NodeProperty.STATIC_MEMBER;
            }
            case IS_GENERATOR_MARKER: {
                return NodeProperty.IS_GENERATOR_MARKER;
            }
            case IS_GENERATOR_SAFE: {
                return NodeProperty.IS_GENERATOR_SAFE;
            }
            case COLOR_FROM_CAST: {
                return NodeProperty.COLOR_FROM_CAST;
            }
            case NON_INDEXABLE: {
                return NodeProperty.NON_INDEXABLE;
            }
            case DELETED: {
                return NodeProperty.DELETED;
            }
            case IS_UNUSED_PARAMETER: {
                return NodeProperty.IS_UNUSED_PARAMETER;
            }
            case IS_SHORTHAND_PROPERTY: {
                return NodeProperty.IS_SHORTHAND_PROPERTY;
            }
            case START_OF_OPT_CHAIN: {
                return NodeProperty.START_OF_OPT_CHAIN;
            }
            case TRAILING_COMMA: {
                return NodeProperty.TRAILING_COMMA;
            }
            case IS_CONSTANT_NAME: {
                return NodeProperty.IS_CONSTANT_NAME;
            }
            case IS_NAMESPACE: {
                return NodeProperty.IS_NAMESPACE;
            }
            case DIRECT_EVAL: {
                return NodeProperty.DIRECT_EVAL;
            }
            case FREE_CALL: {
                return NodeProperty.FREE_CALL;
            }
            case REFLECTED_OBJECT: {
                return NodeProperty.REFLECTED_OBJECT;
            }
            case EXPORT_DEFAULT: {
                return NodeProperty.EXPORT_DEFAULT;
            }
            case EXPORT_ALL_FROM: {
                return NodeProperty.EXPORT_ALL_FROM;
            }
            case COMPUTED_PROP_METHOD: {
                return NodeProperty.COMPUTED_PROP_METHOD;
            }
            case COMPUTED_PROP_GETTER: {
                return NodeProperty.COMPUTED_PROP_GETTER;
            }
            case COMPUTED_PROP_SETTER: {
                return NodeProperty.COMPUTED_PROP_SETTER;
            }
            case COMPUTED_PROP_VARIABLE: {
                return NodeProperty.COMPUTED_PROP_VARIABLE;
            }
            case GOOG_MODULE: {
                return NodeProperty.GOOG_MODULE;
            }
            case TRANSPILED: {
                return NodeProperty.TRANSPILED;
            }
            case MODULE_ALIAS: {
                return NodeProperty.MODULE_ALIAS;
            }
            case MODULE_EXPORT: {
                return NodeProperty.MODULE_EXPORT;
            }
            case ES6_MODULE: {
                return NodeProperty.ES6_MODULE;
            }
            case CONSTANT_VAR_FLAGS: {
                return NodeProperty.CONSTANT_VAR_FLAGS;
            }
            case SYNTHESIZED_UNFULFILLED_NAME_DECLARATION: {
                return NodeProperty.SYNTHESIZED_UNFULFILLED_NAME_DECLARATION;
            }
            case SIDE_EFFECT_FLAGS: 
            case DECLARED_TYPE_EXPR: 
            case FEATURE_SET: 
            case TYPE_BEFORE_CAST: 
            case NON_JSDOC_COMMENT: 
            case JSDOC_INFO: 
            case INCRDECR: 
            case QUOTED: 
            case USE_STRICT: 
            case SOURCE_FILE: 
            case INPUT_ID: 
            case CHANGE_TIME: 
            case OPT_ES6_TYPED: 
            case GENERIC_TYPE: 
            case IMPLEMENTS: 
            case CONSTRUCT_SIGNATURE: 
            case ACCESS_MODIFIER: 
            case PARSE_RESULTS: 
            case IS_TYPESCRIPT_ABSTRACT: 
            case TYPEDEF_TYPE: {
                return null;
            }
        }
        throw new AssertionError();
    }

    private static final void checkUnexpectedNullProtoProps() {
        for (NodeProperty protoProp : NodeProperty.values()) {
            if (protoToRhinoProp[protoProp.ordinal()] != null || protoProp == NodeProperty.NODE_PROPERTY_UNSPECIFIED || protoProp == NodeProperty.IS_DECLARED_CONSTANT || protoProp == NodeProperty.IS_INFERRED_CONSTANT || protoProp == NodeProperty.UNRECOGNIZED || protoProp == NodeProperty.UNUSED_11) continue;
            throw new IllegalStateException("Hit unhandled node property: " + protoProp);
        }
    }

    static {
        PropTranslator.setProps();
        PropTranslator.checkUnexpectedNullProtoProps();
    }
}

