/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.rhino.jstype;

import com.google.javascript.jscomp.jarjar.com.google.common.collect.ImmutableList;
import com.google.javascript.rhino.jstype.JSType;
import com.google.javascript.rhino.jstype.UnionType;
import java.util.List;
import java.util.function.Function;
import java.util.function.Predicate;

final class JSTypeIterations {
    static boolean anyTypeMatches(Predicate<? super JSType> predicate, ImmutableList<? extends JSType> types) {
        for (int i = 0; i < types.size(); ++i) {
            if (!predicate.test((JSType)types.get(i))) continue;
            return true;
        }
        return false;
    }

    static boolean anyTypeMatches(Predicate<? super JSType> predicate, UnionType union) {
        return JSTypeIterations.anyTypeMatches(predicate, union.getAlternates());
    }

    static boolean allTypesMatch(Predicate<? super JSType> predicate, ImmutableList<? extends JSType> types) {
        for (int i = 0; i < types.size(); ++i) {
            if (predicate.test((JSType)types.get(i))) continue;
            return false;
        }
        return true;
    }

    static boolean allTypesMatch(Predicate<? super JSType> predicate, UnionType union) {
        return JSTypeIterations.allTypesMatch(predicate, union.getAlternates());
    }

    static <T extends JSType> ImmutableList<T> mapTypes(Function<? super JSType, T> mapper, ImmutableList<? extends JSType> types) {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (int i = 0; i < types.size(); ++i) {
            builder.add((JSType)mapper.apply((JSType)types.get(i)));
        }
        return builder.build();
    }

    static JSType mapTypes(Function<? super JSType, ? extends JSType> mapper, UnionType union) {
        return UnionType.builder(union.registry).addAlternates((List<? extends JSType>)JSTypeIterations.mapTypes(mapper, union.getAlternates())).build();
    }

    private JSTypeIterations() {
    }
}

